/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.query;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.spi.type.VarcharType;
import io.trino.sql.planner.assertions.ExpectedValueProvider;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.plan.AggregationNode;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.query.QueryAssertions;
import io.trino.sql.tree.FunctionCall;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestJoin {
    private QueryAssertions assertions;

    @BeforeAll
    public void init() {
        this.assertions = new QueryAssertions();
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @Test
    public void testCrossJoinEliminationWithOuterJoin() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("WITH\n  a AS (SELECT id FROM (VALUES (1)) AS t(id)),\n  b AS (SELECT id FROM (VALUES (1)) AS t(id)),\n  c AS (SELECT id FROM (VALUES ('1')) AS t(id)),\n  d as (SELECT id FROM (VALUES (1)) AS t(id))\nSELECT a.id\nFROM a\nLEFT JOIN b ON a.id = b.id\nJOIN c ON a.id = CAST(c.id AS bigint)\nJOIN d ON d.id = a.id\n")))).matches("VALUES 1");
    }

    @Test
    public void testSingleRowNonDeterministicSource() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("WITH data(id) AS (SELECT uuid())\nSELECT COUNT(DISTINCT id)\nFROM (VALUES 1, 2, 3, 4, 5, 6, 7, 8)\nCROSS JOIN data\n")))).matches("VALUES BIGINT '1'");
    }

    @Test
    public void testJoinOnNan() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("WITH t(x) AS (VALUES nan())\nSELECT * FROM t t1 JOIN t t2 ON NOT t1.x < t2.x\n")))).matches("VALUES (nan(), nan())");
    }

    @Test
    public void testJoinWithComplexCriteria() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("WITH\n    t1 (id, v) as (\n        VALUES\n            (1, 100),\n            (2, 200)),\n    t2 (id, x, y) AS (\n        VALUES\n            (1, 10, 'a'),\n            (2, 10, 'b'))\nSELECT x, y\nFROM t1 JOIN t2 ON (t1.id = t2.id)\nWHERE IF(t1.v = 0, 'cc', y) = 'b'\n")))).matches("VALUES (10, 'b')");
    }

    @Test
    public void testAliasingOfNullCasts() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("WITH t AS (\n    SELECT CAST(null AS varchar) AS x, CAST(null AS varchar) AS y\n    FROM (VALUES 1) t(a) JOIN (VALUES 1) u(a) USING (a))\nSELECT * FROM t\nWHERE CAST(x AS bigint) IS NOT NULL AND y = 'hello'\n")))).hasOutputTypes(List.of(VarcharType.VARCHAR, VarcharType.VARCHAR)).returnsEmptyResult();
    }

    @Test
    public void testInPredicateInJoinCriteria() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("WITH\n    t(x, y) AS (VALUES (1, 10), (2, 20)),\n    u(x) AS (VALUES 1, 2),\n    w(z) AS (VALUES 10, 20)\nSELECT *\nFROM t LEFT JOIN u ON t.x = u.x AND t.y IN (SELECT z FROM w)\n")))).matches("VALUES (2, 20, 2), (1, 10, 1)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES 1, 2, NULL) t(x) JOIN (VALUES 1, 3, NULL) u(x) ON t.x IN (VALUES 1)")))).matches("VALUES (1, 1), (1, 3), (1, NULL)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES 1, 2, NULL) t(x) LEFT JOIN (VALUES 1, 3, NULL) u(x) ON t.x IN (VALUES 1)")))).matches("VALUES (1, 1), (1, 3), (1, NULL), (2, NULL), (NULL, NULL)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES 1, 2, NULL) t(x) RIGHT JOIN (VALUES 1, 3, NULL) u(x) ON t.x IN (VALUES 1)")))).matches("VALUES (1, 1), (1, 3), (1, NULL)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES 1, 2, NULL) t(x) FULL JOIN (VALUES 1, 3, NULL) u(x) ON t.x IN (VALUES 1)")))).matches("VALUES (1, 1), (1, 3), (1, NULL), (2, NULL), (NULL, NULL)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES 1, 2, NULL) t(x) JOIN (VALUES 1, 3, NULL) u(x) ON u.x IN (VALUES 1)")))).matches("VALUES (1, 1), (2, 1), (NULL, 1)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES 1, 2, NULL) t(x) LEFT JOIN (VALUES 1, 3, NULL) u(x) ON u.x IN (VALUES 1)")))).matches("VALUES (1, 1), (2, 1), (NULL, 1)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES 1, 2, NULL) t(x) RIGHT JOIN (VALUES 1, 3, NULL) u(x) ON u.x IN (VALUES 1)")))).matches("VALUES (1, 1), (2, 1), (NULL, 1), (NULL, 3), (NULL, NULL)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES 1, 2, NULL) t(x) FULL JOIN (VALUES 1, 3, NULL) u(x) ON u.x IN (VALUES 1)")))).matches("VALUES (1, 1), (2, 1), (NULL, 1), (NULL, 3), (NULL, NULL)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES 1, 2, NULL) t(x) JOIN (VALUES 1, 3, NULL) u(x) ON t.x IN (SELECT v.x FROM (VALUES 1, 2) v(x) WHERE u.x = v.x)")))).matches("VALUES (1,1)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES 1, 2, NULL) t(x) JOIN (VALUES 1, 3, NULL) u(x) ON u.x IN (SELECT v.x FROM (VALUES 1, 2) v(x) WHERE t.x = v.x)")))).matches("VALUES (1,1)");
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT * FROM (VALUES 1, 2, NULL) t(x) FULL JOIN (VALUES 1, 3, NULL) u(x) ON u.x IN (VALUES t.x)")).hasMessage("line 1:93: Reference to column 't.x' from outer scope not allowed in this context");
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT * FROM (VALUES 1, 2, NULL) t(x) FULL JOIN (VALUES 1, 3, NULL) u(x) ON u.x IN (VALUES u.x)")).hasMessage("line 1:93: Reference to column 'u.x' from outer scope not allowed in this context");
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT * FROM (VALUES 1, 2, NULL) t(x) FULL JOIN (VALUES 1, 3, NULL) u(x) ON t.x IN (VALUES t.x)")).hasMessage("line 1:93: Reference to column 't.x' from outer scope not allowed in this context");
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT * FROM (VALUES 1, 2, NULL) t(x) FULL JOIN (VALUES 1, 3, NULL) u(x) ON t.x IN (VALUES u.x)")).hasMessage("line 1:93: Reference to column 'u.x' from outer scope not allowed in this context");
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT * FROM (VALUES 1, 2, NULL) t(x) LEFT JOIN (VALUES 1, 3, NULL) u(x) ON u.x IN (VALUES t.x)")).hasMessage("line 1:93: Reference to column 't.x' from outer scope not allowed in this context");
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT * FROM (VALUES 1, 2, NULL) t(x) LEFT JOIN (VALUES 1, 3, NULL) u(x) ON u.x IN (VALUES u.x)")).hasMessage("line 1:93: Reference to column 'u.x' from outer scope not allowed in this context");
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT * FROM (VALUES 1, 2, NULL) t(x) LEFT JOIN (VALUES 1, 3, NULL) u(x) ON t.x IN (VALUES t.x)")).hasMessage("line 1:93: Reference to column 't.x' from outer scope not allowed in this context");
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT * FROM (VALUES 1, 2, NULL) t(x) LEFT JOIN (VALUES 1, 3, NULL) u(x) ON t.x IN (VALUES u.x)")).hasMessage("line 1:93: Reference to column 'u.x' from outer scope not allowed in this context");
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT * FROM (VALUES 1, 2, NULL) t(x) RIGHT JOIN (VALUES 1, 3, NULL) u(x) ON u.x IN (VALUES t.x)")).hasMessage("line 1:94: Reference to column 't.x' from outer scope not allowed in this context");
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT * FROM (VALUES 1, 2, NULL) t(x) RIGHT JOIN (VALUES 1, 3, NULL) u(x) ON u.x IN (VALUES u.x)")).hasMessage("line 1:94: Reference to column 'u.x' from outer scope not allowed in this context");
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT * FROM (VALUES 1, 2, NULL) t(x) RIGHT JOIN (VALUES 1, 3, NULL) u(x) ON t.x IN (VALUES t.x)")).hasMessage("line 1:94: Reference to column 't.x' from outer scope not allowed in this context");
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT * FROM (VALUES 1, 2, NULL) t(x) RIGHT JOIN (VALUES 1, 3, NULL) u(x) ON t.x IN (VALUES u.x)")).hasMessage("line 1:94: Reference to column 'u.x' from outer scope not allowed in this context");
    }

    @Test
    public void testQuantifiedComparisonInJoinCriteria() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES 1, 2, NULL) t(x) RIGHT JOIN (VALUES 1, 3, NULL) u(x) ON u.x > ALL (VALUES 1)")))).matches("VALUES (1, 3), (2, 3), (NULL, 3), (NULL, 1), (NULL, NULL)");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT * FROM (VALUES 1, 2, NULL) t(x) JOIN (VALUES 1, 3, NULL) u(x) ON t.x + u.x > ALL (VALUES 2)")))).matches("VALUES (1, 3), (2, 1), (2, 3)");
        Assertions.assertThatThrownBy(() -> this.assertions.query("SELECT * FROM (VALUES 1, 2, NULL) t(x) RIGHT JOIN (VALUES 1, 3, NULL) u(x) ON t.x + u.x > ALL (VALUES 1)"));
    }

    @Test
    public void testOutputDuplicatesInsensitiveJoin() {
        this.assertions.assertQueryAndPlan("SELECT t.x, count(*) FROM (VALUES 1, 2) t(x) JOIN (VALUES 2, 2) u(x) ON t.x = u.x GROUP BY t.x", "VALUES (2, BIGINT '2')", PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of((Object)"COUNT", PlanMatchPattern.functionCall("count", (List<String>)ImmutableList.of())), PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, builder -> builder.left(PlanMatchPattern.anyTree(PlanMatchPattern.values("y"))).right(PlanMatchPattern.values(new String[0]))).with(JoinNode.class, Predicate.not(JoinNode::isMaySkipOutputDuplicates))))));
        this.assertions.assertQueryAndPlan("SELECT t.x FROM (VALUES 1, 2) t(x) JOIN (VALUES 2, 2) u(x) ON t.x = u.x GROUP BY t.x", "VALUES 2", PlanMatchPattern.anyTree(PlanMatchPattern.aggregation((Map<String, ExpectedValueProvider<FunctionCall>>)ImmutableMap.of(), AggregationNode.Step.FINAL, PlanMatchPattern.anyTree(PlanMatchPattern.join(JoinNode.Type.INNER, builder -> builder.left(PlanMatchPattern.anyTree(PlanMatchPattern.values("y"))).right(PlanMatchPattern.values(new String[0]))).with(JoinNode.class, JoinNode::isMaySkipOutputDuplicates)))));
    }

    @Test
    public void testPredicateOverOuterJoin() {
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT 5\nFROM (VALUES (1,'foo')) l(l1, l2)\nLEFT JOIN (VALUES (2,'bar')) r(r1, r2)\nON l2 = r2\nWHERE l1 >= COALESCE(r1, 0)\n")))).matches("VALUES 5");
        ((QueryAssertions.QueryAssert)((Object)Assertions.assertThat(this.assertions.query("SELECT 5\nFROM (VALUES (2,'foo')) l(l1, l2)\nRIGHT JOIN (VALUES (1,'bar')) r(r1, r2)\nON l2 = r2\nWHERE r1 >= COALESCE(l1, 0)\n")))).matches("VALUES 5");
    }
}

