/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import io.airlift.slice.Slice;
import io.trino.metadata.FunctionBundle;
import io.trino.metadata.InternalFunctionBundle;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.function.LiteralParameters;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.SqlDecimal;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.DateTimeTestingUtils;
import io.trino.testing.SqlVarbinaryTestingUtil;
import io.trino.testing.assertions.TrinoExceptionAssert;
import io.trino.type.JsonType;
import io.trino.type.UnknownType;
import io.trino.util.MoreMaps;
import io.trino.util.StructuralTestUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public class TestMapOperators {
    private QueryAssertions assertions;

    @BeforeAll
    public void init() {
        this.assertions = new QueryAssertions();
        this.assertions.addFunctions((FunctionBundle)InternalFunctionBundle.builder().scalars(TestMapOperators.class).build());
    }

    @AfterAll
    public void teardown() {
        this.assertions.close();
        this.assertions = null;
    }

    @ScalarFunction
    @LiteralParameters(value={"x"})
    @SqlType(value="json")
    public static Slice uncheckedToJson(@SqlType(value="varchar(x)") Slice slice) {
        return slice;
    }

    @Test
    public void testConstructor() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("map", "ARRAY['1','3']", "ARRAY[2,4]")))).hasType((Type)StructuralTestUtil.mapType((Type)VarcharType.createVarcharType((int)1), (Type)IntegerType.INTEGER)).isEqualTo(ImmutableMap.of((Object)"1", (Object)2, (Object)"3", (Object)4));
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        map.put(1, 2);
        map.put(3, null);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("MAP(ARRAY[1, 3], ARRAY[2, NULL])")))).hasType((Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER)).isEqualTo(map);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("MAP(ARRAY[1, 3], ARRAY[2.0E0, 4.0E0])")))).hasType((Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)DoubleType.DOUBLE)).isEqualTo(ImmutableMap.of((Object)1, (Object)2.0, (Object)3, (Object)4.0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("map", "ARRAY[1.0, 383838383838383.12324234234234]", "ARRAY[2.2, 3.3]")))).hasType((Type)StructuralTestUtil.mapType((Type)DecimalType.createDecimalType((int)29, (int)14), (Type)DecimalType.createDecimalType((int)2, (int)1))).isEqualTo(ImmutableMap.of((Object)SqlDecimal.decimal((String)"000000000000001.00000000000000", (DecimalType)DecimalType.createDecimalType((int)29, (int)14)), (Object)SqlDecimal.decimal((String)"2.2", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)), (Object)SqlDecimal.decimal((String)"383838383838383.12324234234234", (DecimalType)DecimalType.createDecimalType((int)29, (int)14)), (Object)SqlDecimal.decimal((String)"3.3", (DecimalType)DecimalType.createDecimalType((int)2, (int)1))));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("map", "ARRAY[1.0E0, 2.0E0]", "ARRAY[ARRAY[BIGINT '1', BIGINT '2'], ARRAY[BIGINT '3' ]]")))).hasType((Type)StructuralTestUtil.mapType((Type)DoubleType.DOUBLE, (Type)new ArrayType((Type)BigintType.BIGINT))).isEqualTo(ImmutableMap.of((Object)1.0, (Object)ImmutableList.of((Object)1L, (Object)2L), (Object)2.0, (Object)ImmutableList.of((Object)3L)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("map", "ARRAY['puppies']", "ARRAY['kittens']")))).hasType((Type)StructuralTestUtil.mapType((Type)VarcharType.createVarcharType((int)7), (Type)VarcharType.createVarcharType((int)7))).isEqualTo(ImmutableMap.of((Object)"puppies", (Object)"kittens"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("map", "ARRAY[TRUE, FALSE]", "ARRAY[2,4]")))).hasType((Type)StructuralTestUtil.mapType((Type)BooleanType.BOOLEAN, (Type)IntegerType.INTEGER)).isEqualTo(ImmutableMap.of((Object)true, (Object)2, (Object)false, (Object)4));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("map", "ARRAY['1', '100']", "ARRAY[TIMESTAMP '1970-01-01 00:00:01', TIMESTAMP '1973-07-08 22:00:01']")))).hasType((Type)StructuralTestUtil.mapType((Type)VarcharType.createVarcharType((int)3), (Type)TimestampType.createTimestampType((int)0))).isEqualTo(ImmutableMap.of((Object)"1", (Object)DateTimeTestingUtils.sqlTimestampOf((int)0, (int)1970, (int)1, (int)1, (int)0, (int)0, (int)1, (int)0), (Object)"100", (Object)DateTimeTestingUtils.sqlTimestampOf((int)0, (int)1973, (int)7, (int)8, (int)22, (int)0, (int)1, (int)0)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("map", "ARRAY[TIMESTAMP '1970-01-01 00:00:01', TIMESTAMP '1973-07-08 22:00:01']", "ARRAY[1.0E0, 100.0E0]")))).hasType((Type)StructuralTestUtil.mapType((Type)TimestampType.createTimestampType((int)0), (Type)DoubleType.DOUBLE)).isEqualTo(ImmutableMap.of((Object)DateTimeTestingUtils.sqlTimestampOf((int)0, (int)1970, (int)1, (int)1, (int)0, (int)0, (int)1, (int)0), (Object)1.0, (Object)DateTimeTestingUtils.sqlTimestampOf((int)0, (int)1973, (int)7, (int)8, (int)22, (int)0, (int)1, (int)0), (Object)100.0));
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.function("map", "ARRAY[1]", "ARRAY[2, 4]").evaluate()).hasMessage("Key and value arrays must be the same length");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.function("map", "ARRAY[1, 2, 3, 2]", "ARRAY[4, 5, 6, 7]").evaluate()).hasMessage("Duplicate map keys (2) are not allowed");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.function("map", "ARRAY[ARRAY[1, 2], ARRAY[1, 3], ARRAY[1, 2]]", "ARRAY[1, 2, 3]").evaluate()).hasMessage("Duplicate map keys ([1, 2]) are not allowed");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("map", "ARRAY[ARRAY[1]]", "ARRAY[2]")))).hasType((Type)StructuralTestUtil.mapType((Type)new ArrayType((Type)IntegerType.INTEGER), (Type)IntegerType.INTEGER)).isEqualTo(ImmutableMap.of((Object)ImmutableList.of((Object)1), (Object)2));
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.function("map", "ARRAY[NULL]", "ARRAY[2]").evaluate()).hasMessage("map key cannot be null");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.function("map", "ARRAY[ARRAY[NULL]]", "ARRAY[2]").evaluate()).hasMessage("map key cannot be indeterminate: [null]");
    }

    @Test
    public void testEmptyMapConstructor() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("MAP()")))).hasType((Type)StructuralTestUtil.mapType((Type)UnknownType.UNKNOWN, (Type)UnknownType.UNKNOWN)).isEqualTo(ImmutableMap.of());
    }

    @Test
    public void testCardinality() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("cardinality", "MAP(ARRAY['1','3'], ARRAY[2,4])")))).isEqualTo(2L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("cardinality", "MAP(ARRAY[1, 3], ARRAY[2, NULL])")))).isEqualTo(2L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("cardinality", "MAP(ARRAY[1, 3], ARRAY[2.0E0, 4.0E0])")))).isEqualTo(2L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("cardinality", "MAP(ARRAY[1.0E0, 2.0E0], ARRAY[ARRAY[1, 2], ARRAY[3]])")))).isEqualTo(2L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("cardinality", "MAP(ARRAY['puppies'], ARRAY['kittens'])")))).isEqualTo(1L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("cardinality", "MAP(ARRAY[TRUE], ARRAY[2])")))).isEqualTo(1L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("cardinality", "MAP(ARRAY['1'], ARRAY[from_unixtime(1)])")))).isEqualTo(1L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("cardinality", "MAP(ARRAY[from_unixtime(1)], ARRAY[1.0E0])")))).isEqualTo(1L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("cardinality", "MAP(ARRAY[1.0, 383838383838383.12324234234234], ARRAY[2.2, 3.3])")))).isEqualTo(2L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("cardinality", "MAP(ARRAY[1.0], ARRAY[2.2])")))).isEqualTo(1L);
    }

    @Test
    public void testMapToJson() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as JSON)").binding("a", "MAP(ARRAY[7,5,3,1], ARRAY[8,6,4,2])")))).hasType((Type)JsonType.JSON).isEqualTo("{\"1\":2,\"3\":4,\"5\":6,\"7\":8}");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as JSON)").binding("a", "MAP(ARRAY[1,3,5,7], ARRAY[2,4,6,8])")))).hasType((Type)JsonType.JSON).isEqualTo("{\"1\":2,\"3\":4,\"5\":6,\"7\":8}");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a AS JSON)").binding("a", "CAST(null as MAP(BIGINT, BIGINT))")))).isNull((Type)JsonType.JSON);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as JSON)").binding("a", "MAP()")))).hasType((Type)JsonType.JSON).isEqualTo("{}");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as JSON)").binding("a", "MAP(ARRAY[1, 2], ARRAY[null, null])")))).hasType((Type)JsonType.JSON).isEqualTo("{\"1\":null,\"2\":null}");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as JSON)").binding("a", "MAP(ARRAY[true, false], ARRAY[1, 2])")))).hasType((Type)JsonType.JSON).isEqualTo("{\"false\":2,\"true\":1}");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a AS JSON)").binding("a", "MAP(cast(ARRAY[1, 2, 3] as ARRAY(TINYINT)), ARRAY[5, 8, null])")))).hasType((Type)JsonType.JSON).isEqualTo("{\"1\":5,\"2\":8,\"3\":null}");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a AS JSON)").binding("a", "MAP(cast(ARRAY[12345, 12346, 12347] as ARRAY(SMALLINT)), ARRAY[5, 8, null])")))).hasType((Type)JsonType.JSON).isEqualTo("{\"12345\":5,\"12346\":8,\"12347\":null}");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a AS JSON)").binding("a", "MAP(cast(ARRAY[123456789,123456790,123456791] as ARRAY(INTEGER)), ARRAY[5, 8, null])")))).hasType((Type)JsonType.JSON).isEqualTo("{\"123456789\":5,\"123456790\":8,\"123456791\":null}");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a AS JSON)").binding("a", "MAP(cast(ARRAY[1234567890123456111,1234567890123456222,1234567890123456777] as ARRAY(BIGINT)), ARRAY[111, 222, null])")))).hasType((Type)JsonType.JSON).isEqualTo("{\"1234567890123456111\":111,\"1234567890123456222\":222,\"1234567890123456777\":null}");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a AS JSON)").binding("a", "MAP(cast(ARRAY[3.14E0, 1e10, 1e20] as ARRAY(REAL)), ARRAY[null, 10, 20])")))).hasType((Type)JsonType.JSON).isEqualTo("{\"1.0E10\":10,\"1.0E20\":20,\"3.14\":null}");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as JSON)").binding("a", "MAP(ARRAY[1e-323,1e308,nan()], ARRAY[-323,308,null])")))).hasType((Type)JsonType.JSON).isEqualTo(Runtime.version().feature() >= 19 ? "{\"1.0E308\":308,\"9.9E-324\":-323,\"NaN\":null}" : "{\"1.0E-323\":-323,\"1.0E308\":308,\"NaN\":null}");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as JSON)").binding("a", "MAP(ARRAY[DECIMAL '3.14', DECIMAL '0.01'], ARRAY[0.14, null])")))).hasType((Type)JsonType.JSON).isEqualTo("{\"0.01\":null,\"3.14\":0.14}");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as JSON)").binding("a", "MAP(ARRAY[DECIMAL '12345678901234567890.1234567890666666', DECIMAL '0.0'], ARRAY[666666, null])")))).hasType((Type)JsonType.JSON).isEqualTo("{\"0.0000000000000000\":null,\"12345678901234567890.1234567890666666\":666666}");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as JSON)").binding("a", "MAP(ARRAY['a', 'bb', 'ccc'], ARRAY[1, 2, 3])")))).hasType((Type)JsonType.JSON).isEqualTo("{\"a\":1,\"bb\":2,\"ccc\":3}");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as JSON)").binding("a", "MAP(ARRAY[1, 2, 3], ARRAY[true, false, null])")))).hasType((Type)JsonType.JSON).isEqualTo("{\"1\":true,\"2\":false,\"3\":null}");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a AS JSON)").binding("a", "MAP(ARRAY[1, 2, 3], cast(ARRAY[5, 8, null] as ARRAY(TINYINT)))")))).hasType((Type)JsonType.JSON).isEqualTo("{\"1\":5,\"2\":8,\"3\":null}");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a AS JSON)").binding("a", "MAP(ARRAY[1, 2, 3], cast(ARRAY[12345, -12345, null] as ARRAY(SMALLINT)))")))).hasType((Type)JsonType.JSON).isEqualTo("{\"1\":12345,\"2\":-12345,\"3\":null}");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a AS JSON)").binding("a", "MAP(ARRAY[1, 2, 3], cast(ARRAY[123456789, -123456789, null] as ARRAY(INTEGER)))")))).hasType((Type)JsonType.JSON).isEqualTo("{\"1\":123456789,\"2\":-123456789,\"3\":null}");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a AS JSON)").binding("a", "MAP(ARRAY[1, 2, 3], cast(ARRAY[1234567890123456789, -1234567890123456789, null] as ARRAY(BIGINT)))")))).hasType((Type)JsonType.JSON).isEqualTo("{\"1\":1234567890123456789,\"2\":-1234567890123456789,\"3\":null}");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a AS JSON)").binding("a", "MAP(ARRAY[1, 2, 3, 5, 8], CAST(ARRAY[3.14E0, nan(), infinity(), -infinity(), null] as ARRAY(REAL)))")))).hasType((Type)JsonType.JSON).isEqualTo("{\"1\":3.14,\"2\":\"NaN\",\"3\":\"Infinity\",\"5\":\"-Infinity\",\"8\":null}");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as JSON)").binding("a", "MAP(ARRAY[1, 2, 3, 5, 8, 13, 21], ARRAY[3.14E0, 1e-323, 1e308, nan(), infinity(), -infinity(), null])")))).hasType((Type)JsonType.JSON).isEqualTo(Runtime.version().feature() >= 19 ? "{\"1\":3.14,\"13\":\"-Infinity\",\"2\":9.9E-324,\"21\":null,\"3\":1.0E308,\"5\":\"NaN\",\"8\":\"Infinity\"}" : "{\"1\":3.14,\"13\":\"-Infinity\",\"2\":1.0E-323,\"21\":null,\"3\":1.0E308,\"5\":\"NaN\",\"8\":\"Infinity\"}");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as JSON)").binding("a", "MAP(ARRAY[1, 2], ARRAY[DECIMAL '3.14', null])")))).hasType((Type)JsonType.JSON).isEqualTo("{\"1\":3.14,\"2\":null}");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as JSON)").binding("a", "MAP(ARRAY[1, 2], ARRAY[DECIMAL '12345678901234567890.123456789012345678', null])")))).hasType((Type)JsonType.JSON).isEqualTo("{\"1\":12345678901234567890.123456789012345678,\"2\":null}");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as JSON)").binding("a", "MAP(ARRAY[1, 2, 3], ARRAY['a', 'bb', null])")))).hasType((Type)JsonType.JSON).isEqualTo("{\"1\":\"a\",\"2\":\"bb\",\"3\":null}");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as JSON)").binding("a", "MAP(ARRAY[1, 2, 3, 5, 8, 13, 21, 34], ARRAY[JSON '123', JSON '3.14', JSON 'false', JSON '\"abc\"', JSON '[1, \"a\", null]', JSON '{\"a\": 1, \"b\": \"str\", \"c\": null}', JSON 'null', null])")))).hasType((Type)JsonType.JSON).isEqualTo("{\"1\":123,\"13\":{\"a\":1,\"b\":\"str\",\"c\":null},\"2\":3.14,\"21\":null,\"3\":false,\"34\":null,\"5\":\"abc\",\"8\":[1,\"a\",null]}");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as JSON)").binding("a", "MAP(ARRAY[1, 2], ARRAY[TIMESTAMP '1970-01-01 00:00:01', null])")))).hasType((Type)JsonType.JSON).isEqualTo(String.format("{\"1\":\"%s\",\"2\":null}", DateTimeTestingUtils.sqlTimestampOf((int)0, (int)1970, (int)1, (int)1, (int)0, (int)0, (int)1, (int)0)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as JSON)").binding("a", "MAP(ARRAY[2, 5, 3], ARRAY[DATE '2001-08-22', DATE '2001-08-23', null])")))).hasType((Type)JsonType.JSON).isEqualTo("{\"2\":\"2001-08-22\",\"3\":null,\"5\":\"2001-08-23\"}");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as JSON)").binding("a", "MAP(ARRAY[1, 2, 3, 5, 8], ARRAY[ARRAY[1, 2], ARRAY[3, null], ARRAY[], ARRAY[null, null], null])")))).hasType((Type)JsonType.JSON).isEqualTo("{\"1\":[1,2],\"2\":[3,null],\"3\":[],\"5\":[null,null],\"8\":null}");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as JSON)").binding("a", "MAP(ARRAY[1, 2, 8, 5, 3], ARRAY[MAP(ARRAY['b', 'a'], ARRAY[2, 1]), MAP(ARRAY['three', 'none'], ARRAY[3, null]), MAP(), MAP(ARRAY['h2', 'h1'], ARRAY[null, null]), null])")))).hasType((Type)JsonType.JSON).isEqualTo("{\"1\":{\"a\":1,\"b\":2},\"2\":{\"none\":null,\"three\":3},\"3\":null,\"5\":{\"h1\":null,\"h2\":null},\"8\":{}}");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a AS JSON)").binding("a", "MAP(ARRAY[1, 2, 3, 5], ARRAY[ROW(1, 2), ROW(3, CAST(null as INTEGER)), CAST(ROW(null, null) AS ROW(INTEGER, INTEGER)), null])")))).hasType((Type)JsonType.JSON).isEqualTo("{\"1\":{\"\":1,\"\":2},\"2\":{\"\":3,\"\":null},\"3\":{\"\":null,\"\":null},\"5\":null}");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as JSON)").binding("a", "MAP(ARRAY[1.0, 383838383838383.12324234234234], ARRAY[2.2, 3.3])")))).hasType((Type)JsonType.JSON).isEqualTo("{\"1.00000000000000\":2.2,\"383838383838383.12324234234234\":3.3}");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as JSON)").binding("a", "MAP(ARRAY[1.0], ARRAY[2.2])")))).hasType((Type)JsonType.JSON).isEqualTo("{\"1.0\":2.2}");
    }

    @Test
    public void testJsonToMap() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a AS MAP(BIGINT, BIGINT))").binding("a", "CAST(null as JSON)")))).isNull((Type)StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as MAP(BIGINT, BIGINT))").binding("a", "JSON 'null'")))).isNull((Type)StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as MAP(BIGINT, BIGINT))").binding("a", "JSON '{}'")))).hasType((Type)StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT)).isEqualTo(ImmutableMap.of());
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as MAP(BIGINT, BIGINT))").binding("a", "JSON '{\"1\": null, \"2\": null}'")))).hasType((Type)StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT)).isEqualTo(MoreMaps.asMap((List)ImmutableList.of((Object)1L, (Object)2L), Arrays.asList(null, null)));
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a AS MAP(DECIMAL(10,5), DECIMAL(2,1)))").binding("a", "CAST(MAP(ARRAY[12345.12345], ARRAY[12345.12345]) as JSON)").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as MAP(BOOLEAN, BIGINT))").binding("a", "JSON '{\"true\": 1, \"false\": 0}'")))).hasType((Type)StructuralTestUtil.mapType((Type)BooleanType.BOOLEAN, (Type)BigintType.BIGINT)).isEqualTo(ImmutableMap.of((Object)true, (Object)1L, (Object)false, (Object)0L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as MAP(TINYINT, BIGINT))").binding("a", "JSON '{\"1\": 5, \"2\": 8, \"3\": 13}'")))).hasType((Type)StructuralTestUtil.mapType((Type)TinyintType.TINYINT, (Type)BigintType.BIGINT)).isEqualTo(ImmutableMap.of((Object)1, (Object)5L, (Object)2, (Object)8L, (Object)3, (Object)13L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as MAP(SMALLINT, BIGINT))").binding("a", "JSON '{\"12345\": 5, \"12346\": 8, \"12347\": 13}'")))).hasType((Type)StructuralTestUtil.mapType((Type)SmallintType.SMALLINT, (Type)BigintType.BIGINT)).isEqualTo(ImmutableMap.of((Object)12345, (Object)5L, (Object)12346, (Object)8L, (Object)12347, (Object)13L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as MAP(INTEGER, BIGINT))").binding("a", "JSON '{\"123456789\": 5, \"123456790\": 8, \"123456791\": 13}'")))).hasType((Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)BigintType.BIGINT)).isEqualTo(ImmutableMap.of((Object)123456789, (Object)5L, (Object)123456790, (Object)8L, (Object)123456791, (Object)13L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as MAP(BIGINT, BIGINT))").binding("a", "JSON '{\"1234567890123456111\": 5, \"1234567890123456222\": 8, \"1234567890123456777\": 13}'")))).hasType((Type)StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT)).isEqualTo(ImmutableMap.of((Object)1234567890123456111L, (Object)5L, (Object)1234567890123456222L, (Object)8L, (Object)1234567890123456777L, (Object)13L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as MAP(REAL, BIGINT))").binding("a", "JSON '{\"3.14\": 5, \"NaN\": 8, \"Infinity\": 13, \"-Infinity\": 21}'")))).hasType((Type)StructuralTestUtil.mapType((Type)RealType.REAL, (Type)BigintType.BIGINT)).isEqualTo(ImmutableMap.of((Object)Float.valueOf(3.14f), (Object)5L, (Object)Float.valueOf(Float.NaN), (Object)8L, (Object)Float.valueOf(Float.POSITIVE_INFINITY), (Object)13L, (Object)Float.valueOf(Float.NEGATIVE_INFINITY), (Object)21L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as MAP(DOUBLE, BIGINT))").binding("a", "JSON '{\"3.1415926\": 5, \"NaN\": 8, \"Infinity\": 13, \"-Infinity\": 21}'")))).hasType((Type)StructuralTestUtil.mapType((Type)DoubleType.DOUBLE, (Type)BigintType.BIGINT)).isEqualTo(ImmutableMap.of((Object)3.1415926, (Object)5L, (Object)Double.NaN, (Object)8L, (Object)Double.POSITIVE_INFINITY, (Object)13L, (Object)Double.NEGATIVE_INFINITY, (Object)21L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as MAP(DECIMAL(10, 5), BIGINT))").binding("a", "JSON '{\"123.456\": 5, \"3.14\": 8}'")))).hasType((Type)StructuralTestUtil.mapType((Type)DecimalType.createDecimalType((int)10, (int)5), (Type)BigintType.BIGINT)).isEqualTo(ImmutableMap.of((Object)SqlDecimal.decimal((String)"123.45600", (DecimalType)DecimalType.createDecimalType((int)10, (int)5)), (Object)5L, (Object)SqlDecimal.decimal((String)"3.14000", (DecimalType)DecimalType.createDecimalType((int)10, (int)5)), (Object)8L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as MAP(DECIMAL(38, 8), BIGINT))").binding("a", "JSON '{\"12345678.12345678\": 5, \"3.1415926\": 8}'")))).hasType((Type)StructuralTestUtil.mapType((Type)DecimalType.createDecimalType((int)38, (int)8), (Type)BigintType.BIGINT)).isEqualTo(ImmutableMap.of((Object)SqlDecimal.decimal((String)"12345678.12345678", (DecimalType)DecimalType.createDecimalType((int)38, (int)8)), (Object)5L, (Object)SqlDecimal.decimal((String)"3.14159260", (DecimalType)DecimalType.createDecimalType((int)38, (int)8)), (Object)8L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as MAP(VARCHAR, BIGINT))").binding("a", "JSON '{\"a\": 5, \"bb\": 8, \"ccc\": 13}'")))).hasType((Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)BigintType.BIGINT)).isEqualTo(ImmutableMap.of((Object)"a", (Object)5L, (Object)"bb", (Object)8L, (Object)"ccc", (Object)13L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as MAP(BIGINT, BOOLEAN))").binding("a", "JSON '{\"1\": true, \"2\": false, \"3\": 12, \"5\": 0, \"8\": 12.3, \"13\": 0.0, \"21\": \"true\", \"34\": \"false\", \"55\": null}'")))).hasType((Type)StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)BooleanType.BOOLEAN)).isEqualTo(MoreMaps.asMap((List)ImmutableList.of((Object)1L, (Object)2L, (Object)3L, (Object)5L, (Object)8L, (Object)13L, (Object)21L, (Object)34L, (Object)55L), Arrays.asList(true, false, true, false, true, false, true, false, null)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as MAP(BIGINT, TINYINT))").binding("a", "JSON '{\"1\": true, \"2\": false, \"3\": 12, \"5\": 12.7, \"8\": \"12\", \"13\": null}'")))).hasType((Type)StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)TinyintType.TINYINT)).isEqualTo(MoreMaps.asMap((List)ImmutableList.of((Object)1L, (Object)2L, (Object)3L, (Object)5L, (Object)8L, (Object)13L), Arrays.asList((byte)1, (byte)0, (byte)12, (byte)13, (byte)12, null)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as MAP(BIGINT, SMALLINT))").binding("a", "JSON '{\"1\": true, \"2\": false, \"3\": 12345, \"5\": 12345.6, \"8\": \"12345\", \"13\": null}'")))).hasType((Type)StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)SmallintType.SMALLINT)).isEqualTo(MoreMaps.asMap((List)ImmutableList.of((Object)1L, (Object)2L, (Object)3L, (Object)5L, (Object)8L, (Object)13L), Arrays.asList((short)1, (short)0, (short)12345, (short)12346, (short)12345, null)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as MAP(BIGINT, INTEGER))").binding("a", "JSON '{\"1\": true, \"2\": false, \"3\": 12345678, \"5\": 12345678.9, \"8\": \"12345678\", \"13\": null}'")))).hasType((Type)StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)IntegerType.INTEGER)).isEqualTo(MoreMaps.asMap((List)ImmutableList.of((Object)1L, (Object)2L, (Object)3L, (Object)5L, (Object)8L, (Object)13L), Arrays.asList(1, 0, 12345678, 12345679, 12345678, null)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as MAP(BIGINT, BIGINT))").binding("a", "JSON '{\"1\": true, \"2\": false, \"3\": 1234567891234567, \"5\": 1234567891234567.8, \"8\": \"1234567891234567\", \"13\": null}'")))).hasType((Type)StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT)).isEqualTo(MoreMaps.asMap((List)ImmutableList.of((Object)1L, (Object)2L, (Object)3L, (Object)5L, (Object)8L, (Object)13L), Arrays.asList(1L, 0L, 1234567891234567L, 1234567891234568L, 1234567891234567L, null)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as MAP(BIGINT, REAL))").binding("a", "JSON '{\"1\": true, \"2\": false, \"3\": 12345, \"5\": 12345.67, \"8\": \"3.14\", \"13\": \"NaN\", \"21\": \"Infinity\", \"34\": \"-Infinity\", \"55\": null}'")))).hasType((Type)StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)RealType.REAL)).isEqualTo(MoreMaps.asMap((List)ImmutableList.of((Object)1L, (Object)2L, (Object)3L, (Object)5L, (Object)8L, (Object)13L, (Object)21L, (Object)34L, (Object)55L), Arrays.asList(Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(12345.0f), Float.valueOf(12345.67f), Float.valueOf(3.14f), Float.valueOf(Float.NaN), Float.valueOf(Float.POSITIVE_INFINITY), Float.valueOf(Float.NEGATIVE_INFINITY), null)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as MAP(BIGINT, DOUBLE))").binding("a", "JSON '{\"1\": true, \"2\": false, \"3\": 1234567890, \"5\": 1234567890.1, \"8\": \"3.14\", \"13\": \"NaN\", \"21\": \"Infinity\", \"34\": \"-Infinity\", \"55\": null}'")))).hasType((Type)StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)DoubleType.DOUBLE)).isEqualTo(MoreMaps.asMap((List)ImmutableList.of((Object)1L, (Object)2L, (Object)3L, (Object)5L, (Object)8L, (Object)13L, (Object)21L, (Object)34L, (Object)55L), Arrays.asList(1.0, 0.0, 1.23456789E9, 1.2345678901E9, 3.14, Double.NaN, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, null)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as MAP(BIGINT, DECIMAL(10, 5)))").binding("a", "JSON '{\"1\": true, \"2\": false, \"3\": 128, \"5\": 123.456, \"8\": \"3.14\", \"13\": null}'")))).hasType((Type)StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)DecimalType.createDecimalType((int)10, (int)5))).isEqualTo(MoreMaps.asMap((List)ImmutableList.of((Object)1L, (Object)2L, (Object)3L, (Object)5L, (Object)8L, (Object)13L), Arrays.asList(SqlDecimal.decimal((String)"1.00000", (DecimalType)DecimalType.createDecimalType((int)10, (int)5)), SqlDecimal.decimal((String)"0.00000", (DecimalType)DecimalType.createDecimalType((int)10, (int)5)), SqlDecimal.decimal((String)"128.00000", (DecimalType)DecimalType.createDecimalType((int)10, (int)5)), SqlDecimal.decimal((String)"123.45600", (DecimalType)DecimalType.createDecimalType((int)10, (int)5)), SqlDecimal.decimal((String)"3.14000", (DecimalType)DecimalType.createDecimalType((int)10, (int)5)), null)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as MAP(BIGINT, DECIMAL(38, 8)))").binding("a", "JSON '{\"1\": true, \"2\": false, \"3\": 128, \"5\": 12345678.12345678, \"8\": \"3.14\", \"13\": null}'")))).hasType((Type)StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)DecimalType.createDecimalType((int)38, (int)8))).isEqualTo(MoreMaps.asMap((List)ImmutableList.of((Object)1L, (Object)2L, (Object)3L, (Object)5L, (Object)8L, (Object)13L), Arrays.asList(SqlDecimal.decimal((String)"1.00000000", (DecimalType)DecimalType.createDecimalType((int)38, (int)8)), SqlDecimal.decimal((String)"0.00000000", (DecimalType)DecimalType.createDecimalType((int)38, (int)8)), SqlDecimal.decimal((String)"128.00000000", (DecimalType)DecimalType.createDecimalType((int)38, (int)8)), SqlDecimal.decimal((String)"12345678.12345678", (DecimalType)DecimalType.createDecimalType((int)38, (int)8)), SqlDecimal.decimal((String)"3.14000000", (DecimalType)DecimalType.createDecimalType((int)38, (int)8)), null)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as MAP(BIGINT, VARCHAR))").binding("a", "JSON '{\"1\": true, \"2\": false, \"3\": 12, \"5\": 12.3, \"8\": \"puppies\", \"13\": \"kittens\", \"21\": \"null\", \"34\": \"\", \"55\": null}'")))).hasType((Type)StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)VarcharType.VARCHAR)).isEqualTo(MoreMaps.asMap((List)ImmutableList.of((Object)1L, (Object)2L, (Object)3L, (Object)5L, (Object)8L, (Object)13L, (Object)21L, (Object)34L, (Object)55L), Arrays.asList("true", "false", "12", "1.23E1", "puppies", "kittens", "null", "", null)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as MAP(VARCHAR, JSON))").binding("a", "JSON '{\"k1\": 5, \"k2\": 3.14, \"k3\":[1, 2, 3], \"k4\":\"e\", \"k5\":{\"a\": \"b\"}, \"k6\":null, \"k7\":\"null\", \"k8\":[null]}'")))).hasType((Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)JsonType.JSON)).isEqualTo(ImmutableMap.builder().put((Object)"k1", (Object)"5").put((Object)"k2", (Object)"3.14").put((Object)"k3", (Object)"[1,2,3]").put((Object)"k4", (Object)"\"e\"").put((Object)"k5", (Object)"{\"a\":\"b\"}").put((Object)"k6", (Object)"null").put((Object)"k7", (Object)"\"null\"").put((Object)"k8", (Object)"[null]").buildOrThrow());
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as MAP(VARCHAR, JSON))").binding("a", "JSON '{\"k1\": {\"1klmnopq\":1, \"2klmnopq\":2, \"3klmnopq\":3, \"4klmnopq\":4, \"5klmnopq\":5, \"6klmnopq\":6, \"7klmnopq\":7}}'")))).hasType((Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)JsonType.JSON)).isEqualTo(ImmutableMap.of((Object)"k1", (Object)"{\"1klmnopq\":1,\"2klmnopq\":2,\"3klmnopq\":3,\"4klmnopq\":4,\"5klmnopq\":5,\"6klmnopq\":6,\"7klmnopq\":7}"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as MAP(VARCHAR, JSON))").binding("a", "unchecked_to_json('{\"k1\": {\"7klmnopq\":7, \"6klmnopq\":6, \"5klmnopq\":5, \"4klmnopq\":4, \"3klmnopq\":3, \"2klmnopq\":2, \"1klmnopq\":1}}')")))).hasType((Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)JsonType.JSON)).isEqualTo(ImmutableMap.of((Object)"k1", (Object)"{\"7klmnopq\":7,\"6klmnopq\":6,\"5klmnopq\":5,\"4klmnopq\":4,\"3klmnopq\":3,\"2klmnopq\":2,\"1klmnopq\":1}"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as MAP(BIGINT, ARRAY(BIGINT)))").binding("a", "JSON '{\"1\": [1, 2], \"2\": [3, null], \"3\": [], \"5\": [null, null], \"8\": null}'")))).hasType((Type)StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)new ArrayType((Type)BigintType.BIGINT))).isEqualTo(MoreMaps.asMap((List)ImmutableList.of((Object)1L, (Object)2L, (Object)3L, (Object)5L, (Object)8L), Arrays.asList(Arrays.asList(1L, 2L), Arrays.asList(3L, null), Collections.emptyList(), Arrays.asList(null, null), null)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(JSON '{\"1\": {\"a\": 1, \"b\": 2}, \"2\": {\"none\": null, \"three\": 3}, \"3\": {}, \"5\": {\"h1\": null,\"h2\": null}, \"8\": null}' AS MAP(BIGINT, MAP(VARCHAR, BIGINT)))")))).hasType((Type)StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)BigintType.BIGINT))).isEqualTo(MoreMaps.asMap((List)ImmutableList.of((Object)1L, (Object)2L, (Object)3L, (Object)5L, (Object)8L), Arrays.asList(ImmutableMap.of((Object)"a", (Object)1L, (Object)"b", (Object)2L), MoreMaps.asMap((List)ImmutableList.of((Object)"none", (Object)"three"), Arrays.asList(null, 3L)), ImmutableMap.of(), MoreMaps.asMap((List)ImmutableList.of((Object)"h1", (Object)"h2"), Arrays.asList(null, null)), null)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("CAST(JSON '{\"row1\": [1, \"two\"], \"row2\": [3, null], \"row3\": {\"k1\": 1, \"k2\": \"two\"}, \"row4\": {\"k2\": null, \"k1\": 3}, \"row5\": null}' AS MAP(VARCHAR, ROW(k1 BIGINT, k2 VARCHAR)))")))).hasType((Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)RowType.from((List)ImmutableList.of((Object)RowType.field((String)"k1", (Type)BigintType.BIGINT), (Object)RowType.field((String)"k2", (Type)VarcharType.VARCHAR))))).isEqualTo(MoreMaps.asMap((List)ImmutableList.of((Object)"row1", (Object)"row2", (Object)"row3", (Object)"row4", (Object)"row5"), Arrays.asList(Arrays.asList(1L, "two"), Arrays.asList(3L, null), Arrays.asList(1L, "two"), Arrays.asList(3L, null), null)));
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as MAP(ARRAY(BIGINT), BIGINT))").binding("a", "JSON '{\"[]\": 1}'").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.TYPE_MISMATCH}).hasMessage("line 1:8: Cannot cast json to map(array(bigint), bigint)");
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as MAP(BIGINT, BIGINT))").binding("a", "JSON '[1, 2]'").evaluate()).hasMessage("Cannot cast to map(bigint, bigint). Expected a json object, but got [\n[1,2]")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as MAP(VARCHAR, MAP(VARCHAR, BIGINT)))").binding("a", "JSON '{\"a\": 1, \"b\": 2}'").evaluate()).hasMessage("Cannot cast to map(varchar, map(varchar, bigint)). Expected a json object, but got 1\n{\"a\":1,\"b\":2}")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as MAP(VARCHAR, BIGINT))").binding("a", "JSON '{\"a\": 1, \"b\": []}'").evaluate()).hasMessage("Cannot cast to map(varchar, bigint). Unexpected token when cast to bigint: [\n{\"a\":1,\"b\":[]}")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as MAP(VARCHAR, MAP(VARCHAR, BIGINT)))").binding("a", "JSON '{\"1\": {\"a\": 1}, \"2\": []}'").evaluate()).hasMessage("Cannot cast to map(varchar, map(varchar, bigint)). Expected a json object, but got [\n{\"1\":{\"a\":1},\"2\":[]}")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as MAP(VARCHAR, BIGINT))").binding("a", "unchecked_to_json('\"a\": 1, \"b\": 2')").evaluate()).hasMessage("Cannot cast to map(varchar, bigint). Expected a json object, but got a\n\"a\": 1, \"b\": 2")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as MAP(VARCHAR, BIGINT))").binding("a", "unchecked_to_json('{\"a\": 1} 2')").evaluate()).hasMessage("Cannot cast to map(varchar, bigint). Unexpected trailing token: 2\n{\"a\": 1} 2")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as MAP(VARCHAR, BIGINT))").binding("a", "unchecked_to_json('{\"a\": 1')").evaluate()).hasMessage("Cannot cast to map(varchar, bigint).\n{\"a\": 1")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as MAP(VARCHAR, BIGINT))").binding("a", "JSON '{\"a\": \"b\"}'").evaluate()).hasMessage("Cannot cast to map(varchar, bigint). Cannot cast 'b' to BIGINT\n{\"a\":\"b\"}")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as MAP(VARCHAR, INTEGER))").binding("a", "JSON '{\"a\": 1234567890123.456}'").evaluate()).hasMessage("Cannot cast to map(varchar, integer). Out of range for integer: 1.234567890123456E12\n{\"a\":1.234567890123456E12}")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as MAP(BIGINT, BIGINT))").binding("a", "JSON '{\"1\":1, \"01\": 2}'").evaluate()).hasMessage("Cannot cast to map(bigint, bigint). Duplicate keys are not allowed\n{\"01\":2,\"1\":1}")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as ARRAY(MAP(BIGINT, BIGINT)))").binding("a", "JSON '[{\"1\":1, \"01\": 2}]'").evaluate()).hasMessage("Cannot cast to array(map(bigint, bigint)). Duplicate keys are not allowed\n[{\"01\":2,\"1\":1}]")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as MAP(VARCHAR, VARCHAR))").binding("a", "JSON '{\"puppies\":\"kittens\"}'")))).hasType((Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR)).isEqualTo(ImmutableMap.of((Object)"puppies", (Object)"kittens"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as MAP(BOOLEAN, VARCHAR))").binding("a", "JSON '{\"true\":\"kittens\"}'")))).hasType((Type)StructuralTestUtil.mapType((Type)BooleanType.BOOLEAN, (Type)VarcharType.VARCHAR)).isEqualTo(ImmutableMap.of((Object)true, (Object)"kittens"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as MAP(BOOLEAN, VARCHAR))").binding("a", "JSON 'null'")))).isNull((Type)StructuralTestUtil.mapType((Type)BooleanType.BOOLEAN, (Type)VarcharType.VARCHAR));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a AS MAP(DECIMAL(29,14), DECIMAL(2,1)))").binding("a", "CAST(MAP(ARRAY[1.0, 383838383838383.12324234234234], ARRAY[2.2, 3.3]) as JSON)")))).hasType((Type)StructuralTestUtil.mapType((Type)DecimalType.createDecimalType((int)29, (int)14), (Type)DecimalType.createDecimalType((int)2, (int)1))).isEqualTo(ImmutableMap.of((Object)SqlDecimal.decimal((String)"000000000000001.00000000000000", (DecimalType)DecimalType.createDecimalType((int)29, (int)14)), (Object)SqlDecimal.decimal((String)"2.2", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)), (Object)SqlDecimal.decimal((String)"383838383838383.12324234234234", (DecimalType)DecimalType.createDecimalType((int)29, (int)14)), (Object)SqlDecimal.decimal((String)"3.3", (DecimalType)DecimalType.createDecimalType((int)2, (int)1))));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a AS MAP(DECIMAL(2,1), DECIMAL(29,14)))").binding("a", "CAST(MAP(ARRAY[2.2, 3.3], ARRAY[1.0, 383838383838383.12324234234234]) as JSON)")))).hasType((Type)StructuralTestUtil.mapType((Type)DecimalType.createDecimalType((int)2, (int)1), (Type)DecimalType.createDecimalType((int)29, (int)14))).isEqualTo(ImmutableMap.of((Object)SqlDecimal.decimal((String)"2.2", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)), (Object)SqlDecimal.decimal((String)"000000000000001.00000000000000", (DecimalType)DecimalType.createDecimalType((int)29, (int)14)), (Object)SqlDecimal.decimal((String)"3.3", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)), (Object)SqlDecimal.decimal((String)"383838383838383.12324234234234", (DecimalType)DecimalType.createDecimalType((int)29, (int)14))));
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a AS MAP(DECIMAL(2,1), DECIMAL(10,5)))").binding("a", "CAST(MAP(ARRAY[12345.12345], ARRAY[12345.12345]) as JSON)").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a AS MAP(DECIMAL(10,5), DECIMAL(2,1)))").binding("a", "CAST(MAP(ARRAY[12345.12345], ARRAY[12345.12345]) as JSON)").evaluate()).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
    }

    @Test
    public void testElementAt() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("element_at", "map(CAST(ARRAY[] AS ARRAY(BIGINT)), CAST(ARRAY[] AS ARRAY(BIGINT)))", "1")))).isNull((Type)BigintType.BIGINT);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("element_at", "map(ARRAY[1], ARRAY[1e0])", "2")))).isNull((Type)DoubleType.DOUBLE);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("element_at", "map(ARRAY[1.0], ARRAY['a'])", "2.0")))).isNull((Type)VarcharType.createVarcharType((int)1));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("element_at", "map(ARRAY['a'], ARRAY[true])", "'b'")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("element_at", "map(ARRAY[true], ARRAY[ARRAY[1]])", "false")))).isNull((Type)new ArrayType((Type)IntegerType.INTEGER));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("element_at", "map(ARRAY[ARRAY[1]], ARRAY[1])", "ARRAY[2]")))).isNull((Type)IntegerType.INTEGER);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("element_at", "map(ARRAY[1], ARRAY[null])", "1")))).isNull((Type)UnknownType.UNKNOWN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("element_at", "map(ARRAY[1.0E0], ARRAY[null])", "1.0E0")))).isNull((Type)UnknownType.UNKNOWN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("element_at", "map(ARRAY[TRUE], ARRAY[null])", "TRUE")))).isNull((Type)UnknownType.UNKNOWN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("element_at", "map(ARRAY['puppies'], ARRAY[null])", "'puppies'")))).isNull((Type)UnknownType.UNKNOWN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("element_at", "map(ARRAY[ARRAY[1]], ARRAY[null])", "ARRAY[1]")))).isNull((Type)UnknownType.UNKNOWN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("element_at", "map(ARRAY[1, 3], ARRAY[2, 4])", "3")))).isEqualTo(4);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("element_at", "map(ARRAY[BIGINT '1', 3], ARRAY[BIGINT '2', 4])", "3")))).isEqualTo(4L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("element_at", "map(ARRAY[1, 3], ARRAY[2, NULL])", "3")))).isNull((Type)IntegerType.INTEGER);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("element_at", "map(ARRAY[BIGINT '1', 3], ARRAY[2, NULL])", "3")))).isNull((Type)IntegerType.INTEGER);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("element_at", "map(ARRAY[1, 3], ARRAY[2.0E0, 4.0E0])", "1")))).isEqualTo(2.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("element_at", "map(ARRAY[1.0E0, 2.0E0], ARRAY[ARRAY[1, 2], ARRAY[3]])", "1.0E0")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(ImmutableList.of((Object)1, (Object)2));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("element_at", "map(ARRAY['puppies'], ARRAY['kittens'])", "'puppies'")))).hasType((Type)VarcharType.createVarcharType((int)7)).isEqualTo("kittens");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("element_at", "map(ARRAY[TRUE, FALSE], ARRAY[2, 4])", "TRUE")))).isEqualTo(2);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("element_at", "map(ARRAY[ARRAY[1, 2], ARRAY[3]], ARRAY[1e0, 2e0])", "ARRAY[1, 2]")))).isEqualTo(1.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("element_at", "map(ARRAY['1', '100'], ARRAY[TIMESTAMP '1970-01-01 00:00:01', TIMESTAMP '2005-09-10 13:00:00'])", "'1'")))).hasType((Type)TimestampType.createTimestampType((int)0)).isEqualTo(DateTimeTestingUtils.sqlTimestampOf((int)0, (int)1970, (int)1, (int)1, (int)0, (int)0, (int)1, (int)0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("element_at", "map(ARRAY[from_unixtime(1), from_unixtime(100)], ARRAY[1.0E0, 100.0E0])", "from_unixtime(1)")))).isEqualTo(1.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("element_at", "map(ARRAY[TIMESTAMP '2020-05-10 12:34:56.123456789', TIMESTAMP '2222-05-10 12:34:56.123456789'], ARRAY[1, 2])", "TIMESTAMP '2222-05-10 12:34:56.123456789'")))).isEqualTo(2);
    }

    @Test
    public void testSubscript() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a[1]").binding("a", "map(ARRAY[1], ARRAY[null])")))).isNull((Type)UnknownType.UNKNOWN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a[1.0E0]").binding("a", "map(ARRAY[1.0E0], ARRAY[null])")))).isNull((Type)UnknownType.UNKNOWN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a[TRUE]").binding("a", "map(ARRAY[TRUE], ARRAY[null])")))).isNull((Type)UnknownType.UNKNOWN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a['puppies']").binding("a", "map(ARRAY['puppies'], ARRAY[null])")))).isNull((Type)UnknownType.UNKNOWN);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.function("map", "ARRAY[CAST(null as bigint)]", "ARRAY[1]").evaluate()).hasMessage("map key cannot be null");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.function("map", "ARRAY[CAST(null as bigint)]", "ARRAY[CAST(null as bigint)]").evaluate()).hasMessage("map key cannot be null");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.function("map", "ARRAY[1,null]", "ARRAY[null,2]").evaluate()).hasMessage("map key cannot be null");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a[3]").binding("a", "map(ARRAY[1, 3], ARRAY[2, 4])")))).isEqualTo(4);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a[3]").binding("a", "map(ARRAY[BIGINT '1', 3], ARRAY[BIGINT '2', 4])")))).isEqualTo(4L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a[3]").binding("a", "map(ARRAY[1, 3], ARRAY[2, NULL])")))).isNull((Type)IntegerType.INTEGER);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a[3]").binding("a", "map(ARRAY[BIGINT '1', 3], ARRAY[2, NULL])")))).isNull((Type)IntegerType.INTEGER);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a[1]").binding("a", "map(ARRAY[1, 3], ARRAY[2.0E0, 4.0E0])")))).isEqualTo(2.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a[1.0E0]").binding("a", "map(ARRAY[1.0E0, 2.0E0], ARRAY[ARRAY[1, 2], ARRAY[3]])")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(ImmutableList.of((Object)1, (Object)2));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a['puppies']").binding("a", "map(ARRAY['puppies'], ARRAY['kittens'])")))).hasType((Type)VarcharType.createVarcharType((int)7)).isEqualTo("kittens");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a[TRUE]").binding("a", "map(ARRAY[TRUE,FALSE],ARRAY[2,4])")))).isEqualTo(2);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a['1']").binding("a", "map(ARRAY['1', '100'], ARRAY[TIMESTAMP '1970-01-01 00:00:01', TIMESTAMP '1973-07-08 22:00:01'])")))).hasType((Type)TimestampType.createTimestampType((int)0)).isEqualTo(DateTimeTestingUtils.sqlTimestampOf((int)0, (int)1970, (int)1, (int)1, (int)0, (int)0, (int)1, (int)0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a[from_unixtime(1)]").binding("a", "map(ARRAY[from_unixtime(1), from_unixtime(100)], ARRAY[1.0E0, 100.0E0])")))).isEqualTo(1.0);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("a[3]").binding("a", "map(ARRAY[BIGINT '1'], ARRAY[BIGINT '2'])").evaluate()).hasMessage("Key not present in map: 3");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("a['missing']").binding("a", "map(ARRAY['hi'], ARRAY[2])").evaluate()).hasMessage("Key not present in map: missing");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a[ARRAY[1,1]]").binding("a", "map(ARRAY[array[1,1]], ARRAY['a'])")))).hasType((Type)VarcharType.createVarcharType((int)1)).isEqualTo("a");
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a[('a', 'b')]").binding("a", "map(ARRAY[('a', 'b')], ARRAY[ARRAY[100, 200]])")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(ImmutableList.of((Object)100, (Object)200));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a[1.0]").binding("a", "map(ARRAY[1.0], ARRAY[2.2])")))).hasType((Type)DecimalType.createDecimalType((int)2, (int)1)).isEqualTo(SqlDecimal.decimal((String)"2.2", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a[000000000000001.00000000000000]").binding("a", "map(ARRAY[000000000000001.00000000000000], ARRAY[2.2])")))).hasType((Type)DecimalType.createDecimalType((int)2, (int)1)).isEqualTo(SqlDecimal.decimal((String)"2.2", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a[TIMESTAMP '2222-05-10 12:34:56.123456789']").binding("a", "map(ARRAY[TIMESTAMP '2020-05-10 12:34:56.123456789', TIMESTAMP '2222-05-10 12:34:56.123456789'], ARRAY[1, 2])")))).isEqualTo(2);
    }

    @Test
    public void testMapKeys() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("map_keys", "map(ARRAY['1', '3'], ARRAY['2', '4'])")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)1))).isEqualTo(ImmutableList.of((Object)"1", (Object)"3"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("map_keys", "map(ARRAY[1.0E0, 2.0E0], ARRAY[ARRAY[1, 2], ARRAY[3]])")))).hasType((Type)new ArrayType((Type)DoubleType.DOUBLE)).isEqualTo(ImmutableList.of((Object)1.0, (Object)2.0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("map_keys", "map(ARRAY['puppies'], ARRAY['kittens'])")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)7))).isEqualTo(ImmutableList.of((Object)"puppies"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("map_keys", "map(ARRAY[TRUE], ARRAY[2])")))).hasType((Type)new ArrayType((Type)BooleanType.BOOLEAN)).isEqualTo(ImmutableList.of((Object)true));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("map_keys", "map(ARRAY[TIMESTAMP '1970-01-01 00:00:01'], ARRAY[1.0E0])")))).hasType((Type)new ArrayType((Type)TimestampType.createTimestampType((int)0))).isEqualTo(ImmutableList.of((Object)DateTimeTestingUtils.sqlTimestampOf((int)0, (int)1970, (int)1, (int)1, (int)0, (int)0, (int)1, (int)0)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("map_keys", "map(ARRAY[CAST('puppies' as varbinary)], ARRAY['kittens'])")))).hasType((Type)new ArrayType((Type)VarbinaryType.VARBINARY)).isEqualTo(ImmutableList.of((Object)SqlVarbinaryTestingUtil.sqlVarbinary((String)"puppies")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("map_keys", "map(ARRAY[1,2],  ARRAY[ARRAY[1, 2], ARRAY[3]])")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(ImmutableList.of((Object)1, (Object)2));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("map_keys", "map(ARRAY[1,4], ARRAY[MAP(ARRAY[2], ARRAY[3]), MAP(ARRAY[5], ARRAY[6])])")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(ImmutableList.of((Object)1, (Object)4));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("map_keys", "map(ARRAY[ARRAY[1], ARRAY[2, 3]],  ARRAY[ARRAY[3, 4], ARRAY[5]])")))).hasType((Type)new ArrayType((Type)new ArrayType((Type)IntegerType.INTEGER))).isEqualTo(ImmutableList.of((Object)ImmutableList.of((Object)1), (Object)ImmutableList.of((Object)2, (Object)3)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("map_keys", "map(ARRAY[1.0, 383838383838383.12324234234234], ARRAY[2.2, 3.3])")))).hasType((Type)new ArrayType((Type)DecimalType.createDecimalType((int)29, (int)14))).isEqualTo(ImmutableList.of((Object)SqlDecimal.decimal((String)"000000000000001.00000000000000", (DecimalType)DecimalType.createDecimalType((int)29, (int)14)), (Object)SqlDecimal.decimal((String)"383838383838383.12324234234234", (DecimalType)DecimalType.createDecimalType((int)29, (int)14))));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("map_keys", "map(ARRAY[1.0, 2.01], ARRAY[2.2, 3.3])")))).hasType((Type)new ArrayType((Type)DecimalType.createDecimalType((int)3, (int)2))).isEqualTo(ImmutableList.of((Object)SqlDecimal.decimal((String)"1.00", (DecimalType)DecimalType.createDecimalType((int)3, (int)2)), (Object)SqlDecimal.decimal((String)"2.01", (DecimalType)DecimalType.createDecimalType((int)3, (int)2))));
    }

    @Test
    public void testMapValues() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("map_values", "map(ARRAY['1'], ARRAY[ARRAY[TRUE, FALSE, NULL]])")))).hasType((Type)new ArrayType((Type)new ArrayType((Type)BooleanType.BOOLEAN))).isEqualTo(ImmutableList.of((Object)Lists.newArrayList((Object[])new Boolean[]{true, false, null})));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("map_values", "map(ARRAY['1'], ARRAY[ARRAY[ARRAY[1, 2]]])")))).hasType((Type)new ArrayType((Type)new ArrayType((Type)new ArrayType((Type)IntegerType.INTEGER)))).isEqualTo(ImmutableList.of((Object)ImmutableList.of((Object)ImmutableList.of((Object)1, (Object)2))));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("map_values", "map(ARRAY[1, 3], ARRAY['2', '4'])")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)1))).isEqualTo(ImmutableList.of((Object)"2", (Object)"4"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("map_values", "map(ARRAY[1.0E0,2.0E0], ARRAY[ARRAY[1, 2], ARRAY[3]])")))).hasType((Type)new ArrayType((Type)new ArrayType((Type)IntegerType.INTEGER))).isEqualTo(ImmutableList.of((Object)ImmutableList.of((Object)1, (Object)2), (Object)ImmutableList.of((Object)3)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("map_values", "map(ARRAY['puppies'], ARRAY['kittens'])")))).hasType((Type)new ArrayType((Type)VarcharType.createVarcharType((int)7))).isEqualTo(ImmutableList.of((Object)"kittens"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("map_values", "map(ARRAY[TRUE], ARRAY[2])")))).hasType((Type)new ArrayType((Type)IntegerType.INTEGER)).isEqualTo(ImmutableList.of((Object)2));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("map_values", "map(ARRAY['1'], ARRAY[NULL])")))).hasType((Type)new ArrayType((Type)UnknownType.UNKNOWN)).isEqualTo(Lists.newArrayList((Object[])new Object[]{null}));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("map_values", "map(ARRAY['1'], ARRAY[TRUE])")))).hasType((Type)new ArrayType((Type)BooleanType.BOOLEAN)).isEqualTo(ImmutableList.of((Object)true));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("map_values", "map(ARRAY['1'], ARRAY[1.0E0])")))).hasType((Type)new ArrayType((Type)DoubleType.DOUBLE)).isEqualTo(ImmutableList.of((Object)1.0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("map_values", "map(ARRAY['1', '2'], ARRAY[ARRAY[1.0E0, 2.0E0], ARRAY[3.0E0, 4.0E0]])")))).hasType((Type)new ArrayType((Type)new ArrayType((Type)DoubleType.DOUBLE))).isEqualTo(ImmutableList.of((Object)ImmutableList.of((Object)1.0, (Object)2.0), (Object)ImmutableList.of((Object)3.0, (Object)4.0)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("map_values", "map(ARRAY[1.0, 383838383838383.12324234234234], ARRAY[2.2, 3.3])")))).hasType((Type)new ArrayType((Type)DecimalType.createDecimalType((int)2, (int)1))).isEqualTo(ImmutableList.of((Object)SqlDecimal.decimal((String)"2.2", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)), (Object)SqlDecimal.decimal((String)"3.3", (DecimalType)DecimalType.createDecimalType((int)2, (int)1))));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("map_values", "map(ARRAY[1.0, 2.01], ARRAY[383838383838383.12324234234234, 3.3])")))).hasType((Type)new ArrayType((Type)DecimalType.createDecimalType((int)29, (int)14))).isEqualTo(ImmutableList.of((Object)SqlDecimal.decimal((String)"383838383838383.12324234234234", (DecimalType)DecimalType.createDecimalType((int)29, (int)14)), (Object)SqlDecimal.decimal((String)"000000000000003.30000000000000", (DecimalType)DecimalType.createDecimalType((int)29, (int)14))));
    }

    @Test
    public void testEquals() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "MAP(ARRAY[1], ARRAY[2])", "MAP(ARRAY[1], ARRAY[2])")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "MAP(ARRAY[1], ARRAY[2])", "MAP(ARRAY[1], ARRAY[4])")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "MAP(ARRAY[3], ARRAY[1])", "MAP(ARRAY[2], ARRAY[1])")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "MAP(ARRAY[2.2], ARRAY[3.1])", "MAP(ARRAY[2.2], ARRAY[3.1])")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "MAP(ARRAY[2.2], ARRAY[3.1])", "MAP(ARRAY[2.2], ARRAY[3.0])")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("MAP(ARRAY[383838383838383.12324234234234], ARRAY[000000000000003.30000000000000]) = MAP(ARRAY[383838383838383.12324234234234], ARRAY[000000000000003.30000000000000])")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("MAP(ARRAY[383838383838383.12324234234234], ARRAY[000000000000003.30000000000000]) = MAP(ARRAY[383838383838383.12324234234234], ARRAY[000000000000013.30000000000000])")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "MAP(ARRAY[1], ARRAY[2])", "MAP(ARRAY[1, 3], ARRAY[2, 4])")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "MAP(ARRAY[1, 3], ARRAY[2, 4])", "MAP(ARRAY[1], ARRAY[2])")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "MAP(ARRAY[1, 3], ARRAY[2, 4])", "MAP(ARRAY[3, 1], ARRAY[4, 2])")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "MAP(ARRAY[1, 3], ARRAY[2, 4])", "MAP(ARRAY[3, 1], ARRAY[2, 4])")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "MAP(ARRAY['1', '3'], ARRAY[2.0E0, 4.0E0])", "MAP(ARRAY['3', '1'], ARRAY[4.0E0, 2.0E0])")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "MAP(ARRAY['1', '3'], ARRAY[2.0E0, 4.0E0])", "MAP(ARRAY['3', '1'], ARRAY[2.0E0, 4.0E0])")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "MAP(ARRAY[TRUE, FALSE], ARRAY['2', '4'])", "MAP(ARRAY[FALSE, TRUE], ARRAY['4', '2'])")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "MAP(ARRAY[TRUE, FALSE], ARRAY['2', '4'])", "MAP(ARRAY[FALSE, TRUE], ARRAY['2', '4'])")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "MAP(ARRAY[1.0E0, 3.0E0], ARRAY[TRUE, FALSE])", "MAP(ARRAY[3.0E0, 1.0E0], ARRAY[FALSE, TRUE])")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "MAP(ARRAY[1.0E0, 3.0E0], ARRAY[TRUE, FALSE])", "MAP(ARRAY[3.0E0, 1.0E0], ARRAY[TRUE, FALSE])")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "MAP(ARRAY[1.0E0, 3.0E0], ARRAY[from_unixtime(1), from_unixtime(100)])", "MAP(ARRAY[3.0E0, 1.0E0], ARRAY[from_unixtime(100), from_unixtime(1)])")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "MAP(ARRAY[1.0E0, 3.0E0], ARRAY[from_unixtime(1), from_unixtime(100)])", "MAP(ARRAY[3.0E0, 1.0E0], ARRAY[from_unixtime(1), from_unixtime(100)])")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "MAP(ARRAY[from_unixtime(1), from_unixtime(100)], ARRAY['kittens', 'puppies'])", "MAP(ARRAY[from_unixtime(100), from_unixtime(1)], ARRAY['puppies', 'kittens'])")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "MAP(ARRAY[from_unixtime(1), from_unixtime(100)], ARRAY['kittens', 'puppies'])", "MAP(ARRAY[from_unixtime(100), from_unixtime(1)], ARRAY['kittens', 'puppies'])")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "MAP(ARRAY['kittens', 'puppies'], ARRAY[ARRAY[1, 2], ARRAY[3]])", "MAP(ARRAY['kittens', 'puppies'], ARRAY[ARRAY[1, 2], ARRAY[3]])")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "MAP(ARRAY['kittens', 'puppies'], ARRAY[ARRAY[1, 2], ARRAY[3]])", "MAP(ARRAY['kittens', 'puppies'], ARRAY[ARRAY[3], ARRAY[1, 2]])")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "MAP(ARRAY[ARRAY['kittens', 'puppies'], ARRAY['dog', 'cat']], ARRAY[ARRAY[1, 2], ARRAY[3]])", "MAP(ARRAY[ARRAY['kittens', 'puppies'], ARRAY['dog', 'cat']], ARRAY[ARRAY[1, 2], ARRAY[3]])")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "MAP(ARRAY[ARRAY['kittens', 'puppies'], ARRAY['dog', 'cat']], ARRAY[ARRAY[1, 2], ARRAY[3]])", "MAP(ARRAY[ARRAY['kittens', 'puppies'], ARRAY['dog', 'cat']], ARRAY[ARRAY[3], ARRAY[1, 2]])")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "MAP(ARRAY[ARRAY['kittens', 'puppies'], ARRAY['cat', 'dog']], ARRAY[ARRAY[1, 2], ARRAY[3]])", "MAP(ARRAY[ARRAY['kittens', 'puppies'], ARRAY['dog', 'cat']], ARRAY[ARRAY[1, 2], ARRAY[3]])")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "MAP(ARRAY[1.0, 383838383838383.12324234234234], ARRAY[2.2, 3.3])", "MAP(ARRAY[1.0, 383838383838383.12324234234234], ARRAY[2.2, 3.3])")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "MAP(ARRAY[1.0, 383838383838383.12324234234234], ARRAY[2.2, 3.3])", "MAP(ARRAY[1.0, 383838383838383.12324234234234], ARRAY[2.2, 3.2])")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "MAP(ARRAY['kittens', 'puppies'], ARRAY[NULL, 3])", "MAP(ARRAY['kittens', 'puppies'], ARRAY[NULL, 3])")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "MAP(ARRAY['kittens', 'puppies'], ARRAY[3, 3])", "MAP(ARRAY['kittens', 'puppies'], ARRAY[NULL, 3])")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "MAP(ARRAY['kittens', 'puppies'], ARRAY[NULL, 3])", "MAP(ARRAY['kittens', 'puppies'], ARRAY[NULL, 2])")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "MAP(ARRAY['kittens', 'puppies'], ARRAY[NULL, NULL])", "MAP(ARRAY['kittens', 'puppies'], ARRAY[NULL, NULL])")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "MAP(ARRAY[from_unixtime(1), from_unixtime(100)], ARRAY[NULL, FALSE])", "MAP(ARRAY[from_unixtime(100), from_unixtime(1)], ARRAY[FALSE, NULL])")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "MAP(ARRAY[from_unixtime(1), from_unixtime(100)], ARRAY[TRUE, NULL])", "MAP(ARRAY[from_unixtime(100), from_unixtime(1)], ARRAY[TRUE, NULL])")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "MAP(ARRAY[1.0, 383838383838383.12324234234234], ARRAY[2.2, null])", "MAP(ARRAY[1.0, 383838383838383.12324234234234], ARRAY[2.2, null])")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.EQUAL, "MAP(ARRAY[1.0, 2.1], ARRAY[null, null])", "MAP(ARRAY[1.0, 2.1], ARRAY[null, null])")))).isNull((Type)BooleanType.BOOLEAN);
    }

    @Test
    public void testNotEquals() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "MAP(ARRAY[1], ARRAY[2])").binding("b", "MAP(ARRAY[1], ARRAY[2])")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "MAP(ARRAY[1], ARRAY[2])").binding("b", "MAP(ARRAY[1], ARRAY[4])")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "MAP(ARRAY[3], ARRAY[1])").binding("b", "MAP(ARRAY[2], ARRAY[1])")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "MAP(ARRAY[2.2], ARRAY[3.1])").binding("b", "MAP(ARRAY[2.2], ARRAY[3.1])")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "MAP(ARRAY[2.2], ARRAY[3.1])").binding("b", "MAP(ARRAY[2.2], ARRAY[3.0])")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("MAP(ARRAY[383838383838383.12324234234234], ARRAY[000000000000003.30000000000000]) != MAP(ARRAY[383838383838383.12324234234234], ARRAY[000000000000003.30000000000000])")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("MAP(ARRAY[383838383838383.12324234234234], ARRAY[000000000000003.30000000000000]) != MAP(ARRAY[383838383838383.12324234234234], ARRAY[000000000000013.30000000000000])")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "MAP(ARRAY[1], ARRAY[2])").binding("b", "MAP(ARRAY[1, 3], ARRAY[2, 4])")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "MAP(ARRAY[1, 3], ARRAY[2, 4])").binding("b", "MAP(ARRAY[1], ARRAY[2])")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "MAP(ARRAY[1, 3], ARRAY[2, 4])").binding("b", "MAP(ARRAY[3, 1], ARRAY[4, 2])")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "MAP(ARRAY[1, 3], ARRAY[2, 4])").binding("b", "MAP(ARRAY[3, 1], ARRAY[2, 4])")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "MAP(ARRAY['1', '3'], ARRAY[2.0E0, 4.0E0])").binding("b", "MAP(ARRAY['3', '1'], ARRAY[4.0E0, 2.0E0])")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "MAP(ARRAY['1', '3'], ARRAY[2.0E0, 4.0E0])").binding("b", "MAP(ARRAY['3', '1'], ARRAY[2.0E0, 4.0E0])")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "MAP(ARRAY[TRUE, FALSE], ARRAY['2', '4'])").binding("b", "MAP(ARRAY[FALSE, TRUE], ARRAY['4', '2'])")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "MAP(ARRAY[TRUE, FALSE], ARRAY['2', '4'])").binding("b", "MAP(ARRAY[FALSE, TRUE], ARRAY['2', '4'])")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "MAP(ARRAY[1.0E0, 3.0E0], ARRAY[TRUE, FALSE])").binding("b", "MAP(ARRAY[3.0E0, 1.0E0], ARRAY[FALSE, TRUE])")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "MAP(ARRAY[1.0E0, 3.0E0], ARRAY[TRUE, FALSE])").binding("b", "MAP(ARRAY[3.0E0, 1.0E0], ARRAY[TRUE, FALSE])")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "MAP(ARRAY[1.0E0, 3.0E0], ARRAY[from_unixtime(1), from_unixtime(100)])").binding("b", "MAP(ARRAY[3.0E0, 1.0E0], ARRAY[from_unixtime(100), from_unixtime(1)])")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "MAP(ARRAY[1.0E0, 3.0E0], ARRAY[from_unixtime(1), from_unixtime(100)])").binding("b", "MAP(ARRAY[3.0E0, 1.0E0], ARRAY[from_unixtime(1), from_unixtime(100)])")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "MAP(ARRAY[from_unixtime(1), from_unixtime(100)], ARRAY['kittens','puppies'])").binding("b", "MAP(ARRAY[from_unixtime(100), from_unixtime(1)], ARRAY['puppies', 'kittens'])")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "MAP(ARRAY[from_unixtime(1), from_unixtime(100)], ARRAY['kittens','puppies'])").binding("b", "MAP(ARRAY[from_unixtime(100), from_unixtime(1)], ARRAY['kittens', 'puppies'])")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "MAP(ARRAY['kittens', 'puppies'], ARRAY[ARRAY[1, 2], ARRAY[3]])").binding("b", "MAP(ARRAY['kittens','puppies'], ARRAY[ARRAY[1, 2], ARRAY[3]])")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "MAP(ARRAY['kittens', 'puppies'], ARRAY[ARRAY[1, 2], ARRAY[3]])").binding("b", "MAP(ARRAY['kittens','puppies'], ARRAY[ARRAY[3], ARRAY[1, 2]])")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "MAP(ARRAY[1.0, 383838383838383.12324234234234], ARRAY[2.2, 3.3])").binding("b", "MAP(ARRAY[1.0, 383838383838383.12324234234234], ARRAY[2.2, 3.3])")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "MAP(ARRAY[1.0, 383838383838383.12324234234234], ARRAY[2.2, 3.3])").binding("b", "MAP(ARRAY[1.0, 383838383838383.12324234234234], ARRAY[2.2, 3.2])")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "MAP(ARRAY['kittens', 'puppies'], ARRAY[NULL, 3])").binding("b", "MAP(ARRAY['kittens', 'puppies'], ARRAY[NULL, 3])")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "MAP(ARRAY['kittens', 'puppies'], ARRAY[3, 3])").binding("b", "MAP(ARRAY['kittens', 'puppies'], ARRAY[NULL, 3])")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "MAP(ARRAY['kittens', 'puppies'], ARRAY[NULL, 3])").binding("b", "MAP(ARRAY['kittens', 'puppies'], ARRAY[NULL, 2])")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "MAP(ARRAY['kittens', 'puppies'], ARRAY[NULL, NULL])").binding("b", "MAP(ARRAY['kittens', 'puppies'], ARRAY[NULL, NULL])")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "MAP(ARRAY[from_unixtime(1), from_unixtime(100)], ARRAY[NULL, FALSE])").binding("b", "MAP(ARRAY[from_unixtime(100), from_unixtime(1)], ARRAY[FALSE, NULL])")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "MAP(ARRAY[from_unixtime(1), from_unixtime(100)], ARRAY[TRUE, NULL])").binding("b", "MAP(ARRAY[from_unixtime(100), from_unixtime(1)], ARRAY[TRUE, NULL])")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "MAP(ARRAY[1.0, 383838383838383.12324234234234], ARRAY[2.2, null])").binding("b", "MAP(ARRAY[1.0, 383838383838383.12324234234234], ARRAY[2.2, null])")))).isNull((Type)BooleanType.BOOLEAN);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("a != b").binding("a", "MAP(ARRAY[1.0, 2.1], ARRAY[null, null])").binding("b", "MAP(ARRAY[1.0, 2.1], ARRAY[null, null])")))).isNull((Type)BooleanType.BOOLEAN);
    }

    @Test
    public void testDistinctFrom() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "CAST(NULL AS MAP(INTEGER, VARCHAR))", "CAST(NULL AS MAP(INTEGER, VARCHAR))")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "MAP(ARRAY[1], ARRAY[2])", "NULL")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "NULL", "MAP(ARRAY[1], ARRAY[2])")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "MAP(ARRAY[1], ARRAY[2])", "MAP(ARRAY[1], ARRAY[2])")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "MAP(ARRAY[1], ARRAY[NULL])", "MAP(ARRAY[1], ARRAY[NULL])")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "MAP(ARRAY[1], ARRAY[0])", "MAP(ARRAY[1], ARRAY[NULL])")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "MAP(ARRAY[1], ARRAY[NULL])", "MAP(ARRAY[1], ARRAY[0])")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "MAP(ARRAY[1, 2], ARRAY['kittens','puppies'])", "MAP(ARRAY[1, 2], ARRAY['puppies', 'kittens'])")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "MAP(ARRAY[1, 2], ARRAY['kittens','puppies'])", "MAP(ARRAY[1, 2], ARRAY['kittens', 'puppies'])")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "MAP(ARRAY[1, 3], ARRAY['kittens','puppies'])", "MAP(ARRAY[1, 2], ARRAY['kittens', 'puppies'])")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "MAP(ARRAY[1, 3], ARRAY['kittens','puppies'])", "MAP(ARRAY[1, 2], ARRAY['kittens', 'pupp111'])")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "MAP(ARRAY[1, 3], ARRAY['kittens','puppies'])", "MAP(ARRAY[1, 2], ARRAY['kittens', NULL])")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "MAP(ARRAY[1, 3], ARRAY['kittens','puppies'])", "MAP(ARRAY[1, 2], ARRAY[NULL, NULL])")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "MAP(ARRAY[1, 3], ARRAY[MAP(ARRAY['kittens'], ARRAY[1e0]), MAP(ARRAY['puppies'], ARRAY[3e0])])", "MAP(ARRAY[1, 3], ARRAY[MAP(ARRAY['kittens'], ARRAY[1e0]), MAP(ARRAY['puppies'], ARRAY[3e0])])")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.IS_DISTINCT_FROM, "MAP(ARRAY[1, 3], ARRAY[MAP(ARRAY['kittens'], ARRAY[1e0]), MAP(ARRAY['puppies'], ARRAY[3e0])])", "MAP(ARRAY[1, 3], ARRAY[MAP(ARRAY['kittens'], ARRAY[1e0]), MAP(ARRAY['puppies'], ARRAY[4e0])])")))).isEqualTo(true);
    }

    @Test
    public void testMapConcat() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("map_concat", "map(ARRAY[TRUE], ARRAY[1])", "map(CAST(ARRAY[] AS ARRAY(BOOLEAN)), CAST(ARRAY[] AS ARRAY(INTEGER)))")))).hasType((Type)StructuralTestUtil.mapType((Type)BooleanType.BOOLEAN, (Type)IntegerType.INTEGER)).isEqualTo(ImmutableMap.of((Object)true, (Object)1));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("map_concat", "map(ARRAY[TRUE], ARRAY[1])", "map(ARRAY[TRUE, FALSE], ARRAY[10, 20])")))).hasType((Type)StructuralTestUtil.mapType((Type)BooleanType.BOOLEAN, (Type)IntegerType.INTEGER)).isEqualTo(ImmutableMap.of((Object)true, (Object)10, (Object)false, (Object)20));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("map_concat", "map(ARRAY[TRUE, FALSE], ARRAY[1, 2])", "map(ARRAY[TRUE, FALSE], ARRAY[10, 20])")))).hasType((Type)StructuralTestUtil.mapType((Type)BooleanType.BOOLEAN, (Type)IntegerType.INTEGER)).isEqualTo(ImmutableMap.of((Object)true, (Object)10, (Object)false, (Object)20));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("map_concat", "map(ARRAY[TRUE, FALSE], ARRAY[1, 2])", "map(ARRAY[TRUE], ARRAY[10])")))).hasType((Type)StructuralTestUtil.mapType((Type)BooleanType.BOOLEAN, (Type)IntegerType.INTEGER)).isEqualTo(ImmutableMap.of((Object)true, (Object)10, (Object)false, (Object)2));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("map_concat", "map(ARRAY['1', '2', '3'], ARRAY[1, 2, 3])", "map(ARRAY['1', '2', '3', '4'], ARRAY[10, 20, 30, 40])")))).hasType((Type)StructuralTestUtil.mapType((Type)VarcharType.createVarcharType((int)1), (Type)IntegerType.INTEGER)).isEqualTo(ImmutableMap.of((Object)"1", (Object)10, (Object)"2", (Object)20, (Object)"3", (Object)30, (Object)"4", (Object)40));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("map_concat", "map(ARRAY['1', '2', '3', '4'], ARRAY[1, 2, 3, 4])", "map(ARRAY['1', '2', '3', '4'], ARRAY[10, 20, 30, 40])")))).hasType((Type)StructuralTestUtil.mapType((Type)VarcharType.createVarcharType((int)1), (Type)IntegerType.INTEGER)).isEqualTo(ImmutableMap.of((Object)"1", (Object)10, (Object)"2", (Object)20, (Object)"3", (Object)30, (Object)"4", (Object)40));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("map_concat", "map(ARRAY['1', '2', '3', '4'], ARRAY[1, 2, 3, 4])", "map(ARRAY['1', '2', '3'], ARRAY[10, 20, 30])")))).hasType((Type)StructuralTestUtil.mapType((Type)VarcharType.createVarcharType((int)1), (Type)IntegerType.INTEGER)).isEqualTo(ImmutableMap.of((Object)"1", (Object)10, (Object)"2", (Object)20, (Object)"3", (Object)30, (Object)"4", (Object)4));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("map_concat", "map(ARRAY[1, 2, 3], ARRAY[ARRAY[1.0E0], ARRAY[2.0E0], ARRAY[3.0E0]])", "map(ARRAY[1, 2, 3, 4], ARRAY[ARRAY[10.0E0], ARRAY[20.0E0], ARRAY[30.0E0], ARRAY[40.0E0]])")))).hasType((Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)new ArrayType((Type)DoubleType.DOUBLE))).isEqualTo(ImmutableMap.of((Object)1, (Object)ImmutableList.of((Object)10.0), (Object)2, (Object)ImmutableList.of((Object)20.0), (Object)3, (Object)ImmutableList.of((Object)30.0), (Object)4, (Object)ImmutableList.of((Object)40.0)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("map_concat", "map(ARRAY[1, 2, 3, 4], ARRAY[ARRAY[1.0E0], ARRAY[2.0E0], ARRAY[3.0E0], ARRAY[4.0E0]])", "map(ARRAY[1, 2, 3, 4], ARRAY[ARRAY[10.0E0], ARRAY[20.0E0], ARRAY[30.0E0], ARRAY[40.0E0]])")))).hasType((Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)new ArrayType((Type)DoubleType.DOUBLE))).isEqualTo(ImmutableMap.of((Object)1, (Object)ImmutableList.of((Object)10.0), (Object)2, (Object)ImmutableList.of((Object)20.0), (Object)3, (Object)ImmutableList.of((Object)30.0), (Object)4, (Object)ImmutableList.of((Object)40.0)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("map_concat", "map(ARRAY[1, 2, 3, 4], ARRAY[ARRAY[1.0E0], ARRAY[2.0E0], ARRAY[3.0E0], ARRAY[4.0E0]])", "map(ARRAY[1, 2, 3], ARRAY[ARRAY[10.0E0], ARRAY[20.0E0], ARRAY[30.0E0]])")))).hasType((Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)new ArrayType((Type)DoubleType.DOUBLE))).isEqualTo(ImmutableMap.of((Object)1, (Object)ImmutableList.of((Object)10.0), (Object)2, (Object)ImmutableList.of((Object)20.0), (Object)3, (Object)ImmutableList.of((Object)30.0), (Object)4, (Object)ImmutableList.of((Object)4.0)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("map_concat", "map(ARRAY[ARRAY[1.0E0], ARRAY[2.0E0], ARRAY[3.0E0]], ARRAY['1', '2', '3'])", "map(ARRAY[ARRAY[1.0E0], ARRAY[2.0E0], ARRAY[3.0E0], ARRAY[4.0E0]], ARRAY['10', '20', '30', '40'])")))).hasType((Type)StructuralTestUtil.mapType((Type)new ArrayType((Type)DoubleType.DOUBLE), (Type)VarcharType.createVarcharType((int)2))).isEqualTo(ImmutableMap.of((Object)ImmutableList.of((Object)1.0), (Object)"10", (Object)ImmutableList.of((Object)2.0), (Object)"20", (Object)ImmutableList.of((Object)3.0), (Object)"30", (Object)ImmutableList.of((Object)4.0), (Object)"40"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("map_concat", "map(ARRAY[ARRAY[1.0E0], ARRAY[2.0E0], ARRAY[3.0E0]], ARRAY['1', '2', '3'])", "map(ARRAY[ARRAY[1.0E0], ARRAY[2.0E0], ARRAY[3.0E0], ARRAY[4.0E0]], ARRAY['10', '20', '30', '40'])")))).hasType((Type)StructuralTestUtil.mapType((Type)new ArrayType((Type)DoubleType.DOUBLE), (Type)VarcharType.createVarcharType((int)2))).isEqualTo(ImmutableMap.of((Object)ImmutableList.of((Object)1.0), (Object)"10", (Object)ImmutableList.of((Object)2.0), (Object)"20", (Object)ImmutableList.of((Object)3.0), (Object)"30", (Object)ImmutableList.of((Object)4.0), (Object)"40"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("map_concat", "map(ARRAY[ARRAY[1.0E0], ARRAY[2.0E0], ARRAY[3.0E0], ARRAY[4.0E0]], ARRAY['1', '2', '3', '4'])", "map(ARRAY[ARRAY[1.0E0], ARRAY[2.0E0], ARRAY[3.0E0]], ARRAY['10', '20', '30'])")))).hasType((Type)StructuralTestUtil.mapType((Type)new ArrayType((Type)DoubleType.DOUBLE), (Type)VarcharType.createVarcharType((int)2))).isEqualTo(ImmutableMap.of((Object)ImmutableList.of((Object)1.0), (Object)"10", (Object)ImmutableList.of((Object)2.0), (Object)"20", (Object)ImmutableList.of((Object)3.0), (Object)"30", (Object)ImmutableList.of((Object)4.0), (Object)"4"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("map_concat", "MAP(ARRAY[1], ARRAY[-1])", "NULL", "MAP(ARRAY[3], ARRAY[-3])")))).isNull((Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("map_concat", "MAP(ARRAY[1], ARRAY[-1])", "MAP(ARRAY[2], ARRAY[-2])", "MAP(ARRAY[3], ARRAY[-3])")))).hasType((Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER)).isEqualTo(ImmutableMap.of((Object)1, (Object)-1, (Object)2, (Object)-2, (Object)3, (Object)-3));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("map_concat", "map(ARRAY[1], ARRAY[-1])", "map(ARRAY[1], ARRAY[-2])", "MAP(ARRAY[1], ARRAY[-3])")))).hasType((Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER)).isEqualTo(ImmutableMap.of((Object)1, (Object)-3));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("map_concat", "map(ARRAY[1], ARRAY[-1])", "map(ARRAY[], ARRAY[])", "MAP(ARRAY[3], ARRAY[-3])")))).hasType((Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER)).isEqualTo(ImmutableMap.of((Object)1, (Object)-1, (Object)3, (Object)-3));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("map_concat", "map(ARRAY[], ARRAY[])", "map(ARRAY['a_string'], ARRAY['b_string'])", "cast(MAP(ARRAY[], ARRAY[]) AS MAP(VARCHAR, VARCHAR))")))).hasType((Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR)).isEqualTo(ImmutableMap.of((Object)"a_string", (Object)"b_string"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("map_concat", "map(ARRAY[], ARRAY[])", "map(ARRAY[], ARRAY[])", "MAP(ARRAY[], ARRAY[])")))).hasType((Type)StructuralTestUtil.mapType((Type)UnknownType.UNKNOWN, (Type)UnknownType.UNKNOWN)).isEqualTo(ImmutableMap.of());
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("map_concat", "map()", "map()", "map()")))).hasType((Type)StructuralTestUtil.mapType((Type)UnknownType.UNKNOWN, (Type)UnknownType.UNKNOWN)).isEqualTo(ImmutableMap.of());
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("map_concat", "map(ARRAY[1], ARRAY[-1])", "map()", "map(ARRAY[3], ARRAY[-3])")))).hasType((Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER)).isEqualTo(ImmutableMap.of((Object)1, (Object)-1, (Object)3, (Object)-3));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("map_concat", "map(ARRAY[TRUE], ARRAY[1])", "map(ARRAY[TRUE, FALSE], ARRAY[10, 20])", "map(ARRAY[FALSE], ARRAY[0])")))).hasType((Type)StructuralTestUtil.mapType((Type)BooleanType.BOOLEAN, (Type)IntegerType.INTEGER)).isEqualTo(ImmutableMap.of((Object)true, (Object)10, (Object)false, (Object)0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("map_concat", "map(ARRAY[1.0, 383838383838383.12324234234234], ARRAY[2.2, 3.3])", "map(ARRAY[1.0, 383838383838383.12324234234234], ARRAY[2.1, 3.2])")))).hasType((Type)StructuralTestUtil.mapType((Type)DecimalType.createDecimalType((int)29, (int)14), (Type)DecimalType.createDecimalType((int)2, (int)1))).isEqualTo(ImmutableMap.of((Object)SqlDecimal.decimal((String)"000000000000001.00000000000000", (DecimalType)DecimalType.createDecimalType((int)29, (int)14)), (Object)SqlDecimal.decimal((String)"2.1", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)), (Object)SqlDecimal.decimal((String)"383838383838383.12324234234234", (DecimalType)DecimalType.createDecimalType((int)29, (int)14)), (Object)SqlDecimal.decimal((String)"3.2", (DecimalType)DecimalType.createDecimalType((int)2, (int)1))));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("map_concat", "map(ARRAY[1.0], ARRAY[2.2])", "map(ARRAY[5.1], ARRAY[3.2])")))).hasType((Type)StructuralTestUtil.mapType((Type)DecimalType.createDecimalType((int)2, (int)1), (Type)DecimalType.createDecimalType((int)2, (int)1))).isEqualTo(ImmutableMap.of((Object)SqlDecimal.decimal((String)"1.0", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)), (Object)SqlDecimal.decimal((String)"2.2", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)), (Object)SqlDecimal.decimal((String)"5.1", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)), (Object)SqlDecimal.decimal((String)"3.2", (DecimalType)DecimalType.createDecimalType((int)2, (int)1))));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("map_concat", "map(ARRAY[1.0], ARRAY[2.2])", "map(ARRAY[5.1], ARRAY[33.2])")))).hasType((Type)StructuralTestUtil.mapType((Type)DecimalType.createDecimalType((int)2, (int)1), (Type)DecimalType.createDecimalType((int)3, (int)1))).isEqualTo(ImmutableMap.of((Object)SqlDecimal.decimal((String)"1.0", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)), (Object)SqlDecimal.decimal((String)"2.2", (DecimalType)DecimalType.createDecimalType((int)3, (int)1)), (Object)SqlDecimal.decimal((String)"5.1", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)), (Object)SqlDecimal.decimal((String)"33.2", (DecimalType)DecimalType.createDecimalType((int)3, (int)1))));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("map_concat", "map(ARRAY[1.0], ARRAY[2.2])", "map(ARRAY[55.1], ARRAY[33.2])")))).hasType((Type)StructuralTestUtil.mapType((Type)DecimalType.createDecimalType((int)3, (int)1), (Type)DecimalType.createDecimalType((int)3, (int)1))).isEqualTo(ImmutableMap.of((Object)SqlDecimal.decimal((String)"01.0", (DecimalType)DecimalType.createDecimalType((int)3, (int)1)), (Object)SqlDecimal.decimal((String)"2.2", (DecimalType)DecimalType.createDecimalType((int)3, (int)1)), (Object)SqlDecimal.decimal((String)"55.1", (DecimalType)DecimalType.createDecimalType((int)3, (int)1)), (Object)SqlDecimal.decimal((String)"33.2", (DecimalType)DecimalType.createDecimalType((int)3, (int)1))));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("map_concat", "map(ARRAY[1.0], ARRAY[2.2])", "map(ARRAY[5.1], ARRAY[33.22])")))).hasType((Type)StructuralTestUtil.mapType((Type)DecimalType.createDecimalType((int)2, (int)1), (Type)DecimalType.createDecimalType((int)4, (int)2))).isEqualTo(ImmutableMap.of((Object)SqlDecimal.decimal((String)"5.1", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)), (Object)SqlDecimal.decimal((String)"33.22", (DecimalType)DecimalType.createDecimalType((int)4, (int)2)), (Object)SqlDecimal.decimal((String)"1.0", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)), (Object)SqlDecimal.decimal((String)"2.20", (DecimalType)DecimalType.createDecimalType((int)4, (int)2))));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("map_concat", "map(ARRAY[1.0], ARRAY[2.2])", "map(ARRAY[5.1], ARRAY[00000000000000002.2])")))).hasType((Type)StructuralTestUtil.mapType((Type)DecimalType.createDecimalType((int)2, (int)1), (Type)DecimalType.createDecimalType((int)2, (int)1))).isEqualTo(ImmutableMap.of((Object)SqlDecimal.decimal((String)"1.0", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)), (Object)SqlDecimal.decimal((String)"2.2", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)), (Object)SqlDecimal.decimal((String)"5.1", (DecimalType)DecimalType.createDecimalType((int)2, (int)1)), (Object)SqlDecimal.decimal((String)"2.2", (DecimalType)DecimalType.createDecimalType((int)2, (int)1))));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("map_concat", "map(ARRAY[NaN()], ARRAY[1])", "map(ARRAY[NaN()], ARRAY[2])", "map(ARRAY[NaN()], ARRAY[3])")))).hasType((Type)StructuralTestUtil.mapType((Type)DoubleType.DOUBLE, (Type)IntegerType.INTEGER)).isEqualTo(ImmutableMap.of((Object)Double.NaN, (Object)3));
    }

    @Test
    public void testMapToMapCast() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as MAP(varchar, MAP(bigint,bigint)))").binding("a", "MAP(ARRAY[1], ARRAY[MAP(ARRAY[1.0E0], ARRAY[false])])")))).hasType((Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT))).isEqualTo(ImmutableMap.of((Object)"1", (Object)ImmutableMap.of((Object)1L, (Object)0L)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as MAP(varchar,bigint))").binding("a", "MAP(ARRAY['1', '100'], ARRAY[true, false])")))).hasType((Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)BigintType.BIGINT)).isEqualTo(ImmutableMap.of((Object)"1", (Object)1L, (Object)"100", (Object)0L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as MAP(bigint, boolean))").binding("a", "MAP(ARRAY[1,2], ARRAY[1,2])")))).hasType((Type)StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)BooleanType.BOOLEAN)).isEqualTo(ImmutableMap.of((Object)1L, (Object)true, (Object)2L, (Object)true));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as MAP(bigint, ARRAY(boolean)))").binding("a", "MAP(ARRAY[1,2], ARRAY[array[1],array[2]])")))).hasType((Type)StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)new ArrayType((Type)BooleanType.BOOLEAN))).isEqualTo(ImmutableMap.of((Object)1L, (Object)ImmutableList.of((Object)true), (Object)2L, (Object)ImmutableList.of((Object)true)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as MAP(varchar, MAP(bigint,bigint)))").binding("a", "MAP(ARRAY[1], ARRAY[MAP(ARRAY[1.0E0], ARRAY[false])])")))).hasType((Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT))).isEqualTo(ImmutableMap.of((Object)"1", (Object)ImmutableMap.of((Object)1L, (Object)0L)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as MAP(bigint, varchar))").binding("a", "MAP(ARRAY[1,2], ARRAY[DATE '2016-01-02', DATE '2016-02-03'])")))).hasType((Type)StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)VarcharType.VARCHAR)).isEqualTo(ImmutableMap.of((Object)1L, (Object)"2016-01-02", (Object)2L, (Object)"2016-02-03"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as MAP(bigint, varchar))").binding("a", "MAP(ARRAY[1,2], ARRAY[TIMESTAMP '2016-01-02 01:02:03', TIMESTAMP '2016-02-03 03:04:05'])")))).hasType((Type)StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)VarcharType.VARCHAR)).isEqualTo(ImmutableMap.of((Object)1L, (Object)"2016-01-02 01:02:03", (Object)2L, (Object)"2016-02-03 03:04:05"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as MAP(integer, real))").binding("a", "MAP(ARRAY['123', '456'], ARRAY[1.23456E0, 2.34567E0])")))).hasType((Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)RealType.REAL)).isEqualTo(ImmutableMap.of((Object)123, (Object)Float.valueOf(1.23456f), (Object)456, (Object)Float.valueOf(2.34567f)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as MAP(smallint, decimal(6,5)))").binding("a", "MAP(ARRAY['123', '456'], ARRAY[1.23456E0, 2.34567E0])")))).hasType((Type)StructuralTestUtil.mapType((Type)SmallintType.SMALLINT, (Type)DecimalType.createDecimalType((int)6, (int)5))).isEqualTo(ImmutableMap.of((Object)123, (Object)SqlDecimal.decimal((String)"1.23456", (DecimalType)DecimalType.createDecimalType((int)6, (int)5)), (Object)456, (Object)SqlDecimal.decimal((String)"2.34567", (DecimalType)DecimalType.createDecimalType((int)6, (int)5))));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as MAP(bigint, bigint))").binding("a", "MAP(ARRAY[json '1'], ARRAY[1])")))).hasType((Type)StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT)).isEqualTo(ImmutableMap.of((Object)1L, (Object)1L));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as MAP(bigint, bigint))").binding("a", "MAP(ARRAY['1'], ARRAY[json '1'])")))).hasType((Type)StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT)).isEqualTo(ImmutableMap.of((Object)1L, (Object)1L));
        HashMap<Long, Double> expected = new HashMap<Long, Double>();
        expected.put(0L, 1.0);
        expected.put(1L, null);
        expected.put(2L, null);
        expected.put(3L, 2.0);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.expression("cast(a as MAP(BIGINT, DOUBLE))").binding("a", "MAP(ARRAY[0, 1, 2, 3], ARRAY[1,NULL, NULL, 2])")))).hasType((Type)StructuralTestUtil.mapType((Type)BigintType.BIGINT, (Type)DoubleType.DOUBLE)).isEqualTo(expected);
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as MAP(boolean, bigint))").binding("a", "MAP(ARRAY[1, 2], ARRAY[6, 9])").evaluate()).hasMessage("duplicate keys")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as MAP(bigint, bigint))").binding("a", "MAP(ARRAY[json 'null'], ARRAY[1])").evaluate()).hasMessage("map key is null")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
        ((TrinoExceptionAssert)TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.expression("cast(a as MAP(double, integer))").binding("a", "MAP(ARRAY['NaN', ' NaN '], ARRAY[1, 2])").evaluate()).hasMessage("duplicate keys")).hasErrorCode(new ErrorCodeSupplier[]{StandardErrorCode.INVALID_CAST_ARGUMENT});
    }

    @Test
    public void testMapFromEntries() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("map_from_entries", "null")))).isNull((Type)StructuralTestUtil.mapType((Type)UnknownType.UNKNOWN, (Type)UnknownType.UNKNOWN));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("map_from_entries", "ARRAY[]")))).hasType((Type)StructuralTestUtil.mapType((Type)UnknownType.UNKNOWN, (Type)UnknownType.UNKNOWN)).isEqualTo(ImmutableMap.of());
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("map_from_entries", "CAST(ARRAY[] AS ARRAY(ROW(DOUBLE, BIGINT)))")))).hasType((Type)StructuralTestUtil.mapType((Type)DoubleType.DOUBLE, (Type)BigintType.BIGINT)).isEqualTo(ImmutableMap.of());
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("map_from_entries", "ARRAY[(1, 3)]")))).hasType((Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER)).isEqualTo(ImmutableMap.of((Object)1, (Object)3));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("map_from_entries", "ARRAY[(1, 'x'), (2, 'y')]")))).hasType((Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)VarcharType.createVarcharType((int)1))).isEqualTo(ImmutableMap.of((Object)1, (Object)"x", (Object)2, (Object)"y"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("map_from_entries", "ARRAY[('x', 1.0E0), ('y', 2.0E0)]")))).hasType((Type)StructuralTestUtil.mapType((Type)VarcharType.createVarcharType((int)1), (Type)DoubleType.DOUBLE)).isEqualTo(ImmutableMap.of((Object)"x", (Object)1.0, (Object)"y", (Object)2.0));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("map_from_entries", "ARRAY[('x', ARRAY[1, 2]), ('y', ARRAY[3, 4])]")))).hasType((Type)StructuralTestUtil.mapType((Type)VarcharType.createVarcharType((int)1), (Type)new ArrayType((Type)IntegerType.INTEGER))).isEqualTo(ImmutableMap.of((Object)"x", (Object)ImmutableList.of((Object)1, (Object)2), (Object)"y", (Object)ImmutableList.of((Object)3, (Object)4)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("map_from_entries", "ARRAY[(ARRAY[1, 2], 'x'), (ARRAY[3, 4], 'y')]")))).hasType((Type)StructuralTestUtil.mapType((Type)new ArrayType((Type)IntegerType.INTEGER), (Type)VarcharType.createVarcharType((int)1))).isEqualTo(ImmutableMap.of((Object)ImmutableList.of((Object)1, (Object)2), (Object)"x", (Object)ImmutableList.of((Object)3, (Object)4), (Object)"y"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("map_from_entries", "ARRAY[('x', MAP(ARRAY[1], ARRAY[2])), ('y', MAP(ARRAY[3], ARRAY[4]))]")))).hasType((Type)StructuralTestUtil.mapType((Type)VarcharType.createVarcharType((int)1), (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER))).isEqualTo(ImmutableMap.of((Object)"x", (Object)ImmutableMap.of((Object)1, (Object)2), (Object)"y", (Object)ImmutableMap.of((Object)3, (Object)4)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("map_from_entries", "ARRAY[(MAP(ARRAY[1], ARRAY[2]), 'x'), (MAP(ARRAY[3], ARRAY[4]), 'y')]")))).hasType((Type)StructuralTestUtil.mapType((Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER), (Type)VarcharType.createVarcharType((int)1))).isEqualTo(ImmutableMap.of((Object)ImmutableMap.of((Object)1, (Object)2), (Object)"x", (Object)ImmutableMap.of((Object)3, (Object)4), (Object)"y"));
        HashMap<String, Object> expectedNullValueMap = new HashMap<String, Object>();
        expectedNullValueMap.put("x", null);
        expectedNullValueMap.put("y", null);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("map_from_entries", "ARRAY[('x', null), ('y', null)]")))).hasType((Type)StructuralTestUtil.mapType((Type)VarcharType.createVarcharType((int)1), (Type)UnknownType.UNKNOWN)).isEqualTo(expectedNullValueMap);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.function("map_from_entries", "ARRAY[('a', 1), ('a', 2)]").evaluate()).hasMessage("Duplicate map keys (a) are not allowed");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.function("map_from_entries", "ARRAY[(1, 1), (1, 2)]").evaluate()).hasMessage("Duplicate map keys (1) are not allowed");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.function("map_from_entries", "ARRAY[(1.0, 1), (1.0, 2)]").evaluate()).hasMessage("Duplicate map keys (1.0) are not allowed");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.function("map_from_entries", "ARRAY[(ARRAY[1, 2], 1), (ARRAY[1, 2], 2)]").evaluate()).hasMessage("Duplicate map keys ([1, 2]) are not allowed");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.function("map_from_entries", "ARRAY[(MAP(ARRAY[1], ARRAY[2]), 1), (MAP(ARRAY[1], ARRAY[2]), 2)]").evaluate()).hasMessage("Duplicate map keys ({1=2}) are not allowed");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.function("map_from_entries", "ARRAY[(NaN(), 1), (NaN(), 2)]").evaluate()).hasMessage("Duplicate map keys (NaN) are not allowed");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.function("map_from_entries", "ARRAY[(null, 1), (null, 2)]").evaluate()).hasMessage("map key cannot be null");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.function("map_from_entries", "ARRAY[null]").evaluate()).hasMessage("map entry cannot be null");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.function("map_from_entries", "ARRAY[(1, 2), null]").evaluate()).hasMessage("map entry cannot be null");
    }

    @Test
    public void testMultimapFromEntries() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("multimap_from_entries", "null")))).isNull((Type)StructuralTestUtil.mapType((Type)UnknownType.UNKNOWN, (Type)new ArrayType((Type)UnknownType.UNKNOWN)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("multimap_from_entries", "ARRAY[]")))).hasType((Type)StructuralTestUtil.mapType((Type)UnknownType.UNKNOWN, (Type)new ArrayType((Type)UnknownType.UNKNOWN))).isEqualTo(ImmutableMap.of());
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("multimap_from_entries", "CAST(ARRAY[] AS ARRAY(ROW(DOUBLE, BIGINT)))")))).hasType((Type)StructuralTestUtil.mapType((Type)DoubleType.DOUBLE, (Type)new ArrayType((Type)BigintType.BIGINT))).isEqualTo(ImmutableMap.of());
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("multimap_from_entries", "ARRAY[(1, 3), (2, 4), (1, 6), (1, 8), (2, 10)]")))).hasType((Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)new ArrayType((Type)IntegerType.INTEGER))).isEqualTo(ImmutableMap.of((Object)1, (Object)ImmutableList.of((Object)3, (Object)6, (Object)8), (Object)2, (Object)ImmutableList.of((Object)4, (Object)10)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("multimap_from_entries", "ARRAY[(1, 'x'), (2, 'y'), (1, 'a'), (3, 'b'), (2, 'c'), (3, null)]")))).hasType((Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)new ArrayType((Type)VarcharType.createVarcharType((int)1)))).isEqualTo(ImmutableMap.of((Object)1, (Object)ImmutableList.of((Object)"x", (Object)"a"), (Object)2, (Object)ImmutableList.of((Object)"y", (Object)"c"), (Object)3, Arrays.asList("b", null)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("multimap_from_entries", "ARRAY[('x', 1.0E0), ('y', 2.0E0), ('z', null), ('x', 1.5E0), ('y', 2.5E0)]")))).hasType((Type)StructuralTestUtil.mapType((Type)VarcharType.createVarcharType((int)1), (Type)new ArrayType((Type)DoubleType.DOUBLE))).isEqualTo(ImmutableMap.of((Object)"x", (Object)ImmutableList.of((Object)1.0, (Object)1.5), (Object)"y", (Object)ImmutableList.of((Object)2.0, (Object)2.5), (Object)"z", Collections.singletonList(null)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("multimap_from_entries", "ARRAY[(NaN(), 1), (NaN(), 2)]")))).hasType((Type)StructuralTestUtil.mapType((Type)DoubleType.DOUBLE, (Type)new ArrayType((Type)IntegerType.INTEGER))).isEqualTo(ImmutableMap.of((Object)Double.NaN, (Object)ImmutableList.of((Object)1, (Object)2)));
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.function("multimap_from_entries", "ARRAY[(null, 1), (null, 2)]").evaluate()).hasMessage("map key cannot be null");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.function("multimap_from_entries", "ARRAY[null]").evaluate()).hasMessage("map entry cannot be null");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertions.function("multimap_from_entries", "ARRAY[(1, 2), null]").evaluate()).hasMessage("map entry cannot be null");
    }

    @Test
    public void testMapEntries() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("map_entries", "null")))).isNull(TestMapOperators.entryType((Type)UnknownType.UNKNOWN, (Type)UnknownType.UNKNOWN));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("map_entries", "MAP(ARRAY[], null)")))).isNull(TestMapOperators.entryType((Type)UnknownType.UNKNOWN, (Type)UnknownType.UNKNOWN));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("map_entries", "MAP(null, ARRAY[])")))).isNull(TestMapOperators.entryType((Type)UnknownType.UNKNOWN, (Type)UnknownType.UNKNOWN));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("map_entries", "MAP(ARRAY[1, 2, 3], null)")))).isNull(TestMapOperators.entryType((Type)IntegerType.INTEGER, (Type)UnknownType.UNKNOWN));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("map_entries", "MAP(null, ARRAY[1, 2, 3])")))).isNull(TestMapOperators.entryType((Type)UnknownType.UNKNOWN, (Type)IntegerType.INTEGER));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("map_entries", "MAP(ARRAY[], ARRAY[])")))).hasType(TestMapOperators.entryType((Type)UnknownType.UNKNOWN, (Type)UnknownType.UNKNOWN)).isEqualTo(ImmutableList.of());
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("map_entries", "MAP(ARRAY[1], ARRAY['x'])")))).hasType(TestMapOperators.entryType((Type)IntegerType.INTEGER, (Type)VarcharType.createVarcharType((int)1))).isEqualTo(ImmutableList.of((Object)ImmutableList.of((Object)1, (Object)"x")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("map_entries", "MAP(ARRAY[1, 2], ARRAY['x', 'y'])")))).hasType(TestMapOperators.entryType((Type)IntegerType.INTEGER, (Type)VarcharType.createVarcharType((int)1))).isEqualTo(ImmutableList.of((Object)ImmutableList.of((Object)1, (Object)"x"), (Object)ImmutableList.of((Object)2, (Object)"y")));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("map_entries", "MAP(ARRAY['x', 'y'], ARRAY[ARRAY[1, 2], ARRAY[3, 4]])")))).hasType(TestMapOperators.entryType((Type)VarcharType.createVarcharType((int)1), (Type)new ArrayType((Type)IntegerType.INTEGER))).isEqualTo(ImmutableList.of((Object)ImmutableList.of((Object)"x", (Object)ImmutableList.of((Object)1, (Object)2)), (Object)ImmutableList.of((Object)"y", (Object)ImmutableList.of((Object)3, (Object)4))));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("map_entries", "MAP(ARRAY[ARRAY[1.0E0, 2.0E0], ARRAY[3.0E0, 4.0E0]], ARRAY[5.0E0, 6.0E0])")))).hasType(TestMapOperators.entryType((Type)new ArrayType((Type)DoubleType.DOUBLE), (Type)DoubleType.DOUBLE)).isEqualTo(ImmutableList.of((Object)ImmutableList.of((Object)ImmutableList.of((Object)1.0, (Object)2.0), (Object)5.0), (Object)ImmutableList.of((Object)ImmutableList.of((Object)3.0, (Object)4.0), (Object)6.0)));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("map_entries", "MAP(ARRAY['x', 'y'], ARRAY[MAP(ARRAY[1], ARRAY[2]), MAP(ARRAY[3], ARRAY[4])])")))).hasType(TestMapOperators.entryType((Type)VarcharType.createVarcharType((int)1), (Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER))).isEqualTo(ImmutableList.of((Object)ImmutableList.of((Object)"x", (Object)ImmutableMap.of((Object)1, (Object)2)), (Object)ImmutableList.of((Object)"y", (Object)ImmutableMap.of((Object)3, (Object)4))));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("map_entries", "MAP(ARRAY[MAP(ARRAY[1], ARRAY[2]), MAP(ARRAY[3], ARRAY[4])], ARRAY['x', 'y'])")))).hasType(TestMapOperators.entryType((Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER), (Type)VarcharType.createVarcharType((int)1))).isEqualTo(ImmutableList.of((Object)ImmutableList.of((Object)ImmutableMap.of((Object)1, (Object)2), (Object)"x"), (Object)ImmutableList.of((Object)ImmutableMap.of((Object)3, (Object)4), (Object)"y")));
        ImmutableList expectedEntries = ImmutableList.of(Arrays.asList("x", null), Arrays.asList("y", null));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("map_entries", "MAP(ARRAY['x', 'y'], ARRAY[null, null])")))).hasType(TestMapOperators.entryType((Type)VarcharType.createVarcharType((int)1), (Type)UnknownType.UNKNOWN)).isEqualTo(expectedEntries);
    }

    @Test
    public void testEntryMappings() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("map_from_entries", "map_entries(MAP(ARRAY[1, 2, 3], ARRAY['x', 'y', 'z']))")))).hasType((Type)StructuralTestUtil.mapType((Type)IntegerType.INTEGER, (Type)VarcharType.createVarcharType((int)1))).isEqualTo(ImmutableMap.of((Object)1, (Object)"x", (Object)2, (Object)"y", (Object)3, (Object)"z"));
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.function("map_entries", "map_from_entries(ARRAY[(1, 'x'), (2, 'y'), (3, 'z')])")))).hasType(TestMapOperators.entryType((Type)IntegerType.INTEGER, (Type)VarcharType.createVarcharType((int)1))).isEqualTo(ImmutableList.of((Object)ImmutableList.of((Object)1, (Object)"x"), (Object)ImmutableList.of((Object)2, (Object)"y"), (Object)ImmutableList.of((Object)3, (Object)"z")));
    }

    @Test
    public void testIndeterminate() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "cast(null as map(bigint, bigint))")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "map(array[1,2], array[3,4])")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "map(array[1,2], array[1.0,2.0])")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "map(array[1,2], array[null, 3])")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "map(array[1,2], array[null, 3.0])")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "map(array[1,2], array[array[11], array[22]])")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "map(array[1,2], array[array[11], array[null]])")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "map(array[1,2], array[array[11], array[22,null]])")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "map(array[1,2], array[array[11, null], array[22,null]])")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "map(array[1,2], array[array[null], array[null]])")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "map(array[array[1], array[2]], array[array[11], array[22]])")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "map(array[row(1), row(2)], array[array[11], array[22]])")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "map(array[row(1), row(2)], array[array[11], array[22, null]])")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "map(array[1E0, 2E0], array[11E0, null])")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "map(array[1E0, 2E0], array[11E0, 12E0])")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "map(array['a', 'b'], array['c', null])")))).isEqualTo(true);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "map(array['a', 'b'], array['c', 'd'])")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "map(array[true,false], array[false,true])")))).isEqualTo(false);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.INDETERMINATE, "map(array[true,false], array[false,null])")))).isEqualTo(true);
    }

    @Test
    public void testMapHashOperator() {
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.HASH_CODE, "MAP(ARRAY[1], ARRAY[2])")))).isEqualTo(-6461599496541202183L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.HASH_CODE, "MAP(ARRAY[1, 2147483647], ARRAY[2147483647, 2])")))).isEqualTo(3917017315680083193L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.HASH_CODE, "MAP(ARRAY[8589934592], ARRAY[2])")))).isEqualTo(5432374638989305986L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.HASH_CODE, "MAP(ARRAY[true], ARRAY[false])")))).isEqualTo(-6061667139012558290L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.HASH_CODE, "MAP(ARRAY['123'], ARRAY['456'])")))).isEqualTo(370638291674634983L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.XX_HASH_64, "MAP(ARRAY[1], ARRAY[2])")))).isEqualTo(8497999304769451045L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.XX_HASH_64, "MAP(ARRAY[1, 2147483647], ARRAY[2147483647, 2])")))).isEqualTo(-8786792975300342875L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.XX_HASH_64, "MAP(ARRAY[8589934592], ARRAY[2])")))).isEqualTo(3099409451015666579L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.XX_HASH_64, "MAP(ARRAY[true], ARRAY[false])")))).isEqualTo(-6061667139012558290L);
        ((QueryAssertions.ExpressionAssert)((Object)Assertions.assertThat((AssertProvider)this.assertions.operator(OperatorType.XX_HASH_64, "MAP(ARRAY['123'], ARRAY['456'])")))).isEqualTo(370638291674634983L);
    }

    private static Type entryType(Type keyType, Type valueType) {
        return new ArrayType((Type)RowType.anonymous((List)ImmutableList.of((Object)keyType, (Object)valueType)));
    }
}

