/*
 * Decompiled with CFR 0.152.
 */
package io.trino.util;

import com.google.common.collect.Iterables;
import io.trino.util.DisjointSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestDisjointSet {
    @Test
    public void testInitial() {
        DisjointSet disjoint = new DisjointSet();
        for (int i = 0; i < 100; ++i) {
            Assert.assertEquals((int)((Integer)disjoint.find((Object)i)), (int)i);
        }
        Assert.assertEquals((int)disjoint.getEquivalentClasses().size(), (int)100);
    }

    @Test
    public void testMergeAllSequentially() {
        int i;
        DisjointSet disjoint = new DisjointSet();
        for (i = 0; i < 100; ++i) {
            Assert.assertTrue((boolean)disjoint.findAndUnion((Object)i, (Object)(i + 1)));
            if (i != 0) {
                Assert.assertEquals((Object)disjoint.find((Object)(i - 1)), (Object)disjoint.find((Object)i));
            }
            if (i == 99) continue;
            Assert.assertNotEquals((Object)disjoint.find((Object)(i + 1)), (Object)disjoint.find((Object)(i + 2)));
        }
        for (i = 0; i <= 100; ++i) {
            for (int j = 0; j <= 100; ++j) {
                Assert.assertEquals((Object)disjoint.find((Object)i), (Object)disjoint.find((Object)j));
                Assert.assertFalse((boolean)disjoint.findAndUnion((Object)i, (Object)j));
            }
        }
        Collection equivalentClasses = disjoint.getEquivalentClasses();
        Assert.assertEquals((int)equivalentClasses.size(), (int)1);
        Assert.assertEquals((int)((Set)Iterables.getOnlyElement((Iterable)equivalentClasses)).size(), (int)101);
    }

    @Test
    public void testMergeAllBackwardsSequentially() {
        int i;
        DisjointSet disjoint = new DisjointSet();
        for (i = 100; i > 0; --i) {
            Assert.assertTrue((boolean)disjoint.findAndUnion((Object)i, (Object)(i - 1)));
            if (i != 100) {
                Assert.assertEquals((Object)disjoint.find((Object)(i + 1)), (Object)disjoint.find((Object)i));
            }
            if (i == 1) continue;
            Assert.assertNotEquals((Object)disjoint.find((Object)(i - 1)), (Object)disjoint.find((Object)(i - 2)));
        }
        for (i = 0; i <= 100; ++i) {
            for (int j = 0; j <= 100; ++j) {
                Assert.assertEquals((Object)disjoint.find((Object)i), (Object)disjoint.find((Object)j));
                Assert.assertFalse((boolean)disjoint.findAndUnion((Object)i, (Object)j));
            }
        }
        Collection equivalentClasses = disjoint.getEquivalentClasses();
        Assert.assertEquals((int)equivalentClasses.size(), (int)1);
        Assert.assertEquals((int)((Set)Iterables.getOnlyElement((Iterable)equivalentClasses)).size(), (int)101);
    }

    @Test
    public void testMergeFourGroups() {
        DisjointSet disjoint = new DisjointSet();
        List inputs = IntStream.range(0, 96).boxed().collect(Collectors.toList());
        Collections.shuffle(inputs);
        Iterator iterator = inputs.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            Assert.assertTrue((boolean)disjoint.findAndUnion((Object)i, (Object)(i + 4)));
        }
        for (int i = 0; i < 100; ++i) {
            for (int j = 0; j < 100; ++j) {
                if ((i - j) % 4 == 0) {
                    Assert.assertEquals((Object)disjoint.find((Object)i), (Object)disjoint.find((Object)j));
                    Assert.assertFalse((boolean)disjoint.findAndUnion((Object)i, (Object)j));
                    continue;
                }
                Assert.assertNotEquals((Object)disjoint.find((Object)i), (Object)disjoint.find((Object)j));
            }
        }
        Collection equivalentClasses = disjoint.getEquivalentClasses();
        Assert.assertEquals((int)equivalentClasses.size(), (int)4);
        equivalentClasses.forEach(equivalentClass -> Assert.assertEquals((int)equivalentClass.size(), (int)25));
    }

    @Test
    public void testMergeRandomly() {
        DisjointSet disjoint = new DisjointSet();
        Random rand = new Random();
        double[] numbers = new double[100];
        for (int i = 0; i < 100; ++i) {
            numbers[i] = rand.nextDouble();
            disjoint.find((Object)numbers[i]);
        }
        int groupCount = 100;
        while (groupCount > 1) {
            boolean newEquivalence = disjoint.findAndUnion((Object)numbers[rand.nextInt(100)], (Object)numbers[rand.nextInt(100)]);
            if (newEquivalence) {
                --groupCount;
            }
            Assert.assertEquals((int)disjoint.getEquivalentClasses().size(), (int)groupCount);
        }
    }
}

