/*
 * Decompiled with CFR 0.152.
 */
package io.trino.block;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import io.trino.block.BlockAssertions;
import io.trino.spi.PageBuilder;
import io.trino.spi.block.ArrayBlockBuilder;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestBlockBuilder {
    @Test
    public void testMultipleValuesWithNull() {
        BlockBuilder blockBuilder = BigintType.BIGINT.createBlockBuilder(null, 10);
        blockBuilder.appendNull();
        BigintType.BIGINT.writeLong(blockBuilder, 42L);
        blockBuilder.appendNull();
        BigintType.BIGINT.writeLong(blockBuilder, 42L);
        Block block = blockBuilder.build();
        Assert.assertTrue((boolean)block.isNull(0));
        Assert.assertEquals((long)BigintType.BIGINT.getLong(block, 1), (long)42L);
        Assert.assertTrue((boolean)block.isNull(2));
        Assert.assertEquals((long)BigintType.BIGINT.getLong(block, 3), (long)42L);
    }

    @Test
    public void testNewBlockBuilderLike() {
        ImmutableList channels = ImmutableList.of((Object)BigintType.BIGINT, (Object)VarcharType.VARCHAR, (Object)new ArrayType((Type)new ArrayType((Type)BigintType.BIGINT)));
        PageBuilder pageBuilder = new PageBuilder((List)channels);
        BlockBuilder bigintBlockBuilder = pageBuilder.getBlockBuilder(0);
        BlockBuilder varcharBlockBuilder = pageBuilder.getBlockBuilder(1);
        ArrayBlockBuilder arrayBlockBuilder = (ArrayBlockBuilder)pageBuilder.getBlockBuilder(2);
        int i = 0;
        while (i < 100) {
            int value = i++;
            BigintType.BIGINT.writeLong(bigintBlockBuilder, (long)value);
            VarcharType.VARCHAR.writeSlice(varcharBlockBuilder, Slices.utf8Slice((String)("test" + value)));
            arrayBlockBuilder.buildEntry(elementBuilder -> {
                ArrayBlockBuilder nestedArrayBuilder = (ArrayBlockBuilder)elementBuilder;
                nestedArrayBuilder.buildEntry(valueBuilder -> BigintType.BIGINT.writeLong(valueBuilder, (long)value));
                nestedArrayBuilder.buildEntry(valueBuilder -> BigintType.BIGINT.writeLong(valueBuilder, (long)value * 2L));
            });
            pageBuilder.declarePosition();
        }
        PageBuilder newPageBuilder = pageBuilder.newPageBuilderLike();
        for (int i2 = 0; i2 < channels.size(); ++i2) {
            Assert.assertEquals((Object)newPageBuilder.getType(i2), (Object)pageBuilder.getType(i2));
            Assert.assertNotEquals((Object)pageBuilder.getBlockBuilder(i2), (Object)newPageBuilder.getBlockBuilder(i2));
            Assert.assertEquals((int)newPageBuilder.getBlockBuilder(i2).getPositionCount(), (int)0);
            Assert.assertTrue((newPageBuilder.getBlockBuilder(i2).getRetainedSizeInBytes() < pageBuilder.getBlockBuilder(i2).getRetainedSizeInBytes() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testGetPositions() {
        BlockBuilder blockBuilder = BigintType.BIGINT.createFixedSizeBlockBuilder(5);
        blockBuilder.appendNull();
        BigintType.BIGINT.writeLong(blockBuilder, 42L);
        blockBuilder.appendNull();
        BigintType.BIGINT.writeLong(blockBuilder, 43L);
        blockBuilder.appendNull();
        int[] positions = new int[]{0, 1, 1, 1, 4};
        BlockAssertions.assertBlockEquals((Type)BigintType.BIGINT, blockBuilder.getPositions(positions, 0, positions.length), TestBlockBuilder.buildBigintBlock(null, 42, 42, 42, null));
        BlockAssertions.assertBlockEquals((Type)BigintType.BIGINT, blockBuilder.getPositions(positions, 1, 4), TestBlockBuilder.buildBigintBlock(42, 42, 42, null));
        BlockAssertions.assertBlockEquals((Type)BigintType.BIGINT, blockBuilder.getPositions(positions, 2, 1), TestBlockBuilder.buildBigintBlock(42));
        BlockAssertions.assertBlockEquals((Type)BigintType.BIGINT, blockBuilder.getPositions(positions, 0, 0), TestBlockBuilder.buildBigintBlock(new Integer[0]));
        BlockAssertions.assertBlockEquals((Type)BigintType.BIGINT, blockBuilder.getPositions(positions, 1, 0), TestBlockBuilder.buildBigintBlock(new Integer[0]));
        TestBlockBuilder.assertInvalidPosition((Block)blockBuilder, new int[]{-1}, 0, 1);
        TestBlockBuilder.assertInvalidPosition((Block)blockBuilder, new int[]{6}, 0, 1);
        TestBlockBuilder.assertInvalidOffset((Block)blockBuilder, new int[]{6}, 1, 1);
        TestBlockBuilder.assertInvalidOffset((Block)blockBuilder, new int[]{6}, -1, 1);
        TestBlockBuilder.assertInvalidOffset((Block)blockBuilder, new int[]{6}, 2, -1);
        Block block = blockBuilder.build();
        BlockAssertions.assertBlockEquals((Type)BigintType.BIGINT, block.getPositions(positions, 0, positions.length), TestBlockBuilder.buildBigintBlock(null, 42, 42, 42, null));
        BlockAssertions.assertBlockEquals((Type)BigintType.BIGINT, block.getPositions(positions, 1, 4), TestBlockBuilder.buildBigintBlock(42, 42, 42, null));
        BlockAssertions.assertBlockEquals((Type)BigintType.BIGINT, block.getPositions(positions, 2, 1), TestBlockBuilder.buildBigintBlock(42));
        BlockAssertions.assertBlockEquals((Type)BigintType.BIGINT, block.getPositions(positions, 0, 0), TestBlockBuilder.buildBigintBlock(new Integer[0]));
        BlockAssertions.assertBlockEquals((Type)BigintType.BIGINT, block.getPositions(positions, 1, 0), TestBlockBuilder.buildBigintBlock(new Integer[0]));
        TestBlockBuilder.assertInvalidPosition(block, new int[]{-1}, 0, 1);
        TestBlockBuilder.assertInvalidPosition(block, new int[]{6}, 0, 1);
        TestBlockBuilder.assertInvalidOffset(block, new int[]{6}, 1, 1);
        TestBlockBuilder.assertInvalidOffset(block, new int[]{6}, -1, 1);
        TestBlockBuilder.assertInvalidOffset(block, new int[]{6}, 2, -1);
        AtomicBoolean isIdentical = new AtomicBoolean(false);
        block.getPositions(positions, 0, positions.length - 1).retainedBytesForEachPart((part, size) -> {
            if (part == positions) {
                isIdentical.set(true);
            }
        });
        Assert.assertTrue((boolean)isIdentical.get());
    }

    private static Block buildBigintBlock(Integer ... values) {
        BlockBuilder blockBuilder = BigintType.BIGINT.createFixedSizeBlockBuilder(5);
        for (Integer value : values) {
            if (value == null) {
                blockBuilder.appendNull();
                continue;
            }
            BigintType.BIGINT.writeLong(blockBuilder, (long)value.intValue());
        }
        return blockBuilder.build();
    }

    private static void assertInvalidPosition(Block block, int[] positions, int offset, int length) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> block.getPositions(positions, offset, length).getLong(0, 0)).isInstanceOfAny(new Class[]{IllegalArgumentException.class, IndexOutOfBoundsException.class})).hasMessage("Invalid position %d in block with %d positions", new Object[]{positions[0], block.getPositionCount()});
    }

    private static void assertInvalidOffset(Block block, int[] positions, int offset, int length) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> block.getPositions(positions, offset, length).getLong(0, 0)).isInstanceOfAny(new Class[]{IllegalArgumentException.class, IndexOutOfBoundsException.class})).hasMessage(String.format("Invalid offset %d and length %d in array with %d elements", offset, length, positions.length));
    }
}

