/*
 * Decompiled with CFR 0.152.
 */
package io.trino.connector;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.connector.Grants;
import io.trino.plugin.base.security.AllowAllAccessControl;
import io.trino.spi.connector.ConnectorSecurityContext;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.security.AccessDeniedException;
import io.trino.spi.security.ConnectorIdentity;
import io.trino.spi.security.Privilege;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.security.ViewExpression;
import io.trino.spi.type.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;

class MockConnectorAccessControl
extends AllowAllAccessControl {
    private static final String INFORMATION_SCHEMA = "information_schema";
    private final Grants<String> schemaGrants;
    private final Grants<SchemaTableName> tableGrants;
    private final Function<SchemaTableName, ViewExpression> rowFilters;
    private final BiFunction<SchemaTableName, String, ViewExpression> columnMasks;

    MockConnectorAccessControl(Grants<String> schemaGrants, Grants<SchemaTableName> tableGrants, Function<SchemaTableName, ViewExpression> rowFilters, BiFunction<SchemaTableName, String, ViewExpression> columnMasks) {
        this.schemaGrants = Objects.requireNonNull(schemaGrants, "schemaGrants is null");
        this.tableGrants = Objects.requireNonNull(tableGrants, "tableGrants is null");
        this.rowFilters = Objects.requireNonNull(rowFilters, "rowFilters is null");
        this.columnMasks = Objects.requireNonNull(columnMasks, "columnMasks is null");
    }

    public Set<String> filterSchemas(ConnectorSecurityContext context, Set<String> schemaNames) {
        return (Set)schemaNames.stream().filter(schema -> this.canAccessSchema(context.getIdentity(), (String)schema)).collect(ImmutableSet.toImmutableSet());
    }

    public void checkCanGrantSchemaPrivilege(ConnectorSecurityContext context, Privilege privilege, String schemaName, TrinoPrincipal grantee, boolean grantOption) {
        if (!this.schemaGrants.canGrant(context.getIdentity().getUser(), schemaName, privilege)) {
            AccessDeniedException.denyGrantSchemaPrivilege((String)privilege.toString(), (String)schemaName);
        }
    }

    public void checkCanDenySchemaPrivilege(ConnectorSecurityContext context, Privilege privilege, String schemaName, TrinoPrincipal grantee) {
        throw new UnsupportedOperationException();
    }

    public void checkCanRevokeSchemaPrivilege(ConnectorSecurityContext context, Privilege privilege, String schemaName, TrinoPrincipal revokee, boolean grantOption) {
        if (!this.schemaGrants.canGrant(context.getIdentity().getUser(), schemaName, privilege)) {
            AccessDeniedException.denyRevokeSchemaPrivilege((String)privilege.toString(), (String)schemaName);
        }
    }

    public Set<SchemaTableName> filterTables(ConnectorSecurityContext context, Set<SchemaTableName> tableNames) {
        return (Set)tableNames.stream().filter(tableName -> this.canAccessSchema(context.getIdentity(), tableName.getSchemaName()) || this.canAccessTable(context.getIdentity(), (SchemaTableName)tableName)).collect(ImmutableSet.toImmutableSet());
    }

    public void checkCanGrantTablePrivilege(ConnectorSecurityContext context, Privilege privilege, SchemaTableName tableName, TrinoPrincipal grantee, boolean grantOption) {
        String user = context.getIdentity().getUser();
        if (!this.schemaGrants.canGrant(user, tableName.getSchemaName(), privilege) && !this.tableGrants.canGrant(user, tableName, privilege)) {
            AccessDeniedException.denyGrantTablePrivilege((String)privilege.toString(), (String)tableName.getTableName());
        }
    }

    public void checkCanDenyTablePrivilege(ConnectorSecurityContext context, Privilege privilege, SchemaTableName tableName, TrinoPrincipal grantee) {
        throw new UnsupportedOperationException();
    }

    public void checkCanRevokeTablePrivilege(ConnectorSecurityContext context, Privilege privilege, SchemaTableName tableName, TrinoPrincipal revokee, boolean grantOption) {
        String user = context.getIdentity().getUser();
        if (!this.schemaGrants.canGrant(user, tableName.getSchemaName(), privilege) && !this.tableGrants.canGrant(user, tableName, privilege)) {
            AccessDeniedException.denyRevokeTablePrivilege((String)privilege.toString(), (String)tableName.toString());
        }
    }

    public List<ViewExpression> getRowFilters(ConnectorSecurityContext context, SchemaTableName tableName) {
        return (List)Optional.ofNullable(this.rowFilters.apply(tableName)).map(ImmutableList::of).orElseGet(ImmutableList::of);
    }

    public Optional<ViewExpression> getColumnMask(ConnectorSecurityContext context, SchemaTableName tableName, String columnName, Type type) {
        return Optional.ofNullable(this.columnMasks.apply(tableName, columnName));
    }

    public List<ViewExpression> getColumnMasks(ConnectorSecurityContext context, SchemaTableName tableName, String columnName, Type type) {
        throw new UnsupportedOperationException();
    }

    public void grantSchemaPrivileges(String schemaName, Set<Privilege> privileges, TrinoPrincipal grantee, boolean grantOption) {
        this.schemaGrants.grant(grantee, schemaName, privileges, grantOption);
    }

    public void revokeSchemaPrivileges(String schemaName, Set<Privilege> privileges, TrinoPrincipal revokee, boolean grantOption) {
        this.schemaGrants.revoke(revokee, schemaName, privileges, grantOption);
    }

    public void grantTablePrivileges(SchemaTableName tableName, Set<Privilege> privileges, TrinoPrincipal grantee, boolean grantOption) {
        this.tableGrants.grant(grantee, tableName, privileges, grantOption);
    }

    public void revokeTablePrivileges(SchemaTableName tableName, Set<Privilege> privileges, TrinoPrincipal revokee, boolean grantOption) {
        this.tableGrants.revoke(revokee, tableName, privileges, grantOption);
    }

    private boolean canAccessSchema(ConnectorIdentity identity, String schemaName) {
        return schemaName.equalsIgnoreCase(INFORMATION_SCHEMA) || Arrays.stream(Privilege.values()).anyMatch(privilege -> this.schemaGrants.isAllowed(identity.getUser(), schemaName, (Privilege)privilege));
    }

    private boolean canAccessTable(ConnectorIdentity identity, SchemaTableName tableName) {
        return Arrays.stream(Privilege.values()).anyMatch(privilege -> this.tableGrants.isAllowed(identity.getUser(), tableName, (Privilege)privilege));
    }
}

