/*
 * Decompiled with CFR 0.152.
 */
package io.trino.cost;

import io.trino.cost.EstimateAssertion;
import io.trino.cost.SymbolStatsEstimate;
import java.util.Objects;
import org.testng.Assert;

public class SymbolStatsAssertion {
    private final SymbolStatsEstimate statistics;

    private SymbolStatsAssertion(SymbolStatsEstimate statistics) {
        this.statistics = Objects.requireNonNull(statistics, "statistics is null");
    }

    public static SymbolStatsAssertion assertThat(SymbolStatsEstimate actual) {
        return new SymbolStatsAssertion(actual);
    }

    public SymbolStatsAssertion nullsFraction(double expected) {
        EstimateAssertion.assertEstimateEquals(this.statistics.getNullsFraction(), expected, "nullsFraction mismatch", new Object[0]);
        return this;
    }

    public SymbolStatsAssertion nullsFractionUnknown() {
        Assert.assertTrue((boolean)Double.isNaN(this.statistics.getNullsFraction()), (String)("expected unknown nullsFraction but got " + this.statistics.getNullsFraction()));
        return this;
    }

    public SymbolStatsAssertion lowValue(double expected) {
        EstimateAssertion.assertEstimateEquals(this.statistics.getLowValue(), expected, "lowValue mismatch", new Object[0]);
        return this;
    }

    public SymbolStatsAssertion lowValueUnknown() {
        return this.lowValue(Double.NEGATIVE_INFINITY);
    }

    public SymbolStatsAssertion highValue(double expected) {
        EstimateAssertion.assertEstimateEquals(this.statistics.getHighValue(), expected, "highValue mismatch", new Object[0]);
        return this;
    }

    public SymbolStatsAssertion highValueUnknown() {
        return this.highValue(Double.POSITIVE_INFINITY);
    }

    public void empty() {
        this.emptyRange().distinctValuesCount(0.0).nullsFraction(1.0);
    }

    public SymbolStatsAssertion emptyRange() {
        Assert.assertTrue((Double.isNaN(this.statistics.getLowValue()) && Double.isNaN(this.statistics.getHighValue()) ? 1 : 0) != 0, (String)("expected empty range (NaN, NaN) but got (" + this.statistics.getLowValue() + ", " + this.statistics.getHighValue() + ") instead"));
        Assert.assertEquals((Object)this.statistics.getDistinctValuesCount(), (Object)0.0, (String)"expected no distinctValuesCount");
        Assert.assertEquals((Object)this.statistics.getAverageRowSize(), (Object)0.0, (String)"expected 0 average row size");
        Assert.assertEquals((Object)this.statistics.getNullsFraction(), (Object)1.0, (String)"expected all nulls");
        return this;
    }

    public SymbolStatsAssertion unknownRange() {
        return this.lowValueUnknown().highValueUnknown();
    }

    public SymbolStatsAssertion distinctValuesCount(double expected) {
        EstimateAssertion.assertEstimateEquals(this.statistics.getDistinctValuesCount(), expected, "distinctValuesCount mismatch", new Object[0]);
        return this;
    }

    public SymbolStatsAssertion distinctValuesCountUnknown() {
        Assert.assertTrue((boolean)Double.isNaN(this.statistics.getDistinctValuesCount()), (String)("expected unknown distinctValuesCount but got " + this.statistics.getDistinctValuesCount()));
        return this;
    }

    public SymbolStatsAssertion averageRowSize(double expected) {
        EstimateAssertion.assertEstimateEquals(this.statistics.getAverageRowSize(), expected, "average row size mismatch", new Object[0]);
        return this;
    }

    public SymbolStatsAssertion dataSizeUnknown() {
        Assert.assertTrue((boolean)Double.isNaN(this.statistics.getAverageRowSize()), (String)("expected unknown dataSize but got " + this.statistics.getAverageRowSize()));
        return this;
    }

    public SymbolStatsAssertion isEqualTo(SymbolStatsEstimate expected) {
        return this.nullsFraction(expected.getNullsFraction()).lowValue(expected.getLowValue()).highValue(expected.getHighValue()).distinctValuesCount(expected.getDistinctValuesCount()).averageRowSize(expected.getAverageRowSize());
    }
}

