/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.resourcegroups;

import com.google.common.collect.ImmutableList;
import io.trino.execution.resourcegroups.FifoQueue;
import io.trino.execution.resourcegroups.IndexedPriorityQueue;
import io.trino.execution.resourcegroups.StochasticPriorityQueue;
import io.trino.execution.resourcegroups.UpdateablePriorityQueue;
import java.util.Collection;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestUpdateablePriorityQueue {
    @Test
    public void testFifoQueue() {
        Assert.assertEquals(TestUpdateablePriorityQueue.populateAndExtract((UpdateablePriorityQueue<Integer>)new FifoQueue()), (Collection)ImmutableList.of((Object)1, (Object)2, (Object)3));
    }

    @Test
    public void testIndexedPriorityQueue() {
        Assert.assertEquals(TestUpdateablePriorityQueue.populateAndExtract((UpdateablePriorityQueue<Integer>)new IndexedPriorityQueue()), (Collection)ImmutableList.of((Object)3, (Object)2, (Object)1));
        Assert.assertEquals(TestUpdateablePriorityQueue.populateAndExtract((UpdateablePriorityQueue<Integer>)new IndexedPriorityQueue(IndexedPriorityQueue.PriorityOrdering.HIGH_TO_LOW)), (Collection)ImmutableList.of((Object)3, (Object)2, (Object)1));
        Assert.assertEquals(TestUpdateablePriorityQueue.populateAndExtract((UpdateablePriorityQueue<Integer>)new IndexedPriorityQueue(IndexedPriorityQueue.PriorityOrdering.LOW_TO_HIGH)), (Collection)ImmutableList.of((Object)1, (Object)2, (Object)3));
    }

    @Test
    public void testPrioritizedPeekPollIndexedPriorityQueue() {
        IndexedPriorityQueue queue = new IndexedPriorityQueue();
        queue.addOrUpdate((Object)"a", 1L);
        queue.addOrUpdate((Object)"b", 3L);
        queue.addOrUpdate((Object)"c", 2L);
        IndexedPriorityQueue.Prioritized peek1 = queue.peekPrioritized();
        Assertions.assertThat((Object)peek1.getValue()).isEqualTo((Object)"b");
        Assertions.assertThat((long)peek1.getPriority()).isEqualTo(3L);
        IndexedPriorityQueue.Prioritized poll1 = queue.pollPrioritized();
        Assertions.assertThat((Object)poll1.getValue()).isEqualTo((Object)"b");
        Assertions.assertThat((long)poll1.getPriority()).isEqualTo(3L);
        IndexedPriorityQueue.Prioritized peek2 = queue.peekPrioritized();
        Assertions.assertThat((Object)peek2.getValue()).isEqualTo((Object)"c");
        Assertions.assertThat((long)peek2.getPriority()).isEqualTo(2L);
        IndexedPriorityQueue.Prioritized poll2 = queue.pollPrioritized();
        Assertions.assertThat((Object)poll2.getValue()).isEqualTo((Object)"c");
        Assertions.assertThat((long)poll2.getPriority()).isEqualTo(2L);
        IndexedPriorityQueue.Prioritized peek3 = queue.peekPrioritized();
        Assertions.assertThat((Object)peek3.getValue()).isEqualTo((Object)"a");
        Assertions.assertThat((long)peek3.getPriority()).isEqualTo(1L);
        IndexedPriorityQueue.Prioritized poll3 = queue.pollPrioritized();
        Assertions.assertThat((Object)poll3.getValue()).isEqualTo((Object)"a");
        Assertions.assertThat((long)poll3.getPriority()).isEqualTo(1L);
        Assertions.assertThat((Object)queue.peekPrioritized()).isNull();
        Assertions.assertThat((Object)queue.pollPrioritized()).isNull();
    }

    @Test
    public void testStochasticPriorityQueue() {
        Assert.assertTrue((TestUpdateablePriorityQueue.populateAndExtract((UpdateablePriorityQueue<Integer>)new StochasticPriorityQueue()).size() == 3 ? 1 : 0) != 0);
    }

    private static List<Integer> populateAndExtract(UpdateablePriorityQueue<Integer> queue) {
        queue.addOrUpdate((Object)1, 1L);
        queue.addOrUpdate((Object)2, 2L);
        queue.addOrUpdate((Object)3, 3L);
        return ImmutableList.copyOf(queue);
    }
}

