/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.operator.aggregation.AggregationTestUtils;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.tree.QualifiedName;
import io.trino.util.StructuralTestUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class TestMapUnionAggregation {
    private static final TestingFunctionResolution FUNCTION_RESOLUTION = new TestingFunctionResolution();

    @Test
    public void testSimpleWithDuplicates() {
        MapType mapType = StructuralTestUtil.mapType((Type)DoubleType.DOUBLE, (Type)VarcharType.VARCHAR);
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, QualifiedName.of((String)"map_union"), (List<TypeSignatureProvider>)TypeSignatureProvider.fromTypes((Type[])new Type[]{mapType}), (Object)ImmutableMap.of((Object)23.0, (Object)"aaa", (Object)33.0, (Object)"bbb", (Object)43.0, (Object)"ccc", (Object)53.0, (Object)"ddd", (Object)13.0, (Object)"eee"), StructuralTestUtil.arrayBlockOf((Type)mapType, StructuralTestUtil.mapBlockOf((Type)DoubleType.DOUBLE, (Type)VarcharType.VARCHAR, ImmutableMap.of((Object)23.0, (Object)"aaa", (Object)33.0, (Object)"bbb", (Object)53.0, (Object)"ddd")), StructuralTestUtil.mapBlockOf((Type)DoubleType.DOUBLE, (Type)VarcharType.VARCHAR, ImmutableMap.of((Object)43.0, (Object)"ccc", (Object)53.0, (Object)"ddd", (Object)13.0, (Object)"eee"))));
        mapType = StructuralTestUtil.mapType((Type)DoubleType.DOUBLE, (Type)BigintType.BIGINT);
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, QualifiedName.of((String)"map_union"), (List<TypeSignatureProvider>)TypeSignatureProvider.fromTypes((Type[])new Type[]{mapType}), (Object)ImmutableMap.of((Object)1.0, (Object)99L, (Object)2.0, (Object)99L, (Object)3.0, (Object)99L, (Object)4.0, (Object)44L), StructuralTestUtil.arrayBlockOf((Type)mapType, StructuralTestUtil.mapBlockOf((Type)DoubleType.DOUBLE, (Type)BigintType.BIGINT, ImmutableMap.of((Object)1.0, (Object)99L, (Object)2.0, (Object)99L, (Object)3.0, (Object)99L)), StructuralTestUtil.mapBlockOf((Type)DoubleType.DOUBLE, (Type)BigintType.BIGINT, ImmutableMap.of((Object)1.0, (Object)44L, (Object)2.0, (Object)44L, (Object)4.0, (Object)44L))));
        mapType = StructuralTestUtil.mapType((Type)BooleanType.BOOLEAN, (Type)BigintType.BIGINT);
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, QualifiedName.of((String)"map_union"), (List<TypeSignatureProvider>)TypeSignatureProvider.fromTypes((Type[])new Type[]{mapType}), (Object)ImmutableMap.of((Object)false, (Object)12L, (Object)true, (Object)13L), StructuralTestUtil.arrayBlockOf((Type)mapType, StructuralTestUtil.mapBlockOf((Type)BooleanType.BOOLEAN, (Type)BigintType.BIGINT, ImmutableMap.of((Object)false, (Object)12L)), StructuralTestUtil.mapBlockOf((Type)BooleanType.BOOLEAN, (Type)BigintType.BIGINT, ImmutableMap.of((Object)true, (Object)13L, (Object)false, (Object)33L))));
    }

    @Test
    public void testSimpleWithNulls() {
        MapType mapType = StructuralTestUtil.mapType((Type)DoubleType.DOUBLE, (Type)VarcharType.VARCHAR);
        Map<Object, Object> expected = TestMapUnionAggregation.mapOf(23.0, "aaa", 33.0, null, 43.0, "ccc", 53.0, "ddd");
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, QualifiedName.of((String)"map_union"), (List<TypeSignatureProvider>)TypeSignatureProvider.fromTypes((Type[])new Type[]{mapType}), expected, StructuralTestUtil.arrayBlockOf((Type)mapType, StructuralTestUtil.mapBlockOf((Type)DoubleType.DOUBLE, (Type)VarcharType.VARCHAR, TestMapUnionAggregation.mapOf(23.0, "aaa", 33.0, null, 53.0, "ddd")), null, StructuralTestUtil.mapBlockOf((Type)DoubleType.DOUBLE, (Type)VarcharType.VARCHAR, TestMapUnionAggregation.mapOf(43.0, "ccc", 53.0, "ddd"))));
    }

    @Test
    public void testStructural() {
        MapType mapType = StructuralTestUtil.mapType((Type)DoubleType.DOUBLE, (Type)new ArrayType((Type)VarcharType.VARCHAR));
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, QualifiedName.of((String)"map_union"), (List<TypeSignatureProvider>)TypeSignatureProvider.fromTypes((Type[])new Type[]{mapType}), (Object)ImmutableMap.of((Object)1.0, (Object)ImmutableList.of((Object)"a", (Object)"b"), (Object)2.0, (Object)ImmutableList.of((Object)"c", (Object)"d"), (Object)3.0, (Object)ImmutableList.of((Object)"e", (Object)"f"), (Object)4.0, (Object)ImmutableList.of((Object)"r", (Object)"s")), StructuralTestUtil.arrayBlockOf((Type)mapType, StructuralTestUtil.mapBlockOf((Type)DoubleType.DOUBLE, (Type)new ArrayType((Type)VarcharType.VARCHAR), ImmutableMap.of((Object)1.0, (Object)ImmutableList.of((Object)"a", (Object)"b"), (Object)2.0, (Object)ImmutableList.of((Object)"c", (Object)"d"), (Object)3.0, (Object)ImmutableList.of((Object)"e", (Object)"f"))), StructuralTestUtil.mapBlockOf((Type)DoubleType.DOUBLE, (Type)new ArrayType((Type)VarcharType.VARCHAR), ImmutableMap.of((Object)1.0, (Object)ImmutableList.of((Object)"x", (Object)"y"), (Object)4.0, (Object)ImmutableList.of((Object)"r", (Object)"s"), (Object)3.0, (Object)ImmutableList.of((Object)"w", (Object)"z")))));
        mapType = StructuralTestUtil.mapType((Type)DoubleType.DOUBLE, (Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR));
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, QualifiedName.of((String)"map_union"), (List<TypeSignatureProvider>)TypeSignatureProvider.fromTypes((Type[])new Type[]{mapType}), (Object)ImmutableMap.of((Object)1.0, (Object)ImmutableMap.of((Object)"a", (Object)"b"), (Object)2.0, (Object)ImmutableMap.of((Object)"c", (Object)"d"), (Object)3.0, (Object)ImmutableMap.of((Object)"e", (Object)"f")), StructuralTestUtil.arrayBlockOf((Type)mapType, StructuralTestUtil.mapBlockOf((Type)DoubleType.DOUBLE, (Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR), ImmutableMap.of((Object)1.0, (Object)ImmutableMap.of((Object)"a", (Object)"b"), (Object)2.0, (Object)ImmutableMap.of((Object)"c", (Object)"d"))), StructuralTestUtil.mapBlockOf((Type)DoubleType.DOUBLE, (Type)StructuralTestUtil.mapType((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR), ImmutableMap.of((Object)3.0, (Object)ImmutableMap.of((Object)"e", (Object)"f")))));
        mapType = StructuralTestUtil.mapType((Type)new ArrayType((Type)VarcharType.VARCHAR), (Type)DoubleType.DOUBLE);
        AggregationTestUtils.assertAggregation(FUNCTION_RESOLUTION, QualifiedName.of((String)"map_union"), (List<TypeSignatureProvider>)TypeSignatureProvider.fromTypes((Type[])new Type[]{mapType}), (Object)ImmutableMap.of((Object)ImmutableList.of((Object)"a", (Object)"b"), (Object)1.0, (Object)ImmutableList.of((Object)"c", (Object)"d"), (Object)2.0, (Object)ImmutableList.of((Object)"e", (Object)"f"), (Object)3.0), StructuralTestUtil.arrayBlockOf((Type)mapType, StructuralTestUtil.mapBlockOf((Type)new ArrayType((Type)VarcharType.VARCHAR), (Type)DoubleType.DOUBLE, ImmutableMap.of((Object)ImmutableList.of((Object)"a", (Object)"b"), (Object)1.0, (Object)ImmutableList.of((Object)"e", (Object)"f"), (Object)3.0)), StructuralTestUtil.mapBlockOf((Type)new ArrayType((Type)VarcharType.VARCHAR), (Type)DoubleType.DOUBLE, ImmutableMap.of((Object)ImmutableList.of((Object)"c", (Object)"d"), (Object)2.0))));
    }

    private static Map<Object, Object> mapOf(Object ... entries) {
        Preconditions.checkArgument((entries.length % 2 == 0 ? 1 : 0) != 0);
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (int i = 0; i < entries.length; i += 2) {
            map.put(entries[i], entries[i + 1]);
        }
        return map;
    }
}

