/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import io.airlift.stats.QuantileDigest;
import io.trino.operator.aggregation.AbstractTestAggregationFunction;
import io.trino.operator.aggregation.AggregationTestUtils;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.QuantileDigestParametricType;
import io.trino.spi.type.QuantileDigestType;
import io.trino.spi.type.SqlVarbinary;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.tree.QualifiedName;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import org.junit.jupiter.api.Test;

public class TestMergeQuantileDigestFunction
extends AbstractTestAggregationFunction {
    public static final BiFunction<Object, Object, Boolean> QDIGEST_EQUALITY = (actualBinary, expectedBinary) -> {
        if (actualBinary == null && expectedBinary == null) {
            return true;
        }
        Objects.requireNonNull(actualBinary, "actual value was null");
        Objects.requireNonNull(expectedBinary, "expected value was null");
        QuantileDigest actual = new QuantileDigest(Slices.wrappedBuffer((byte[])((SqlVarbinary)actualBinary).getBytes()));
        QuantileDigest expected = new QuantileDigest(Slices.wrappedBuffer((byte[])((SqlVarbinary)expectedBinary).getBytes()));
        return actual.getCount() == expected.getCount() && actual.getMin() == expected.getMin() && actual.getMax() == expected.getMax() && actual.getAlpha() == expected.getAlpha() && actual.getMaxError() == expected.getMaxError();
    };

    @Override
    protected Block[] getSequenceBlocks(int start, int length) {
        Type type = this.functionResolution.getPlannerContext().getTypeManager().getType(new TypeSignature(QuantileDigestParametricType.QDIGEST.getName(), new TypeSignatureParameter[]{TypeSignatureParameter.typeParameter((TypeSignature)DoubleType.DOUBLE.getTypeSignature())}));
        BlockBuilder blockBuilder = type.createBlockBuilder(null, length);
        for (int i = start; i < start + length; ++i) {
            QuantileDigest qdigest = new QuantileDigest(0.0);
            qdigest.add((long)i);
            type.writeSlice(blockBuilder, qdigest.serialize());
        }
        return new Block[]{blockBuilder.build()};
    }

    @Override
    protected String getFunctionName() {
        return "merge";
    }

    @Override
    protected List<Type> getFunctionParameterTypes() {
        return ImmutableList.of((Object)new QuantileDigestType((Type)DoubleType.DOUBLE));
    }

    @Override
    protected Object getExpectedValue(int start, int length) {
        if (length == 0) {
            return null;
        }
        QuantileDigest qdigest = new QuantileDigest(0.0);
        for (int i = start; i < start + length; ++i) {
            qdigest.add((long)i);
        }
        return new SqlVarbinary(qdigest.serialize().getBytes());
    }

    @Override
    @Test
    public void testMultiplePositions() {
        AggregationTestUtils.assertAggregation(this.functionResolution, QualifiedName.of((String)this.getFunctionName()), (List<TypeSignatureProvider>)TypeSignatureProvider.fromTypes(this.getFunctionParameterTypes()), QDIGEST_EQUALITY, "test multiple positions", new Page(this.getSequenceBlocks(0, 5)), this.getExpectedValue(0, 5));
    }

    @Override
    @Test
    public void testMixedNullAndNonNullPositions() {
        AggregationTestUtils.assertAggregation(this.functionResolution, QualifiedName.of((String)this.getFunctionName()), (List<TypeSignatureProvider>)TypeSignatureProvider.fromTypes(this.getFunctionParameterTypes()), QDIGEST_EQUALITY, "test mixed null and nonnull position", new Page(TestMergeQuantileDigestFunction.createAlternatingNullsBlock(this.getFunctionParameterTypes(), this.getSequenceBlocks(0, 10))), this.getExpectedValueIncludingNulls(0, 10, 20));
    }
}

