/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.DynamicSliceOutput;
import io.trino.FullConnectorSession;
import io.trino.jmh.Benchmarks;
import io.trino.json.ir.IrContextVariable;
import io.trino.json.ir.IrJsonPath;
import io.trino.json.ir.IrMemberAccessor;
import io.trino.json.ir.IrPathNode;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.metadata.TestingFunctionResolution;
import io.trino.operator.DriverYieldSignal;
import io.trino.operator.project.PageProcessor;
import io.trino.operator.scalar.JsonPath;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.VariableWidthBlockBuilder;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.security.ConnectorIdentity;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeId;
import io.trino.spi.type.VarcharType;
import io.trino.sql.analyzer.ExpressionAnalyzer;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.planner.TestingPlannerContext;
import io.trino.sql.relational.CallExpression;
import io.trino.sql.relational.Expressions;
import io.trino.sql.tree.QualifiedName;
import io.trino.testing.TestingConnectorSession;
import io.trino.testing.TestingSession;
import io.trino.type.Json2016Type;
import io.trino.type.JsonPathType;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OperationsPerInvocation;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.options.WarmupMode;
import org.testng.annotations.Test;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Fork(value=2)
@Warmup(iterations=5, time=1000, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=5, time=1000, timeUnit=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkJsonFunctions {
    private static final int POSITION_COUNT = 100000;
    private static final FullConnectorSession FULL_CONNECTOR_SESSION = new FullConnectorSession(TestingSession.testSessionBuilder().build(), ConnectorIdentity.ofUser((String)"test"));

    @Benchmark
    @OperationsPerInvocation(value=100000)
    public List<Optional<Page>> benchmarkJsonValueFunction(BenchmarkData data) {
        return ImmutableList.copyOf((Iterator)data.getJsonValuePageProcessor().process((ConnectorSession)FULL_CONNECTOR_SESSION, new DriverYieldSignal(), AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName()), data.getPage()));
    }

    @Benchmark
    @OperationsPerInvocation(value=100000)
    public List<Optional<Page>> benchmarkJsonExtractScalarFunction(BenchmarkData data) {
        return ImmutableList.copyOf((Iterator)data.getJsonExtractScalarPageProcessor().process((ConnectorSession)FULL_CONNECTOR_SESSION, new DriverYieldSignal(), AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName()), data.getPage()));
    }

    @Benchmark
    @OperationsPerInvocation(value=100000)
    public List<Optional<Page>> benchmarkJsonQueryFunction(BenchmarkData data) {
        return ImmutableList.copyOf((Iterator)data.getJsonQueryPageProcessor().process((ConnectorSession)FULL_CONNECTOR_SESSION, new DriverYieldSignal(), AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName()), data.getPage()));
    }

    @Benchmark
    @OperationsPerInvocation(value=100000)
    public List<Optional<Page>> benchmarkJsonExtractFunction(BenchmarkData data) {
        return ImmutableList.copyOf((Iterator)data.getJsonExtractPageProcessor().process(TestingConnectorSession.SESSION, new DriverYieldSignal(), AggregatedMemoryContext.newSimpleAggregatedMemoryContext().newLocalMemoryContext(PageProcessor.class.getSimpleName()), data.getPage()));
    }

    @Test
    public void verify() {
        BenchmarkData data = new BenchmarkData();
        data.setup();
        new BenchmarkJsonFunctions().benchmarkJsonValueFunction(data);
        new BenchmarkJsonFunctions().benchmarkJsonExtractScalarFunction(data);
        new BenchmarkJsonFunctions().benchmarkJsonQueryFunction(data);
        new BenchmarkJsonFunctions().benchmarkJsonExtractFunction(data);
    }

    public static void main(String[] args) throws Exception {
        Benchmarks.benchmark(BenchmarkJsonFunctions.class, (WarmupMode)WarmupMode.BULK_INDI).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        @Param(value={"1", "3", "10"})
        private int depth;
        private Page page;
        private PageProcessor jsonValuePageProcessor;
        private PageProcessor jsonExtractScalarPageProcessor;
        private PageProcessor jsonQueryPageProcessor;
        private PageProcessor jsonExtractPageProcessor;

        @Setup
        public void setup() {
            this.page = new Page(new Block[]{BenchmarkData.createChannel(100000, this.depth)});
            TestingFunctionResolution functionResolution = new TestingFunctionResolution();
            Type jsonPath2016Type = TestingPlannerContext.PLANNER_CONTEXT.getTypeManager().getType(TypeId.of((String)"JsonPath2016"));
            this.jsonValuePageProcessor = BenchmarkData.createJsonValuePageProcessor(this.depth, functionResolution, jsonPath2016Type);
            this.jsonExtractScalarPageProcessor = BenchmarkData.createJsonExtractScalarPageProcessor(this.depth, functionResolution);
            this.jsonQueryPageProcessor = BenchmarkData.createJsonQueryPageProcessor(this.depth, functionResolution, jsonPath2016Type);
            this.jsonExtractPageProcessor = BenchmarkData.createJsonExtractPageProcessor(this.depth, functionResolution);
        }

        private static PageProcessor createJsonValuePageProcessor(int depth, TestingFunctionResolution functionResolution, Type jsonPath2016Type) {
            IrContextVariable pathRoot = new IrContextVariable(Optional.empty());
            for (int i = 1; i <= depth; ++i) {
                pathRoot = new IrMemberAccessor((IrPathNode)pathRoot, Optional.of("key" + i), Optional.empty());
            }
            ImmutableList jsonValueProjection = ImmutableList.of((Object)new CallExpression(functionResolution.resolveFunction(QualifiedName.of((String)"$json_value"), TypeSignatureProvider.fromTypes((List)ImmutableList.of((Object)Json2016Type.JSON_2016, (Object)jsonPath2016Type, (Object)ExpressionAnalyzer.JSON_NO_PARAMETERS_ROW_TYPE, (Object)TinyintType.TINYINT, (Object)VarcharType.VARCHAR, (Object)TinyintType.TINYINT, (Object)VarcharType.VARCHAR))), (List)ImmutableList.of((Object)new CallExpression(functionResolution.resolveFunction(QualifiedName.of((String)"$varchar_to_json"), TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, BooleanType.BOOLEAN})), (List)ImmutableList.of((Object)Expressions.field((int)0, (Type)VarcharType.VARCHAR), (Object)Expressions.constant((Object)true, (Type)BooleanType.BOOLEAN))), (Object)Expressions.constant((Object)new IrJsonPath(false, (IrPathNode)pathRoot), (Type)jsonPath2016Type), (Object)Expressions.constantNull((Type)ExpressionAnalyzer.JSON_NO_PARAMETERS_ROW_TYPE), (Object)Expressions.constant((Object)0L, (Type)TinyintType.TINYINT), (Object)Expressions.constantNull((Type)VarcharType.VARCHAR), (Object)Expressions.constant((Object)0L, (Type)TinyintType.TINYINT), (Object)Expressions.constantNull((Type)VarcharType.VARCHAR))));
            return (PageProcessor)functionResolution.getExpressionCompiler().compilePageProcessor(Optional.empty(), (List)jsonValueProjection).get();
        }

        private static PageProcessor createJsonExtractScalarPageProcessor(int depth, TestingFunctionResolution functionResolution) {
            StringBuilder pathString = new StringBuilder("$");
            for (int i = 1; i <= depth; ++i) {
                pathString.append(".key").append(i);
            }
            VarcharType boundedVarcharType = VarcharType.createVarcharType((int)100);
            ImmutableList jsonExtractScalarProjection = ImmutableList.of((Object)new CallExpression(functionResolution.resolveFunction(QualifiedName.of((String)"json_extract_scalar"), TypeSignatureProvider.fromTypes((List)ImmutableList.of((Object)boundedVarcharType, (Object)JsonPathType.JSON_PATH))), (List)ImmutableList.of((Object)Expressions.field((int)0, (Type)boundedVarcharType), (Object)Expressions.constant((Object)new JsonPath(pathString.toString()), (Type)JsonPathType.JSON_PATH))));
            return (PageProcessor)functionResolution.getExpressionCompiler().compilePageProcessor(Optional.empty(), (List)jsonExtractScalarProjection).get();
        }

        private static PageProcessor createJsonQueryPageProcessor(int depth, TestingFunctionResolution functionResolution, Type jsonPath2016Type) {
            IrContextVariable pathRoot = new IrContextVariable(Optional.empty());
            for (int i = 1; i <= depth - 1; ++i) {
                pathRoot = new IrMemberAccessor((IrPathNode)pathRoot, Optional.of("key" + i), Optional.empty());
            }
            ImmutableList jsonQueryProjection = ImmutableList.of((Object)new CallExpression(functionResolution.resolveFunction(QualifiedName.of((String)"$json_query"), TypeSignatureProvider.fromTypes((List)ImmutableList.of((Object)Json2016Type.JSON_2016, (Object)jsonPath2016Type, (Object)ExpressionAnalyzer.JSON_NO_PARAMETERS_ROW_TYPE, (Object)TinyintType.TINYINT, (Object)TinyintType.TINYINT, (Object)TinyintType.TINYINT))), (List)ImmutableList.of((Object)new CallExpression(functionResolution.resolveFunction(QualifiedName.of((String)"$varchar_to_json"), TypeSignatureProvider.fromTypes((Type[])new Type[]{VarcharType.VARCHAR, BooleanType.BOOLEAN})), (List)ImmutableList.of((Object)Expressions.field((int)0, (Type)VarcharType.VARCHAR), (Object)Expressions.constant((Object)true, (Type)BooleanType.BOOLEAN))), (Object)Expressions.constant((Object)new IrJsonPath(false, (IrPathNode)pathRoot), (Type)jsonPath2016Type), (Object)Expressions.constantNull((Type)ExpressionAnalyzer.JSON_NO_PARAMETERS_ROW_TYPE), (Object)Expressions.constant((Object)0L, (Type)TinyintType.TINYINT), (Object)Expressions.constant((Object)0L, (Type)TinyintType.TINYINT), (Object)Expressions.constant((Object)0L, (Type)TinyintType.TINYINT))));
            return (PageProcessor)functionResolution.getExpressionCompiler().compilePageProcessor(Optional.empty(), (List)jsonQueryProjection).get();
        }

        private static PageProcessor createJsonExtractPageProcessor(int depth, TestingFunctionResolution functionResolution) {
            StringBuilder pathString = new StringBuilder("$");
            for (int i = 1; i <= depth - 1; ++i) {
                pathString.append(".key").append(i);
            }
            VarcharType boundedVarcharType = VarcharType.createVarcharType((int)100);
            ImmutableList jsonExtractScalarProjection = ImmutableList.of((Object)new CallExpression(functionResolution.resolveFunction(QualifiedName.of((String)"json_extract"), TypeSignatureProvider.fromTypes((List)ImmutableList.of((Object)boundedVarcharType, (Object)JsonPathType.JSON_PATH))), (List)ImmutableList.of((Object)Expressions.field((int)0, (Type)boundedVarcharType), (Object)Expressions.constant((Object)new JsonPath(pathString.toString()), (Type)JsonPathType.JSON_PATH))));
            return (PageProcessor)functionResolution.getExpressionCompiler().compilePageProcessor(Optional.empty(), (List)jsonExtractScalarProjection).get();
        }

        private static Block createChannel(int positionCount, int depth) {
            VariableWidthBlockBuilder blockBuilder = VarcharType.VARCHAR.createBlockBuilder(null, positionCount);
            for (int position = 0; position < positionCount; ++position) {
                int i;
                DynamicSliceOutput slice = new DynamicSliceOutput(20);
                for (i = 1; i <= depth; ++i) {
                    slice.appendBytes(("{\"key" + i + "\" : ").getBytes(StandardCharsets.UTF_8));
                }
                slice.appendBytes(BenchmarkData.generateRandomJsonText().getBytes(StandardCharsets.UTF_8));
                for (i = 1; i <= depth; ++i) {
                    slice.appendByte(125);
                }
                VarcharType.VARCHAR.writeSlice((BlockBuilder)blockBuilder, slice.slice());
            }
            return blockBuilder.build();
        }

        private static String generateRandomJsonText() {
            String characters = "ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890";
            int length = ThreadLocalRandom.current().nextInt(10) + 1;
            StringBuilder builder = new StringBuilder(length + 2);
            builder.append('\"');
            for (int i = 0; i < length; ++i) {
                builder.append(characters.charAt(ThreadLocalRandom.current().nextInt(characters.length())));
            }
            builder.append('\"');
            return builder.toString();
        }

        public PageProcessor getJsonValuePageProcessor() {
            return this.jsonValuePageProcessor;
        }

        public PageProcessor getJsonExtractScalarPageProcessor() {
            return this.jsonExtractScalarPageProcessor;
        }

        public PageProcessor getJsonQueryPageProcessor() {
            return this.jsonQueryPageProcessor;
        }

        public PageProcessor getJsonExtractPageProcessor() {
            return this.jsonExtractPageProcessor;
        }

        public Page getPage() {
            return this.page;
        }
    }
}

