/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.unnest;

import io.trino.block.BlockAssertions;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.LongArrayBlock;
import io.trino.spi.block.LongArrayBlockBuilder;
import io.trino.spi.type.BigintType;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.RunnerException;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;
import org.openjdk.jmh.runner.options.VerboseMode;

@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.MICROSECONDS)
@Fork(value=3)
@Warmup(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@BenchmarkMode(value={Mode.AverageTime})
public class BenchmarkCopyBlock {
    private static final int POSITIONS_PER_PAGE = 10000;
    private static final int BLOCK_COUNT = 100;

    @Benchmark
    public Block[] copyBlockByLoop(BenchmarkData data) {
        Block[] blocks = new Block[100];
        for (int i = 0; i < 100; ++i) {
            Block block = data.blocks.get(i);
            int positionCount = block.getPositionCount();
            long[] values = new long[positionCount];
            for (int j = 0; j < positionCount; ++j) {
                values[j] = block.getLong(j, 0);
            }
            boolean[] valueIsNull = BenchmarkCopyBlock.copyIsNulls(block);
            blocks[i] = new LongArrayBlock(positionCount, Optional.of(valueIsNull), values);
        }
        return blocks;
    }

    @Benchmark
    public Block[] copyBlockByAppend(BenchmarkData data) {
        Block[] blocks = new Block[100];
        for (int i = 0; i < 100; ++i) {
            Block block = data.blocks.get(i);
            int positionCount = block.getPositionCount();
            LongArrayBlockBuilder longArrayBlockBuilder = new LongArrayBlockBuilder(null, 10000);
            for (int j = 0; j < positionCount; ++j) {
                BigintType.BIGINT.appendTo(block, j, (BlockBuilder)longArrayBlockBuilder);
            }
            blocks[i] = longArrayBlockBuilder.build();
        }
        return blocks;
    }

    private static boolean[] copyIsNulls(Block block) {
        int positionCount = block.getPositionCount();
        boolean[] valueIsNull = new boolean[positionCount + 1];
        if (block.mayHaveNull()) {
            for (int i = 0; i < positionCount; ++i) {
                valueIsNull[i] = block.isNull(i);
            }
        }
        return valueIsNull;
    }

    public static void main(String[] args) throws RunnerException {
        Options options = new OptionsBuilder().verbosity(VerboseMode.NORMAL).include(".*" + BenchmarkCopyBlock.class.getSimpleName() + ".*").build();
        new Runner(options).run();
    }

    private static Block createRandomLongsBlock(int positionCount, double nullRate) {
        if (nullRate < 0.0 || nullRate > 1.0) {
            throw new IllegalArgumentException(String.format("nullRate %f is not valid.", nullRate));
        }
        return BlockAssertions.createLongsBlock(IntStream.range(0, positionCount).mapToObj(i -> {
            if (ThreadLocalRandom.current().nextDouble(1.0) < nullRate) {
                return null;
            }
            return ThreadLocalRandom.current().nextLong();
        }).collect(Collectors.toList()));
    }

    @State(value=Scope.Thread)
    public static class BenchmarkData {
        @Param(value={"0.0", "0.2"})
        private float nullsRatio;
        List<Block> blocks = new ArrayList<Block>();

        @Setup
        public void setup() {
            for (int i = 0; i < 100; ++i) {
                this.blocks.add(BenchmarkCopyBlock.createRandomLongsBlock(10000, this.nullsRatio));
            }
        }
    }
}

