/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.SessionTestUtils;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.TestingColumnHandle;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.predicate.ValueSet;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.sql.DynamicFilters;
import io.trino.sql.analyzer.TypeSignatureTranslator;
import io.trino.sql.planner.LocalDynamicFiltersCollector;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SymbolAllocator;
import io.trino.sql.planner.TestingPlannerContext;
import io.trino.sql.planner.TypeProvider;
import io.trino.sql.planner.plan.DynamicFilterId;
import io.trino.sql.tree.Cast;
import io.trino.sql.tree.ComparisonExpression;
import io.trino.sql.tree.Expression;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestLocalDynamicFiltersCollector {
    @Test
    public void testSingleEquality() {
        LocalDynamicFiltersCollector collector = new LocalDynamicFiltersCollector(SessionTestUtils.TEST_SESSION);
        DynamicFilterId filterId = new DynamicFilterId("filter");
        collector.register((Set)ImmutableSet.of((Object)filterId));
        SymbolAllocator symbolAllocator = new SymbolAllocator();
        Symbol symbol = symbolAllocator.newSymbol("symbol", (Type)BigintType.BIGINT);
        TestingColumnHandle column = new TestingColumnHandle("column");
        DynamicFilter filter = this.createDynamicFilter(collector, (List<DynamicFilters.Descriptor>)ImmutableList.of((Object)new DynamicFilters.Descriptor(filterId, (Expression)symbol.toSymbolReference())), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)symbol, (Object)column), symbolAllocator.getTypes());
        Assert.assertEquals((Set)filter.getColumnsCovered(), Set.of(column), (String)"columns covered");
        CompletableFuture isBlocked = filter.isBlocked();
        Assert.assertFalse((boolean)filter.isComplete());
        Assert.assertTrue((boolean)filter.isAwaitable());
        Assert.assertFalse((boolean)isBlocked.isDone());
        Assert.assertEquals((Object)filter.getCurrentPredicate(), (Object)TupleDomain.all());
        Domain domain = Domain.singleValue((Type)BigintType.BIGINT, (Object)7L);
        collector.collectDynamicFilterDomains((Map)ImmutableMap.of((Object)filterId, (Object)domain));
        Assert.assertTrue((boolean)filter.isComplete());
        Assert.assertFalse((boolean)filter.isAwaitable());
        Assert.assertTrue((boolean)isBlocked.isDone());
        Assert.assertEquals((Object)filter.getCurrentPredicate(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)column, (Object)domain)));
    }

    @Test
    public void testDynamicFilterCoercion() {
        LocalDynamicFiltersCollector collector = new LocalDynamicFiltersCollector(SessionTestUtils.TEST_SESSION);
        DynamicFilterId filterId = new DynamicFilterId("filter");
        collector.register((Set)ImmutableSet.of((Object)filterId));
        SymbolAllocator symbolAllocator = new SymbolAllocator();
        Symbol symbol = symbolAllocator.newSymbol("symbol", (Type)IntegerType.INTEGER);
        TestingColumnHandle column = new TestingColumnHandle("column");
        DynamicFilter filter = this.createDynamicFilter(collector, (List<DynamicFilters.Descriptor>)ImmutableList.of((Object)new DynamicFilters.Descriptor(filterId, (Expression)new Cast((Expression)symbol.toSymbolReference(), TypeSignatureTranslator.toSqlType((Type)BigintType.BIGINT)))), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)symbol, (Object)column), symbolAllocator.getTypes());
        Assert.assertEquals((Set)filter.getColumnsCovered(), Set.of(column), (String)"columns covered");
        CompletableFuture isBlocked = filter.isBlocked();
        Assert.assertFalse((boolean)filter.isComplete());
        Assert.assertTrue((boolean)filter.isAwaitable());
        Assert.assertFalse((boolean)isBlocked.isDone());
        Assert.assertEquals((Object)filter.getCurrentPredicate(), (Object)TupleDomain.all());
        Domain domain = Domain.singleValue((Type)BigintType.BIGINT, (Object)7L);
        collector.collectDynamicFilterDomains((Map)ImmutableMap.of((Object)filterId, (Object)domain));
        Assert.assertTrue((boolean)filter.isComplete());
        Assert.assertFalse((boolean)filter.isAwaitable());
        Assert.assertTrue((boolean)isBlocked.isDone());
        Assert.assertEquals((Object)filter.getCurrentPredicate(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)column, (Object)Domain.singleValue((Type)IntegerType.INTEGER, (Object)7L))));
    }

    @Test
    public void testDynamicFilterCancellation() {
        LocalDynamicFiltersCollector collector = new LocalDynamicFiltersCollector(SessionTestUtils.TEST_SESSION);
        DynamicFilterId filterId = new DynamicFilterId("filter");
        collector.register((Set)ImmutableSet.of((Object)filterId));
        SymbolAllocator symbolAllocator = new SymbolAllocator();
        Symbol symbol = symbolAllocator.newSymbol("symbol", (Type)BigintType.BIGINT);
        TestingColumnHandle column = new TestingColumnHandle("column");
        DynamicFilter filter = this.createDynamicFilter(collector, (List<DynamicFilters.Descriptor>)ImmutableList.of((Object)new DynamicFilters.Descriptor(filterId, (Expression)symbol.toSymbolReference())), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)symbol, (Object)column), symbolAllocator.getTypes());
        CompletableFuture isBlocked = filter.isBlocked();
        Assert.assertFalse((boolean)filter.isComplete());
        Assert.assertFalse((boolean)isBlocked.isDone());
        Assert.assertEquals((Object)filter.getCurrentPredicate(), (Object)TupleDomain.all());
        Assert.assertFalse((boolean)isBlocked.cancel(false));
        Assert.assertFalse((boolean)isBlocked.isDone());
        Assert.assertFalse((boolean)filter.isComplete());
        Domain domain = Domain.singleValue((Type)BigintType.BIGINT, (Object)7L);
        collector.collectDynamicFilterDomains((Map)ImmutableMap.of((Object)filterId, (Object)domain));
        Assert.assertTrue((boolean)filter.isComplete());
        Assert.assertTrue((boolean)isBlocked.isDone());
        Assert.assertEquals((Object)filter.getCurrentPredicate(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)column, (Object)domain)));
    }

    @Test
    public void testMultipleProbeColumns() {
        LocalDynamicFiltersCollector collector = new LocalDynamicFiltersCollector(SessionTestUtils.TEST_SESSION);
        DynamicFilterId filterId = new DynamicFilterId("filter");
        collector.register((Set)ImmutableSet.of((Object)filterId));
        SymbolAllocator symbolAllocator = new SymbolAllocator();
        Symbol symbol1 = symbolAllocator.newSymbol("symbol1", (Type)BigintType.BIGINT);
        Symbol symbol2 = symbolAllocator.newSymbol("symbol2", (Type)BigintType.BIGINT);
        TestingColumnHandle column1 = new TestingColumnHandle("column1");
        TestingColumnHandle column2 = new TestingColumnHandle("column2");
        DynamicFilter filter = this.createDynamicFilter(collector, (List<DynamicFilters.Descriptor>)ImmutableList.of((Object)new DynamicFilters.Descriptor(filterId, (Expression)symbol1.toSymbolReference()), (Object)new DynamicFilters.Descriptor(filterId, (Expression)symbol2.toSymbolReference())), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)symbol1, (Object)column1, (Object)symbol2, (Object)column2), symbolAllocator.getTypes());
        Assert.assertEquals((Set)filter.getColumnsCovered(), Set.of(column1, column2), (String)"columns covered");
        CompletableFuture isBlocked = filter.isBlocked();
        Assert.assertFalse((boolean)filter.isComplete());
        Assert.assertTrue((boolean)filter.isAwaitable());
        Assert.assertFalse((boolean)isBlocked.isDone());
        Assert.assertEquals((Object)filter.getCurrentPredicate(), (Object)TupleDomain.all());
        Domain domain = Domain.singleValue((Type)BigintType.BIGINT, (Object)7L);
        collector.collectDynamicFilterDomains((Map)ImmutableMap.of((Object)filterId, (Object)domain));
        Assert.assertTrue((boolean)filter.isComplete());
        Assert.assertFalse((boolean)filter.isAwaitable());
        Assert.assertTrue((boolean)isBlocked.isDone());
        Assert.assertEquals((Object)filter.getCurrentPredicate(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)column1, (Object)domain, (Object)column2, (Object)domain)));
    }

    @Test
    public void testComparison() {
        LocalDynamicFiltersCollector collector = new LocalDynamicFiltersCollector(SessionTestUtils.TEST_SESSION);
        DynamicFilterId filterId1 = new DynamicFilterId("filter1");
        DynamicFilterId filterId2 = new DynamicFilterId("filter2");
        collector.register((Set)ImmutableSet.of((Object)filterId1, (Object)filterId2));
        SymbolAllocator symbolAllocator = new SymbolAllocator();
        Symbol symbol = symbolAllocator.newSymbol("symbol", (Type)BigintType.BIGINT);
        TestingColumnHandle column = new TestingColumnHandle("column");
        DynamicFilter filter = this.createDynamicFilter(collector, (List<DynamicFilters.Descriptor>)ImmutableList.of((Object)new DynamicFilters.Descriptor(filterId1, (Expression)symbol.toSymbolReference(), ComparisonExpression.Operator.GREATER_THAN), (Object)new DynamicFilters.Descriptor(filterId2, (Expression)symbol.toSymbolReference(), ComparisonExpression.Operator.LESS_THAN)), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)symbol, (Object)column), symbolAllocator.getTypes());
        Assert.assertEquals((Set)filter.getColumnsCovered(), Set.of(column), (String)"columns covered");
        CompletableFuture isBlocked = filter.isBlocked();
        Assert.assertFalse((boolean)filter.isComplete());
        Assert.assertFalse((boolean)isBlocked.isDone());
        Assert.assertEquals((Object)filter.getCurrentPredicate(), (Object)TupleDomain.all());
        collector.collectDynamicFilterDomains((Map)ImmutableMap.of((Object)filterId1, (Object)Domain.multipleValues((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)1L, (Object)2L, (Object)3L)), (Object)filterId2, (Object)Domain.multipleValues((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)4L, (Object)5L, (Object)6L))));
        Assert.assertTrue((boolean)filter.isComplete());
        Assert.assertTrue((boolean)isBlocked.isDone());
        Assert.assertEquals((Object)filter.getCurrentPredicate(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)column, (Object)Domain.create((ValueSet)ValueSet.ofRanges((Range)Range.range((Type)BigintType.BIGINT, (Object)1L, (boolean)false, (Object)6L, (boolean)false), (Range[])new Range[0]), (boolean)false))));
    }

    @Test
    public void testIsNotDistinctFrom() {
        LocalDynamicFiltersCollector collector = new LocalDynamicFiltersCollector(SessionTestUtils.TEST_SESSION);
        DynamicFilterId filterId1 = new DynamicFilterId("filter1");
        DynamicFilterId filterId2 = new DynamicFilterId("filter2");
        collector.register((Set)ImmutableSet.of((Object)filterId1, (Object)filterId2));
        SymbolAllocator symbolAllocator = new SymbolAllocator();
        Symbol symbol1 = symbolAllocator.newSymbol("symbol1", (Type)BigintType.BIGINT);
        Symbol symbol2 = symbolAllocator.newSymbol("symbol2", (Type)BigintType.BIGINT);
        TestingColumnHandle column1 = new TestingColumnHandle("column1");
        TestingColumnHandle column2 = new TestingColumnHandle("column2");
        DynamicFilter filter = this.createDynamicFilter(collector, (List<DynamicFilters.Descriptor>)ImmutableList.of((Object)new DynamicFilters.Descriptor(filterId1, (Expression)symbol1.toSymbolReference(), ComparisonExpression.Operator.EQUAL, true), (Object)new DynamicFilters.Descriptor(filterId2, (Expression)symbol2.toSymbolReference(), ComparisonExpression.Operator.EQUAL, true)), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)symbol1, (Object)column1, (Object)symbol2, (Object)column2), symbolAllocator.getTypes());
        Assert.assertEquals((Set)filter.getColumnsCovered(), Set.of(column1, column2), (String)"columns covered");
        CompletableFuture isBlocked = filter.isBlocked();
        Assert.assertFalse((boolean)filter.isComplete());
        Assert.assertFalse((boolean)isBlocked.isDone());
        Assert.assertEquals((Object)filter.getCurrentPredicate(), (Object)TupleDomain.all());
        collector.collectDynamicFilterDomains((Map)ImmutableMap.of((Object)filterId1, (Object)Domain.multipleValues((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)4L, (Object)5L, (Object)6L)), (Object)filterId2, (Object)Domain.none((Type)BigintType.BIGINT)));
        Assert.assertTrue((boolean)filter.isComplete());
        Assert.assertTrue((boolean)isBlocked.isDone());
        Assert.assertEquals((Object)filter.getCurrentPredicate(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)column1, (Object)Domain.create((ValueSet)ValueSet.of((Type)BigintType.BIGINT, (Object)4L, (Object[])new Object[]{5L, 6L}), (boolean)true), (Object)column2, (Object)Domain.onlyNull((Type)BigintType.BIGINT))));
    }

    @Test
    public void testMultipleBuildColumnsSingleProbeColumn() {
        LocalDynamicFiltersCollector collector = new LocalDynamicFiltersCollector(SessionTestUtils.TEST_SESSION);
        DynamicFilterId filter1 = new DynamicFilterId("filter1");
        DynamicFilterId filter2 = new DynamicFilterId("filter2");
        collector.register((Set)ImmutableSet.of((Object)filter1));
        collector.register((Set)ImmutableSet.of((Object)filter2));
        SymbolAllocator symbolAllocator = new SymbolAllocator();
        Symbol symbol = symbolAllocator.newSymbol("symbol", (Type)BigintType.BIGINT);
        TestingColumnHandle column = new TestingColumnHandle("column");
        DynamicFilter filter = this.createDynamicFilter(collector, (List<DynamicFilters.Descriptor>)ImmutableList.of((Object)new DynamicFilters.Descriptor(filter1, (Expression)symbol.toSymbolReference()), (Object)new DynamicFilters.Descriptor(filter2, (Expression)symbol.toSymbolReference())), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)symbol, (Object)column), symbolAllocator.getTypes());
        Assert.assertEquals((Set)filter.getColumnsCovered(), Set.of(column), (String)"columns covered");
        CompletableFuture isBlocked = filter.isBlocked();
        Assert.assertFalse((boolean)filter.isComplete());
        Assert.assertTrue((boolean)filter.isAwaitable());
        Assert.assertFalse((boolean)isBlocked.isDone());
        Assert.assertEquals((Object)filter.getCurrentPredicate(), (Object)TupleDomain.all());
        collector.collectDynamicFilterDomains((Map)ImmutableMap.of((Object)filter1, (Object)Domain.multipleValues((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)1L, (Object)2L, (Object)3L))));
        Assert.assertFalse((boolean)filter.isComplete());
        Assert.assertTrue((boolean)filter.isAwaitable());
        Assert.assertTrue((boolean)isBlocked.isDone());
        Assert.assertEquals((Object)filter.getCurrentPredicate(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)column, (Object)Domain.multipleValues((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)1L, (Object)2L, (Object)3L)))));
        isBlocked = filter.isBlocked();
        Assert.assertFalse((boolean)isBlocked.isDone());
        Assert.assertFalse((boolean)filter.isComplete());
        Assert.assertTrue((boolean)filter.isAwaitable());
        collector.collectDynamicFilterDomains((Map)ImmutableMap.of((Object)filter2, (Object)Domain.multipleValues((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)2L, (Object)3L, (Object)4L))));
        Assert.assertTrue((boolean)filter.isComplete());
        Assert.assertFalse((boolean)filter.isAwaitable());
        Assert.assertTrue((boolean)isBlocked.isDone());
        Assert.assertEquals((Object)filter.getCurrentPredicate(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)column, (Object)Domain.multipleValues((Type)BigintType.BIGINT, (List)ImmutableList.of((Object)2L, (Object)3L)))));
    }

    @Test
    public void testUnusedDynamicFilter() {
        LocalDynamicFiltersCollector collector = new LocalDynamicFiltersCollector(SessionTestUtils.TEST_SESSION);
        DynamicFilterId unusedFilterId = new DynamicFilterId("unused");
        DynamicFilterId usedFilterId = new DynamicFilterId("used");
        collector.register((Set)ImmutableSet.of((Object)unusedFilterId));
        collector.register((Set)ImmutableSet.of((Object)usedFilterId));
        SymbolAllocator symbolAllocator = new SymbolAllocator();
        Symbol usedSymbol = symbolAllocator.newSymbol("used", (Type)BigintType.BIGINT);
        TestingColumnHandle usedColumn = new TestingColumnHandle("used");
        DynamicFilter filter = this.createDynamicFilter(collector, (List<DynamicFilters.Descriptor>)ImmutableList.of((Object)new DynamicFilters.Descriptor(usedFilterId, (Expression)usedSymbol.toSymbolReference())), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)usedSymbol, (Object)usedColumn), symbolAllocator.getTypes());
        CompletableFuture isBlocked = filter.isBlocked();
        Assert.assertFalse((boolean)filter.isComplete());
        Assert.assertTrue((boolean)filter.isAwaitable());
        Assert.assertFalse((boolean)isBlocked.isDone());
        Assert.assertEquals((Object)filter.getCurrentPredicate(), (Object)TupleDomain.all());
        collector.collectDynamicFilterDomains((Map)ImmutableMap.of((Object)unusedFilterId, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)1L)));
        Assert.assertFalse((boolean)filter.isComplete());
        Assert.assertFalse((boolean)isBlocked.isDone());
        Assert.assertEquals((Object)filter.getCurrentPredicate(), (Object)TupleDomain.all());
        collector.collectDynamicFilterDomains((Map)ImmutableMap.of((Object)usedFilterId, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)2L)));
        Assert.assertTrue((boolean)filter.isComplete());
        Assert.assertFalse((boolean)filter.isAwaitable());
        Assert.assertTrue((boolean)isBlocked.isDone());
        Assert.assertEquals((Object)filter.getCurrentPredicate(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)usedColumn, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)2L))));
    }

    @Test
    public void testUnregisteredDynamicFilter() {
        LocalDynamicFiltersCollector collector = new LocalDynamicFiltersCollector(SessionTestUtils.TEST_SESSION);
        DynamicFilterId registeredFilterId = new DynamicFilterId("registered");
        DynamicFilterId unregisteredFilterId = new DynamicFilterId("unregistered");
        collector.register((Set)ImmutableSet.of((Object)registeredFilterId));
        SymbolAllocator symbolAllocator = new SymbolAllocator();
        Symbol registeredSymbol = symbolAllocator.newSymbol("registered", (Type)BigintType.BIGINT);
        Symbol unregisteredSymbol = symbolAllocator.newSymbol("unregistered", (Type)BigintType.BIGINT);
        TestingColumnHandle registeredColumn = new TestingColumnHandle("registered");
        TestingColumnHandle unregisteredColumn = new TestingColumnHandle("unregistered");
        DynamicFilter filter = this.createDynamicFilter(collector, (List<DynamicFilters.Descriptor>)ImmutableList.of((Object)new DynamicFilters.Descriptor(registeredFilterId, (Expression)registeredSymbol.toSymbolReference()), (Object)new DynamicFilters.Descriptor(unregisteredFilterId, (Expression)unregisteredSymbol.toSymbolReference())), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)registeredSymbol, (Object)registeredColumn, (Object)unregisteredSymbol, (Object)unregisteredColumn), symbolAllocator.getTypes());
        CompletableFuture isBlocked = filter.isBlocked();
        Assert.assertFalse((boolean)filter.isComplete());
        Assert.assertTrue((boolean)filter.isAwaitable());
        Assert.assertFalse((boolean)isBlocked.isDone());
        Assert.assertEquals((Object)filter.getCurrentPredicate(), (Object)TupleDomain.all());
        collector.collectDynamicFilterDomains((Map)ImmutableMap.of((Object)registeredFilterId, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)2L)));
        Assert.assertTrue((boolean)filter.isComplete());
        Assert.assertFalse((boolean)filter.isAwaitable());
        Assert.assertTrue((boolean)isBlocked.isDone());
        Assert.assertEquals((Object)filter.getCurrentPredicate(), (Object)TupleDomain.withColumnDomains((Map)ImmutableMap.of((Object)registeredColumn, (Object)Domain.singleValue((Type)BigintType.BIGINT, (Object)2L))));
    }

    private DynamicFilter createDynamicFilter(LocalDynamicFiltersCollector collector, List<DynamicFilters.Descriptor> descriptors, Map<Symbol, ColumnHandle> columnsMap, TypeProvider typeProvider) {
        return collector.createDynamicFilter(descriptors, columnsMap, typeProvider, TestingPlannerContext.PLANNER_CONTEXT);
    }
}

