/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.cost.StatsAndCosts;
import io.trino.operator.RetryPolicy;
import io.trino.spi.type.VarcharType;
import io.trino.sql.planner.Partitioning;
import io.trino.sql.planner.PartitioningHandle;
import io.trino.sql.planner.PartitioningScheme;
import io.trino.sql.planner.PlanFragment;
import io.trino.sql.planner.SubPlan;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SystemPartitioningHandle;
import io.trino.sql.planner.TopologicalOrderSubPlanVisitor;
import io.trino.sql.planner.plan.ExchangeNode;
import io.trino.sql.planner.plan.IndexJoinNode;
import io.trino.sql.planner.plan.JoinNode;
import io.trino.sql.planner.plan.PlanFragmentId;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.RemoteSourceNode;
import io.trino.sql.planner.plan.SemiJoinNode;
import io.trino.sql.planner.plan.SpatialJoinNode;
import io.trino.sql.planner.plan.ValuesNode;
import io.trino.sql.tree.BooleanLiteral;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Row;
import io.trino.sql.tree.StringLiteral;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.testng.annotations.Test;

public class TestTopologicalOrderSubPlanVisitor {
    private void test(JoinFunction f) {
        SubPlan a = TestTopologicalOrderSubPlanVisitor.valuesSubPlan("a");
        SubPlan b = TestTopologicalOrderSubPlanVisitor.valuesSubPlan("b");
        SubPlan c = TestTopologicalOrderSubPlanVisitor.valuesSubPlan("c");
        SubPlan middle = TestTopologicalOrderSubPlanVisitor.createSubPlan("middle", f.apply("middle_join", (PlanNode)TestTopologicalOrderSubPlanVisitor.remoteSource("b"), (PlanNode)TestTopologicalOrderSubPlanVisitor.remoteSource("c")), (List<SubPlan>)ImmutableList.of((Object)b, (Object)c));
        SubPlan root = TestTopologicalOrderSubPlanVisitor.createSubPlan("root", f.apply("root_join", (PlanNode)TestTopologicalOrderSubPlanVisitor.remoteSource("a"), (PlanNode)TestTopologicalOrderSubPlanVisitor.remoteSource("middle")), (List<SubPlan>)ImmutableList.of((Object)a, (Object)middle));
        Assertions.assertThat((List)TopologicalOrderSubPlanVisitor.sortPlanInTopologicalOrder((SubPlan)root)).isEqualTo((Object)ImmutableList.of((Object)c, (Object)b, (Object)middle, (Object)a, (Object)root));
    }

    @Test
    public void testJoinOrder() {
        this.test(TestTopologicalOrderSubPlanVisitor::join);
    }

    @Test
    public void testSemiJoinOrder() {
        this.test(TestTopologicalOrderSubPlanVisitor::semiJoin);
    }

    @Test
    public void testIndexJoin() {
        this.test(TestTopologicalOrderSubPlanVisitor::indexJoin);
    }

    @Test
    public void testSpatialJoin() {
        this.test(TestTopologicalOrderSubPlanVisitor::spatialJoin);
    }

    private static RemoteSourceNode remoteSource(String fragmentId) {
        return TestTopologicalOrderSubPlanVisitor.remoteSource((List<String>)ImmutableList.of((Object)fragmentId));
    }

    private static RemoteSourceNode remoteSource(List<String> fragmentIds) {
        return new RemoteSourceNode(new PlanNodeId(fragmentIds.get(0)), (List)fragmentIds.stream().map(PlanFragmentId::new).collect(ImmutableList.toImmutableList()), (List)ImmutableList.of((Object)new Symbol("blah")), Optional.empty(), ExchangeNode.Type.REPARTITION, RetryPolicy.TASK);
    }

    private static JoinNode join(String id, PlanNode left, PlanNode right) {
        return new JoinNode(new PlanNodeId(id), JoinNode.Type.INNER, left, right, (List)ImmutableList.of(), left.getOutputSymbols(), right.getOutputSymbols(), false, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), (Map)ImmutableMap.of(), Optional.empty());
    }

    private static SemiJoinNode semiJoin(String id, PlanNode left, PlanNode right) {
        return new SemiJoinNode(new PlanNodeId(id), left, right, (Symbol)left.getOutputSymbols().get(0), (Symbol)right.getOutputSymbols().get(0), new Symbol(id), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    private static IndexJoinNode indexJoin(String id, PlanNode left, PlanNode right) {
        return new IndexJoinNode(new PlanNodeId(id), IndexJoinNode.Type.INNER, left, right, (List)ImmutableList.of(), Optional.empty(), Optional.empty());
    }

    private static SpatialJoinNode spatialJoin(String id, PlanNode left, PlanNode right) {
        return new SpatialJoinNode(new PlanNodeId(id), SpatialJoinNode.Type.INNER, left, right, left.getOutputSymbols(), (Expression)BooleanLiteral.TRUE_LITERAL, Optional.empty(), Optional.empty(), Optional.empty());
    }

    private static SubPlan valuesSubPlan(String fragmentId) {
        Symbol symbol = new Symbol("column");
        return TestTopologicalOrderSubPlanVisitor.createSubPlan(fragmentId, (PlanNode)new ValuesNode(new PlanNodeId(fragmentId + "Values"), (List)ImmutableList.of((Object)symbol), (List)ImmutableList.of((Object)new Row((List)ImmutableList.of((Object)new StringLiteral("foo"))))), (List<SubPlan>)ImmutableList.of());
    }

    private static SubPlan createSubPlan(String fragmentId, PlanNode plan, List<SubPlan> children) {
        Symbol symbol = (Symbol)plan.getOutputSymbols().get(0);
        PlanNodeId valuesNodeId = new PlanNodeId("plan");
        PlanFragment planFragment = new PlanFragment(new PlanFragmentId(fragmentId), plan, (Map)ImmutableMap.of((Object)symbol, (Object)VarcharType.VARCHAR), SystemPartitioningHandle.SOURCE_DISTRIBUTION, Optional.empty(), (List)ImmutableList.of((Object)valuesNodeId), new PartitioningScheme(Partitioning.create((PartitioningHandle)SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List)ImmutableList.of()), (List)ImmutableList.of((Object)symbol)), StatsAndCosts.empty(), (List)ImmutableList.of(), Optional.empty());
        return new SubPlan(planFragment, children);
    }

    private static interface JoinFunction {
        public PlanNode apply(String var1, PlanNode var2, PlanNode var3);
    }
}

