/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.Session;
import io.trino.connector.MockConnectorFactory;
import io.trino.connector.MockConnectorTableHandle;
import io.trino.plugin.tpch.TpchColumnHandle;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TopNApplicationResult;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.iterative.rule.PushTopNIntoTableScan;
import io.trino.sql.planner.iterative.rule.test.RuleTester;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.TopNNode;
import io.trino.sql.tree.SortItem;
import io.trino.testing.TestingSession;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.junit.jupiter.api.Test;

public class TestPushTopNIntoTableScan {
    private static final String TEST_SCHEMA = "test_schema";
    private static final String TEST_TABLE = "test_table";
    private static final SchemaTableName TEST_SCHEMA_TABLE = new SchemaTableName("test_schema", "test_table");
    private static final Session MOCK_SESSION = TestingSession.testSessionBuilder().setCatalog("test-catalog").setSchema("test_schema").build();
    private static final String dimensionName = "dimension";
    private static final ColumnHandle dimensionColumn = new TpchColumnHandle("dimension", (Type)VarcharType.VARCHAR);
    private static final String metricName = "metric";
    private static final ColumnHandle metricColumn = new TpchColumnHandle("metric", (Type)BigintType.BIGINT);
    private static final ImmutableMap<String, ColumnHandle> assignments = ImmutableMap.of((Object)"dimension", (Object)dimensionColumn, (Object)"metric", (Object)metricColumn);

    @Test
    public void testDoesNotFire() {
        MockConnectorFactory mockFactory = this.createMockFactory((Map<String, ColumnHandle>)assignments, Optional.empty());
        try (RuleTester ruleTester = RuleTester.builder().withDefaultCatalogConnectorFactory(mockFactory).build();){
            ruleTester.assertThat((Rule<?>)new PushTopNIntoTableScan(ruleTester.getMetadata())).on(p -> {
                Symbol dimension = p.symbol(dimensionName, (Type)VarcharType.VARCHAR);
                Symbol metric = p.symbol(metricName, (Type)BigintType.BIGINT);
                return p.topN(1L, (List<Symbol>)ImmutableList.of((Object)dimension), (PlanNode)p.tableScan(ruleTester.getCurrentCatalogTableHandle(TEST_SCHEMA, TEST_TABLE), (List<Symbol>)ImmutableList.of((Object)dimension, (Object)metric), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)dimension, (Object)dimensionColumn, (Object)metric, (Object)metricColumn)));
            }).withSession(MOCK_SESSION).doesNotFire();
        }
    }

    @Test
    public void testPushSingleTopNIntoTableScan() {
        MockConnectorTableHandle connectorHandle = new MockConnectorTableHandle(TEST_SCHEMA_TABLE);
        MockConnectorFactory.ApplyTopN applyTopN = (session, handle, topNCount, sortItems, tableAssignments) -> Optional.of(new TopNApplicationResult((Object)connectorHandle, true, false));
        MockConnectorFactory mockFactory = this.createMockFactory((Map<String, ColumnHandle>)assignments, Optional.of(applyTopN));
        try (RuleTester ruleTester = RuleTester.builder().withDefaultCatalogConnectorFactory(mockFactory).build();){
            ruleTester.assertThat((Rule<?>)new PushTopNIntoTableScan(ruleTester.getMetadata())).on(p -> {
                Symbol dimension = p.symbol(dimensionName, (Type)VarcharType.VARCHAR);
                Symbol metric = p.symbol(metricName, (Type)BigintType.BIGINT);
                return p.topN(1L, (List<Symbol>)ImmutableList.of((Object)dimension), (PlanNode)p.tableScan(ruleTester.getCurrentCatalogTableHandle(TEST_SCHEMA, TEST_TABLE), (List<Symbol>)ImmutableList.of((Object)dimension, (Object)metric), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)dimension, (Object)dimensionColumn, (Object)metric, (Object)metricColumn)));
            }).withSession(MOCK_SESSION).matches(PlanMatchPattern.tableScan(connectorHandle::equals, (TupleDomain<Predicate<ColumnHandle>>)TupleDomain.all(), new HashMap<String, Predicate<ColumnHandle>>()));
        }
    }

    @Test
    public void testPushSingleTopNIntoTableScanNotGuaranteed() {
        MockConnectorTableHandle connectorHandle = new MockConnectorTableHandle(TEST_SCHEMA_TABLE);
        MockConnectorFactory.ApplyTopN applyTopN = (session, handle, topNCount, sortItems, tableAssignments) -> Optional.of(new TopNApplicationResult((Object)connectorHandle, false, false));
        MockConnectorFactory mockFactory = this.createMockFactory((Map<String, ColumnHandle>)assignments, Optional.of(applyTopN));
        try (RuleTester ruleTester = RuleTester.builder().withDefaultCatalogConnectorFactory(mockFactory).build();){
            ruleTester.assertThat((Rule<?>)new PushTopNIntoTableScan(ruleTester.getMetadata())).on(p -> {
                Symbol dimension = p.symbol(dimensionName, (Type)VarcharType.VARCHAR);
                Symbol metric = p.symbol(metricName, (Type)BigintType.BIGINT);
                return p.topN(1L, (List<Symbol>)ImmutableList.of((Object)dimension), (PlanNode)p.tableScan(ruleTester.getCurrentCatalogTableHandle(TEST_SCHEMA, TEST_TABLE), (List<Symbol>)ImmutableList.of((Object)dimension, (Object)metric), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)dimension, (Object)dimensionColumn, (Object)metric, (Object)metricColumn)));
            }).withSession(MOCK_SESSION).matches(PlanMatchPattern.topN(1L, (List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort(dimensionName, SortItem.Ordering.ASCENDING, SortItem.NullOrdering.FIRST)), TopNNode.Step.SINGLE, PlanMatchPattern.tableScan(connectorHandle::equals, (TupleDomain<Predicate<ColumnHandle>>)TupleDomain.all(), (Map<String, Predicate<ColumnHandle>>)ImmutableMap.of((Object)dimensionName, arg_0 -> ((ColumnHandle)dimensionColumn).equals(arg_0), (Object)metricName, arg_0 -> ((ColumnHandle)metricColumn).equals(arg_0)))));
        }
    }

    @Test
    public void testPushPartialTopNIntoTableScan() {
        MockConnectorTableHandle connectorHandle = new MockConnectorTableHandle(TEST_SCHEMA_TABLE);
        MockConnectorFactory.ApplyTopN applyTopN = (session, handle, topNCount, sortItems, tableAssignments) -> Optional.of(new TopNApplicationResult((Object)connectorHandle, true, false));
        MockConnectorFactory mockFactory = this.createMockFactory((Map<String, ColumnHandle>)assignments, Optional.of(applyTopN));
        try (RuleTester ruleTester = RuleTester.builder().withDefaultCatalogConnectorFactory(mockFactory).build();){
            ruleTester.assertThat((Rule<?>)new PushTopNIntoTableScan(ruleTester.getMetadata())).on(p -> {
                Symbol dimension = p.symbol(dimensionName, (Type)VarcharType.VARCHAR);
                Symbol metric = p.symbol(metricName, (Type)BigintType.BIGINT);
                return p.topN(1L, (List<Symbol>)ImmutableList.of((Object)dimension), TopNNode.Step.PARTIAL, (PlanNode)p.tableScan(ruleTester.getCurrentCatalogTableHandle(TEST_SCHEMA, TEST_TABLE), (List<Symbol>)ImmutableList.of((Object)dimension, (Object)metric), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)dimension, (Object)dimensionColumn, (Object)metric, (Object)metricColumn)));
            }).withSession(MOCK_SESSION).matches(PlanMatchPattern.tableScan(connectorHandle::equals, (TupleDomain<Predicate<ColumnHandle>>)TupleDomain.all(), new HashMap<String, Predicate<ColumnHandle>>()));
        }
    }

    @Test
    public void testPushPartialTopNIntoTableScanNotGuaranteed() {
        MockConnectorTableHandle connectorHandle = new MockConnectorTableHandle(TEST_SCHEMA_TABLE);
        MockConnectorFactory.ApplyTopN applyTopN = (session, handle, topNCount, sortItems, tableAssignments) -> Optional.of(new TopNApplicationResult((Object)connectorHandle, false, false));
        MockConnectorFactory mockFactory = this.createMockFactory((Map<String, ColumnHandle>)assignments, Optional.of(applyTopN));
        try (RuleTester ruleTester = RuleTester.builder().withDefaultCatalogConnectorFactory(mockFactory).build();){
            ruleTester.assertThat((Rule<?>)new PushTopNIntoTableScan(ruleTester.getMetadata())).on(p -> {
                Symbol dimension = p.symbol(dimensionName, (Type)VarcharType.VARCHAR);
                Symbol metric = p.symbol(metricName, (Type)BigintType.BIGINT);
                return p.topN(1L, (List<Symbol>)ImmutableList.of((Object)dimension), TopNNode.Step.PARTIAL, (PlanNode)p.tableScan(ruleTester.getCurrentCatalogTableHandle(TEST_SCHEMA, TEST_TABLE), (List<Symbol>)ImmutableList.of((Object)dimension, (Object)metric), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)dimension, (Object)dimensionColumn, (Object)metric, (Object)metricColumn)));
            }).withSession(MOCK_SESSION).matches(PlanMatchPattern.topN(1L, (List<PlanMatchPattern.Ordering>)ImmutableList.of((Object)PlanMatchPattern.sort(dimensionName, SortItem.Ordering.ASCENDING, SortItem.NullOrdering.FIRST)), TopNNode.Step.PARTIAL, PlanMatchPattern.tableScan(connectorHandle::equals, (TupleDomain<Predicate<ColumnHandle>>)TupleDomain.all(), (Map<String, Predicate<ColumnHandle>>)ImmutableMap.of((Object)dimensionName, arg_0 -> ((ColumnHandle)dimensionColumn).equals(arg_0), (Object)metricName, arg_0 -> ((ColumnHandle)metricColumn).equals(arg_0)))));
        }
    }

    @Test
    public void testPushFinalTopNIntoTableScan() {
        MockConnectorTableHandle connectorHandle = new MockConnectorTableHandle(TEST_SCHEMA_TABLE);
        MockConnectorFactory.ApplyTopN applyTopN = (session, handle, topNCount, sortItems, tableAssignments) -> Optional.of(new TopNApplicationResult((Object)connectorHandle, true, false));
        MockConnectorFactory mockFactory = this.createMockFactory((Map<String, ColumnHandle>)assignments, Optional.of(applyTopN));
        try (RuleTester ruleTester = RuleTester.builder().withDefaultCatalogConnectorFactory(mockFactory).build();){
            ruleTester.assertThat((Rule<?>)new PushTopNIntoTableScan(ruleTester.getMetadata())).on(p -> {
                Symbol dimension = p.symbol(dimensionName, (Type)VarcharType.VARCHAR);
                Symbol metric = p.symbol(metricName, (Type)BigintType.BIGINT);
                return p.topN(1L, (List<Symbol>)ImmutableList.of((Object)dimension), TopNNode.Step.FINAL, (PlanNode)p.tableScan(ruleTester.getCurrentCatalogTableHandle(TEST_SCHEMA, TEST_TABLE), (List<Symbol>)ImmutableList.of((Object)dimension, (Object)metric), (Map<Symbol, ColumnHandle>)ImmutableMap.of((Object)dimension, (Object)dimensionColumn, (Object)metric, (Object)metricColumn)));
            }).withSession(MOCK_SESSION).matches(PlanMatchPattern.tableScan(connectorHandle::equals, (TupleDomain<Predicate<ColumnHandle>>)TupleDomain.all(), new HashMap<String, Predicate<ColumnHandle>>()));
        }
    }

    private MockConnectorFactory createMockFactory(Map<String, ColumnHandle> assignments, Optional<MockConnectorFactory.ApplyTopN> applyTopN) {
        List metadata = (List)assignments.entrySet().stream().map(entry -> new ColumnMetadata((String)entry.getKey(), ((TpchColumnHandle)entry.getValue()).getType())).collect(ImmutableList.toImmutableList());
        MockConnectorFactory.Builder builder = MockConnectorFactory.builder().withListSchemaNames(connectorSession -> ImmutableList.of((Object)TEST_SCHEMA)).withListTables((connectorSession, schema) -> TEST_SCHEMA.equals(schema) ? ImmutableList.of((Object)TEST_TABLE) : ImmutableList.of()).withGetColumns(schemaTableName -> metadata);
        if (applyTopN.isPresent()) {
            builder = builder.withApplyTopN(applyTopN.get());
        }
        return builder.build();
    }
}

