/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.optimizations;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.metadata.Metadata;
import io.trino.sql.planner.PlanOptimizers;
import io.trino.sql.planner.RuleStatsRecorder;
import io.trino.sql.planner.assertions.BasePlanTest;
import io.trino.sql.planner.assertions.PlanMatchPattern;
import io.trino.sql.planner.iterative.IterativeOptimizer;
import io.trino.sql.planner.iterative.rule.MergeExcept;
import io.trino.sql.planner.iterative.rule.MergeIntersect;
import io.trino.sql.planner.iterative.rule.MergeUnion;
import io.trino.sql.planner.iterative.rule.PruneDistinctAggregation;
import io.trino.sql.planner.iterative.rule.RemoveRedundantIdentityProjections;
import io.trino.sql.planner.optimizations.PlanOptimizer;
import io.trino.sql.planner.optimizations.UnaliasSymbolReferences;
import java.util.List;
import java.util.Set;
import org.junit.jupiter.api.Test;

public class TestSetFlattening
extends BasePlanTest {
    @Test
    public void testFlattensUnion() {
        this.assertPlan("(SELECT * FROM nation UNION SELECT * FROM nation)UNION (SELECT * FROM nation UNION SELECT * FROM nation)", PlanMatchPattern.anyTree(PlanMatchPattern.union(PlanMatchPattern.tableScan("nation"), PlanMatchPattern.tableScan("nation"), PlanMatchPattern.tableScan("nation"), PlanMatchPattern.tableScan("nation"))));
    }

    @Test
    public void testFlattensUnionAll() {
        this.assertPlan("(SELECT * FROM nation UNION ALL SELECT * FROM nation)UNION ALL (SELECT * FROM nation UNION ALL SELECT * FROM nation)", PlanMatchPattern.anyTree(PlanMatchPattern.union(PlanMatchPattern.tableScan("nation"), PlanMatchPattern.tableScan("nation"), PlanMatchPattern.tableScan("nation"), PlanMatchPattern.tableScan("nation"))));
    }

    @Test
    public void testFlattensUnionAndUnionAllWhenAllowed() {
        this.assertPlan("SELECT * FROM nation UNION ALL (SELECT * FROM nation UNION (SELECT * FROM nation UNION ALL select * FROM nation))", PlanMatchPattern.anyTree(PlanMatchPattern.union(PlanMatchPattern.tableScan("nation"), PlanMatchPattern.anyTree(PlanMatchPattern.union(PlanMatchPattern.tableScan("nation"), PlanMatchPattern.tableScan("nation"), PlanMatchPattern.tableScan("nation"))))));
    }

    @Test
    public void testFlattensIntersect() {
        this.assertPlan("(SELECT * FROM nation INTERSECT SELECT * FROM nation)INTERSECT (SELECT * FROM nation INTERSECT SELECT * FROM nation)", PlanMatchPattern.anyTree(PlanMatchPattern.intersect(PlanMatchPattern.tableScan("nation"), PlanMatchPattern.tableScan("nation"), PlanMatchPattern.tableScan("nation"), PlanMatchPattern.tableScan("nation"))));
    }

    @Test
    public void testFlattensOnlyFirstInputOfExcept() {
        this.assertPlan("(SELECT * FROM nation EXCEPT SELECT * FROM nation)EXCEPT (SELECT * FROM nation EXCEPT SELECT * FROM nation)", PlanMatchPattern.anyTree(PlanMatchPattern.except(PlanMatchPattern.tableScan("nation"), PlanMatchPattern.tableScan("nation"), PlanMatchPattern.except(PlanMatchPattern.tableScan("nation"), PlanMatchPattern.tableScan("nation")))));
    }

    @Test
    public void testDoesNotFlattenDifferentSetOperations() {
        this.assertPlan("(SELECT * FROM nation EXCEPT SELECT * FROM nation)UNION (SELECT * FROM nation INTERSECT SELECT * FROM nation)", PlanMatchPattern.anyTree(PlanMatchPattern.union(PlanMatchPattern.except(PlanMatchPattern.tableScan("nation"), PlanMatchPattern.tableScan("nation")), PlanMatchPattern.intersect(PlanMatchPattern.tableScan("nation"), PlanMatchPattern.tableScan("nation")))));
    }

    @Override
    protected void assertPlan(String sql, PlanMatchPattern pattern) {
        ImmutableList optimizers = ImmutableList.of((Object)new UnaliasSymbolReferences(this.getQueryRunner().getMetadata()), (Object)new IterativeOptimizer(this.getQueryRunner().getPlannerContext(), new RuleStatsRecorder(), this.getQueryRunner().getStatsCalculator(), this.getQueryRunner().getEstimatedExchangesCostCalculator(), (Set)ImmutableSet.builder().add((Object)new RemoveRedundantIdentityProjections()).add((Object)new MergeUnion()).add((Object)new MergeIntersect()).add((Object)new MergeExcept()).add((Object)new PruneDistinctAggregation()).addAll((Iterable)PlanOptimizers.columnPruningRules((Metadata)this.getQueryRunner().getMetadata())).build()));
        this.assertPlan(sql, pattern, (List<PlanOptimizer>)optimizers);
    }
}

