/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.type.AbstractTestType;
import io.trino.type.InternalTypeManager;
import io.trino.util.StructuralTestUtil;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestIntegerArrayType
extends AbstractTestType {
    public TestIntegerArrayType() {
        super(InternalTypeManager.TESTING_TYPE_MANAGER.getType(TypeSignature.arrayType((TypeSignature)IntegerType.INTEGER.getTypeSignature())), List.class, TestIntegerArrayType.createTestBlock(InternalTypeManager.TESTING_TYPE_MANAGER.getType(TypeSignature.arrayType((TypeSignature)IntegerType.INTEGER.getTypeSignature()))));
    }

    public static Block createTestBlock(Type arrayType) {
        BlockBuilder blockBuilder = arrayType.createBlockBuilder(null, 4);
        arrayType.writeObject(blockBuilder, (Object)StructuralTestUtil.arrayBlockOf((Type)IntegerType.INTEGER, 1, 2));
        arrayType.writeObject(blockBuilder, (Object)StructuralTestUtil.arrayBlockOf((Type)IntegerType.INTEGER, 1, 2, 3));
        arrayType.writeObject(blockBuilder, (Object)StructuralTestUtil.arrayBlockOf((Type)IntegerType.INTEGER, 1, 2, 3));
        arrayType.writeObject(blockBuilder, (Object)StructuralTestUtil.arrayBlockOf((Type)IntegerType.INTEGER, 100, 200, 300));
        return blockBuilder.build();
    }

    @Override
    protected Object getGreaterValue(Object value) {
        Block block = (Block)value;
        BlockBuilder blockBuilder = IntegerType.INTEGER.createBlockBuilder(null, block.getPositionCount() + 1);
        for (int i = 0; i < block.getPositionCount(); ++i) {
            IntegerType.INTEGER.appendTo(block, i, blockBuilder);
        }
        IntegerType.INTEGER.writeLong(blockBuilder, 1L);
        return blockBuilder.build();
    }

    @Test
    public void testRange() {
        Assertions.assertThat((Optional)this.type.getRange()).isEmpty();
    }

    @Test
    public void testPreviousValue() {
        Assertions.assertThat((Optional)this.type.getPreviousValue(this.getSampleValue())).isEmpty();
    }

    @Test
    public void testNextValue() {
        Assertions.assertThat((Optional)this.type.getNextValue(this.getSampleValue())).isEmpty();
    }
}

