/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slices;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.RowBlockBuilder;
import io.trino.spi.block.RowValueBuilder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.type.AbstractTestType;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestSimpleRowType
extends AbstractTestType {
    private static final RowType TYPE = RowType.from((List)ImmutableList.of((Object)RowType.field((String)"a", (Type)BigintType.BIGINT), (Object)RowType.field((String)"b", (Type)VarcharType.VARCHAR)));

    public TestSimpleRowType() {
        super((Type)TYPE, List.class, TestSimpleRowType.createTestBlock());
    }

    private static Block createTestBlock() {
        RowBlockBuilder blockBuilder = TYPE.createBlockBuilder(null, 3);
        blockBuilder.buildEntry(fieldBuilders -> {
            BigintType.BIGINT.writeLong((BlockBuilder)fieldBuilders.get(0), 1L);
            VarcharType.VARCHAR.writeSlice((BlockBuilder)fieldBuilders.get(1), Slices.utf8Slice((String)"cat"));
        });
        blockBuilder.buildEntry(fieldBuilders -> {
            BigintType.BIGINT.writeLong((BlockBuilder)fieldBuilders.get(0), 2L);
            VarcharType.VARCHAR.writeSlice((BlockBuilder)fieldBuilders.get(1), Slices.utf8Slice((String)"cats"));
        });
        blockBuilder.buildEntry(fieldBuilders -> {
            BigintType.BIGINT.writeLong((BlockBuilder)fieldBuilders.get(0), 3L);
            VarcharType.VARCHAR.writeSlice((BlockBuilder)fieldBuilders.get(1), Slices.utf8Slice((String)"dog"));
        });
        return blockBuilder.build();
    }

    @Override
    protected Object getGreaterValue(Object value) {
        return RowValueBuilder.buildRowValue((RowType)TYPE, fieldBuilders -> {
            Block block = (Block)value;
            BigintType.BIGINT.writeLong((BlockBuilder)fieldBuilders.get(0), block.getSingleValueBlock(0).getLong(0, 0) + 1L);
            VarcharType.VARCHAR.writeSlice((BlockBuilder)fieldBuilders.get(1), block.getSingleValueBlock(1).getSlice(0, 0, 1));
        });
    }

    @Test
    public void testRange() {
        Assertions.assertThat((Optional)this.type.getRange()).isEmpty();
    }

    @Test
    public void testPreviousValue() {
        Assertions.assertThat((Optional)this.type.getPreviousValue(this.getSampleValue())).isEmpty();
    }

    @Test
    public void testNextValue() {
        Assertions.assertThat((Optional)this.type.getNextValue(this.getSampleValue())).isEmpty();
    }
}

