/*
 * Decompiled with CFR 0.152.
 */
package io.trino.util;

import io.trino.util.LongLong2LongOpenCustomBigHashMap;
import java.util.Arrays;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class TestLongLong2LongOpenCustomBigHashMap {
    private static final LongLong2LongOpenCustomBigHashMap.HashStrategy DEFAULT_STRATEGY = new LongLong2LongOpenCustomBigHashMap.HashStrategy(){

        public long hashCode(long e1, long e2) {
            return e1 * 31L + e2;
        }

        public boolean equals(long a1, long a2, long b1, long b2) {
            return a1 == b1 && a2 == b2;
        }
    };

    @DataProvider
    public static Object[][] nullKeyValues() {
        return new Object[][]{{0L, 0L}, {1L, 1L}, {-1L, -1L}, {0L, -1L}};
    }

    @Test(dataProvider="nullKeyValues")
    public void testBasicOps(long nullKey1, long nullKey2) {
        int expected = 100000;
        LongLong2LongOpenCustomBigHashMap map = new LongLong2LongOpenCustomBigHashMap((long)expected, DEFAULT_STRATEGY, nullKey1, nullKey2);
        map.defaultReturnValue(-1L);
        Assert.assertTrue((boolean)map.isEmpty());
        Assert.assertEquals((long)map.size(), (long)0L);
        Assert.assertEquals((long)map.get(0L, 0L), (long)-1L);
        Assert.assertEquals((long)map.get(1L, -1L), (long)-1L);
        List<Long> values = Arrays.asList(Long.MIN_VALUE, -10L, 0L, 10L, Long.MAX_VALUE);
        int count = 0;
        for (long key1 : values) {
            for (long key2 : values) {
                Assert.assertEquals((long)map.put(key1, key2, (long)(++count - 1)), (long)-1L);
                Assert.assertFalse((boolean)map.isEmpty());
                Assert.assertEquals((long)map.size(), (long)count);
            }
        }
        count = 0;
        for (long key1 : values) {
            for (long key2 : values) {
                Assert.assertTrue((boolean)map.replace(key1, key2, (long)(++count - 1), (long)count));
                Assert.assertFalse((boolean)map.isEmpty());
                Assert.assertEquals((long)map.size(), (long)((long)values.size() * (long)values.size()));
            }
        }
        count = 0;
        for (long key1 : values) {
            for (long key2 : values) {
                Assert.assertTrue((boolean)map.containsKey(key1, key2));
                Assert.assertTrue((boolean)map.containsValue((long)(++count)));
                Assert.assertEquals((long)map.get(key1, key2), (long)count);
            }
        }
        count = 0;
        for (long key1 : values) {
            for (long key2 : values) {
                Assert.assertEquals((long)map.remove(key1, key2), (long)(++count));
            }
        }
    }

    @Test(dataProvider="nullKeyValues")
    public void testHashCollision(long nullKey1, long nullKey2) {
        LongLong2LongOpenCustomBigHashMap.HashStrategy collisionHashStrategy = new LongLong2LongOpenCustomBigHashMap.HashStrategy(){

            public long hashCode(long e1, long e2) {
                return 0L;
            }

            public boolean equals(long a1, long a2, long b1, long b2) {
                return a1 == b1 && a2 == b2;
            }
        };
        LongLong2LongOpenCustomBigHashMap map = new LongLong2LongOpenCustomBigHashMap(collisionHashStrategy, nullKey1, nullKey2);
        map.defaultReturnValue(-1L);
        List<Long> values = Arrays.asList(Long.MIN_VALUE, -10L, 0L, 10L, Long.MAX_VALUE);
        int count = 0;
        for (long key1 : values) {
            for (long key2 : values) {
                Assert.assertEquals((long)map.put(key1, key2, (long)(++count - 1)), (long)-1L);
                Assert.assertFalse((boolean)map.isEmpty());
                Assert.assertEquals((long)map.size(), (long)count);
            }
        }
        count = 0;
        for (long key1 : values) {
            for (long key2 : values) {
                Assert.assertTrue((boolean)map.replace(key1, key2, (long)(++count - 1), (long)count));
                Assert.assertFalse((boolean)map.isEmpty());
                Assert.assertEquals((long)map.size(), (long)((long)values.size() * (long)values.size()));
            }
        }
        count = 0;
        for (long key1 : values) {
            for (long key2 : values) {
                Assert.assertTrue((boolean)map.containsKey(key1, key2));
                Assert.assertTrue((boolean)map.containsValue((long)(++count)));
                Assert.assertEquals((long)map.get(key1, key2), (long)count);
            }
        }
        count = 0;
        for (long key1 : values) {
            for (long key2 : values) {
                Assert.assertEquals((long)map.remove(key1, key2), (long)(++count));
            }
        }
    }

    @Test(dataProvider="nullKeyValues")
    public void testRehash(long nullKey1, long nullKey2) {
        long key2;
        long key1;
        int initialCapacity = 1;
        LongLong2LongOpenCustomBigHashMap map = new LongLong2LongOpenCustomBigHashMap((long)initialCapacity, DEFAULT_STRATEGY, nullKey1, nullKey2);
        map.defaultReturnValue(-1L);
        int count = 0;
        for (key1 = 0L; key1 < 1000L; ++key1) {
            for (key2 = 0L; key2 < 1000L; ++key2) {
                Assert.assertEquals((long)map.put(key1, key2, (long)(++count)), (long)-1L);
            }
        }
        count = 0;
        for (key1 = 0L; key1 < 1000L; ++key1) {
            for (key2 = 0L; key2 < 1000L; ++key2) {
                Assert.assertEquals((long)map.get(key1, key2), (long)(++count));
            }
        }
        for (key1 = 1L; key1 < 1000L; ++key1) {
            for (key2 = 0L; key2 < 1000L; ++key2) {
                map.remove(key1, key2);
            }
        }
        map.trim();
        count = 0;
        for (long key22 = 0L; key22 < 1000L; ++key22) {
            Assert.assertEquals((long)map.get(0L, key22), (long)(++count));
        }
    }
}

