/*
 * Decompiled with CFR 0.152.
 */
package io.trino.connector.system.jdbc;

import com.google.inject.Inject;
import io.trino.connector.system.jdbc.ColumnJdbcTable;
import io.trino.connector.system.jdbc.JdbcTable;
import io.trino.metadata.MetadataUtil;
import io.trino.metadata.TypeRegistry;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.InMemoryRecordSet;
import io.trino.spi.connector.RecordCursor;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.ParametricType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.Objects;

public class TypesJdbcTable
extends JdbcTable {
    public static final SchemaTableName NAME = new SchemaTableName("jdbc", "types");
    public static final ConnectorTableMetadata METADATA = MetadataUtil.TableMetadataBuilder.tableMetadataBuilder(NAME).column("type_name", (Type)VarcharType.createUnboundedVarcharType()).column("data_type", (Type)BigintType.BIGINT).column("precision", (Type)BigintType.BIGINT).column("literal_prefix", (Type)VarcharType.createUnboundedVarcharType()).column("literal_suffix", (Type)VarcharType.createUnboundedVarcharType()).column("create_params", (Type)VarcharType.createUnboundedVarcharType()).column("nullable", (Type)BigintType.BIGINT).column("case_sensitive", (Type)BooleanType.BOOLEAN).column("searchable", (Type)BigintType.BIGINT).column("unsigned_attribute", (Type)BooleanType.BOOLEAN).column("fixed_prec_scale", (Type)BooleanType.BOOLEAN).column("auto_increment", (Type)BooleanType.BOOLEAN).column("local_type_name", (Type)VarcharType.createUnboundedVarcharType()).column("minimum_scale", (Type)BigintType.BIGINT).column("maximum_scale", (Type)BigintType.BIGINT).column("sql_data_type", (Type)BigintType.BIGINT).column("sql_datetime_sub", (Type)BigintType.BIGINT).column("num_prec_radix", (Type)BigintType.BIGINT).build();
    private final TypeRegistry typeRegistry;

    @Inject
    public TypesJdbcTable(TypeRegistry typeRegistry) {
        this.typeRegistry = Objects.requireNonNull(typeRegistry, "typeRegistry is null");
    }

    public ConnectorTableMetadata getTableMetadata() {
        return METADATA;
    }

    public RecordCursor cursor(ConnectorTransactionHandle transactionHandle, ConnectorSession connectorSession, TupleDomain<Integer> constraint) {
        InMemoryRecordSet.Builder table = InMemoryRecordSet.builder((ConnectorTableMetadata)METADATA);
        for (Type type : this.typeRegistry.getTypes()) {
            TypesJdbcTable.addTypeRow(table, type);
        }
        for (ParametricType parametricType : this.typeRegistry.getParametricTypes()) {
            TypesJdbcTable.addTypeRow(table, parametricType);
        }
        return table.build().cursor();
    }

    private static void addTypeRow(InMemoryRecordSet.Builder builder, Type type) {
        builder.addRow(new Object[]{type.getDisplayName(), ColumnJdbcTable.jdbcDataType(type), ColumnJdbcTable.columnSize(type), null, null, null, 1, false, type.isComparable() ? 3 : 0, null, false, null, null, 0, 0, null, null, ColumnJdbcTable.numPrecRadix(type)});
    }

    private static void addTypeRow(InMemoryRecordSet.Builder builder, ParametricType type) {
        String typeName = type.getName();
        builder.addRow(new Object[]{typeName, typeName.equalsIgnoreCase("array") ? 2003 : 2000, null, null, null, null, 1, false, 0, null, false, null, null, 0, 0, null, null, null});
    }
}

