/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.primitives.Primitives;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.inject.Inject;
import io.trino.FeaturesConfig;
import io.trino.cache.CacheUtils;
import io.trino.cache.NonEvictableCache;
import io.trino.cache.SafeCaches;
import io.trino.client.NodeVersion;
import io.trino.connector.CatalogServiceProvider;
import io.trino.connector.system.GlobalSystemConnector;
import io.trino.metadata.BlockEncodingManager;
import io.trino.metadata.GlobalFunctionCatalog;
import io.trino.metadata.InternalBlockEncodingSerde;
import io.trino.metadata.InternalFunctionBundle;
import io.trino.metadata.InternalFunctionDependencies;
import io.trino.metadata.LiteralFunction;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.SystemFunctionBundle;
import io.trino.metadata.TableFunctionHandle;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.AggregationImplementation;
import io.trino.spi.function.BoundSignature;
import io.trino.spi.function.FunctionDependencies;
import io.trino.spi.function.FunctionId;
import io.trino.spi.function.FunctionProvider;
import io.trino.spi.function.InOut;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.ScalarFunctionImplementation;
import io.trino.spi.function.WindowFunctionSupplier;
import io.trino.spi.function.table.TableFunctionProcessorProvider;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.type.BlockTypeOperators;
import io.trino.type.InternalTypeManager;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class FunctionManager {
    private final NonEvictableCache<FunctionKey, ScalarFunctionImplementation> specializedScalarCache = SafeCaches.buildNonEvictableCache((CacheBuilder)CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(1L, TimeUnit.HOURS));
    private final NonEvictableCache<FunctionKey, AggregationImplementation> specializedAggregationCache = SafeCaches.buildNonEvictableCache((CacheBuilder)CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(1L, TimeUnit.HOURS));
    private final NonEvictableCache<FunctionKey, WindowFunctionSupplier> specializedWindowCache = SafeCaches.buildNonEvictableCache((CacheBuilder)CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(1L, TimeUnit.HOURS));
    private final CatalogServiceProvider<FunctionProvider> functionProviders;
    private final GlobalFunctionCatalog globalFunctionCatalog;

    @Inject
    public FunctionManager(CatalogServiceProvider<FunctionProvider> functionProviders, GlobalFunctionCatalog globalFunctionCatalog) {
        this.functionProviders = Objects.requireNonNull(functionProviders, "functionProviders is null");
        this.globalFunctionCatalog = Objects.requireNonNull(globalFunctionCatalog, "globalFunctionCatalog is null");
    }

    public ScalarFunctionImplementation getScalarFunctionImplementation(ResolvedFunction resolvedFunction, InvocationConvention invocationConvention) {
        try {
            return (ScalarFunctionImplementation)CacheUtils.uncheckedCacheGet(this.specializedScalarCache, (Object)new FunctionKey(resolvedFunction, invocationConvention), () -> this.getScalarFunctionImplementationInternal(resolvedFunction, invocationConvention));
        }
        catch (UncheckedExecutionException e) {
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), TrinoException.class);
            throw new RuntimeException(e.getCause());
        }
    }

    private ScalarFunctionImplementation getScalarFunctionImplementationInternal(ResolvedFunction resolvedFunction, InvocationConvention invocationConvention) {
        FunctionDependencies functionDependencies = this.getFunctionDependencies(resolvedFunction);
        ScalarFunctionImplementation scalarFunctionImplementation = this.getFunctionProvider(resolvedFunction).getScalarFunctionImplementation(resolvedFunction.getFunctionId(), resolvedFunction.getSignature(), functionDependencies, invocationConvention);
        FunctionManager.verifyMethodHandleSignature(resolvedFunction.getSignature(), scalarFunctionImplementation, invocationConvention);
        return scalarFunctionImplementation;
    }

    public AggregationImplementation getAggregationImplementation(ResolvedFunction resolvedFunction) {
        try {
            return (AggregationImplementation)CacheUtils.uncheckedCacheGet(this.specializedAggregationCache, (Object)new FunctionKey(resolvedFunction), () -> this.getAggregationImplementationInternal(resolvedFunction));
        }
        catch (UncheckedExecutionException e) {
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), TrinoException.class);
            throw new RuntimeException(e.getCause());
        }
    }

    private AggregationImplementation getAggregationImplementationInternal(ResolvedFunction resolvedFunction) {
        FunctionDependencies functionDependencies = this.getFunctionDependencies(resolvedFunction);
        return this.getFunctionProvider(resolvedFunction).getAggregationImplementation(resolvedFunction.getFunctionId(), resolvedFunction.getSignature(), functionDependencies);
    }

    public WindowFunctionSupplier getWindowFunctionSupplier(ResolvedFunction resolvedFunction) {
        try {
            return (WindowFunctionSupplier)CacheUtils.uncheckedCacheGet(this.specializedWindowCache, (Object)new FunctionKey(resolvedFunction), () -> this.getWindowFunctionSupplierInternal(resolvedFunction));
        }
        catch (UncheckedExecutionException e) {
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), TrinoException.class);
            throw new RuntimeException(e.getCause());
        }
    }

    private WindowFunctionSupplier getWindowFunctionSupplierInternal(ResolvedFunction resolvedFunction) {
        FunctionDependencies functionDependencies = this.getFunctionDependencies(resolvedFunction);
        return this.getFunctionProvider(resolvedFunction).getWindowFunctionSupplier(resolvedFunction.getFunctionId(), resolvedFunction.getSignature(), functionDependencies);
    }

    public TableFunctionProcessorProvider getTableFunctionProcessorProvider(TableFunctionHandle tableFunctionHandle) {
        GlobalFunctionCatalog provider;
        CatalogHandle catalogHandle = tableFunctionHandle.getCatalogHandle();
        if (catalogHandle.equals((Object)GlobalSystemConnector.CATALOG_HANDLE)) {
            provider = this.globalFunctionCatalog;
        } else {
            provider = this.functionProviders.getService(catalogHandle);
            Preconditions.checkArgument((provider != null ? 1 : 0) != 0, (String)"No function provider for catalog: '%s'", (Object)catalogHandle);
        }
        return provider.getTableFunctionProcessorProvider(tableFunctionHandle.getFunctionHandle());
    }

    private FunctionDependencies getFunctionDependencies(ResolvedFunction resolvedFunction) {
        return new InternalFunctionDependencies(this::getScalarFunctionImplementation, resolvedFunction.getTypeDependencies(), resolvedFunction.getFunctionDependencies());
    }

    private FunctionProvider getFunctionProvider(ResolvedFunction resolvedFunction) {
        if (resolvedFunction.getCatalogHandle().equals((Object)GlobalSystemConnector.CATALOG_HANDLE)) {
            return this.globalFunctionCatalog;
        }
        FunctionProvider functionProvider = this.functionProviders.getService(resolvedFunction.getCatalogHandle());
        Preconditions.checkArgument((functionProvider != null ? 1 : 0) != 0, (String)"No function provider for catalog: '%s' (function '%s')", (Object)resolvedFunction.getCatalogHandle(), (Object)resolvedFunction.getSignature().getName());
        return functionProvider;
    }

    private static void verifyMethodHandleSignature(BoundSignature boundSignature, ScalarFunctionImplementation scalarFunctionImplementation, InvocationConvention convention) {
        MethodHandle methodHandle = scalarFunctionImplementation.getMethodHandle();
        MethodType methodType = methodHandle.type();
        Preconditions.checkArgument((convention.getArgumentConventions().size() == boundSignature.getArgumentTypes().size() ? 1 : 0) != 0, (String)"Expected %s arguments, but got %s", (int)boundSignature.getArgumentTypes().size(), (int)convention.getArgumentConventions().size());
        long expectedParameterCount = convention.getArgumentConventions().stream().mapToInt(InvocationConvention.InvocationArgumentConvention::getParameterCount).sum();
        expectedParameterCount += methodType.parameterList().stream().filter(ConnectorSession.class::equals).count();
        expectedParameterCount += (long)convention.getReturnConvention().getParameterCount();
        if (scalarFunctionImplementation.getInstanceFactory().isPresent()) {
            ++expectedParameterCount;
        }
        Preconditions.checkArgument((expectedParameterCount == (long)methodType.parameterCount() ? 1 : 0) != 0, (String)"Expected %s method parameters, but got %s", (long)expectedParameterCount, (int)methodType.parameterCount());
        int parameterIndex = 0;
        if (scalarFunctionImplementation.getInstanceFactory().isPresent()) {
            FunctionManager.verifyFunctionSignature(convention.supportsInstanceFactory(), "Method requires instance factory, but calling convention does not support an instance factory", new Object[0]);
            MethodHandle factoryMethod = (MethodHandle)scalarFunctionImplementation.getInstanceFactory().orElseThrow();
            FunctionManager.verifyFunctionSignature(methodType.parameterType(parameterIndex).equals(factoryMethod.type().returnType()), "Invalid return type", new Object[0]);
            ++parameterIndex;
        }
        int lambdaArgumentIndex = 0;
        for (int argumentIndex = 0; argumentIndex < boundSignature.getArgumentTypes().size(); ++argumentIndex) {
            while (methodType.parameterType(parameterIndex).equals(ConnectorSession.class)) {
                FunctionManager.verifyFunctionSignature(convention.supportsSession(), "Method requires session, but calling convention does not support session", new Object[0]);
                ++parameterIndex;
            }
            TypeDescriptor.OfField parameterType = methodType.parameterType(parameterIndex);
            Type argumentType = (Type)boundSignature.getArgumentTypes().get(argumentIndex);
            InvocationConvention.InvocationArgumentConvention argumentConvention = convention.getArgumentConvention(argumentIndex);
            switch (argumentConvention) {
                case NEVER_NULL: {
                    FunctionManager.verifyFunctionSignature(((Class)parameterType).isAssignableFrom(argumentType.getJavaType()), "Expected argument type to be %s, but is %s", argumentType, parameterType);
                    break;
                }
                case NULL_FLAG: {
                    FunctionManager.verifyFunctionSignature(((Class)parameterType).isAssignableFrom(argumentType.getJavaType()), "Expected argument type to be %s, but is %s", argumentType.getJavaType(), parameterType);
                    FunctionManager.verifyFunctionSignature(methodType.parameterType(parameterIndex + 1).equals(Boolean.TYPE), "Expected null flag parameter to be followed by a boolean parameter", new Object[0]);
                    break;
                }
                case BOXED_NULLABLE: {
                    FunctionManager.verifyFunctionSignature(((Class)parameterType).isAssignableFrom(Primitives.wrap((Class)argumentType.getJavaType())), "Expected argument type to be %s, but is %s", Primitives.wrap((Class)argumentType.getJavaType()), parameterType);
                    break;
                }
                case BLOCK_POSITION_NOT_NULL: 
                case BLOCK_POSITION: {
                    FunctionManager.verifyFunctionSignature(parameterType.equals(Block.class) && methodType.parameterType(parameterIndex + 1).equals(Integer.TYPE), "Expected %s argument types to be Block and int".formatted(argumentConvention), new Object[0]);
                    break;
                }
                case IN_OUT: {
                    FunctionManager.verifyFunctionSignature(parameterType.equals(InOut.class), "Expected IN_OUT argument type to be InOut", new Object[0]);
                    break;
                }
                case FUNCTION: {
                    Class lambdaInterface = (Class)scalarFunctionImplementation.getLambdaInterfaces().get(lambdaArgumentIndex);
                    FunctionManager.verifyFunctionSignature(parameterType.equals(lambdaInterface), "Expected function interface to be %s, but is %s", lambdaInterface, parameterType);
                    ++lambdaArgumentIndex;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown argument convention: " + argumentConvention);
                }
            }
            parameterIndex += argumentConvention.getParameterCount();
        }
        Type returnType = boundSignature.getReturnType();
        switch (convention.getReturnConvention()) {
            case FAIL_ON_NULL: {
                FunctionManager.verifyFunctionSignature(((Class)methodType.returnType()).isAssignableFrom(returnType.getJavaType()), "Expected return type to be %s, but is %s", returnType.getJavaType(), methodType.returnType());
                break;
            }
            case NULLABLE_RETURN: {
                FunctionManager.verifyFunctionSignature(((Class)methodType.returnType()).isAssignableFrom(Primitives.wrap((Class)returnType.getJavaType())), "Expected return type to be %s, but is %s", returnType.getJavaType(), Primitives.wrap((Class)methodType.returnType()));
                break;
            }
            case BLOCK_BUILDER: {
                FunctionManager.verifyFunctionSignature(methodType.lastParameterType().equals(BlockBuilder.class), "Expected last argument type to be BlockBuilder, but is %s", methodType.lastParameterType());
                FunctionManager.verifyFunctionSignature(methodType.returnType().equals(Void.TYPE), "Expected return type to be void, but is %s", methodType.returnType());
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown return convention: " + convention.getReturnConvention());
            }
        }
    }

    private static void verifyFunctionSignature(boolean check, String message, Object ... args) {
        if (!check) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, String.format(message, args));
        }
    }

    public static FunctionManager createTestingFunctionManager() {
        TypeOperators typeOperators = new TypeOperators();
        GlobalFunctionCatalog functionCatalog = new GlobalFunctionCatalog();
        functionCatalog.addFunctions(SystemFunctionBundle.create(new FeaturesConfig(), typeOperators, new BlockTypeOperators(typeOperators), NodeVersion.UNKNOWN));
        functionCatalog.addFunctions(new InternalFunctionBundle(new LiteralFunction(new InternalBlockEncodingSerde(new BlockEncodingManager(), InternalTypeManager.TESTING_TYPE_MANAGER))));
        return new FunctionManager(CatalogServiceProvider.fail(), functionCatalog);
    }

    private static class FunctionKey {
        private final FunctionId functionId;
        private final BoundSignature boundSignature;
        private final Optional<InvocationConvention> invocationConvention;

        public FunctionKey(ResolvedFunction resolvedFunction) {
            this(resolvedFunction.getFunctionId(), resolvedFunction.getSignature(), Optional.empty());
        }

        public FunctionKey(ResolvedFunction resolvedFunction, InvocationConvention invocationConvention) {
            this(resolvedFunction.getFunctionId(), resolvedFunction.getSignature(), Optional.of(invocationConvention));
        }

        public FunctionKey(FunctionId functionId, BoundSignature boundSignature, Optional<InvocationConvention> invocationConvention) {
            this.functionId = Objects.requireNonNull(functionId, "functionId is null");
            this.boundSignature = Objects.requireNonNull(boundSignature, "boundSignature is null");
            this.invocationConvention = Objects.requireNonNull(invocationConvention, "invocationConvention is null");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FunctionKey that = (FunctionKey)o;
            return this.functionId.equals((Object)that.functionId) && this.boundSignature.equals((Object)that.boundSignature) && this.invocationConvention.equals(that.invocationConvention);
        }

        public int hashCode() {
            return Objects.hash(this.functionId, this.boundSignature, this.invocationConvention);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).omitNullValues().add("functionId", (Object)this.functionId).add("boundSignature", (Object)this.boundSignature).add("invocationConvention", this.invocationConvention.orElse(null)).toString();
        }
    }
}

