/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import io.trino.operator.Driver;
import io.trino.operator.DriverContext;
import io.trino.operator.Operator;
import io.trino.operator.OperatorContext;
import io.trino.operator.OperatorFactory;
import io.trino.operator.SourceOperatorFactory;
import io.trino.sql.planner.plan.PlanNodeId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;

public class DriverFactory {
    private final int pipelineId;
    private final boolean inputDriver;
    private final boolean outputDriver;
    private final List<OperatorFactory> operatorFactories;
    private final Optional<PlanNodeId> sourceId;
    private final OptionalInt driverInstances;
    @GuardedBy(value="this")
    private volatile boolean noMoreDrivers;

    public DriverFactory(int pipelineId, boolean inputDriver, boolean outputDriver, List<OperatorFactory> operatorFactories, OptionalInt driverInstances) {
        this.pipelineId = pipelineId;
        this.inputDriver = inputDriver;
        this.outputDriver = outputDriver;
        this.operatorFactories = ImmutableList.copyOf((Collection)Objects.requireNonNull(operatorFactories, "operatorFactories is null"));
        Preconditions.checkArgument((!operatorFactories.isEmpty() ? 1 : 0) != 0, (Object)"There must be at least one operator");
        this.driverInstances = Objects.requireNonNull(driverInstances, "driverInstances is null");
        List sourceIds = (List)operatorFactories.stream().filter(SourceOperatorFactory.class::isInstance).map(SourceOperatorFactory.class::cast).map(SourceOperatorFactory::getSourceId).collect(ImmutableList.toImmutableList());
        Preconditions.checkArgument((sourceIds.size() <= 1 ? 1 : 0) != 0, (String)"Expected at most one source operator in driver factory, but found %s", (Object)sourceIds);
        this.sourceId = sourceIds.isEmpty() ? Optional.empty() : Optional.of((PlanNodeId)sourceIds.get(0));
    }

    public int getPipelineId() {
        return this.pipelineId;
    }

    public boolean isInputDriver() {
        return this.inputDriver;
    }

    public boolean isOutputDriver() {
        return this.outputDriver;
    }

    public Optional<PlanNodeId> getSourceId() {
        return this.sourceId;
    }

    public OptionalInt getDriverInstances() {
        return this.driverInstances;
    }

    public List<OperatorFactory> getOperatorFactories() {
        return this.operatorFactories;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Driver createDriver(DriverContext driverContext) {
        Objects.requireNonNull(driverContext, "driverContext is null");
        ArrayList<Operator> operators = new ArrayList<Operator>(this.operatorFactories.size());
        try {
            DriverFactory driverFactory = this;
            synchronized (driverFactory) {
                Preconditions.checkState((!this.noMoreDrivers ? 1 : 0) != 0, (Object)"noMoreDrivers is already set");
                for (OperatorFactory operatorFactory : this.operatorFactories) {
                    Operator operator = operatorFactory.createOperator(driverContext);
                    operators.add(operator);
                }
            }
            return Driver.createDriver(driverContext, operators);
        }
        catch (Throwable failure) {
            for (Operator operator : operators) {
                try {
                    operator.close();
                }
                catch (Throwable closeFailure) {
                    if (failure == closeFailure) continue;
                    failure.addSuppressed(closeFailure);
                }
            }
            for (OperatorContext operatorContext : driverContext.getOperatorContexts()) {
                try {
                    operatorContext.destroy();
                }
                catch (Throwable destroyFailure) {
                    if (failure == destroyFailure) continue;
                    failure.addSuppressed(destroyFailure);
                }
            }
            throw failure;
        }
    }

    public synchronized void noMoreDrivers() {
        if (this.noMoreDrivers) {
            return;
        }
        this.noMoreDrivers = true;
        for (OperatorFactory operatorFactory : this.operatorFactories) {
            operatorFactory.noMoreOperators();
        }
    }

    public boolean isNoMoreDrivers() {
        return this.noMoreDrivers;
    }
}

