/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.base.Preconditions;
import io.trino.operator.BasicWorkProcessorOperatorAdapter;
import io.trino.operator.ChangeOnlyUpdatedColumnsMergeProcessor;
import io.trino.operator.DeleteAndInsertMergeProcessor;
import io.trino.operator.MergeRowChangeProcessor;
import io.trino.operator.OperatorFactory;
import io.trino.operator.ProcessorContext;
import io.trino.operator.WorkProcessor;
import io.trino.operator.WorkProcessorOperator;
import io.trino.spi.Page;
import io.trino.spi.connector.RowChangeParadigm;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.TableWriterNode;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public class MergeProcessorOperator
implements WorkProcessorOperator {
    private final WorkProcessor<Page> pages;

    public static OperatorFactory createOperatorFactory(int operatorId, PlanNodeId planNodeId, TableWriterNode.MergeParadigmAndTypes merge, int rowIdChannel, int mergeRowChannel, List<Integer> redistributionColumns, List<Integer> dataColumnChannels, Function<Page, Page> pagePreprocessor) {
        MergeRowChangeProcessor rowChangeProcessor = MergeProcessorOperator.createRowChangeProcessor(merge, rowIdChannel, mergeRowChannel, redistributionColumns, dataColumnChannels);
        return BasicWorkProcessorOperatorAdapter.createAdapterOperatorFactory(new Factory(operatorId, planNodeId, rowChangeProcessor, pagePreprocessor));
    }

    private static MergeRowChangeProcessor createRowChangeProcessor(TableWriterNode.MergeParadigmAndTypes merge, int rowIdChannel, int mergeRowChannel, List<Integer> redistributionColumnChannels, List<Integer> dataColumnChannels) {
        return switch (merge.getParadigm().orElseThrow()) {
            default -> throw new IncompatibleClassChangeError();
            case RowChangeParadigm.DELETE_ROW_AND_INSERT_ROW -> new DeleteAndInsertMergeProcessor(merge.getColumnTypes(), merge.getRowIdType(), rowIdChannel, mergeRowChannel, redistributionColumnChannels, dataColumnChannels);
            case RowChangeParadigm.CHANGE_ONLY_UPDATED_COLUMNS -> new ChangeOnlyUpdatedColumnsMergeProcessor(rowIdChannel, mergeRowChannel, dataColumnChannels, redistributionColumnChannels);
        };
    }

    private MergeProcessorOperator(WorkProcessor<Page> sourcePages, MergeRowChangeProcessor rowChangeProcessor, Function<Page, Page> pagePreprocessor) {
        this.pages = sourcePages.transform(page -> {
            if (page == null) {
                return WorkProcessor.TransformationState.finished();
            }
            return WorkProcessor.TransformationState.ofResult(rowChangeProcessor.transformPage((Page)pagePreprocessor.apply((Page)page)));
        });
    }

    @Override
    public WorkProcessor<Page> getOutputPages() {
        return this.pages;
    }

    public static class Factory
    implements BasicWorkProcessorOperatorAdapter.BasicAdapterWorkProcessorOperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final MergeRowChangeProcessor rowChangeProcessor;
        private final Function<Page, Page> pagePreprocessor;
        private boolean closed;

        public Factory(int operatorId, PlanNodeId planNodeId, MergeRowChangeProcessor rowChangeProcessor, Function<Page, Page> pagePreprocessor) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.rowChangeProcessor = Objects.requireNonNull(rowChangeProcessor, "rowChangeProcessor is null");
            this.pagePreprocessor = Objects.requireNonNull(pagePreprocessor, "pagePreprocessor is null");
        }

        @Override
        public WorkProcessorOperator create(ProcessorContext processorContext, WorkProcessor<Page> sourcePages) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            return new MergeProcessorOperator(sourcePages, this.rowChangeProcessor, this.pagePreprocessor);
        }

        @Override
        public int getOperatorId() {
            return this.operatorId;
        }

        @Override
        public PlanNodeId getPlanNodeId() {
            return this.planNodeId;
        }

        @Override
        public String getOperatorType() {
            return MergeProcessorOperator.class.getSimpleName();
        }

        @Override
        public void close() {
            this.closed = true;
        }

        @Override
        public Factory duplicate() {
            return new Factory(this.operatorId, this.planNodeId, this.rowChangeProcessor, this.pagePreprocessor);
        }
    }
}

