/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.state;

import io.airlift.slice.SizeOf;
import io.trino.array.LongBigArray;
import io.trino.operator.aggregation.state.AbstractGroupedAccumulatorState;
import io.trino.operator.aggregation.state.LongDecimalWithOverflowAndLongState;
import io.trino.spi.function.AccumulatorState;
import io.trino.spi.function.AccumulatorStateFactory;
import jakarta.annotation.Nullable;

public class LongDecimalWithOverflowAndLongStateFactory
implements AccumulatorStateFactory<LongDecimalWithOverflowAndLongState> {
    public LongDecimalWithOverflowAndLongState createSingleState() {
        return new SingleLongDecimalWithOverflowAndLongState();
    }

    public LongDecimalWithOverflowAndLongState createGroupedState() {
        return new GroupedLongDecimalWithOverflowAndLongState();
    }

    private static final class SingleLongDecimalWithOverflowAndLongState
    implements LongDecimalWithOverflowAndLongState {
        private static final int INSTANCE_SIZE = SizeOf.instanceSize(SingleLongDecimalWithOverflowAndLongState.class);
        private static final int SIZE = (int)SizeOf.sizeOf((long[])new long[2]) + 8 + 8;
        private final long[] unscaledDecimal = new long[2];
        private long longValue;
        private long overflow;

        public SingleLongDecimalWithOverflowAndLongState() {
        }

        private SingleLongDecimalWithOverflowAndLongState(long[] unscaledDecimal, long longValue, long overflow) {
            System.arraycopy(unscaledDecimal, 0, this.unscaledDecimal, 0, 2);
            this.longValue = longValue;
            this.overflow = overflow;
        }

        @Override
        public long getLong() {
            return this.longValue;
        }

        @Override
        public void setLong(long longValue) {
            this.longValue = longValue;
        }

        @Override
        public void addLong(long value) {
            this.longValue += value;
        }

        @Override
        public long[] getDecimalArray() {
            return this.unscaledDecimal;
        }

        @Override
        public int getDecimalArrayOffset() {
            return 0;
        }

        @Override
        public long getOverflow() {
            return this.overflow;
        }

        @Override
        public void setOverflow(long overflow) {
            this.overflow = overflow;
        }

        @Override
        public void addOverflow(long overflow) {
            this.overflow += overflow;
        }

        public long getEstimatedSize() {
            return INSTANCE_SIZE + SIZE;
        }

        public AccumulatorState copy() {
            return new SingleLongDecimalWithOverflowAndLongState(this.unscaledDecimal, this.longValue, this.overflow);
        }
    }

    private static final class GroupedLongDecimalWithOverflowAndLongState
    extends AbstractGroupedAccumulatorState
    implements LongDecimalWithOverflowAndLongState {
        private static final int INSTANCE_SIZE = SizeOf.instanceSize(GroupedLongDecimalWithOverflowAndLongState.class);
        private final LongBigArray longs = new LongBigArray();
        private final LongBigArray unscaledDecimals = new LongBigArray();
        @Nullable
        private LongBigArray overflows;

        private GroupedLongDecimalWithOverflowAndLongState() {
        }

        public void ensureCapacity(long size) {
            this.longs.ensureCapacity(size);
            this.unscaledDecimals.ensureCapacity(size * 2L);
            if (this.overflows != null) {
                this.overflows.ensureCapacity(size);
            }
        }

        @Override
        public long getLong() {
            return this.longs.get(this.getGroupId());
        }

        @Override
        public void setLong(long value) {
            this.longs.set(this.getGroupId(), value);
        }

        @Override
        public void addLong(long value) {
            this.longs.add(this.getGroupId(), value);
        }

        @Override
        public long[] getDecimalArray() {
            return this.unscaledDecimals.getSegment(this.getGroupId() * 2L);
        }

        @Override
        public int getDecimalArrayOffset() {
            return this.unscaledDecimals.getOffset(this.getGroupId() * 2L);
        }

        @Override
        public long getOverflow() {
            if (this.overflows == null) {
                return 0L;
            }
            return this.overflows.get(this.getGroupId());
        }

        @Override
        public void setOverflow(long overflow) {
            if (overflow == 0L && this.overflows == null) {
                return;
            }
            long groupId = this.getGroupId();
            if (this.overflows == null) {
                this.overflows = new LongBigArray();
                this.overflows.ensureCapacity(this.longs.getCapacity());
            }
            this.overflows.set(groupId, overflow);
        }

        @Override
        public void addOverflow(long overflow) {
            if (overflow != 0L) {
                long groupId = this.getGroupId();
                if (this.overflows == null) {
                    this.overflows = new LongBigArray();
                    this.overflows.ensureCapacity(this.longs.getCapacity());
                }
                this.overflows.add(groupId, overflow);
            }
        }

        public long getEstimatedSize() {
            return (long)INSTANCE_SIZE + this.longs.sizeOf() + this.unscaledDecimals.sizeOf() + (this.overflows == null ? 0L : this.overflows.sizeOf());
        }
    }
}

