/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar;

import io.trino.operator.aggregation.histogram.SingleTypedHistogram;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.MapBlock;
import io.trino.spi.block.MapBlockBuilder;
import io.trino.spi.function.Convention;
import io.trino.spi.function.Description;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorDependency;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.function.TypeParameter;
import io.trino.spi.type.MapType;
import io.trino.spi.type.Type;
import io.trino.type.BlockTypeOperators;

@Description(value="Return a map containing the counts of the elements in the array")
@ScalarFunction(value="array_histogram")
public final class ArrayHistogramFunction {
    private static final int EXPECTED_HISTOGRAM_SIZE = 10;

    private ArrayHistogramFunction() {
    }

    @TypeParameter(value="T")
    @SqlType(value="map(T, bigint)")
    public static Block arrayHistogram(@TypeParameter(value="T") Type elementType, @OperatorDependency(operator=OperatorType.EQUAL, argumentTypes={"T", "T"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION}, result=InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN)) BlockTypeOperators.BlockPositionEqual equalOperator, @OperatorDependency(operator=OperatorType.HASH_CODE, argumentTypes={"T"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) BlockTypeOperators.BlockPositionHashCode hashCodeOperator, @TypeParameter(value="map(T, bigint)") MapType mapType, @SqlType(value="array(T)") Block arrayBlock) {
        SingleTypedHistogram histogram = new SingleTypedHistogram(elementType, equalOperator, hashCodeOperator, 10);
        int positionCount = arrayBlock.getPositionCount();
        for (int position = 0; position < positionCount; ++position) {
            if (arrayBlock.isNull(position)) continue;
            histogram.add(position, arrayBlock, 1L);
        }
        MapBlockBuilder blockBuilder = mapType.createBlockBuilder(null, histogram.getPositionCount());
        histogram.serialize((BlockBuilder)blockBuilder);
        MapBlock mapBlock = (MapBlock)blockBuilder.build();
        return (Block)mapBlock.getObject(0, Block.class);
    }
}

