/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.Immutable;
import io.trino.connector.CatalogProperties;
import io.trino.cost.StatsAndCosts;
import io.trino.spi.type.Type;
import io.trino.sql.planner.PartitioningHandle;
import io.trino.sql.planner.PartitioningScheme;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.SystemPartitioningHandle;
import io.trino.sql.planner.plan.PlanFragmentId;
import io.trino.sql.planner.plan.PlanNode;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.sql.planner.plan.RemoteSourceNode;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

@Immutable
public class PlanFragment {
    private final PlanFragmentId id;
    private final PlanNode root;
    private final Map<Symbol, Type> symbols;
    private final PartitioningHandle partitioning;
    private final Optional<Integer> partitionCount;
    private final List<PlanNodeId> partitionedSources;
    private final Set<PlanNodeId> partitionedSourcesSet;
    private final List<Type> types;
    private final Set<PlanNode> partitionedSourceNodes;
    private final List<RemoteSourceNode> remoteSourceNodes;
    private final PartitioningScheme outputPartitioningScheme;
    private final StatsAndCosts statsAndCosts;
    private final List<CatalogProperties> activeCatalogs;
    private final Optional<String> jsonRepresentation;

    private PlanFragment(PlanFragmentId id, PlanNode root, Map<Symbol, Type> symbols, PartitioningHandle partitioning, Optional<Integer> partitionCount, List<PlanNodeId> partitionedSources, Set<PlanNodeId> partitionedSourcesSet, List<Type> types, Set<PlanNode> partitionedSourceNodes, List<RemoteSourceNode> remoteSourceNodes, PartitioningScheme outputPartitioningScheme, StatsAndCosts statsAndCosts, List<CatalogProperties> activeCatalogs) {
        this.id = Objects.requireNonNull(id, "id is null");
        this.root = Objects.requireNonNull(root, "root is null");
        this.symbols = Objects.requireNonNull(symbols, "symbols is null");
        this.partitioning = Objects.requireNonNull(partitioning, "partitioning is null");
        this.partitionCount = Objects.requireNonNull(partitionCount, "partitionCount is null");
        this.partitionedSources = Objects.requireNonNull(partitionedSources, "partitionedSources is null");
        this.partitionedSourcesSet = Objects.requireNonNull(partitionedSourcesSet, "partitionedSourcesSet is null");
        this.types = Objects.requireNonNull(types, "types is null");
        this.partitionedSourceNodes = Objects.requireNonNull(partitionedSourceNodes, "partitionedSourceNodes is null");
        this.remoteSourceNodes = Objects.requireNonNull(remoteSourceNodes, "remoteSourceNodes is null");
        this.outputPartitioningScheme = Objects.requireNonNull(outputPartitioningScheme, "outputPartitioningScheme is null");
        this.statsAndCosts = Objects.requireNonNull(statsAndCosts, "statsAndCosts is null");
        this.activeCatalogs = Objects.requireNonNull(activeCatalogs, "activeCatalogs is null");
        this.jsonRepresentation = Optional.empty();
    }

    @JsonCreator
    public PlanFragment(@JsonProperty(value="id") PlanFragmentId id, @JsonProperty(value="root") PlanNode root, @JsonProperty(value="symbols") Map<Symbol, Type> symbols, @JsonProperty(value="partitioning") PartitioningHandle partitioning, @JsonProperty(value="partitionCount") Optional<Integer> partitionCount, @JsonProperty(value="partitionedSources") List<PlanNodeId> partitionedSources, @JsonProperty(value="outputPartitioningScheme") PartitioningScheme outputPartitioningScheme, @JsonProperty(value="statsAndCosts") StatsAndCosts statsAndCosts, @JsonProperty(value="activeCatalogs") List<CatalogProperties> activeCatalogs, @JsonProperty(value="jsonRepresentation") Optional<String> jsonRepresentation) {
        this.id = Objects.requireNonNull(id, "id is null");
        this.root = Objects.requireNonNull(root, "root is null");
        this.symbols = Objects.requireNonNull(symbols, "symbols is null");
        this.partitioning = Objects.requireNonNull(partitioning, "partitioning is null");
        this.partitionCount = Objects.requireNonNull(partitionCount, "partitionCount is null");
        this.partitionedSources = ImmutableList.copyOf((Collection)Objects.requireNonNull(partitionedSources, "partitionedSources is null"));
        this.partitionedSourcesSet = ImmutableSet.copyOf(partitionedSources);
        this.statsAndCosts = Objects.requireNonNull(statsAndCosts, "statsAndCosts is null");
        this.activeCatalogs = Objects.requireNonNull(activeCatalogs, "activeCatalogs is null");
        this.jsonRepresentation = Objects.requireNonNull(jsonRepresentation, "jsonRepresentation is null");
        Preconditions.checkArgument((partitionCount.isEmpty() || partitioning.getConnectorHandle() instanceof SystemPartitioningHandle ? 1 : 0) != 0, (Object)"Connector partitioning handle should be of type system partitioning when partitionCount is present");
        Preconditions.checkArgument((this.partitionedSourcesSet.size() == partitionedSources.size() ? 1 : 0) != 0, (Object)"partitionedSources contains duplicates");
        Preconditions.checkArgument((boolean)ImmutableSet.copyOf(root.getOutputSymbols()).containsAll(outputPartitioningScheme.getOutputLayout()), (String)"Root node outputs (%s) does not include all fragment outputs (%s)", root.getOutputSymbols(), outputPartitioningScheme.getOutputLayout());
        this.types = (List)outputPartitioningScheme.getOutputLayout().stream().map(symbols::get).collect(ImmutableList.toImmutableList());
        this.partitionedSourceNodes = PlanFragment.findSources(root, partitionedSources);
        ImmutableList.Builder remoteSourceNodes = ImmutableList.builder();
        PlanFragment.findRemoteSourceNodes(root, (ImmutableList.Builder<RemoteSourceNode>)remoteSourceNodes);
        this.remoteSourceNodes = remoteSourceNodes.build();
        this.outputPartitioningScheme = Objects.requireNonNull(outputPartitioningScheme, "partitioningScheme is null");
    }

    @JsonProperty
    public PlanFragmentId getId() {
        return this.id;
    }

    @JsonProperty
    public PlanNode getRoot() {
        return this.root;
    }

    @JsonProperty
    public Map<Symbol, Type> getSymbols() {
        return this.symbols;
    }

    @JsonProperty
    public PartitioningHandle getPartitioning() {
        return this.partitioning;
    }

    @JsonProperty
    public Optional<Integer> getPartitionCount() {
        return this.partitionCount;
    }

    @JsonProperty
    public List<PlanNodeId> getPartitionedSources() {
        return this.partitionedSources;
    }

    public boolean isPartitionedSources(PlanNodeId nodeId) {
        return this.partitionedSourcesSet.contains(nodeId);
    }

    @JsonProperty
    public PartitioningScheme getOutputPartitioningScheme() {
        return this.outputPartitioningScheme;
    }

    @JsonProperty
    public StatsAndCosts getStatsAndCosts() {
        return this.statsAndCosts;
    }

    @JsonProperty
    public List<CatalogProperties> getActiveCatalogs() {
        return this.activeCatalogs;
    }

    @JsonProperty
    public Optional<String> getJsonRepresentation() {
        return this.jsonRepresentation;
    }

    public PlanFragment withoutEmbeddedJsonRepresentation() {
        if (this.jsonRepresentation.isEmpty()) {
            return this;
        }
        return new PlanFragment(this.id, this.root, this.symbols, this.partitioning, this.partitionCount, this.partitionedSources, this.partitionedSourcesSet, this.types, this.partitionedSourceNodes, this.remoteSourceNodes, this.outputPartitioningScheme, this.statsAndCosts, this.activeCatalogs);
    }

    public List<Type> getTypes() {
        return this.types;
    }

    public Set<PlanNode> getPartitionedSourceNodes() {
        return this.partitionedSourceNodes;
    }

    public boolean isLeaf() {
        return this.remoteSourceNodes.isEmpty();
    }

    public List<RemoteSourceNode> getRemoteSourceNodes() {
        return this.remoteSourceNodes;
    }

    private static Set<PlanNode> findSources(PlanNode node, Iterable<PlanNodeId> nodeIds) {
        ImmutableSet.Builder nodes = ImmutableSet.builder();
        PlanFragment.findSources(node, (Set<PlanNodeId>)ImmutableSet.copyOf(nodeIds), (ImmutableSet.Builder<PlanNode>)nodes);
        return nodes.build();
    }

    private static void findSources(PlanNode node, Set<PlanNodeId> nodeIds, ImmutableSet.Builder<PlanNode> nodes) {
        if (nodeIds.contains(node.getId())) {
            nodes.add((Object)node);
        }
        for (PlanNode source : node.getSources()) {
            nodes.addAll(PlanFragment.findSources(source, nodeIds));
        }
    }

    private static void findRemoteSourceNodes(PlanNode node, ImmutableList.Builder<RemoteSourceNode> builder) {
        for (PlanNode source : node.getSources()) {
            PlanFragment.findRemoteSourceNodes(source, builder);
        }
        if (node instanceof RemoteSourceNode) {
            builder.add((Object)((RemoteSourceNode)node));
        }
    }

    public PlanFragment withBucketToPartition(Optional<int[]> bucketToPartition) {
        return new PlanFragment(this.id, this.root, this.symbols, this.partitioning, this.partitionCount, this.partitionedSources, this.outputPartitioningScheme.withBucketToPartition(bucketToPartition), this.statsAndCosts, this.activeCatalogs, this.jsonRepresentation);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)this.id).add("partitioning", (Object)this.partitioning).add("partitionCount", this.partitionCount).add("partitionedSource", this.partitionedSources).add("outputPartitioningScheme", (Object)this.outputPartitioningScheme).toString();
    }
}

