/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tracing;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Inject;
import io.airlift.slice.Slice;
import io.airlift.tracing.Tracing;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.Tracer;
import io.trino.Session;
import io.trino.metadata.AnalyzeMetadata;
import io.trino.metadata.AnalyzeTableHandle;
import io.trino.metadata.CatalogInfo;
import io.trino.metadata.InsertTableHandle;
import io.trino.metadata.MaterializedViewDefinition;
import io.trino.metadata.MergeHandle;
import io.trino.metadata.Metadata;
import io.trino.metadata.OperatorNotFoundException;
import io.trino.metadata.OutputTableHandle;
import io.trino.metadata.QualifiedObjectName;
import io.trino.metadata.QualifiedTablePrefix;
import io.trino.metadata.RedirectionAwareTableHandle;
import io.trino.metadata.ResolvedFunction;
import io.trino.metadata.ResolvedIndex;
import io.trino.metadata.TableExecuteHandle;
import io.trino.metadata.TableFunctionHandle;
import io.trino.metadata.TableHandle;
import io.trino.metadata.TableLayout;
import io.trino.metadata.TableMetadata;
import io.trino.metadata.TableProperties;
import io.trino.metadata.TableSchema;
import io.trino.metadata.TableVersion;
import io.trino.metadata.ViewDefinition;
import io.trino.metadata.ViewInfo;
import io.trino.spi.connector.AggregateFunction;
import io.trino.spi.connector.AggregationApplicationResult;
import io.trino.spi.connector.BeginTableExecuteResult;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.connector.CatalogSchemaName;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorCapabilities;
import io.trino.spi.connector.ConnectorOutputMetadata;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.ConstraintApplicationResult;
import io.trino.spi.connector.JoinApplicationResult;
import io.trino.spi.connector.JoinStatistics;
import io.trino.spi.connector.JoinType;
import io.trino.spi.connector.LimitApplicationResult;
import io.trino.spi.connector.MaterializedViewFreshness;
import io.trino.spi.connector.ProjectionApplicationResult;
import io.trino.spi.connector.RelationCommentMetadata;
import io.trino.spi.connector.RowChangeParadigm;
import io.trino.spi.connector.SampleApplicationResult;
import io.trino.spi.connector.SampleType;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SortItem;
import io.trino.spi.connector.SystemTable;
import io.trino.spi.connector.TableColumnsMetadata;
import io.trino.spi.connector.TableFunctionApplicationResult;
import io.trino.spi.connector.TableScanRedirectApplicationResult;
import io.trino.spi.connector.TopNApplicationResult;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.function.AggregationFunctionMetadata;
import io.trino.spi.function.FunctionMetadata;
import io.trino.spi.function.OperatorType;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.security.GrantInfo;
import io.trino.spi.security.Identity;
import io.trino.spi.security.Privilege;
import io.trino.spi.security.RoleGrant;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.spi.statistics.ComputedStatistics;
import io.trino.spi.statistics.TableStatistics;
import io.trino.spi.statistics.TableStatisticsMetadata;
import io.trino.spi.type.Type;
import io.trino.sql.analyzer.TypeSignatureProvider;
import io.trino.sql.planner.PartitioningHandle;
import io.trino.sql.tree.QualifiedName;
import io.trino.tracing.ForTracing;
import io.trino.tracing.ScopedSpan;
import io.trino.tracing.TrinoAttributes;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.UnaryOperator;

public class TracingMetadata
implements Metadata {
    private final Tracer tracer;
    private final Metadata delegate;

    @Inject
    public TracingMetadata(Tracer tracer, @ForTracing Metadata delegate) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.tracer = Objects.requireNonNull(tracer, "tracer is null");
    }

    @VisibleForTesting
    public Metadata getDelegate() {
        return this.delegate;
    }

    @Override
    public Set<ConnectorCapabilities> getConnectorCapabilities(Session session, CatalogHandle catalogHandle) {
        Span span = this.startSpan("getConnectorCapabilities", catalogHandle.getCatalogName());
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            Set<ConnectorCapabilities> set = this.delegate.getConnectorCapabilities(session, catalogHandle);
            return set;
        }
    }

    @Override
    public boolean catalogExists(Session session, String catalogName) {
        Span span = this.startSpan("catalogExists", catalogName);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            boolean bl = this.delegate.catalogExists(session, catalogName);
            return bl;
        }
    }

    @Override
    public boolean schemaExists(Session session, CatalogSchemaName schema) {
        Span span = this.startSpan("schemaExists", schema);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            boolean bl = this.delegate.schemaExists(session, schema);
            return bl;
        }
    }

    @Override
    public List<String> listSchemaNames(Session session, String catalogName) {
        Span span = this.startSpan("listSchemaNames", catalogName);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            List<String> list = this.delegate.listSchemaNames(session, catalogName);
            return list;
        }
    }

    @Override
    public Optional<TableHandle> getTableHandle(Session session, QualifiedObjectName tableName) {
        Span span = this.startSpan("getTableHandle", tableName);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            Optional<TableHandle> optional = this.delegate.getTableHandle(session, tableName);
            return optional;
        }
    }

    @Override
    public Optional<SystemTable> getSystemTable(Session session, QualifiedObjectName tableName) {
        Span span = this.startSpan("getSystemTable", tableName);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            Optional<SystemTable> optional = this.delegate.getSystemTable(session, tableName);
            return optional;
        }
    }

    @Override
    public Optional<TableExecuteHandle> getTableHandleForExecute(Session session, TableHandle tableHandle, String procedureName, Map<String, Object> executeProperties) {
        Span span = this.startSpan("getTableHandleForExecute", tableHandle).setAttribute(TrinoAttributes.PROCEDURE, (Object)procedureName);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            Optional<TableExecuteHandle> optional = this.delegate.getTableHandleForExecute(session, tableHandle, procedureName, executeProperties);
            return optional;
        }
    }

    @Override
    public Optional<TableLayout> getLayoutForTableExecute(Session session, TableExecuteHandle tableExecuteHandle) {
        Span span = this.startSpan("getLayoutForTableExecute", tableExecuteHandle);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            Optional<TableLayout> optional = this.delegate.getLayoutForTableExecute(session, tableExecuteHandle);
            return optional;
        }
    }

    @Override
    public BeginTableExecuteResult<TableExecuteHandle, TableHandle> beginTableExecute(Session session, TableExecuteHandle handle, TableHandle updatedSourceTableHandle) {
        Span span = this.startSpan("beginTableExecute", handle);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            BeginTableExecuteResult<TableExecuteHandle, TableHandle> beginTableExecuteResult = this.delegate.beginTableExecute(session, handle, updatedSourceTableHandle);
            return beginTableExecuteResult;
        }
    }

    @Override
    public void finishTableExecute(Session session, TableExecuteHandle handle, Collection<Slice> fragments, List<Object> tableExecuteState) {
        Span span = this.startSpan("finishTableExecute", handle);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.finishTableExecute(session, handle, fragments, tableExecuteState);
        }
    }

    @Override
    public void executeTableExecute(Session session, TableExecuteHandle handle) {
        Span span = this.startSpan("executeTableExecute", handle);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.executeTableExecute(session, handle);
        }
    }

    @Override
    public TableProperties getTableProperties(Session session, TableHandle handle) {
        Span span = this.startSpan("getTableProperties", handle);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            TableProperties tableProperties = this.delegate.getTableProperties(session, handle);
            return tableProperties;
        }
    }

    @Override
    public TableHandle makeCompatiblePartitioning(Session session, TableHandle table, PartitioningHandle partitioningHandle) {
        Span span = this.startSpan("makeCompatiblePartitioning", table);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            TableHandle tableHandle = this.delegate.makeCompatiblePartitioning(session, table, partitioningHandle);
            return tableHandle;
        }
    }

    @Override
    public Optional<PartitioningHandle> getCommonPartitioning(Session session, PartitioningHandle left, PartitioningHandle right) {
        Span span = this.startSpan("getCommonPartitioning");
        if (span.isRecording() && left.getCatalogHandle().equals(right.getCatalogHandle()) && left.getCatalogHandle().isPresent()) {
            span.setAttribute(TrinoAttributes.CATALOG, (Object)left.getCatalogHandle().get().getCatalogName());
        }
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            Optional<PartitioningHandle> optional = this.delegate.getCommonPartitioning(session, left, right);
            return optional;
        }
    }

    @Override
    public Optional<Object> getInfo(Session session, TableHandle handle) {
        Span span = this.startSpan("getInfo", handle);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            Optional<Object> optional = this.delegate.getInfo(session, handle);
            return optional;
        }
    }

    @Override
    public CatalogSchemaTableName getTableName(Session session, TableHandle tableHandle) {
        Span span = this.startSpan("getTableName", tableHandle);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            CatalogSchemaTableName catalogSchemaTableName = this.delegate.getTableName(session, tableHandle);
            return catalogSchemaTableName;
        }
    }

    @Override
    public TableSchema getTableSchema(Session session, TableHandle tableHandle) {
        Span span = this.startSpan("getTableSchema", tableHandle);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            TableSchema tableSchema = this.delegate.getTableSchema(session, tableHandle);
            return tableSchema;
        }
    }

    @Override
    public TableMetadata getTableMetadata(Session session, TableHandle tableHandle) {
        Span span = this.startSpan("getTableMetadata", tableHandle);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            TableMetadata tableMetadata = this.delegate.getTableMetadata(session, tableHandle);
            return tableMetadata;
        }
    }

    @Override
    public TableStatistics getTableStatistics(Session session, TableHandle tableHandle) {
        Span span = this.startSpan("getTableStatistics", tableHandle);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            TableStatistics tableStatistics = this.delegate.getTableStatistics(session, tableHandle);
            return tableStatistics;
        }
    }

    @Override
    public List<QualifiedObjectName> listTables(Session session, QualifiedTablePrefix prefix) {
        Span span = this.startSpan("listTables", prefix);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            List<QualifiedObjectName> list = this.delegate.listTables(session, prefix);
            return list;
        }
    }

    @Override
    public Map<String, ColumnHandle> getColumnHandles(Session session, TableHandle tableHandle) {
        Span span = this.startSpan("getColumnHandles", tableHandle);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            Map<String, ColumnHandle> map = this.delegate.getColumnHandles(session, tableHandle);
            return map;
        }
    }

    @Override
    public ColumnMetadata getColumnMetadata(Session session, TableHandle tableHandle, ColumnHandle columnHandle) {
        Span span = this.startSpan("getColumnMetadata", tableHandle);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            ColumnMetadata columnMetadata = this.delegate.getColumnMetadata(session, tableHandle, columnHandle);
            return columnMetadata;
        }
    }

    @Override
    public List<TableColumnsMetadata> listTableColumns(Session session, QualifiedTablePrefix prefix, UnaryOperator<Set<SchemaTableName>> relationFilter) {
        Span span = this.startSpan("listTableColumns", prefix);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            List<TableColumnsMetadata> list = this.delegate.listTableColumns(session, prefix, relationFilter);
            return list;
        }
    }

    @Override
    public List<RelationCommentMetadata> listRelationComments(Session session, String catalogName, Optional<String> schemaName, UnaryOperator<Set<SchemaTableName>> relationFilter) {
        Span span = this.startSpan("listRelationComments", new QualifiedTablePrefix(catalogName, schemaName, Optional.empty()));
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            List<RelationCommentMetadata> list = this.delegate.listRelationComments(session, catalogName, schemaName, relationFilter);
            return list;
        }
    }

    @Override
    public void createSchema(Session session, CatalogSchemaName schema, Map<String, Object> properties, TrinoPrincipal principal) {
        Span span = this.startSpan("createSchema", schema);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.createSchema(session, schema, properties, principal);
        }
    }

    @Override
    public void dropSchema(Session session, CatalogSchemaName schema, boolean cascade) {
        Span span = this.startSpan("dropSchema", schema);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.dropSchema(session, schema, cascade);
        }
    }

    @Override
    public void renameSchema(Session session, CatalogSchemaName source, String target) {
        Span span = this.startSpan("renameSchema", source);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.renameSchema(session, source, target);
        }
    }

    @Override
    public void setSchemaAuthorization(Session session, CatalogSchemaName source, TrinoPrincipal principal) {
        Span span = this.startSpan("setSchemaAuthorization", source);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.setSchemaAuthorization(session, source, principal);
        }
    }

    @Override
    public void createTable(Session session, String catalogName, ConnectorTableMetadata tableMetadata, boolean ignoreExisting) {
        Span span = this.startSpan("createTable", catalogName, tableMetadata);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.createTable(session, catalogName, tableMetadata, ignoreExisting);
        }
    }

    @Override
    public void renameTable(Session session, TableHandle tableHandle, CatalogSchemaTableName currentTableName, QualifiedObjectName newTableName) {
        Span span = this.startSpan("renameTable", currentTableName);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.renameTable(session, tableHandle, currentTableName, newTableName);
        }
    }

    @Override
    public void setTableProperties(Session session, TableHandle tableHandle, Map<String, Optional<Object>> properties) {
        Span span = this.startSpan("setTableProperties", tableHandle);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.setTableProperties(session, tableHandle, properties);
        }
    }

    @Override
    public void setTableComment(Session session, TableHandle tableHandle, Optional<String> comment) {
        Span span = this.startSpan("setTableComment", tableHandle);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.setTableComment(session, tableHandle, comment);
        }
    }

    @Override
    public void setViewComment(Session session, QualifiedObjectName viewName, Optional<String> comment) {
        Span span = this.startSpan("setViewComment", viewName);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.setViewComment(session, viewName, comment);
        }
    }

    @Override
    public void setViewColumnComment(Session session, QualifiedObjectName viewName, String columnName, Optional<String> comment) {
        Span span = this.startSpan("setViewColumnComment", viewName);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.setViewColumnComment(session, viewName, columnName, comment);
        }
    }

    @Override
    public void setMaterializedViewColumnComment(Session session, QualifiedObjectName viewName, String columnName, Optional<String> comment) {
        Span span = this.startSpan("setMaterializedViewColumnComment", viewName);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.setMaterializedViewColumnComment(session, viewName, columnName, comment);
        }
    }

    @Override
    public void setColumnComment(Session session, TableHandle tableHandle, ColumnHandle column, Optional<String> comment) {
        Span span = this.startSpan("setColumnComment", tableHandle);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.setColumnComment(session, tableHandle, column, comment);
        }
    }

    @Override
    public void renameColumn(Session session, TableHandle tableHandle, CatalogSchemaTableName table, ColumnHandle source, String target) {
        Span span = this.startSpan("renameColumn", table);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.renameColumn(session, tableHandle, table, source, target);
        }
    }

    @Override
    public void renameField(Session session, TableHandle tableHandle, List<String> fieldPath, String target) {
        Span span = this.startSpan("renameField", tableHandle);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.renameField(session, tableHandle, fieldPath, target);
        }
    }

    @Override
    public void addColumn(Session session, TableHandle tableHandle, CatalogSchemaTableName table, ColumnMetadata column) {
        Span span = this.startSpan("addColumn", table);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.addColumn(session, tableHandle, table, column);
        }
    }

    @Override
    public void addField(Session session, TableHandle tableHandle, List<String> parentPath, String fieldName, Type type, boolean ignoreExisting) {
        Span span = this.startSpan("addField", tableHandle);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.addField(session, tableHandle, parentPath, fieldName, type, ignoreExisting);
        }
    }

    @Override
    public void setColumnType(Session session, TableHandle tableHandle, ColumnHandle column, Type type) {
        Span span = this.startSpan("setColumnType", tableHandle);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.setColumnType(session, tableHandle, column, type);
        }
    }

    @Override
    public void setFieldType(Session session, TableHandle tableHandle, List<String> fieldPath, Type type) {
        Span span = this.startSpan("setFieldType", tableHandle);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.setFieldType(session, tableHandle, fieldPath, type);
        }
    }

    @Override
    public void setTableAuthorization(Session session, CatalogSchemaTableName table, TrinoPrincipal principal) {
        Span span = this.startSpan("setTableAuthorization", table);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.setTableAuthorization(session, table, principal);
        }
    }

    @Override
    public void dropColumn(Session session, TableHandle tableHandle, CatalogSchemaTableName table, ColumnHandle column) {
        Span span = this.startSpan("dropColumn", table);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.dropColumn(session, tableHandle, table, column);
        }
    }

    @Override
    public void dropField(Session session, TableHandle tableHandle, ColumnHandle column, List<String> fieldPath) {
        Span span = this.startSpan("dropField", tableHandle);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.dropField(session, tableHandle, column, fieldPath);
        }
    }

    @Override
    public void dropTable(Session session, TableHandle tableHandle, CatalogSchemaTableName tableName) {
        Span span = this.startSpan("dropTable", tableName);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.dropTable(session, tableHandle, tableName);
        }
    }

    @Override
    public void truncateTable(Session session, TableHandle tableHandle) {
        Span span = this.startSpan("truncateTable", tableHandle);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.truncateTable(session, tableHandle);
        }
    }

    @Override
    public Optional<TableLayout> getNewTableLayout(Session session, String catalogName, ConnectorTableMetadata tableMetadata) {
        Span span = this.startSpan("getNewTableLayout", catalogName, tableMetadata);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            Optional<TableLayout> optional = this.delegate.getNewTableLayout(session, catalogName, tableMetadata);
            return optional;
        }
    }

    @Override
    public OutputTableHandle beginCreateTable(Session session, String catalogName, ConnectorTableMetadata tableMetadata, Optional<TableLayout> layout) {
        Span span = this.startSpan("beginCreateTable", catalogName, tableMetadata);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            OutputTableHandle outputTableHandle = this.delegate.beginCreateTable(session, catalogName, tableMetadata, layout);
            return outputTableHandle;
        }
    }

    @Override
    public Optional<ConnectorOutputMetadata> finishCreateTable(Session session, OutputTableHandle tableHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        Span span = this.startSpan("finishCreateTable", tableHandle.getCatalogHandle().getCatalogName());
        if (span.isRecording()) {
            span.setAttribute(TrinoAttributes.TABLE, (Object)tableHandle.getConnectorHandle().toString());
        }
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            Optional<ConnectorOutputMetadata> optional = this.delegate.finishCreateTable(session, tableHandle, fragments, computedStatistics);
            return optional;
        }
    }

    @Override
    public Optional<TableLayout> getInsertLayout(Session session, TableHandle target) {
        Span span = this.startSpan("getInsertLayout", target);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            Optional<TableLayout> optional = this.delegate.getInsertLayout(session, target);
            return optional;
        }
    }

    @Override
    public TableStatisticsMetadata getStatisticsCollectionMetadataForWrite(Session session, CatalogHandle catalogHandle, ConnectorTableMetadata tableMetadata) {
        Span span = this.startSpan("getStatisticsCollectionMetadataForWrite", catalogHandle.getCatalogName(), tableMetadata);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            TableStatisticsMetadata tableStatisticsMetadata = this.delegate.getStatisticsCollectionMetadataForWrite(session, catalogHandle, tableMetadata);
            return tableStatisticsMetadata;
        }
    }

    @Override
    public AnalyzeMetadata getStatisticsCollectionMetadata(Session session, TableHandle tableHandle, Map<String, Object> analyzeProperties) {
        Span span = this.startSpan("getStatisticsCollectionMetadata", tableHandle);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            AnalyzeMetadata analyzeMetadata = this.delegate.getStatisticsCollectionMetadata(session, tableHandle, analyzeProperties);
            return analyzeMetadata;
        }
    }

    @Override
    public AnalyzeTableHandle beginStatisticsCollection(Session session, TableHandle tableHandle) {
        Span span = this.startSpan("beginStatisticsCollection", tableHandle);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            AnalyzeTableHandle analyzeTableHandle = this.delegate.beginStatisticsCollection(session, tableHandle);
            return analyzeTableHandle;
        }
    }

    @Override
    public void finishStatisticsCollection(Session session, AnalyzeTableHandle tableHandle, Collection<ComputedStatistics> computedStatistics) {
        Span span = this.startSpan("finishStatisticsCollection", tableHandle.getCatalogHandle().getCatalogName());
        if (span.isRecording()) {
            span.setAttribute(TrinoAttributes.TABLE, (Object)tableHandle.getConnectorHandle().toString());
        }
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.finishStatisticsCollection(session, tableHandle, computedStatistics);
        }
    }

    @Override
    public void cleanupQuery(Session session) {
        Span span = this.startSpan("cleanupQuery");
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.cleanupQuery(session);
        }
    }

    @Override
    public InsertTableHandle beginInsert(Session session, TableHandle tableHandle, List<ColumnHandle> columns) {
        Span span = this.startSpan("beginInsert", tableHandle);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            InsertTableHandle insertTableHandle = this.delegate.beginInsert(session, tableHandle, columns);
            return insertTableHandle;
        }
    }

    @Override
    public boolean supportsMissingColumnsOnInsert(Session session, TableHandle tableHandle) {
        Span span = this.startSpan("supportsMissingColumnsOnInsert", tableHandle);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            boolean bl = this.delegate.supportsMissingColumnsOnInsert(session, tableHandle);
            return bl;
        }
    }

    @Override
    public Optional<ConnectorOutputMetadata> finishInsert(Session session, InsertTableHandle tableHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        Span span = this.startSpan("finishInsert", tableHandle.getCatalogHandle().getCatalogName());
        if (span.isRecording()) {
            span.setAttribute(TrinoAttributes.TABLE, (Object)tableHandle.getConnectorHandle().toString());
        }
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            Optional<ConnectorOutputMetadata> optional = this.delegate.finishInsert(session, tableHandle, fragments, computedStatistics);
            return optional;
        }
    }

    @Override
    public boolean delegateMaterializedViewRefreshToConnector(Session session, QualifiedObjectName viewName) {
        Span span = this.startSpan("delegateMaterializedViewRefreshToConnector", viewName);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            boolean bl = this.delegate.delegateMaterializedViewRefreshToConnector(session, viewName);
            return bl;
        }
    }

    @Override
    public ListenableFuture<Void> refreshMaterializedView(Session session, QualifiedObjectName viewName) {
        Span span = this.startSpan("refreshMaterializedView", viewName);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            ListenableFuture<Void> listenableFuture = this.delegate.refreshMaterializedView(session, viewName);
            return listenableFuture;
        }
    }

    @Override
    public InsertTableHandle beginRefreshMaterializedView(Session session, TableHandle tableHandle, List<TableHandle> sourceTableHandles) {
        Span span = this.startSpan("beginRefreshMaterializedView", tableHandle);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            InsertTableHandle insertTableHandle = this.delegate.beginRefreshMaterializedView(session, tableHandle, sourceTableHandles);
            return insertTableHandle;
        }
    }

    @Override
    public Optional<ConnectorOutputMetadata> finishRefreshMaterializedView(Session session, TableHandle tableHandle, InsertTableHandle insertTableHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics, List<TableHandle> sourceTableHandles) {
        Span span = this.startSpan("finishRefreshMaterializedView", tableHandle);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            Optional<ConnectorOutputMetadata> optional = this.delegate.finishRefreshMaterializedView(session, tableHandle, insertTableHandle, fragments, computedStatistics, sourceTableHandles);
            return optional;
        }
    }

    @Override
    public Optional<TableHandle> applyDelete(Session session, TableHandle tableHandle) {
        Span span = this.startSpan("applyDelete", tableHandle);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            Optional<TableHandle> optional = this.delegate.applyDelete(session, tableHandle);
            return optional;
        }
    }

    @Override
    public OptionalLong executeDelete(Session session, TableHandle tableHandle) {
        Span span = this.startSpan("executeDelete", tableHandle);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            OptionalLong optionalLong = this.delegate.executeDelete(session, tableHandle);
            return optionalLong;
        }
    }

    @Override
    public RowChangeParadigm getRowChangeParadigm(Session session, TableHandle tableHandle) {
        Span span = this.startSpan("getRowChangeParadigm", tableHandle);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            RowChangeParadigm rowChangeParadigm = this.delegate.getRowChangeParadigm(session, tableHandle);
            return rowChangeParadigm;
        }
    }

    @Override
    public ColumnHandle getMergeRowIdColumnHandle(Session session, TableHandle tableHandle) {
        Span span = this.startSpan("getMergeRowIdColumnHandle", tableHandle);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            ColumnHandle columnHandle = this.delegate.getMergeRowIdColumnHandle(session, tableHandle);
            return columnHandle;
        }
    }

    @Override
    public Optional<PartitioningHandle> getUpdateLayout(Session session, TableHandle tableHandle) {
        Span span = this.startSpan("getUpdateLayout", tableHandle);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            Optional<PartitioningHandle> optional = this.delegate.getUpdateLayout(session, tableHandle);
            return optional;
        }
    }

    @Override
    public MergeHandle beginMerge(Session session, TableHandle tableHandle) {
        Span span = this.startSpan("beginMerge", tableHandle);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            MergeHandle mergeHandle = this.delegate.beginMerge(session, tableHandle);
            return mergeHandle;
        }
    }

    @Override
    public void finishMerge(Session session, MergeHandle tableHandle, Collection<Slice> fragments, Collection<ComputedStatistics> computedStatistics) {
        Span span = this.startSpan("finishMerge", tableHandle.getTableHandle().getCatalogHandle().getCatalogName());
        if (span.isRecording()) {
            span.setAttribute(TrinoAttributes.TABLE, (Object)tableHandle.getTableHandle().getConnectorHandle().toString());
        }
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.finishMerge(session, tableHandle, fragments, computedStatistics);
        }
    }

    @Override
    public Optional<CatalogHandle> getCatalogHandle(Session session, String catalogName) {
        Span span = this.startSpan("getCatalogHandle", catalogName);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            Optional<CatalogHandle> optional = this.delegate.getCatalogHandle(session, catalogName);
            return optional;
        }
    }

    @Override
    public List<CatalogInfo> listCatalogs(Session session) {
        Span span = this.startSpan("listCatalogs");
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            List<CatalogInfo> list = this.delegate.listCatalogs(session);
            return list;
        }
    }

    @Override
    public List<QualifiedObjectName> listViews(Session session, QualifiedTablePrefix prefix) {
        Span span = this.startSpan("listViews", prefix);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            List<QualifiedObjectName> list = this.delegate.listViews(session, prefix);
            return list;
        }
    }

    @Override
    public Map<QualifiedObjectName, ViewInfo> getViews(Session session, QualifiedTablePrefix prefix) {
        Span span = this.startSpan("getViews", prefix);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            Map<QualifiedObjectName, ViewInfo> map = this.delegate.getViews(session, prefix);
            return map;
        }
    }

    @Override
    public boolean isView(Session session, QualifiedObjectName viewName) {
        Span span = this.startSpan("isView", viewName);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            boolean bl = this.delegate.isView(session, viewName);
            return bl;
        }
    }

    @Override
    public Optional<ViewDefinition> getView(Session session, QualifiedObjectName viewName) {
        Span span = this.startSpan("getView", viewName);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            Optional<ViewDefinition> optional = this.delegate.getView(session, viewName);
            return optional;
        }
    }

    @Override
    public Map<String, Object> getSchemaProperties(Session session, CatalogSchemaName schemaName) {
        Span span = this.startSpan("getSchemaProperties", schemaName);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            Map<String, Object> map = this.delegate.getSchemaProperties(session, schemaName);
            return map;
        }
    }

    @Override
    public Optional<TrinoPrincipal> getSchemaOwner(Session session, CatalogSchemaName schemaName) {
        Span span = this.startSpan("getSchemaOwner", schemaName);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            Optional<TrinoPrincipal> optional = this.delegate.getSchemaOwner(session, schemaName);
            return optional;
        }
    }

    @Override
    public void createView(Session session, QualifiedObjectName viewName, ViewDefinition definition, boolean replace) {
        Span span = this.startSpan("createView", viewName);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.createView(session, viewName, definition, replace);
        }
    }

    @Override
    public void renameView(Session session, QualifiedObjectName existingViewName, QualifiedObjectName newViewName) {
        Span span = this.startSpan("renameView", existingViewName);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.renameView(session, existingViewName, newViewName);
        }
    }

    @Override
    public void setViewAuthorization(Session session, CatalogSchemaTableName view, TrinoPrincipal principal) {
        Span span = this.startSpan("setViewAuthorization", view);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.setViewAuthorization(session, view, principal);
        }
    }

    @Override
    public void dropView(Session session, QualifiedObjectName viewName) {
        Span span = this.startSpan("dropView", viewName);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.dropView(session, viewName);
        }
    }

    @Override
    public Optional<ResolvedIndex> resolveIndex(Session session, TableHandle tableHandle, Set<ColumnHandle> indexableColumns, Set<ColumnHandle> outputColumns, TupleDomain<ColumnHandle> tupleDomain) {
        Span span = this.startSpan("resolveIndex", tableHandle);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            Optional<ResolvedIndex> optional = this.delegate.resolveIndex(session, tableHandle, indexableColumns, outputColumns, tupleDomain);
            return optional;
        }
    }

    @Override
    public Optional<LimitApplicationResult<TableHandle>> applyLimit(Session session, TableHandle table, long limit) {
        Span span = this.startSpan("applyLimit", table);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            Optional<LimitApplicationResult<TableHandle>> optional = this.delegate.applyLimit(session, table, limit);
            return optional;
        }
    }

    @Override
    public Optional<ConstraintApplicationResult<TableHandle>> applyFilter(Session session, TableHandle table, Constraint constraint) {
        Span span = this.startSpan("applyFilter", table);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            Optional<ConstraintApplicationResult<TableHandle>> optional = this.delegate.applyFilter(session, table, constraint);
            return optional;
        }
    }

    @Override
    public Optional<ProjectionApplicationResult<TableHandle>> applyProjection(Session session, TableHandle table, List<ConnectorExpression> projections, Map<String, ColumnHandle> assignments) {
        Span span = this.startSpan("applyProjection", table);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            Optional<ProjectionApplicationResult<TableHandle>> optional = this.delegate.applyProjection(session, table, projections, assignments);
            return optional;
        }
    }

    @Override
    public Optional<SampleApplicationResult<TableHandle>> applySample(Session session, TableHandle table, SampleType sampleType, double sampleRatio) {
        Span span = this.startSpan("applySample", table);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            Optional<SampleApplicationResult<TableHandle>> optional = this.delegate.applySample(session, table, sampleType, sampleRatio);
            return optional;
        }
    }

    @Override
    public Optional<AggregationApplicationResult<TableHandle>> applyAggregation(Session session, TableHandle table, List<AggregateFunction> aggregations, Map<String, ColumnHandle> assignments, List<List<ColumnHandle>> groupingSets) {
        Span span = this.startSpan("applyAggregation", table);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            Optional<AggregationApplicationResult<TableHandle>> optional = this.delegate.applyAggregation(session, table, aggregations, assignments, groupingSets);
            return optional;
        }
    }

    @Override
    public Optional<JoinApplicationResult<TableHandle>> applyJoin(Session session, JoinType joinType, TableHandle left, TableHandle right, ConnectorExpression joinCondition, Map<String, ColumnHandle> leftAssignments, Map<String, ColumnHandle> rightAssignments, JoinStatistics statistics) {
        Span span = this.startSpan("applyJoin");
        if (span.isRecording() && left.getCatalogHandle().equals((Object)right.getCatalogHandle())) {
            span.setAttribute(TrinoAttributes.CATALOG, (Object)left.getCatalogHandle().getCatalogName());
        }
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            Optional<JoinApplicationResult<TableHandle>> optional = this.delegate.applyJoin(session, joinType, left, right, joinCondition, leftAssignments, rightAssignments, statistics);
            return optional;
        }
    }

    @Override
    public Optional<TopNApplicationResult<TableHandle>> applyTopN(Session session, TableHandle handle, long topNCount, List<SortItem> sortItems, Map<String, ColumnHandle> assignments) {
        Span span = this.startSpan("applyTopN", handle);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            Optional<TopNApplicationResult<TableHandle>> optional = this.delegate.applyTopN(session, handle, topNCount, sortItems, assignments);
            return optional;
        }
    }

    @Override
    public Optional<TableFunctionApplicationResult<TableHandle>> applyTableFunction(Session session, TableFunctionHandle handle) {
        Span span = this.startSpan("applyTableFunction").setAttribute(TrinoAttributes.CATALOG, (Object)handle.getCatalogHandle().getCatalogName()).setAttribute(TrinoAttributes.HANDLE, (Object)handle.getFunctionHandle().toString());
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            Optional<TableFunctionApplicationResult<TableHandle>> optional = this.delegate.applyTableFunction(session, handle);
            return optional;
        }
    }

    @Override
    public void validateScan(Session session, TableHandle table) {
        Span span = this.startSpan("validateScan", table);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.validateScan(session, table);
        }
    }

    @Override
    public boolean isCatalogManagedSecurity(Session session, String catalog) {
        Span span = this.startSpan("isCatalogManagedSecurity", catalog);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            boolean bl = this.delegate.isCatalogManagedSecurity(session, catalog);
            return bl;
        }
    }

    @Override
    public boolean roleExists(Session session, String role, Optional<String> catalog) {
        Span span = this.getStartSpan("roleExists", catalog);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            boolean bl = this.delegate.roleExists(session, role, catalog);
            return bl;
        }
    }

    @Override
    public void createRole(Session session, String role, Optional<TrinoPrincipal> grantor, Optional<String> catalog) {
        Span span = this.getStartSpan("createRole", catalog);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.createRole(session, role, grantor, catalog);
        }
    }

    @Override
    public void dropRole(Session session, String role, Optional<String> catalog) {
        Span span = this.getStartSpan("dropRole", catalog);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.dropRole(session, role, catalog);
        }
    }

    @Override
    public Set<String> listRoles(Session session, Optional<String> catalog) {
        Span span = this.getStartSpan("listRoles", catalog);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            Set<String> set = this.delegate.listRoles(session, catalog);
            return set;
        }
    }

    @Override
    public Set<RoleGrant> listRoleGrants(Session session, Optional<String> catalog, TrinoPrincipal principal) {
        Span span = this.getStartSpan("listRoleGrants", catalog);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            Set<RoleGrant> set = this.delegate.listRoleGrants(session, catalog, principal);
            return set;
        }
    }

    @Override
    public void grantRoles(Session session, Set<String> roles, Set<TrinoPrincipal> grantees, boolean adminOption, Optional<TrinoPrincipal> grantor, Optional<String> catalog) {
        Span span = this.getStartSpan("grantRoles", catalog);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.grantRoles(session, roles, grantees, adminOption, grantor, catalog);
        }
    }

    @Override
    public void revokeRoles(Session session, Set<String> roles, Set<TrinoPrincipal> grantees, boolean adminOption, Optional<TrinoPrincipal> grantor, Optional<String> catalog) {
        Span span = this.getStartSpan("revokeRoles", catalog);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.revokeRoles(session, roles, grantees, adminOption, grantor, catalog);
        }
    }

    @Override
    public Set<RoleGrant> listApplicableRoles(Session session, TrinoPrincipal principal, Optional<String> catalog) {
        Span span = this.getStartSpan("listApplicableRoles", catalog);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            Set<RoleGrant> set = this.delegate.listApplicableRoles(session, principal, catalog);
            return set;
        }
    }

    @Override
    public Set<String> listEnabledRoles(Identity identity) {
        Span span = this.startSpan("listEnabledRoles");
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            Set<String> set = this.delegate.listEnabledRoles(identity);
            return set;
        }
    }

    @Override
    public Set<String> listEnabledRoles(Session session, String catalog) {
        Span span = this.startSpan("listEnabledRoles", catalog);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            Set<String> set = this.delegate.listEnabledRoles(session, catalog);
            return set;
        }
    }

    @Override
    public void grantSchemaPrivileges(Session session, CatalogSchemaName schemaName, Set<Privilege> privileges, TrinoPrincipal grantee, boolean grantOption) {
        Span span = this.startSpan("grantSchemaPrivileges", schemaName);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.grantSchemaPrivileges(session, schemaName, privileges, grantee, grantOption);
        }
    }

    @Override
    public void denySchemaPrivileges(Session session, CatalogSchemaName schemaName, Set<Privilege> privileges, TrinoPrincipal grantee) {
        Span span = this.startSpan("denySchemaPrivileges", schemaName);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.denySchemaPrivileges(session, schemaName, privileges, grantee);
        }
    }

    @Override
    public void revokeSchemaPrivileges(Session session, CatalogSchemaName schemaName, Set<Privilege> privileges, TrinoPrincipal grantee, boolean grantOption) {
        Span span = this.startSpan("revokeSchemaPrivileges", schemaName);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.revokeSchemaPrivileges(session, schemaName, privileges, grantee, grantOption);
        }
    }

    @Override
    public void grantTablePrivileges(Session session, QualifiedObjectName tableName, Set<Privilege> privileges, TrinoPrincipal grantee, boolean grantOption) {
        Span span = this.startSpan("grantTablePrivileges", tableName);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.grantTablePrivileges(session, tableName, privileges, grantee, grantOption);
        }
    }

    @Override
    public void denyTablePrivileges(Session session, QualifiedObjectName tableName, Set<Privilege> privileges, TrinoPrincipal grantee) {
        Span span = this.startSpan("denyTablePrivileges", tableName);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.denyTablePrivileges(session, tableName, privileges, grantee);
        }
    }

    @Override
    public void revokeTablePrivileges(Session session, QualifiedObjectName tableName, Set<Privilege> privileges, TrinoPrincipal grantee, boolean grantOption) {
        Span span = this.startSpan("revokeTablePrivileges", tableName);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.revokeTablePrivileges(session, tableName, privileges, grantee, grantOption);
        }
    }

    @Override
    public List<GrantInfo> listTablePrivileges(Session session, QualifiedTablePrefix prefix) {
        Span span = this.startSpan("listTablePrivileges", prefix);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            List<GrantInfo> list = this.delegate.listTablePrivileges(session, prefix);
            return list;
        }
    }

    @Override
    public Collection<FunctionMetadata> listFunctions(Session session) {
        Span span = this.startSpan("listFunctions");
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            Collection<FunctionMetadata> collection = this.delegate.listFunctions(session);
            return collection;
        }
    }

    @Override
    public ResolvedFunction decodeFunction(QualifiedName name) {
        return this.delegate.decodeFunction(name);
    }

    @Override
    public ResolvedFunction resolveFunction(Session session, QualifiedName name, List<TypeSignatureProvider> parameterTypes) {
        Span span = this.startSpan("resolveFunction").setAllAttributes(Tracing.attribute(TrinoAttributes.FUNCTION, TracingMetadata.extractFunctionName(name)));
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            ResolvedFunction resolvedFunction = this.delegate.resolveFunction(session, name, parameterTypes);
            return resolvedFunction;
        }
    }

    @Override
    public ResolvedFunction resolveOperator(Session session, OperatorType operatorType, List<? extends Type> argumentTypes) throws OperatorNotFoundException {
        return this.delegate.resolveOperator(session, operatorType, argumentTypes);
    }

    @Override
    public ResolvedFunction getCoercion(Session session, Type fromType, Type toType) {
        return this.delegate.getCoercion(session, fromType, toType);
    }

    @Override
    public ResolvedFunction getCoercion(Session session, OperatorType operatorType, Type fromType, Type toType) {
        return this.delegate.getCoercion(session, operatorType, fromType, toType);
    }

    @Override
    public ResolvedFunction getCoercion(Session session, QualifiedName name, Type fromType, Type toType) {
        return this.delegate.getCoercion(session, name, fromType, toType);
    }

    @Override
    public boolean isAggregationFunction(Session session, QualifiedName name) {
        Span span = this.startSpan("isAggregationFunction").setAllAttributes(Tracing.attribute(TrinoAttributes.FUNCTION, TracingMetadata.extractFunctionName(name)));
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            boolean bl = this.delegate.isAggregationFunction(session, name);
            return bl;
        }
    }

    @Override
    public boolean isWindowFunction(Session session, QualifiedName name) {
        Span span = this.startSpan("isWindowFunction").setAllAttributes(Tracing.attribute(TrinoAttributes.FUNCTION, TracingMetadata.extractFunctionName(name)));
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            boolean bl = this.delegate.isWindowFunction(session, name);
            return bl;
        }
    }

    @Override
    public FunctionMetadata getFunctionMetadata(Session session, ResolvedFunction resolvedFunction) {
        Span span = this.startSpan("getFunctionMetadata").setAttribute(TrinoAttributes.CATALOG, (Object)resolvedFunction.getCatalogHandle().getCatalogName()).setAttribute(TrinoAttributes.FUNCTION, (Object)resolvedFunction.getSignature().getName());
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            FunctionMetadata functionMetadata = this.delegate.getFunctionMetadata(session, resolvedFunction);
            return functionMetadata;
        }
    }

    @Override
    public AggregationFunctionMetadata getAggregationFunctionMetadata(Session session, ResolvedFunction resolvedFunction) {
        Span span = this.startSpan("getAggregationFunctionMetadata").setAttribute(TrinoAttributes.CATALOG, (Object)resolvedFunction.getCatalogHandle().getCatalogName()).setAttribute(TrinoAttributes.FUNCTION, (Object)resolvedFunction.getSignature().getName());
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            AggregationFunctionMetadata aggregationFunctionMetadata = this.delegate.getAggregationFunctionMetadata(session, resolvedFunction);
            return aggregationFunctionMetadata;
        }
    }

    @Override
    public void createMaterializedView(Session session, QualifiedObjectName viewName, MaterializedViewDefinition definition, boolean replace, boolean ignoreExisting) {
        Span span = this.startSpan("createMaterializedView", viewName);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.createMaterializedView(session, viewName, definition, replace, ignoreExisting);
        }
    }

    @Override
    public void dropMaterializedView(Session session, QualifiedObjectName viewName) {
        Span span = this.startSpan("dropMaterializedView", viewName);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.dropMaterializedView(session, viewName);
        }
    }

    @Override
    public List<QualifiedObjectName> listMaterializedViews(Session session, QualifiedTablePrefix prefix) {
        Span span = this.startSpan("listMaterializedViews", prefix);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            List<QualifiedObjectName> list = this.delegate.listMaterializedViews(session, prefix);
            return list;
        }
    }

    @Override
    public Map<QualifiedObjectName, ViewInfo> getMaterializedViews(Session session, QualifiedTablePrefix prefix) {
        Span span = this.startSpan("getMaterializedViews", prefix);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            Map<QualifiedObjectName, ViewInfo> map = this.delegate.getMaterializedViews(session, prefix);
            return map;
        }
    }

    @Override
    public boolean isMaterializedView(Session session, QualifiedObjectName viewName) {
        Span span = this.startSpan("isMaterializedView", viewName);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            boolean bl = this.delegate.isMaterializedView(session, viewName);
            return bl;
        }
    }

    @Override
    public Optional<MaterializedViewDefinition> getMaterializedView(Session session, QualifiedObjectName viewName) {
        Span span = this.startSpan("getMaterializedView", viewName);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            Optional<MaterializedViewDefinition> optional = this.delegate.getMaterializedView(session, viewName);
            return optional;
        }
    }

    @Override
    public MaterializedViewFreshness getMaterializedViewFreshness(Session session, QualifiedObjectName name) {
        Span span = this.startSpan("getMaterializedViewFreshness", name);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            MaterializedViewFreshness materializedViewFreshness = this.delegate.getMaterializedViewFreshness(session, name);
            return materializedViewFreshness;
        }
    }

    @Override
    public void renameMaterializedView(Session session, QualifiedObjectName existingViewName, QualifiedObjectName newViewName) {
        Span span = this.startSpan("renameMaterializedView", existingViewName);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.renameMaterializedView(session, existingViewName, newViewName);
        }
    }

    @Override
    public void setMaterializedViewProperties(Session session, QualifiedObjectName viewName, Map<String, Optional<Object>> properties) {
        Span span = this.startSpan("setMaterializedViewProperties", viewName);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            this.delegate.setMaterializedViewProperties(session, viewName, properties);
        }
    }

    @Override
    public Optional<TableScanRedirectApplicationResult> applyTableScanRedirect(Session session, TableHandle tableHandle) {
        Span span = this.startSpan("applyTableScanRedirect", tableHandle);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            Optional<TableScanRedirectApplicationResult> optional = this.delegate.applyTableScanRedirect(session, tableHandle);
            return optional;
        }
    }

    @Override
    public RedirectionAwareTableHandle getRedirectionAwareTableHandle(Session session, QualifiedObjectName tableName) {
        Span span = this.startSpan("getRedirectionAwareTableHandle", tableName);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            RedirectionAwareTableHandle redirectionAwareTableHandle = this.delegate.getRedirectionAwareTableHandle(session, tableName);
            return redirectionAwareTableHandle;
        }
    }

    @Override
    public RedirectionAwareTableHandle getRedirectionAwareTableHandle(Session session, QualifiedObjectName tableName, Optional<TableVersion> startVersion, Optional<TableVersion> endVersion) {
        Span span = this.startSpan("getRedirectionAwareTableHandle", tableName);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            RedirectionAwareTableHandle redirectionAwareTableHandle = this.delegate.getRedirectionAwareTableHandle(session, tableName, startVersion, endVersion);
            return redirectionAwareTableHandle;
        }
    }

    @Override
    public Optional<TableHandle> getTableHandle(Session session, QualifiedObjectName tableName, Optional<TableVersion> startVersion, Optional<TableVersion> endVersion) {
        Span span = this.startSpan("getTableHandle", tableName);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            Optional<TableHandle> optional = this.delegate.getTableHandle(session, tableName, startVersion, endVersion);
            return optional;
        }
    }

    @Override
    public OptionalInt getMaxWriterTasks(Session session, String catalogName) {
        Span span = this.startSpan("getMaxWriterTasks", catalogName);
        try (ScopedSpan ignored = ScopedSpan.scopedSpan(span);){
            OptionalInt optionalInt = this.delegate.getMaxWriterTasks(session, catalogName);
            return optionalInt;
        }
    }

    private Span startSpan(String methodName) {
        return this.tracer.spanBuilder("Metadata." + methodName).startSpan();
    }

    private Span startSpan(String methodName, String catalogName) {
        return this.startSpan(methodName).setAttribute(TrinoAttributes.CATALOG, (Object)catalogName);
    }

    private Span getStartSpan(String methodName, Optional<String> catalog) {
        return this.startSpan(methodName).setAllAttributes(Tracing.attribute(TrinoAttributes.CATALOG, catalog));
    }

    private Span startSpan(String methodName, CatalogSchemaName schema) {
        return this.startSpan(methodName).setAttribute(TrinoAttributes.CATALOG, (Object)schema.getCatalogName()).setAttribute(TrinoAttributes.SCHEMA, (Object)schema.getSchemaName());
    }

    private Span startSpan(String methodName, QualifiedObjectName table) {
        return this.startSpan(methodName).setAttribute(TrinoAttributes.CATALOG, (Object)table.getCatalogName()).setAttribute(TrinoAttributes.SCHEMA, (Object)table.getSchemaName()).setAttribute(TrinoAttributes.TABLE, (Object)table.getObjectName());
    }

    private Span startSpan(String methodName, CatalogSchemaTableName table) {
        return this.startSpan(methodName).setAttribute(TrinoAttributes.CATALOG, (Object)table.getCatalogName()).setAttribute(TrinoAttributes.SCHEMA, (Object)table.getSchemaTableName().getSchemaName()).setAttribute(TrinoAttributes.TABLE, (Object)table.getSchemaTableName().getTableName());
    }

    private Span startSpan(String methodName, QualifiedTablePrefix prefix) {
        return this.startSpan(methodName).setAttribute(TrinoAttributes.CATALOG, (Object)prefix.getCatalogName()).setAllAttributes(Tracing.attribute(TrinoAttributes.SCHEMA, prefix.getSchemaName())).setAllAttributes(Tracing.attribute(TrinoAttributes.TABLE, prefix.getTableName()));
    }

    private Span startSpan(String methodName, String catalogName, ConnectorTableMetadata tableMetadata) {
        return this.startSpan(methodName).setAttribute(TrinoAttributes.CATALOG, (Object)catalogName).setAttribute(TrinoAttributes.SCHEMA, (Object)tableMetadata.getTable().getSchemaName()).setAttribute(TrinoAttributes.TABLE, (Object)tableMetadata.getTable().getTableName());
    }

    private Span startSpan(String methodName, TableHandle handle) {
        Span span = this.startSpan(methodName);
        if (span.isRecording()) {
            span.setAttribute(TrinoAttributes.CATALOG, (Object)handle.getCatalogHandle().getCatalogName());
            span.setAttribute(TrinoAttributes.HANDLE, (Object)handle.getConnectorHandle().toString());
        }
        return span;
    }

    private Span startSpan(String methodName, TableExecuteHandle handle) {
        Span span = this.startSpan(methodName);
        if (span.isRecording()) {
            span.setAttribute(TrinoAttributes.CATALOG, (Object)handle.getCatalogHandle().getCatalogName());
            span.setAttribute(TrinoAttributes.HANDLE, (Object)handle.getConnectorHandle().toString());
        }
        return span;
    }

    private static Optional<String> extractFunctionName(QualifiedName name) {
        try {
            return Optional.of(ResolvedFunction.extractFunctionName(name));
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }
}

