/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.VariableWidthBlockBuilder;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.type.AbstractVariableWidthType;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.type.LikePattern;
import java.util.Optional;

public class LikePatternType
extends AbstractVariableWidthType {
    public static final LikePatternType LIKE_PATTERN = new LikePatternType();
    public static final String NAME = "LikePattern";

    private LikePatternType() {
        super(new TypeSignature(NAME, new TypeSignatureParameter[0]), LikePattern.class);
    }

    public Object getObjectValue(ConnectorSession session, Block block, int position) {
        throw new UnsupportedOperationException();
    }

    public void appendTo(Block block, int position, BlockBuilder blockBuilder) {
        throw new UnsupportedOperationException();
    }

    public Object getObject(Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        int offset = 0;
        int length = block.getInt(position, offset);
        String pattern = block.getSlice(position, offset += 4, length).toStringUtf8();
        boolean hasEscape = block.getByte(position, offset += length) != 0;
        ++offset;
        Optional<Character> escape = Optional.empty();
        if (hasEscape) {
            escape = Optional.of(Character.valueOf((char)block.getInt(position, offset)));
        }
        return LikePattern.compile(pattern, escape);
    }

    public void writeObject(BlockBuilder blockBuilder, Object value) {
        LikePattern likePattern = (LikePattern)value;
        ((VariableWidthBlockBuilder)blockBuilder).buildEntry(valueWriter -> {
            Slice pattern = Slices.utf8Slice((String)likePattern.getPattern());
            int length = pattern.length();
            valueWriter.writeInt(length);
            valueWriter.writeBytes(pattern, 0, length);
            if (likePattern.getEscape().isEmpty()) {
                valueWriter.writeByte(0);
            } else {
                valueWriter.writeByte(1);
                valueWriter.writeInt((int)likePattern.getEscape().get().charValue());
            }
        });
    }
}

