/*
 * Decompiled with CFR 0.152.
 */
package io.trino.type;

import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.UncheckedExecutionException;
import io.trino.cache.CacheUtils;
import io.trino.cache.NonKeyEvictableCache;
import io.trino.cache.SafeCaches;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.weakref.jmx.Managed;

public class TypeOperatorsCache
implements BiFunction<Object, Supplier<Object>, Object> {
    private final NonKeyEvictableCache<Object, Object> cache = SafeCaches.buildNonEvictableCacheWithWeakInvalidateAll((CacheBuilder)CacheBuilder.newBuilder().maximumSize(10000L));

    @Override
    public Object apply(Object operatorConvention, Supplier<Object> supplier) {
        try {
            return CacheUtils.uncheckedCacheGet(this.cache, (Object)operatorConvention, supplier);
        }
        catch (UncheckedExecutionException e) {
            Throwables.throwIfUnchecked((Throwable)e.getCause());
            throw new RuntimeException(e.getCause());
        }
    }

    @Managed
    public long cacheSize() {
        return this.cache.size();
    }

    @Managed
    public Double getCacheHitRate() {
        return this.cache.stats().hitRate();
    }

    @Managed
    public Double getCacheMissRate() {
        return this.cache.stats().missRate();
    }

    @Managed
    public long getCacheRequestCount() {
        return this.cache.stats().requestCount();
    }

    @Managed
    public void cacheReset() {
        this.cache.invalidateAll();
    }
}

