/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.base.Preconditions;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.DefunctConfig;
import io.airlift.configuration.LegacyConfig;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.airlift.units.MinDataSize;
import io.airlift.units.MinDuration;
import io.trino.operator.RetryPolicy;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

@DefunctConfig(value={"query.max-pending-splits-per-node", "query.queue-config-file", "experimental.big-query-initial-hash-partitions", "experimental.max-concurrent-big-queries", "experimental.max-queued-big-queries", "query-manager.initialization-required-workers", "query-manager.initialization-timeout", "fault-tolerant-execution-target-task-split-count", "fault-tolerant-execution-target-task-input-size", "query.remote-task.max-consecutive-error-count", "query.remote-task.min-error-duration"})
public class QueryManagerConfig {
    public static final long AVAILABLE_HEAP_MEMORY = Runtime.getRuntime().maxMemory();
    public static final int MAX_TASK_RETRY_ATTEMPTS = 126;
    public static final int FAULT_TOLERANT_EXECUTION_MAX_PARTITION_COUNT_LIMIT = 1000;
    private int scheduleSplitBatchSize = 1000;
    private int minScheduleSplitBatchSize = 100;
    private int maxConcurrentQueries = 1000;
    private int maxQueuedQueries = 5000;
    private boolean determinePartitionCountForWriteEnabled;
    private int maxHashPartitionCount = 100;
    private int minHashPartitionCount = 4;
    private int minHashPartitionCountForWrite = 50;
    private int maxWriterTasksCount = 100;
    private Duration minQueryExpireAge = new Duration(15.0, TimeUnit.MINUTES);
    private int maxQueryHistory = 100;
    private int maxQueryLength = 1000000;
    private int maxStageCount = 150;
    private int stageCountWarningThreshold = 50;
    private Duration clientTimeout = new Duration(5.0, TimeUnit.MINUTES);
    private int queryManagerExecutorPoolSize = 5;
    private int queryExecutorPoolSize = 1000;
    private int maxStateMachineCallbackThreads = 5;
    private Duration remoteTaskMaxErrorDuration = new Duration(5.0, TimeUnit.MINUTES);
    private int remoteTaskMaxCallbackThreads = 1000;
    private String queryExecutionPolicy = "phased";
    private Duration queryMaxRunTime = new Duration(100.0, TimeUnit.DAYS);
    private Duration queryMaxExecutionTime = new Duration(100.0, TimeUnit.DAYS);
    private Duration queryMaxPlanningTime = new Duration(10.0, TimeUnit.MINUTES);
    private Duration queryMaxCpuTime = new Duration(1.0E9, TimeUnit.DAYS);
    private Optional<DataSize> queryMaxScanPhysicalBytes = Optional.empty();
    private int queryReportedRuleStatsLimit = 10;
    private int requiredWorkers = 1;
    private Duration requiredWorkersMaxWait = new Duration(5.0, TimeUnit.MINUTES);
    private RetryPolicy retryPolicy = RetryPolicy.NONE;
    private int queryRetryAttempts = 4;
    private int taskRetryAttemptsPerTask = 4;
    private Duration retryInitialDelay = new Duration(10.0, TimeUnit.SECONDS);
    private Duration retryMaxDelay = new Duration(1.0, TimeUnit.MINUTES);
    private double retryDelayScaleFactor = 2.0;
    private int maxTasksWaitingForExecutionPerQuery = 10;
    private int maxTasksWaitingForNodePerStage = 5;
    private boolean enabledAdaptiveTaskRequestSize = true;
    private DataSize maxRemoteTaskRequestSize = DataSize.of((long)8L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private DataSize remoteTaskRequestSizeHeadroom = DataSize.of((long)2L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private int remoteTaskGuaranteedSplitPerTask = 3;
    private int faultTolerantExecutionArbitraryDistributionComputeTaskTargetSizeGrowthPeriod = 64;
    private double faultTolerantExecutionArbitraryDistributionComputeTaskTargetSizeGrowthFactor = 1.26;
    private DataSize faultTolerantExecutionArbitraryDistributionComputeTaskTargetSizeMin = DataSize.of((long)512L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private DataSize faultTolerantExecutionArbitraryDistributionComputeTaskTargetSizeMax = DataSize.of((long)50L, (DataSize.Unit)DataSize.Unit.GIGABYTE);
    private int faultTolerantExecutionArbitraryDistributionWriteTaskTargetSizeGrowthPeriod = 64;
    private double faultTolerantExecutionArbitraryDistributionWriteTaskTargetSizeGrowthFactor = 1.26;
    private DataSize faultTolerantExecutionArbitraryDistributionWriteTaskTargetSizeMin = DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.GIGABYTE);
    private DataSize faultTolerantExecutionArbitraryDistributionWriteTaskTargetSizeMax = DataSize.of((long)50L, (DataSize.Unit)DataSize.Unit.GIGABYTE);
    private DataSize faultTolerantExecutionHashDistributionComputeTaskTargetSize = DataSize.of((long)512L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private double faultTolerantExecutionHashDistributionComputeTasksToNodesMinRatio = 2.0;
    private DataSize faultTolerantExecutionHashDistributionWriteTaskTargetSize = DataSize.of((long)4L, (DataSize.Unit)DataSize.Unit.GIGABYTE);
    private double faultTolerantExecutionHashDistributionWriteTasksToNodesMinRatio = 2.0;
    private int faultTolerantExecutionHashDistributionWriteTaskTargetMaxCount = 2000;
    private DataSize faultTolerantExecutionStandardSplitSize = DataSize.of((long)64L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private int faultTolerantExecutionMaxTaskSplitCount = 256;
    private DataSize faultTolerantExecutionTaskDescriptorStorageMaxMemory = DataSize.ofBytes((long)Math.round((double)AVAILABLE_HEAP_MEMORY * 0.15));
    private int faultTolerantExecutionMaxPartitionCount = 50;
    private int faultTolerantExecutionMinPartitionCount = 4;
    private int faultTolerantExecutionMinPartitionCountForWrite = 50;
    private boolean faultTolerantExecutionRuntimeAdaptivePartitioningEnabled;
    private int faultTolerantExecutionRuntimeAdaptivePartitioningPartitionCount = 1000;
    private DataSize faultTolerantExecutionRuntimeAdaptivePartitioningMaxTaskSize = DataSize.of((long)12L, (DataSize.Unit)DataSize.Unit.GIGABYTE);
    private boolean faultTolerantExecutionForcePreferredWritePartitioningEnabled = true;
    private double faultTolerantExecutionMinSourceStageProgress = 0.2;
    private boolean faultTolerantExecutionSmallStageEstimationEnabled = true;
    private DataSize faultTolerantExecutionSmallStageEstimationThreshold = DataSize.of((long)20L, (DataSize.Unit)DataSize.Unit.GIGABYTE);
    private double faultTolerantExecutionSmallStageSourceSizeMultiplier = 1.2;
    private boolean faultTolerantExecutionSmallStageRequireNoMorePartitions;

    @Min(value=1L)
    public @Min(value=1L) int getScheduleSplitBatchSize() {
        return this.scheduleSplitBatchSize;
    }

    @Config(value="query.schedule-split-batch-size")
    public QueryManagerConfig setScheduleSplitBatchSize(int scheduleSplitBatchSize) {
        this.scheduleSplitBatchSize = scheduleSplitBatchSize;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMinScheduleSplitBatchSize() {
        return this.minScheduleSplitBatchSize;
    }

    @Config(value="query.min-schedule-split-batch-size")
    public QueryManagerConfig setMinScheduleSplitBatchSize(int minScheduleSplitBatchSize) {
        this.minScheduleSplitBatchSize = minScheduleSplitBatchSize;
        return this;
    }

    @Deprecated
    @Min(value=1L)
    public @Min(value=1L) int getMaxConcurrentQueries() {
        return this.maxConcurrentQueries;
    }

    @Deprecated
    @Config(value="query.max-concurrent-queries")
    public QueryManagerConfig setMaxConcurrentQueries(int maxConcurrentQueries) {
        this.maxConcurrentQueries = maxConcurrentQueries;
        return this;
    }

    @Deprecated
    @Min(value=1L)
    public @Min(value=1L) int getMaxQueuedQueries() {
        return this.maxQueuedQueries;
    }

    @Deprecated
    @Config(value="query.max-queued-queries")
    public QueryManagerConfig setMaxQueuedQueries(int maxQueuedQueries) {
        this.maxQueuedQueries = maxQueuedQueries;
        return this;
    }

    public boolean isDeterminePartitionCountForWriteEnabled() {
        return this.determinePartitionCountForWriteEnabled;
    }

    @Config(value="query.determine-partition-count-for-write-enabled")
    @ConfigDescription(value="Determine the number of partitions based on amount of data read and processed by the query for write queries")
    public QueryManagerConfig setDeterminePartitionCountForWriteEnabled(boolean determinePartitionCountForWriteEnabled) {
        this.determinePartitionCountForWriteEnabled = determinePartitionCountForWriteEnabled;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxHashPartitionCount() {
        return this.maxHashPartitionCount;
    }

    @Config(value="query.max-hash-partition-count")
    @LegacyConfig(value={"query.initial-hash-partitions", "query.hash-partition-count"})
    @ConfigDescription(value="Maximum number of partitions for distributed joins and aggregations")
    public QueryManagerConfig setMaxHashPartitionCount(int maxHashPartitionCount) {
        this.maxHashPartitionCount = maxHashPartitionCount;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMinHashPartitionCount() {
        return this.minHashPartitionCount;
    }

    @Config(value="query.min-hash-partition-count")
    @ConfigDescription(value="Minimum number of partitions for distributed joins and aggregations")
    public QueryManagerConfig setMinHashPartitionCount(int minHashPartitionCount) {
        this.minHashPartitionCount = minHashPartitionCount;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMinHashPartitionCountForWrite() {
        return this.minHashPartitionCountForWrite;
    }

    @Config(value="query.min-hash-partition-count-for-write")
    @ConfigDescription(value="Minimum number of partitions for distributed joins and aggregations in write queries")
    public QueryManagerConfig setMinHashPartitionCountForWrite(int minHashPartitionCountForWrite) {
        this.minHashPartitionCountForWrite = minHashPartitionCountForWrite;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxWriterTasksCount() {
        return this.maxWriterTasksCount;
    }

    @Config(value="query.max-writer-task-count")
    @ConfigDescription(value="Maximum number of tasks that will participate in writing data")
    public QueryManagerConfig setMaxWriterTasksCount(int maxWritersNodesCount) {
        this.maxWriterTasksCount = maxWritersNodesCount;
        return this;
    }

    @NotNull
    public Duration getMinQueryExpireAge() {
        return this.minQueryExpireAge;
    }

    @LegacyConfig(value={"query.max-age"})
    @Config(value="query.min-expire-age")
    public QueryManagerConfig setMinQueryExpireAge(Duration minQueryExpireAge) {
        this.minQueryExpireAge = minQueryExpireAge;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) int getMaxQueryHistory() {
        return this.maxQueryHistory;
    }

    @Config(value="query.max-history")
    public QueryManagerConfig setMaxQueryHistory(int maxQueryHistory) {
        this.maxQueryHistory = maxQueryHistory;
        return this;
    }

    @Min(value=0L)
    @Max(value=1000000000L)
    public @Min(value=0L) @Max(value=1000000000L) int getMaxQueryLength() {
        return this.maxQueryLength;
    }

    @Config(value="query.max-length")
    public QueryManagerConfig setMaxQueryLength(int maxQueryLength) {
        this.maxQueryLength = maxQueryLength;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxStageCount() {
        return this.maxStageCount;
    }

    @Config(value="query.max-stage-count")
    public QueryManagerConfig setMaxStageCount(int maxStageCount) {
        this.maxStageCount = maxStageCount;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getStageCountWarningThreshold() {
        return this.stageCountWarningThreshold;
    }

    @Config(value="query.stage-count-warning-threshold")
    @ConfigDescription(value="Emit a warning when stage count exceeds this threshold")
    public QueryManagerConfig setStageCountWarningThreshold(int stageCountWarningThreshold) {
        this.stageCountWarningThreshold = stageCountWarningThreshold;
        return this;
    }

    @MinDuration(value="5s")
    @NotNull
    public @MinDuration(value="5s") @NotNull Duration getClientTimeout() {
        return this.clientTimeout;
    }

    @Config(value="query.client.timeout")
    public QueryManagerConfig setClientTimeout(Duration clientTimeout) {
        this.clientTimeout = clientTimeout;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getQueryManagerExecutorPoolSize() {
        return this.queryManagerExecutorPoolSize;
    }

    @Config(value="query.manager-executor-pool-size")
    public QueryManagerConfig setQueryManagerExecutorPoolSize(int queryManagerExecutorPoolSize) {
        this.queryManagerExecutorPoolSize = queryManagerExecutorPoolSize;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getQueryExecutorPoolSize() {
        return this.queryExecutorPoolSize;
    }

    @Config(value="query.executor-pool-size")
    public QueryManagerConfig setQueryExecutorPoolSize(int queryExecutorPoolSize) {
        this.queryExecutorPoolSize = queryExecutorPoolSize;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxStateMachineCallbackThreads() {
        return this.maxStateMachineCallbackThreads;
    }

    @Config(value="query.max-state-machine-callback-threads")
    @ConfigDescription(value="The maximum number of threads allowed to run query and stage state machine listener callbacks concurrently for each query")
    public QueryManagerConfig setMaxStateMachineCallbackThreads(int maxStateMachineCallbackThreads) {
        this.maxStateMachineCallbackThreads = maxStateMachineCallbackThreads;
        return this;
    }

    @NotNull
    @MinDuration(value="1s")
    public @NotNull @MinDuration(value="1s") Duration getRemoteTaskMaxErrorDuration() {
        return this.remoteTaskMaxErrorDuration;
    }

    @Config(value="query.remote-task.max-error-duration")
    public QueryManagerConfig setRemoteTaskMaxErrorDuration(Duration remoteTaskMaxErrorDuration) {
        this.remoteTaskMaxErrorDuration = remoteTaskMaxErrorDuration;
        return this;
    }

    @NotNull
    public Duration getQueryMaxRunTime() {
        return this.queryMaxRunTime;
    }

    @Config(value="query.max-run-time")
    public QueryManagerConfig setQueryMaxRunTime(Duration queryMaxRunTime) {
        this.queryMaxRunTime = queryMaxRunTime;
        return this;
    }

    @NotNull
    public Duration getQueryMaxExecutionTime() {
        return this.queryMaxExecutionTime;
    }

    @Config(value="query.max-execution-time")
    public QueryManagerConfig setQueryMaxExecutionTime(Duration queryMaxExecutionTime) {
        this.queryMaxExecutionTime = queryMaxExecutionTime;
        return this;
    }

    @NotNull
    public Duration getQueryMaxPlanningTime() {
        return this.queryMaxPlanningTime;
    }

    @Config(value="query.max-planning-time")
    public QueryManagerConfig setQueryMaxPlanningTime(Duration queryMaxPlanningTime) {
        this.queryMaxPlanningTime = queryMaxPlanningTime;
        return this;
    }

    @NotNull
    @MinDuration(value="1ns")
    public @NotNull @MinDuration(value="1ns") Duration getQueryMaxCpuTime() {
        return this.queryMaxCpuTime;
    }

    @Config(value="query.max-cpu-time")
    public QueryManagerConfig setQueryMaxCpuTime(Duration queryMaxCpuTime) {
        this.queryMaxCpuTime = queryMaxCpuTime;
        return this;
    }

    @NotNull
    public Optional<DataSize> getQueryMaxScanPhysicalBytes() {
        return this.queryMaxScanPhysicalBytes;
    }

    @Config(value="query.max-scan-physical-bytes")
    public QueryManagerConfig setQueryMaxScanPhysicalBytes(DataSize queryMaxScanPhysicalBytes) {
        this.queryMaxScanPhysicalBytes = Optional.ofNullable(queryMaxScanPhysicalBytes);
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getQueryReportedRuleStatsLimit() {
        return this.queryReportedRuleStatsLimit;
    }

    @Config(value="query.reported-rule-stats-limit")
    public QueryManagerConfig setQueryReportedRuleStatsLimit(int queryReportedRuleStatsLimit) {
        this.queryReportedRuleStatsLimit = queryReportedRuleStatsLimit;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getRemoteTaskMaxCallbackThreads() {
        return this.remoteTaskMaxCallbackThreads;
    }

    @Config(value="query.remote-task.max-callback-threads")
    public QueryManagerConfig setRemoteTaskMaxCallbackThreads(int remoteTaskMaxCallbackThreads) {
        this.remoteTaskMaxCallbackThreads = remoteTaskMaxCallbackThreads;
        return this;
    }

    @NotNull
    public String getQueryExecutionPolicy() {
        return this.queryExecutionPolicy;
    }

    @Config(value="query.execution-policy")
    public QueryManagerConfig setQueryExecutionPolicy(String queryExecutionPolicy) {
        this.queryExecutionPolicy = queryExecutionPolicy;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getRequiredWorkers() {
        return this.requiredWorkers;
    }

    @Config(value="query-manager.required-workers")
    @ConfigDescription(value="Minimum number of active workers that must be available before a query will start")
    public QueryManagerConfig setRequiredWorkers(int requiredWorkers) {
        this.requiredWorkers = requiredWorkers;
        return this;
    }

    @NotNull
    public Duration getRequiredWorkersMaxWait() {
        return this.requiredWorkersMaxWait;
    }

    @Config(value="query-manager.required-workers-max-wait")
    @ConfigDescription(value="Maximum time to wait for minimum number of workers before the query is failed")
    public QueryManagerConfig setRequiredWorkersMaxWait(Duration requiredWorkersMaxWait) {
        this.requiredWorkersMaxWait = requiredWorkersMaxWait;
        return this;
    }

    @NotNull
    public RetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    @Config(value="retry-policy")
    public QueryManagerConfig setRetryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    @Min(value=0L)
    public @Min(value=0L) int getQueryRetryAttempts() {
        return this.queryRetryAttempts;
    }

    @Config(value="query-retry-attempts")
    @LegacyConfig(value={"retry-attempts"})
    public QueryManagerConfig setQueryRetryAttempts(int queryRetryAttempts) {
        this.queryRetryAttempts = queryRetryAttempts;
        return this;
    }

    @Min(value=0L)
    @Max(value=126L)
    public @Min(value=0L) @Max(value=126L) int getTaskRetryAttemptsPerTask() {
        return this.taskRetryAttemptsPerTask;
    }

    @Config(value="task-retry-attempts-per-task")
    public QueryManagerConfig setTaskRetryAttemptsPerTask(int taskRetryAttemptsPerTask) {
        this.taskRetryAttemptsPerTask = taskRetryAttemptsPerTask;
        return this;
    }

    @NotNull
    public Duration getRetryInitialDelay() {
        return this.retryInitialDelay;
    }

    @Config(value="retry-initial-delay")
    @ConfigDescription(value="Initial delay before initiating a retry attempt. Delay increases exponentially for each subsequent attempt up to 'retry_max_delay'")
    public QueryManagerConfig setRetryInitialDelay(Duration retryInitialDelay) {
        this.retryInitialDelay = retryInitialDelay;
        return this;
    }

    @NotNull
    public Duration getRetryMaxDelay() {
        return this.retryMaxDelay;
    }

    @Config(value="retry-max-delay")
    @ConfigDescription(value="Maximum delay before initiating a retry attempt. Delay increases exponentially for each subsequent attempt starting from 'retry_initial_delay'")
    public QueryManagerConfig setRetryMaxDelay(Duration retryMaxDelay) {
        this.retryMaxDelay = retryMaxDelay;
        return this;
    }

    @NotNull
    public double getRetryDelayScaleFactor() {
        return this.retryDelayScaleFactor;
    }

    @Config(value="retry-delay-scale-factor")
    @ConfigDescription(value="Factor by which retry delay is scaled on subsequent failures")
    public QueryManagerConfig setRetryDelayScaleFactor(double retryDelayScaleFactor) {
        Preconditions.checkArgument((retryDelayScaleFactor >= 1.0 ? 1 : 0) != 0, (Object)"retry-delay-scale-factor must be greater than or equal to 1");
        this.retryDelayScaleFactor = retryDelayScaleFactor;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxTasksWaitingForExecutionPerQuery() {
        return this.maxTasksWaitingForExecutionPerQuery;
    }

    @Config(value="max-tasks-waiting-for-execution-per-query")
    @ConfigDescription(value="Maximum number of tasks waiting to be scheduled per query. Split enumeration is paused by the scheduler when this threshold is crossed")
    public QueryManagerConfig setMaxTasksWaitingForExecutionPerQuery(int maxTasksWaitingForExecutionPerQuery) {
        this.maxTasksWaitingForExecutionPerQuery = maxTasksWaitingForExecutionPerQuery;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getMaxTasksWaitingForNodePerStage() {
        return this.maxTasksWaitingForNodePerStage;
    }

    @Config(value="max-tasks-waiting-for-node-per-stage")
    @ConfigDescription(value="Maximum possible number of tasks waiting for node allocation per stage before scheduling of new tasks for stage is paused")
    public QueryManagerConfig setMaxTasksWaitingForNodePerStage(int maxTasksWaitingForNodePerStage) {
        this.maxTasksWaitingForNodePerStage = maxTasksWaitingForNodePerStage;
        return this;
    }

    public boolean isEnabledAdaptiveTaskRequestSize() {
        return this.enabledAdaptiveTaskRequestSize;
    }

    @Config(value="query.remote-task.enable-adaptive-request-size")
    public QueryManagerConfig setEnabledAdaptiveTaskRequestSize(boolean enabledAdaptiveTaskRequestSize) {
        this.enabledAdaptiveTaskRequestSize = enabledAdaptiveTaskRequestSize;
        return this;
    }

    @NotNull
    public DataSize getMaxRemoteTaskRequestSize() {
        return this.maxRemoteTaskRequestSize;
    }

    @Config(value="query.remote-task.max-request-size")
    public QueryManagerConfig setMaxRemoteTaskRequestSize(DataSize maxRemoteTaskRequestSize) {
        this.maxRemoteTaskRequestSize = maxRemoteTaskRequestSize;
        return this;
    }

    @NotNull
    public DataSize getRemoteTaskRequestSizeHeadroom() {
        return this.remoteTaskRequestSizeHeadroom;
    }

    @Config(value="query.remote-task.request-size-headroom")
    public QueryManagerConfig setRemoteTaskRequestSizeHeadroom(DataSize remoteTaskRequestSizeHeadroom) {
        this.remoteTaskRequestSizeHeadroom = remoteTaskRequestSizeHeadroom;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getRemoteTaskGuaranteedSplitPerTask() {
        return this.remoteTaskGuaranteedSplitPerTask;
    }

    @Config(value="query.remote-task.guaranteed-splits-per-task")
    public QueryManagerConfig setRemoteTaskGuaranteedSplitPerTask(int remoteTaskGuaranteedSplitPerTask) {
        this.remoteTaskGuaranteedSplitPerTask = remoteTaskGuaranteedSplitPerTask;
        return this;
    }

    public int getFaultTolerantExecutionArbitraryDistributionComputeTaskTargetSizeGrowthPeriod() {
        return this.faultTolerantExecutionArbitraryDistributionComputeTaskTargetSizeGrowthPeriod;
    }

    @Config(value="fault-tolerant-execution-arbitrary-distribution-compute-task-target-size-growth-period")
    @ConfigDescription(value="The number of tasks created for any given non-writer stage of arbitrary distribution before task size is increased")
    public QueryManagerConfig setFaultTolerantExecutionArbitraryDistributionComputeTaskTargetSizeGrowthPeriod(int faultTolerantExecutionArbitraryDistributionComputeTaskTargetSizeGrowthPeriod) {
        this.faultTolerantExecutionArbitraryDistributionComputeTaskTargetSizeGrowthPeriod = faultTolerantExecutionArbitraryDistributionComputeTaskTargetSizeGrowthPeriod;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) double getFaultTolerantExecutionArbitraryDistributionComputeTaskTargetSizeGrowthFactor() {
        return this.faultTolerantExecutionArbitraryDistributionComputeTaskTargetSizeGrowthFactor;
    }

    @Config(value="fault-tolerant-execution-arbitrary-distribution-compute-task-target-size-growth-factor")
    @ConfigDescription(value="Growth factor for adaptive sizing of non-writer tasks of arbitrary distribution for fault-tolerant execution")
    public QueryManagerConfig setFaultTolerantExecutionArbitraryDistributionComputeTaskTargetSizeGrowthFactor(double faultTolerantExecutionArbitraryDistributionComputeTaskTargetSizeGrowthFactor) {
        this.faultTolerantExecutionArbitraryDistributionComputeTaskTargetSizeGrowthFactor = faultTolerantExecutionArbitraryDistributionComputeTaskTargetSizeGrowthFactor;
        return this;
    }

    @NotNull
    public DataSize getFaultTolerantExecutionArbitraryDistributionComputeTaskTargetSizeMin() {
        return this.faultTolerantExecutionArbitraryDistributionComputeTaskTargetSizeMin;
    }

    @Config(value="fault-tolerant-execution-arbitrary-distribution-compute-task-target-size-min")
    @ConfigDescription(value="Initial/min target input size for non-writer tasks of arbitrary distribution of fault-tolerant execution")
    public QueryManagerConfig setFaultTolerantExecutionArbitraryDistributionComputeTaskTargetSizeMin(DataSize faultTolerantExecutionArbitraryDistributionComputeTaskTargetSizeMin) {
        this.faultTolerantExecutionArbitraryDistributionComputeTaskTargetSizeMin = faultTolerantExecutionArbitraryDistributionComputeTaskTargetSizeMin;
        return this;
    }

    @NotNull
    public DataSize getFaultTolerantExecutionArbitraryDistributionComputeTaskTargetSizeMax() {
        return this.faultTolerantExecutionArbitraryDistributionComputeTaskTargetSizeMax;
    }

    @Config(value="fault-tolerant-execution-arbitrary-distribution-compute-task-target-size-max")
    @ConfigDescription(value="Max target input size for non-writer task of arbitrary distribution of fault-tolerant execution")
    public QueryManagerConfig setFaultTolerantExecutionArbitraryDistributionComputeTaskTargetSizeMax(DataSize faultTolerantExecutionArbitraryDistributionComputeTaskTargetSizeMax) {
        this.faultTolerantExecutionArbitraryDistributionComputeTaskTargetSizeMax = faultTolerantExecutionArbitraryDistributionComputeTaskTargetSizeMax;
        return this;
    }

    public int getFaultTolerantExecutionArbitraryDistributionWriteTaskTargetSizeGrowthPeriod() {
        return this.faultTolerantExecutionArbitraryDistributionWriteTaskTargetSizeGrowthPeriod;
    }

    @Config(value="fault-tolerant-execution-arbitrary-distribution-write-task-target-size-growth-period")
    @ConfigDescription(value="The number of tasks created for any given writer stage of arbitrary distribution before task size is increased")
    public QueryManagerConfig setFaultTolerantExecutionArbitraryDistributionWriteTaskTargetSizeGrowthPeriod(int faultTolerantExecutionArbitraryDistributionWriteTaskTargetSizeGrowthPeriod) {
        this.faultTolerantExecutionArbitraryDistributionWriteTaskTargetSizeGrowthPeriod = faultTolerantExecutionArbitraryDistributionWriteTaskTargetSizeGrowthPeriod;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) double getFaultTolerantExecutionArbitraryDistributionWriteTaskTargetSizeGrowthFactor() {
        return this.faultTolerantExecutionArbitraryDistributionWriteTaskTargetSizeGrowthFactor;
    }

    @Config(value="fault-tolerant-execution-arbitrary-distribution-write-task-target-size-growth-factor")
    @ConfigDescription(value="Growth factor for adaptive sizing of writer tasks of arbitrary distribution for fault-tolerant execution")
    public QueryManagerConfig setFaultTolerantExecutionArbitraryDistributionWriteTaskTargetSizeGrowthFactor(double faultTolerantExecutionArbitraryDistributionWriteTaskTargetSizeGrowthFactor) {
        this.faultTolerantExecutionArbitraryDistributionWriteTaskTargetSizeGrowthFactor = faultTolerantExecutionArbitraryDistributionWriteTaskTargetSizeGrowthFactor;
        return this;
    }

    @NotNull
    public DataSize getFaultTolerantExecutionArbitraryDistributionWriteTaskTargetSizeMin() {
        return this.faultTolerantExecutionArbitraryDistributionWriteTaskTargetSizeMin;
    }

    @Config(value="fault-tolerant-execution-arbitrary-distribution-write-task-target-size-min")
    @ConfigDescription(value="Initial/min target input size for writer tasks of arbitrary distribution of fault-tolerant execution")
    public QueryManagerConfig setFaultTolerantExecutionArbitraryDistributionWriteTaskTargetSizeMin(DataSize faultTolerantExecutionArbitraryDistributionWriteTaskTargetSizeMin) {
        this.faultTolerantExecutionArbitraryDistributionWriteTaskTargetSizeMin = faultTolerantExecutionArbitraryDistributionWriteTaskTargetSizeMin;
        return this;
    }

    @NotNull
    public DataSize getFaultTolerantExecutionArbitraryDistributionWriteTaskTargetSizeMax() {
        return this.faultTolerantExecutionArbitraryDistributionWriteTaskTargetSizeMax;
    }

    @Config(value="fault-tolerant-execution-arbitrary-distribution-write-task-target-size-max")
    @ConfigDescription(value="Max target input size for writer tasks of arbitrary distribution of fault-tolerant execution")
    public QueryManagerConfig setFaultTolerantExecutionArbitraryDistributionWriteTaskTargetSizeMax(DataSize faultTolerantExecutionArbitraryDistributionWriteTaskTargetSizeMax) {
        this.faultTolerantExecutionArbitraryDistributionWriteTaskTargetSizeMax = faultTolerantExecutionArbitraryDistributionWriteTaskTargetSizeMax;
        return this;
    }

    @NotNull
    public DataSize getFaultTolerantExecutionHashDistributionComputeTaskTargetSize() {
        return this.faultTolerantExecutionHashDistributionComputeTaskTargetSize;
    }

    @Config(value="fault-tolerant-execution-hash-distribution-compute-task-target-size")
    @ConfigDescription(value="Target input size for non-writer tasks of hash distribution of fault-tolerant execution")
    public QueryManagerConfig setFaultTolerantExecutionHashDistributionComputeTaskTargetSize(DataSize faultTolerantExecutionHashDistributionComputeTaskTargetSize) {
        this.faultTolerantExecutionHashDistributionComputeTaskTargetSize = faultTolerantExecutionHashDistributionComputeTaskTargetSize;
        return this;
    }

    @DecimalMin(value="0.0", inclusive=true)
    public @DecimalMin(value="0.0", inclusive=true) double getFaultTolerantExecutionHashDistributionComputeTasksToNodesMinRatio() {
        return this.faultTolerantExecutionHashDistributionComputeTasksToNodesMinRatio;
    }

    @Config(value="fault-tolerant-execution-hash-distribution-compute-task-to-node-min-ratio")
    @ConfigDescription(value="Minimal ratio of tasks count vs cluster nodes count for hash distributed compute stage in fault-tolerant execution")
    public QueryManagerConfig setFaultTolerantExecutionHashDistributionComputeTasksToNodesMinRatio(double faultTolerantExecutionHashDistributionComputeTasksToNodesMinRatio) {
        this.faultTolerantExecutionHashDistributionComputeTasksToNodesMinRatio = faultTolerantExecutionHashDistributionComputeTasksToNodesMinRatio;
        return this;
    }

    @NotNull
    public DataSize getFaultTolerantExecutionHashDistributionWriteTaskTargetSize() {
        return this.faultTolerantExecutionHashDistributionWriteTaskTargetSize;
    }

    @Config(value="fault-tolerant-execution-hash-distribution-write-task-target-size")
    @ConfigDescription(value="Target input size of writer tasks of hash distribution of fault-tolerant execution")
    public QueryManagerConfig setFaultTolerantExecutionHashDistributionWriteTaskTargetSize(DataSize faultTolerantExecutionHashDistributionWriteTaskTargetSize) {
        this.faultTolerantExecutionHashDistributionWriteTaskTargetSize = faultTolerantExecutionHashDistributionWriteTaskTargetSize;
        return this;
    }

    @DecimalMin(value="0.0", inclusive=true)
    public @DecimalMin(value="0.0", inclusive=true) double getFaultTolerantExecutionHashDistributionWriteTasksToNodesMinRatio() {
        return this.faultTolerantExecutionHashDistributionWriteTasksToNodesMinRatio;
    }

    @Config(value="fault-tolerant-execution-hash-distribution-write-task-to-node-min-ratio")
    @ConfigDescription(value="Minimal ratio of tasks count vs cluster nodes count for hash distributed writer stage in fault-tolerant execution")
    public QueryManagerConfig setFaultTolerantExecutionHashDistributionWriteTasksToNodesMinRatio(double faultTolerantExecutionHashDistributionWriteTasksToNodesMinRatio) {
        this.faultTolerantExecutionHashDistributionWriteTasksToNodesMinRatio = faultTolerantExecutionHashDistributionWriteTasksToNodesMinRatio;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getFaultTolerantExecutionHashDistributionWriteTaskTargetMaxCount() {
        return this.faultTolerantExecutionHashDistributionWriteTaskTargetMaxCount;
    }

    @Config(value="fault-tolerant-execution-hash-distribution-write-task-target-max-count")
    @ConfigDescription(value="Soft upper bound on number of writer tasks in a stage of hash distribution of fault-tolerant execution")
    public QueryManagerConfig setFaultTolerantExecutionHashDistributionWriteTaskTargetMaxCount(int faultTolerantExecutionHashDistributionWriteTaskTargetMaxCount) {
        this.faultTolerantExecutionHashDistributionWriteTaskTargetMaxCount = faultTolerantExecutionHashDistributionWriteTaskTargetMaxCount;
        return this;
    }

    @MinDataSize(value="1MB")
    public @MinDataSize(value="1MB") DataSize getFaultTolerantExecutionStandardSplitSize() {
        return this.faultTolerantExecutionStandardSplitSize;
    }

    @Config(value="fault-tolerant-execution-standard-split-size")
    @ConfigDescription(value="Standard split size for a single fault tolerant task (split weight aware)")
    public QueryManagerConfig setFaultTolerantExecutionStandardSplitSize(DataSize faultTolerantExecutionStandardSplitSize) {
        this.faultTolerantExecutionStandardSplitSize = faultTolerantExecutionStandardSplitSize;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getFaultTolerantExecutionMaxTaskSplitCount() {
        return this.faultTolerantExecutionMaxTaskSplitCount;
    }

    @Config(value="fault-tolerant-execution-max-task-split-count")
    @ConfigDescription(value="Maximal number of splits for a single fault tolerant task (count based)")
    public QueryManagerConfig setFaultTolerantExecutionMaxTaskSplitCount(int faultTolerantExecutionMaxTaskSplitCount) {
        this.faultTolerantExecutionMaxTaskSplitCount = faultTolerantExecutionMaxTaskSplitCount;
        return this;
    }

    @NotNull
    public DataSize getFaultTolerantExecutionTaskDescriptorStorageMaxMemory() {
        return this.faultTolerantExecutionTaskDescriptorStorageMaxMemory;
    }

    @Config(value="fault-tolerant-execution-task-descriptor-storage-max-memory")
    @ConfigDescription(value="Maximum amount of memory to be used to store task descriptors for fault tolerant queries on coordinator")
    public QueryManagerConfig setFaultTolerantExecutionTaskDescriptorStorageMaxMemory(DataSize faultTolerantExecutionTaskDescriptorStorageMaxMemory) {
        this.faultTolerantExecutionTaskDescriptorStorageMaxMemory = faultTolerantExecutionTaskDescriptorStorageMaxMemory;
        return this;
    }

    @Min(value=1L)
    @Max(value=1000L)
    public @Min(value=1L) @Max(value=1000L) int getFaultTolerantExecutionMaxPartitionCount() {
        return this.faultTolerantExecutionMaxPartitionCount;
    }

    @Config(value="fault-tolerant-execution-max-partition-count")
    @LegacyConfig(value={"fault-tolerant-execution-partition-count"})
    @ConfigDescription(value="Maximum number of partitions for distributed joins and aggregations executed with fault tolerant execution enabled")
    public QueryManagerConfig setFaultTolerantExecutionMaxPartitionCount(int faultTolerantExecutionMaxPartitionCount) {
        this.faultTolerantExecutionMaxPartitionCount = faultTolerantExecutionMaxPartitionCount;
        return this;
    }

    @Min(value=1L)
    @Max(value=1000L)
    public @Min(value=1L) @Max(value=1000L) int getFaultTolerantExecutionMinPartitionCount() {
        return this.faultTolerantExecutionMinPartitionCount;
    }

    @Config(value="fault-tolerant-execution-min-partition-count")
    @ConfigDescription(value="Minimum number of partitions for distributed joins and aggregations executed with fault tolerant execution enabled")
    public QueryManagerConfig setFaultTolerantExecutionMinPartitionCount(int faultTolerantExecutionMinPartitionCount) {
        this.faultTolerantExecutionMinPartitionCount = faultTolerantExecutionMinPartitionCount;
        return this;
    }

    @Min(value=1L)
    @Max(value=1000L)
    public @Min(value=1L) @Max(value=1000L) int getFaultTolerantExecutionMinPartitionCountForWrite() {
        return this.faultTolerantExecutionMinPartitionCountForWrite;
    }

    @Config(value="fault-tolerant-execution-min-partition-count-for-write")
    @ConfigDescription(value="Minimum number of partitions for distributed joins and aggregations in write queries executed with fault tolerant execution enabled")
    public QueryManagerConfig setFaultTolerantExecutionMinPartitionCountForWrite(int faultTolerantExecutionMinPartitionCountForWrite) {
        this.faultTolerantExecutionMinPartitionCountForWrite = faultTolerantExecutionMinPartitionCountForWrite;
        return this;
    }

    public boolean isFaultTolerantExecutionRuntimeAdaptivePartitioningEnabled() {
        return this.faultTolerantExecutionRuntimeAdaptivePartitioningEnabled;
    }

    @Config(value="fault-tolerant-execution-runtime-adaptive-partitioning-enabled")
    public QueryManagerConfig setFaultTolerantExecutionRuntimeAdaptivePartitioningEnabled(boolean faultTolerantExecutionRuntimeAdaptivePartitioningEnabled) {
        this.faultTolerantExecutionRuntimeAdaptivePartitioningEnabled = faultTolerantExecutionRuntimeAdaptivePartitioningEnabled;
        return this;
    }

    @Min(value=1L)
    @Max(value=1000L)
    public @Min(value=1L) @Max(value=1000L) int getFaultTolerantExecutionRuntimeAdaptivePartitioningPartitionCount() {
        return this.faultTolerantExecutionRuntimeAdaptivePartitioningPartitionCount;
    }

    @Config(value="fault-tolerant-execution-runtime-adaptive-partitioning-partition-count")
    @ConfigDescription(value="The partition count to use for runtime adaptive partitioning when enabled")
    public QueryManagerConfig setFaultTolerantExecutionRuntimeAdaptivePartitioningPartitionCount(int faultTolerantExecutionRuntimeAdaptivePartitioningPartitionCount) {
        this.faultTolerantExecutionRuntimeAdaptivePartitioningPartitionCount = faultTolerantExecutionRuntimeAdaptivePartitioningPartitionCount;
        return this;
    }

    public DataSize getFaultTolerantExecutionRuntimeAdaptivePartitioningMaxTaskSize() {
        return this.faultTolerantExecutionRuntimeAdaptivePartitioningMaxTaskSize;
    }

    @Config(value="fault-tolerant-execution-runtime-adaptive-partitioning-max-task-size")
    @ConfigDescription(value="Max average task input size when deciding runtime adaptive partitioning")
    public QueryManagerConfig setFaultTolerantExecutionRuntimeAdaptivePartitioningMaxTaskSize(DataSize faultTolerantExecutionRuntimeAdaptivePartitioningMaxTaskSize) {
        this.faultTolerantExecutionRuntimeAdaptivePartitioningMaxTaskSize = faultTolerantExecutionRuntimeAdaptivePartitioningMaxTaskSize;
        return this;
    }

    public boolean isFaultTolerantExecutionForcePreferredWritePartitioningEnabled() {
        return this.faultTolerantExecutionForcePreferredWritePartitioningEnabled;
    }

    @Config(value="experimental.fault-tolerant-execution-force-preferred-write-partitioning-enabled")
    public QueryManagerConfig setFaultTolerantExecutionForcePreferredWritePartitioningEnabled(boolean faultTolerantExecutionForcePreferredWritePartitioningEnabled) {
        this.faultTolerantExecutionForcePreferredWritePartitioningEnabled = faultTolerantExecutionForcePreferredWritePartitioningEnabled;
        return this;
    }

    public double getFaultTolerantExecutionMinSourceStageProgress() {
        return this.faultTolerantExecutionMinSourceStageProgress;
    }

    @Config(value="fault-tolerant-execution-min-source-stage-progress")
    @ConfigDescription(value="Minimal progress of source stage to consider scheduling of parent stage")
    public QueryManagerConfig setFaultTolerantExecutionMinSourceStageProgress(double faultTolerantExecutionMinSourceStageProgress) {
        this.faultTolerantExecutionMinSourceStageProgress = faultTolerantExecutionMinSourceStageProgress;
        return this;
    }

    public boolean isFaultTolerantExecutionSmallStageEstimationEnabled() {
        return this.faultTolerantExecutionSmallStageEstimationEnabled;
    }

    @Config(value="fault-tolerant-execution-small-stage-estimation-enabled")
    @ConfigDescription(value="Enable small stage estimation heuristic, used for more aggresive speculative stage scheduling")
    public QueryManagerConfig setFaultTolerantExecutionSmallStageEstimationEnabled(boolean faultTolerantExecutionSmallStageEstimationEnabled) {
        this.faultTolerantExecutionSmallStageEstimationEnabled = faultTolerantExecutionSmallStageEstimationEnabled;
        return this;
    }

    public DataSize getFaultTolerantExecutionSmallStageEstimationThreshold() {
        return this.faultTolerantExecutionSmallStageEstimationThreshold;
    }

    @Config(value="fault-tolerant-execution-small-stage-estimation-threshold")
    @ConfigDescription(value="Threshold until which stage is considered small")
    public QueryManagerConfig setFaultTolerantExecutionSmallStageEstimationThreshold(DataSize faultTolerantExecutionSmallStageEstimationThreshold) {
        this.faultTolerantExecutionSmallStageEstimationThreshold = faultTolerantExecutionSmallStageEstimationThreshold;
        return this;
    }

    @DecimalMin(value="1.0")
    public @DecimalMin(value="1.0") double getFaultTolerantExecutionSmallStageSourceSizeMultiplier() {
        return this.faultTolerantExecutionSmallStageSourceSizeMultiplier;
    }

    @Config(value="fault-tolerant-execution-small-stage-source-size-multiplier")
    @ConfigDescription(value="Multiplier used for heuristic estimation is stage is small; the bigger the more conservative estimation is")
    public QueryManagerConfig setFaultTolerantExecutionSmallStageSourceSizeMultiplier(double faultTolerantExecutionSmallStageSourceSizeMultiplier) {
        this.faultTolerantExecutionSmallStageSourceSizeMultiplier = faultTolerantExecutionSmallStageSourceSizeMultiplier;
        return this;
    }

    public boolean isFaultTolerantExecutionSmallStageRequireNoMorePartitions() {
        return this.faultTolerantExecutionSmallStageRequireNoMorePartitions;
    }

    @Config(value="fault-tolerant-execution-small-stage-require-no-more-partitions")
    @ConfigDescription(value="Is it required for all stage partitions (tasks) to be enumerated for stage to be used in heuristic to determine if parent stage is small")
    public QueryManagerConfig setFaultTolerantExecutionSmallStageRequireNoMorePartitions(boolean faultTolerantExecutionSmallStageRequireNoMorePartitions) {
        this.faultTolerantExecutionSmallStageRequireNoMorePartitions = faultTolerantExecutionSmallStageRequireNoMorePartitions;
        return this;
    }

    public void applyFaultTolerantExecutionDefaults() {
        this.remoteTaskMaxErrorDuration = new Duration(1.0, TimeUnit.MINUTES);
    }
}

