/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.resourcegroups;

import io.trino.execution.resourcegroups.UpdateablePriorityQueue;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

final class FifoQueue<E>
implements UpdateablePriorityQueue<E> {
    private final Set<E> delegate = new LinkedHashSet();

    FifoQueue() {
    }

    @Override
    public boolean addOrUpdate(E element, long priority) {
        return this.delegate.add(element);
    }

    @Override
    public boolean contains(E element) {
        return this.delegate.contains(element);
    }

    @Override
    public boolean remove(E element) {
        return this.delegate.remove(element);
    }

    @Override
    public E poll() {
        Iterator<E> iterator = this.delegate.iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        E element = iterator.next();
        iterator.remove();
        return element;
    }

    @Override
    public E peek() {
        Iterator<E> iterator = this.delegate.iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        return iterator.next();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this.delegate.iterator();
    }
}

