/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.base.MoreObjects;
import io.trino.spi.type.TypeId;
import java.util.Objects;
import java.util.Optional;

public final class ViewColumn {
    private final String name;
    private final TypeId type;
    private final Optional<String> comment;

    public ViewColumn(String name, TypeId type, Optional<String> comment) {
        this.name = Objects.requireNonNull(name, "name is null");
        this.type = Objects.requireNonNull(type, "type is null");
        this.comment = Objects.requireNonNull(comment, "comment is null");
    }

    public String getName() {
        return this.name;
    }

    public TypeId getType() {
        return this.type;
    }

    public Optional<String> getComment() {
        return this.comment;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("name", (Object)this.name).add("type", (Object)this.type).add("comment", this.comment.orElse(null)).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ViewColumn that = (ViewColumn)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.type, that.type) && Objects.equals(this.comment, that.comment);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type, this.comment);
    }
}

