/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.metadata.ViewColumn;
import io.trino.spi.connector.CatalogSchemaTableName;
import io.trino.spi.connector.ConnectorMaterializedViewDefinition;
import io.trino.spi.connector.ConnectorViewDefinition;
import java.util.List;
import java.util.Optional;

public final class ViewInfo {
    private final String originalSql;
    private final List<ViewColumn> columns;
    private final Optional<String> comment;
    private final Optional<CatalogSchemaTableName> storageTable;

    public ViewInfo(ConnectorViewDefinition viewDefinition) {
        this.originalSql = viewDefinition.getOriginalSql();
        this.columns = (List)viewDefinition.getColumns().stream().map(column -> new ViewColumn(column.getName(), column.getType(), column.getComment())).collect(ImmutableList.toImmutableList());
        this.comment = viewDefinition.getComment();
        this.storageTable = Optional.empty();
    }

    public ViewInfo(ConnectorMaterializedViewDefinition viewDefinition) {
        this.originalSql = viewDefinition.getOriginalSql();
        this.columns = (List)viewDefinition.getColumns().stream().map(column -> new ViewColumn(column.getName(), column.getType(), column.getComment())).collect(ImmutableList.toImmutableList());
        this.comment = viewDefinition.getComment();
        this.storageTable = viewDefinition.getStorageTable();
    }

    public String getOriginalSql() {
        return this.originalSql;
    }

    public List<ViewColumn> getColumns() {
        return this.columns;
    }

    public Optional<String> getComment() {
        return this.comment;
    }

    public Optional<CatalogSchemaTableName> getStorageTable() {
        return this.storageTable;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("originalSql", (Object)this.originalSql).add("columns", this.columns).add("comment", this.comment.orElse(null)).add("storageTable", this.storageTable.orElse(null)).toString();
    }
}

