/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.collect.ImmutableList;
import io.trino.operator.JoinOperatorType;
import io.trino.operator.OperatorFactory;
import io.trino.operator.join.JoinBridgeManager;
import io.trino.operator.join.JoinProbe;
import io.trino.operator.join.LookupSourceFactory;
import io.trino.operator.join.unspilled.JoinProbe;
import io.trino.operator.join.unspilled.LookupJoinOperatorFactory;
import io.trino.operator.join.unspilled.PartitionedLookupSourceFactory;
import io.trino.spi.type.Type;
import io.trino.spiller.PartitioningSpillerFactory;
import io.trino.sql.planner.plan.PlanNodeId;
import io.trino.type.BlockTypeOperators;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.IntStream;

public class OperatorFactories {
    private OperatorFactories() {
    }

    public static OperatorFactory join(JoinOperatorType joinType, int operatorId, PlanNodeId planNodeId, JoinBridgeManager<? extends PartitionedLookupSourceFactory> lookupSourceFactory, boolean hasFilter, List<Type> probeTypes, List<Integer> probeJoinChannel, OptionalInt probeHashChannel, Optional<List<Integer>> probeOutputChannelsOptional, BlockTypeOperators blockTypeOperators) {
        List probeOutputChannels = probeOutputChannelsOptional.orElseGet(() -> OperatorFactories.rangeList(probeTypes.size()));
        List probeOutputChannelTypes = (List)probeOutputChannels.stream().map(probeTypes::get).collect(ImmutableList.toImmutableList());
        return new LookupJoinOperatorFactory(operatorId, planNodeId, lookupSourceFactory, probeTypes, probeOutputChannelTypes, lookupSourceFactory.getBuildOutputTypes(), joinType, new JoinProbe.JoinProbeFactory(probeOutputChannels, probeJoinChannel, probeHashChannel, hasFilter), blockTypeOperators, probeJoinChannel, probeHashChannel);
    }

    public static OperatorFactory spillingJoin(JoinOperatorType joinType, int operatorId, PlanNodeId planNodeId, JoinBridgeManager<? extends LookupSourceFactory> lookupSourceFactory, boolean hasFilter, List<Type> probeTypes, List<Integer> probeJoinChannel, OptionalInt probeHashChannel, Optional<List<Integer>> probeOutputChannelsOptional, OptionalInt totalOperatorsCount, PartitioningSpillerFactory partitioningSpillerFactory, BlockTypeOperators blockTypeOperators) {
        List probeOutputChannels = probeOutputChannelsOptional.orElseGet(() -> OperatorFactories.rangeList(probeTypes.size()));
        List probeOutputChannelTypes = (List)probeOutputChannels.stream().map(probeTypes::get).collect(ImmutableList.toImmutableList());
        return new io.trino.operator.join.LookupJoinOperatorFactory(operatorId, planNodeId, lookupSourceFactory, probeTypes, probeOutputChannelTypes, lookupSourceFactory.getBuildOutputTypes(), joinType, new JoinProbe.JoinProbeFactory(probeOutputChannels.stream().mapToInt(i -> i).toArray(), probeJoinChannel, probeHashChannel), blockTypeOperators, totalOperatorsCount, probeJoinChannel, probeHashChannel, partitioningSpillerFactory);
    }

    private static List<Integer> rangeList(int endExclusive) {
        return (List)IntStream.range(0, endExclusive).boxed().collect(ImmutableList.toImmutableList());
    }
}

