/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import com.google.common.collect.ImmutableList;
import io.trino.operator.aggregation.Accumulator;
import io.trino.operator.aggregation.AccumulatorFactory;
import io.trino.operator.aggregation.AggregationMaskBuilder;
import io.trino.operator.aggregation.GroupedAccumulator;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;

public class CompiledAccumulatorFactory
implements AccumulatorFactory {
    private final Constructor<? extends Accumulator> accumulatorConstructor;
    private final Constructor<? extends GroupedAccumulator> groupedAccumulatorConstructor;
    private final List<Class<?>> lambdaInterfaces;
    private final Constructor<? extends AggregationMaskBuilder> maskBuilderConstructor;

    public CompiledAccumulatorFactory(Constructor<? extends Accumulator> accumulatorConstructor, Constructor<? extends GroupedAccumulator> groupedAccumulatorConstructor, List<Class<?>> lambdaInterfaces, Constructor<? extends AggregationMaskBuilder> maskBuilderConstructor) {
        this.accumulatorConstructor = Objects.requireNonNull(accumulatorConstructor, "accumulatorConstructor is null");
        this.groupedAccumulatorConstructor = Objects.requireNonNull(groupedAccumulatorConstructor, "groupedAccumulatorConstructor is null");
        this.lambdaInterfaces = ImmutableList.copyOf((Collection)Objects.requireNonNull(lambdaInterfaces, "lambdaInterfaces is null"));
        this.maskBuilderConstructor = Objects.requireNonNull(maskBuilderConstructor, "maskBuilderConstructor is null");
    }

    @Override
    public List<Class<?>> getLambdaInterfaces() {
        return this.lambdaInterfaces;
    }

    @Override
    public Accumulator createAccumulator(List<Supplier<Object>> lambdaProviders) {
        try {
            return this.accumulatorConstructor.newInstance(lambdaProviders);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Accumulator createIntermediateAccumulator(List<Supplier<Object>> lambdaProviders) {
        try {
            return this.accumulatorConstructor.newInstance(lambdaProviders);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public GroupedAccumulator createGroupedAccumulator(List<Supplier<Object>> lambdaProviders) {
        try {
            return this.groupedAccumulatorConstructor.newInstance(lambdaProviders);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public GroupedAccumulator createGroupedIntermediateAccumulator(List<Supplier<Object>> lambdaProviders) {
        try {
            return this.groupedAccumulatorConstructor.newInstance(lambdaProviders);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public AggregationMaskBuilder createAggregationMaskBuilder() {
        try {
            return this.maskBuilderConstructor.newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }
}

