/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.listagg;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.trino.operator.aggregation.listagg.ListaggAggregationState;
import io.trino.spi.block.AbstractRowBlock;
import io.trino.spi.block.ArrayBlockBuilder;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.ColumnarRow;
import io.trino.spi.block.RowBlockBuilder;
import io.trino.spi.function.AccumulatorStateSerializer;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.List;

public class ListaggAggregationStateSerializer
implements AccumulatorStateSerializer<ListaggAggregationState> {
    private final Type arrayType = new ArrayType((Type)VarcharType.VARCHAR);
    private final Type serializedType = RowType.anonymous((List)ImmutableList.of((Object)VarcharType.VARCHAR, (Object)BooleanType.BOOLEAN, (Object)VarcharType.VARCHAR, (Object)BooleanType.BOOLEAN, (Object)this.arrayType));

    public Type getSerializedType() {
        return this.serializedType;
    }

    public void serialize(ListaggAggregationState state, BlockBuilder out) {
        if (state.isEmpty()) {
            out.appendNull();
        } else {
            ((RowBlockBuilder)out).buildEntry(fieldBuilders -> {
                VarcharType.VARCHAR.writeSlice((BlockBuilder)fieldBuilders.get(0), state.getSeparator());
                BooleanType.BOOLEAN.writeBoolean((BlockBuilder)fieldBuilders.get(1), state.isOverflowError());
                VarcharType.VARCHAR.writeSlice((BlockBuilder)fieldBuilders.get(2), state.getOverflowFiller());
                BooleanType.BOOLEAN.writeBoolean((BlockBuilder)fieldBuilders.get(3), state.showOverflowEntryCount());
                ((ArrayBlockBuilder)fieldBuilders.get(4)).buildEntry(elementBuilder -> state.forEach((block, position) -> {
                    VarcharType.VARCHAR.appendTo(block, position, elementBuilder);
                    return true;
                }));
            });
        }
    }

    public void deserialize(Block block, int index, ListaggAggregationState state) {
        Preconditions.checkArgument((boolean)(block instanceof AbstractRowBlock));
        ColumnarRow columnarRow = ColumnarRow.toColumnarRow((Block)block);
        Slice separator = VarcharType.VARCHAR.getSlice(columnarRow.getField(0), index);
        boolean overflowError = BooleanType.BOOLEAN.getBoolean(columnarRow.getField(1), index);
        Slice overflowFiller = VarcharType.VARCHAR.getSlice(columnarRow.getField(2), index);
        boolean showOverflowEntryCount = BooleanType.BOOLEAN.getBoolean(columnarRow.getField(3), index);
        Block stateBlock = (Block)this.arrayType.getObject(columnarRow.getField(4), index);
        state.reset();
        state.setSeparator(separator);
        state.setOverflowError(overflowError);
        state.setOverflowFiller(overflowFiller);
        state.setShowOverflowEntryCount(showOverflowEntryCount);
        for (int i = 0; i < stateBlock.getPositionCount(); ++i) {
            state.add(stateBlock, i);
        }
    }
}

