/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.state;

import io.airlift.slice.SizeOf;
import io.trino.array.ObjectBigArray;
import io.trino.operator.aggregation.KeyValuePairs;
import io.trino.operator.aggregation.state.AbstractGroupedAccumulatorState;
import io.trino.operator.aggregation.state.KeyValuePairsState;
import io.trino.spi.function.AccumulatorState;
import io.trino.spi.function.AccumulatorStateFactory;
import io.trino.spi.function.TypeParameter;
import io.trino.spi.type.Type;
import java.util.Objects;

public class KeyValuePairsStateFactory
implements AccumulatorStateFactory<KeyValuePairsState> {
    private final Type keyType;
    private final Type valueType;

    public KeyValuePairsStateFactory(@TypeParameter(value="K") Type keyType, @TypeParameter(value="V") Type valueType) {
        this.keyType = keyType;
        this.valueType = valueType;
    }

    public KeyValuePairsState createSingleState() {
        return new SingleState(this.keyType, this.valueType);
    }

    public KeyValuePairsState createGroupedState() {
        return new GroupedState(this.keyType, this.valueType);
    }

    public static class SingleState
    implements KeyValuePairsState {
        private static final int INSTANCE_SIZE = SizeOf.instanceSize(SingleState.class);
        private final Type keyType;
        private final Type valueType;
        private KeyValuePairs pair;

        public SingleState(Type keyType, Type valueType) {
            this.keyType = keyType;
            this.valueType = valueType;
        }

        private SingleState(Type keyType, Type valueType, KeyValuePairs pair) {
            this.keyType = keyType;
            this.valueType = valueType;
            this.pair = pair;
        }

        @Override
        public KeyValuePairs get() {
            return this.pair;
        }

        @Override
        public void set(KeyValuePairs value) {
            this.pair = value;
        }

        @Override
        public void addMemoryUsage(long memory) {
        }

        @Override
        public Type getKeyType() {
            return this.keyType;
        }

        @Override
        public Type getValueType() {
            return this.valueType;
        }

        public long getEstimatedSize() {
            long estimatedSize = INSTANCE_SIZE;
            if (this.pair != null) {
                estimatedSize += this.pair.estimatedInMemorySize();
            }
            return estimatedSize;
        }

        public AccumulatorState copy() {
            KeyValuePairs pairCopy = null;
            if (this.pair != null) {
                pairCopy = this.pair.copy();
            }
            return new SingleState(this.keyType, this.valueType, pairCopy);
        }
    }

    public static class GroupedState
    extends AbstractGroupedAccumulatorState
    implements KeyValuePairsState {
        private static final int INSTANCE_SIZE = SizeOf.instanceSize(GroupedState.class);
        private final Type keyType;
        private final Type valueType;
        private final ObjectBigArray<KeyValuePairs> pairs = new ObjectBigArray();
        private long size;

        public GroupedState(Type keyType, Type valueType) {
            this.keyType = keyType;
            this.valueType = valueType;
        }

        public void ensureCapacity(long size) {
            this.pairs.ensureCapacity(size);
        }

        @Override
        public KeyValuePairs get() {
            return (KeyValuePairs)this.pairs.get(this.getGroupId());
        }

        @Override
        public void set(KeyValuePairs value) {
            Objects.requireNonNull(value, "value is null");
            KeyValuePairs previous = this.get();
            if (previous != null) {
                this.size -= previous.estimatedInMemorySize();
            }
            this.pairs.set(this.getGroupId(), (Object)value);
            this.size += value.estimatedInMemorySize();
        }

        @Override
        public void addMemoryUsage(long memory) {
            this.size += memory;
        }

        @Override
        public Type getKeyType() {
            return this.keyType;
        }

        @Override
        public Type getValueType() {
            return this.valueType;
        }

        public long getEstimatedSize() {
            return (long)INSTANCE_SIZE + this.size + this.pairs.sizeOf();
        }
    }
}

