/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar.timestamptz;

import io.trino.spi.function.Description;
import io.trino.spi.function.LiteralParameters;
import io.trino.spi.function.ScalarFunction;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.LongTimestampWithTimeZone;
import io.trino.util.DateTimeZoneIndex;

@Description(value="Time zone minute of the given timestamp")
@ScalarFunction(value="timezone_minute")
public final class TimeZoneMinute {
    private TimeZoneMinute() {
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="bigint")
    public static long extract(@SqlType(value="timestamp(p) with time zone") long packedEpochMillis) {
        return DateTimeZoneIndex.extractZoneOffsetMinutes(packedEpochMillis) % 60;
    }

    @LiteralParameters(value={"p"})
    @SqlType(value="bigint")
    public static long extract(@SqlType(value="timestamp(p) with time zone") LongTimestampWithTimeZone timestamp) {
        return DateTimeZoneIndex.extractZoneOffsetMinutes(timestamp.getEpochMillis(), timestamp.getTimeZoneKey()) % 60;
    }
}

