/*
 * Decompiled with CFR 0.152.
 */
package io.trino.server;

import com.google.inject.Inject;
import io.airlift.node.NodeInfo;
import io.airlift.units.Duration;
import io.trino.client.NodeVersion;
import io.trino.client.ServerInfo;
import io.trino.metadata.NodeState;
import io.trino.server.GracefulShutdownHandler;
import io.trino.server.ServerConfig;
import io.trino.server.StartupStatus;
import io.trino.server.security.ResourceSecurity;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Response;
import java.util.Objects;
import java.util.Optional;

@Path(value="/v1/info")
public class ServerInfoResource {
    private final NodeVersion version;
    private final String environment;
    private final boolean coordinator;
    private final GracefulShutdownHandler shutdownHandler;
    private final StartupStatus startupStatus;
    private final long startTime = System.nanoTime();

    @Inject
    public ServerInfoResource(NodeVersion nodeVersion, NodeInfo nodeInfo, ServerConfig serverConfig, GracefulShutdownHandler shutdownHandler, StartupStatus startupStatus) {
        this.version = Objects.requireNonNull(nodeVersion, "nodeVersion is null");
        this.environment = nodeInfo.getEnvironment();
        this.coordinator = serverConfig.isCoordinator();
        this.shutdownHandler = Objects.requireNonNull(shutdownHandler, "shutdownHandler is null");
        this.startupStatus = Objects.requireNonNull(startupStatus, "startupStatus is null");
    }

    @ResourceSecurity(value=ResourceSecurity.AccessType.PUBLIC)
    @GET
    @Produces(value={"application/json"})
    public ServerInfo getInfo() {
        boolean starting = !this.startupStatus.isStartupComplete();
        return new ServerInfo(this.version, this.environment, this.coordinator, starting, Optional.of(Duration.nanosSince((long)this.startTime)));
    }

    @ResourceSecurity(value=ResourceSecurity.AccessType.MANAGEMENT_WRITE)
    @PUT
    @Path(value="state")
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    public Response updateState(NodeState state) throws WebApplicationException {
        Objects.requireNonNull(state, "state is null");
        switch (state) {
            case SHUTTING_DOWN: {
                this.shutdownHandler.requestShutdown();
                return Response.ok().build();
            }
            case ACTIVE: 
            case INACTIVE: {
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)String.format("Invalid state transition to %s", new Object[]{state})).build());
            }
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)String.format("Invalid state %s", new Object[]{state})).build();
    }

    @ResourceSecurity(value=ResourceSecurity.AccessType.PUBLIC)
    @GET
    @Path(value="state")
    @Produces(value={"application/json"})
    public NodeState getServerState() {
        if (this.shutdownHandler.isShutdownRequested()) {
            return NodeState.SHUTTING_DOWN;
        }
        return NodeState.ACTIVE;
    }

    @ResourceSecurity(value=ResourceSecurity.AccessType.PUBLIC)
    @GET
    @Path(value="coordinator")
    @Produces(value={"text/plain"})
    public Response getServerCoordinator() {
        if (this.coordinator) {
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }
}

