/*
 * Decompiled with CFR 0.152.
 */
package io.trino.split;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.SizeOf;
import io.trino.exchange.ExchangeInput;
import io.trino.spi.HostAddress;
import io.trino.spi.connector.ConnectorSplit;
import java.util.List;
import java.util.Objects;

public class RemoteSplit
implements ConnectorSplit {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(RemoteSplit.class);
    private final ExchangeInput exchangeInput;

    @JsonCreator
    public RemoteSplit(@JsonProperty(value="exchangeInput") ExchangeInput exchangeInput) {
        this.exchangeInput = Objects.requireNonNull(exchangeInput, "remoteSplitInput is null");
    }

    @JsonProperty
    public ExchangeInput getExchangeInput() {
        return this.exchangeInput;
    }

    public Object getInfo() {
        return this;
    }

    public boolean isRemotelyAccessible() {
        return true;
    }

    public List<HostAddress> getAddresses() {
        return ImmutableList.of();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("exchangeInput", (Object)this.exchangeInput).toString();
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + this.exchangeInput.getRetainedSizeInBytes();
    }
}

