/*
 * Decompiled with CFR 0.152.
 */
package io.trino.util;

import com.google.common.collect.ImmutableList;
import io.trino.annotation.UsedByGeneratedCode;
import io.trino.spi.function.FunctionDependencies;
import io.trino.spi.function.FunctionDependencyDeclaration;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.TypeSignature;
import io.trino.util.Reflection;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.List;

public final class MinMaxCompare {
    private static final MethodHandle MIN_FUNCTION = Reflection.methodHandle(MinMaxCompare.class, "min", Long.TYPE);
    private static final MethodHandle MAX_FUNCTION = Reflection.methodHandle(MinMaxCompare.class, "max", Long.TYPE);

    private MinMaxCompare() {
    }

    public static FunctionDependencyDeclaration getMinMaxCompareFunctionDependencies(TypeSignature typeSignature, boolean min) {
        OperatorType comparisonOperator = MinMaxCompare.getMinMaxCompareOperatorType(min);
        return FunctionDependencyDeclaration.builder().addOperatorSignature(comparisonOperator, (List)ImmutableList.of((Object)typeSignature, (Object)typeSignature)).build();
    }

    public static MethodHandle getMinMaxCompare(FunctionDependencies dependencies, Type type, InvocationConvention convention, boolean min) {
        OperatorType comparisonOperator = MinMaxCompare.getMinMaxCompareOperatorType(min);
        MethodHandle handle = dependencies.getOperatorImplementation(comparisonOperator, List.of(type, type), convention).getMethodHandle();
        return MinMaxCompare.comparisonToMinMaxResult(min, handle);
    }

    public static MethodHandle getMinMaxCompare(TypeOperators typeOperators, Type type, InvocationConvention convention, boolean min) {
        MethodHandle handle = min ? typeOperators.getComparisonUnorderedLastOperator(type, convention) : typeOperators.getComparisonUnorderedFirstOperator(type, convention);
        return MinMaxCompare.comparisonToMinMaxResult(min, handle);
    }

    public static OperatorType getMinMaxCompareOperatorType(boolean min) {
        return min ? OperatorType.COMPARISON_UNORDERED_LAST : OperatorType.COMPARISON_UNORDERED_FIRST;
    }

    public static MethodHandle comparisonToMinMaxResult(boolean min, MethodHandle handle) {
        return MethodHandles.filterReturnValue(handle, min ? MIN_FUNCTION : MAX_FUNCTION);
    }

    @UsedByGeneratedCode
    public static boolean min(long comparisonResult) {
        return comparisonResult < 0L;
    }

    @UsedByGeneratedCode
    public static boolean max(long comparisonResult) {
        return comparisonResult > 0L;
    }
}

