/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.collect.ImmutableSet;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.security.Privilege;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.tree.Node;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class PrivilegeUtilities {
    private PrivilegeUtilities() {
    }

    public static Set<Privilege> parseStatementPrivileges(Node statement, Optional<List<String>> optionalPrivileges) {
        Set<Object> privileges = optionalPrivileges.isPresent() ? (Set)optionalPrivileges.get().stream().map(privilege -> PrivilegeUtilities.parsePrivilege(statement, privilege)).collect(ImmutableSet.toImmutableSet()) : EnumSet.allOf(Privilege.class);
        return privileges;
    }

    private static Privilege parsePrivilege(Node statement, String privilegeString) {
        for (Privilege privilege : Privilege.values()) {
            if (!privilege.name().equalsIgnoreCase(privilegeString)) continue;
            return privilege;
        }
        throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.INVALID_PRIVILEGE, statement, "Unknown privilege: '%s'", privilegeString);
    }
}

