/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.buffer;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.ThreadSafe;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLongArray;

@ThreadSafe
public class SpoolingOutputStats {
    private final int partitionCount;
    private volatile AtomicLongArray accumulators;
    private volatile Snapshot finalSnapshot;

    public SpoolingOutputStats(int partitionCount) {
        Preconditions.checkArgument((partitionCount > 0 ? 1 : 0) != 0, (Object)"partitionCount must be greater than zero");
        this.partitionCount = partitionCount;
        this.accumulators = new AtomicLongArray(partitionCount);
    }

    public void update(int partition, long dataSizeInBytes) {
        Preconditions.checkPositionIndex((int)partition, (int)this.partitionCount);
        Preconditions.checkArgument((dataSizeInBytes >= 0L ? 1 : 0) != 0, (Object)"dataSizeInBytes must be greater than or equal to zero");
        AtomicLongArray accumulators = this.accumulators;
        if (accumulators != null) {
            accumulators.addAndGet(partition, dataSizeInBytes);
        }
    }

    public void finish() {
        AtomicLongArray accumulators = this.accumulators;
        this.accumulators = null;
        if (accumulators == null) {
            return;
        }
        this.finalSnapshot = SpoolingOutputStats.createSnapshot(accumulators);
    }

    public Optional<Snapshot> getFinalSnapshot() {
        return Optional.ofNullable(this.finalSnapshot);
    }

    private static Snapshot createSnapshot(AtomicLongArray accumulators) {
        int size = accumulators.length();
        Slice values = Slices.allocate((int)(2 * size));
        for (int i = 0; i < size; ++i) {
            values.setShort(2 * i, (int)SpoolingOutputStats.truncate(accumulators.get(i)));
        }
        return new Snapshot(values);
    }

    private static short truncate(long value) {
        int floatBits = Float.floatToRawIntBits(value);
        floatBits <<= 1;
        return (short)(floatBits >>>= 16);
    }

    private static long expand(short value) {
        int floatBits = value & 0xFFFF;
        floatBits <<= 16;
        return Math.round((double)Float.intBitsToFloat(floatBits >>>= 1));
    }

    public static class Snapshot {
        private final Slice values;

        @JsonCreator
        public Snapshot(@JsonProperty(value="values") Slice values) {
            this.values = Objects.requireNonNull(values, "values is null");
        }

        @JsonProperty
        public Slice getValues() {
            return this.values;
        }

        public long getPartitionSizeInBytes(int partition) {
            int partitionCount = this.values.length() / 2;
            Preconditions.checkArgument((partition < partitionCount ? 1 : 0) != 0, (String)"partition must be less than %s", (int)partitionCount);
            return SpoolingOutputStats.expand(this.values.getShort(partition * 2));
        }
    }
}

