/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import io.trino.operator.VariableWidthData;
import io.trino.operator.scalar.CombineHashFunction;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class FlatHashStrategy {
    private static final MethodHandle READ_FLAT_FIELD_IS_NULL;
    private static final MethodHandle READ_FLAT_NULL_FIELD;
    private static final MethodHandle WRITE_FLAT_NULL_FIELD;
    private static final MethodHandle FLAT_IS_NULL;
    private static final MethodHandle BLOCK_IS_NULL;
    private static final MethodHandle LOGICAL_OR;
    private static final MethodHandle BOOLEAN_NOT_EQUALS;
    private static final MethodHandle INTEGER_ADD;
    private final List<Type> types;
    private final boolean anyVariableWidth;
    private final int totalFlatFixedLength;
    private final List<MethodHandle> readFlatMethods;
    private final List<MethodHandle> writeFlatMethods;
    private final List<MethodHandle> hashFlatMethods;
    private final List<MethodHandle> hashBlockMethods;
    private final List<MethodHandle> distinctFlatBlockMethods;

    public FlatHashStrategy(List<Type> types, TypeOperators typeOperators) {
        this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
        ImmutableList.Builder readFlatMethods = ImmutableList.builder();
        ImmutableList.Builder writeFlatMethods = ImmutableList.builder();
        ImmutableList.Builder distinctFlatBlockMethods = ImmutableList.builder();
        ImmutableList.Builder hashFlatMethods = ImmutableList.builder();
        ImmutableList.Builder hashBlockMethods = ImmutableList.builder();
        try {
            Type type;
            int i;
            MethodHandle readFlatNullField = MethodHandles.dropArguments(READ_FLAT_NULL_FIELD, 0, byte[].class, Integer.TYPE, byte[].class);
            int[] fieldIsNullOffsets = new int[types.size()];
            int[] fieldFixedOffsets = new int[types.size()];
            int variableWidthCount = (int)types.stream().filter(Type::isFlatVariableWidth).count();
            int fixedOffset = 0;
            for (i = 0; i < types.size(); ++i) {
                type = types.get(i);
                fieldIsNullOffsets[i] = fixedOffset++;
                fieldFixedOffsets[i] = fixedOffset;
                fixedOffset += type.getFlatFixedSize();
            }
            this.totalFlatFixedLength = fixedOffset;
            this.anyVariableWidth = variableWidthCount > 0;
            for (i = 0; i < types.size(); ++i) {
                type = types.get(i);
                MethodHandle readFlat = typeOperators.getReadValueOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.BLOCK_BUILDER, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.FLAT}));
                readFlat = FlatHashStrategy.toAbsoluteFlatArgument(type, readFlat, 0, fieldFixedOffsets[i]);
                readFlat = MethodHandles.guardWithTest(MethodHandles.insertArguments(READ_FLAT_FIELD_IS_NULL, 0, fieldIsNullOffsets[i]), readFlatNullField, readFlat);
                readFlat = MethodHandles.collectArguments(readFlat, 3, MethodHandles.insertArguments(MethodHandles.arrayElementGetter(BlockBuilder[].class), 1, i));
                readFlatMethods.add((Object)readFlat);
                MethodHandle writeFlat = typeOperators.getReadValueOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FLAT_RETURN, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL}));
                writeFlat = MethodHandles.collectArguments(writeFlat, 3, MethodHandles.insertArguments(INTEGER_ADD, 1, fieldFixedOffsets[i]));
                writeFlat = MethodHandles.guardWithTest(BLOCK_IS_NULL, MethodHandles.insertArguments(WRITE_FLAT_NULL_FIELD, 0, fieldIsNullOffsets[i]), writeFlat);
                writeFlat = MethodHandles.collectArguments(writeFlat, 0, MethodHandles.insertArguments(MethodHandles.arrayElementGetter(Block[].class), 1, i));
                writeFlatMethods.add((Object)writeFlat);
                MethodHandle distinctFlatBlock = typeOperators.getDistinctFromOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.FLAT, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL}));
                distinctFlatBlock = FlatHashStrategy.toAbsoluteFlatArgument(type, distinctFlatBlock, 0, fieldFixedOffsets[i]);
                distinctFlatBlock = MethodHandles.guardWithTest(LOGICAL_OR, MethodHandles.dropArguments(BOOLEAN_NOT_EQUALS, 2, byte[].class, Integer.TYPE, byte[].class, Block.class, Integer.TYPE), MethodHandles.dropArguments(distinctFlatBlock, 0, new Class[]{Boolean.TYPE, Boolean.TYPE}));
                distinctFlatBlock = MethodHandles.collectArguments(distinctFlatBlock, 1, BLOCK_IS_NULL);
                distinctFlatBlock = MethodHandles.collectArguments(distinctFlatBlock, 0, MethodHandles.insertArguments(FLAT_IS_NULL, 0, fieldIsNullOffsets[i]));
                distinctFlatBlock = MethodHandles.permuteArguments(distinctFlatBlock, MethodType.methodType(Boolean.TYPE, byte[].class, Integer.TYPE, byte[].class, Block.class, Integer.TYPE), 0, 1, 3, 4, 0, 1, 2, 3, 4);
                distinctFlatBlock = MethodHandles.collectArguments(distinctFlatBlock, 3, MethodHandles.insertArguments(MethodHandles.arrayElementGetter(Block[].class), 1, i));
                distinctFlatBlockMethods.add((Object)distinctFlatBlock);
                MethodHandle hashFlat = typeOperators.getHashCodeOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.FLAT}));
                hashFlat = FlatHashStrategy.toAbsoluteFlatArgument(type, hashFlat, 0, fieldFixedOffsets[i]);
                hashFlat = MethodHandles.guardWithTest(MethodHandles.insertArguments(FLAT_IS_NULL, 0, fieldIsNullOffsets[i]), MethodHandles.dropArguments(MethodHandles.constant(Long.TYPE, 0), 0, byte[].class, Integer.TYPE, byte[].class), hashFlat);
                hashFlatMethods.add((Object)hashFlat);
                MethodHandle hashBlock = typeOperators.getHashCodeOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL}));
                hashBlock = MethodHandles.guardWithTest(BLOCK_IS_NULL, MethodHandles.dropArguments(MethodHandles.constant(Long.TYPE, 0), 0, new Class[]{Block.class, Integer.TYPE}), hashBlock);
                hashBlock = MethodHandles.collectArguments(hashBlock, 0, MethodHandles.insertArguments(MethodHandles.arrayElementGetter(Block[].class), 1, i));
                hashBlockMethods.add((Object)hashBlock);
            }
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
        this.readFlatMethods = readFlatMethods.build();
        this.writeFlatMethods = writeFlatMethods.build();
        this.distinctFlatBlockMethods = distinctFlatBlockMethods.build();
        this.hashFlatMethods = hashFlatMethods.build();
        this.hashBlockMethods = hashBlockMethods.build();
    }

    public boolean isAnyVariableWidth() {
        return this.anyVariableWidth;
    }

    public int getTotalFlatFixedLength() {
        return this.totalFlatFixedLength;
    }

    public int getTotalVariableWidth(Block[] blocks, int position) {
        if (!this.anyVariableWidth) {
            return 0;
        }
        long variableWidth = 0L;
        for (int i = 0; i < this.types.size(); ++i) {
            Type type = this.types.get(i);
            Block block = blocks[i];
            if (!type.isFlatVariableWidth()) continue;
            variableWidth += (long)type.getFlatVariableWidthSize(block, position);
        }
        return Math.toIntExact(variableWidth);
    }

    public void readFlat(byte[] fixedChunk, int fixedOffset, byte[] variableChunk, int variableOffset, BlockBuilder[] blockBuilders) {
        try {
            for (MethodHandle readFlatMethod : this.readFlatMethods) {
                readFlatMethod.invokeExact(fixedChunk, fixedOffset, variableChunk, blockBuilders);
            }
        }
        catch (Throwable throwable) {
            Throwables.throwIfUnchecked((Throwable)throwable);
            throw new RuntimeException(throwable);
        }
    }

    public void writeFlat(Block[] blocks, int position, byte[] fixedChunk, int fixedOffset, byte[] variableChunk, int variableOffset) {
        try {
            int writeFlatMethodsSize = this.writeFlatMethods.size();
            for (int i = 0; i < writeFlatMethodsSize; ++i) {
                this.writeFlatMethods.get(i).invokeExact(blocks, position, fixedChunk, fixedOffset, variableChunk, variableOffset);
                Type type = this.types.get(i);
                if (!type.isFlatVariableWidth() || blocks[i].isNull(position)) continue;
                variableOffset += type.getFlatVariableWidthSize(blocks[i], position);
            }
        }
        catch (Throwable throwable) {
            Throwables.throwIfUnchecked((Throwable)throwable);
            throw new RuntimeException(throwable);
        }
    }

    public boolean valueNotDistinctFrom(byte[] leftFixedChunk, int leftFixedOffset, byte[] leftVariableChunk, Block[] rightBlocks, int rightPosition) {
        try {
            for (MethodHandle distinctFlatBlockMethod : this.distinctFlatBlockMethods) {
                if (!distinctFlatBlockMethod.invokeExact(leftFixedChunk, leftFixedOffset, leftVariableChunk, rightBlocks, rightPosition)) continue;
                return false;
            }
            return true;
        }
        catch (Throwable throwable) {
            Throwables.throwIfUnchecked((Throwable)throwable);
            throw new RuntimeException(throwable);
        }
    }

    public long hash(Block[] blocks, int position) {
        try {
            long result = 0L;
            for (MethodHandle hashBlockMethod : this.hashBlockMethods) {
                result = CombineHashFunction.getHash(result, hashBlockMethod.invokeExact(blocks, position));
            }
            return result;
        }
        catch (Throwable throwable) {
            Throwables.throwIfUnchecked((Throwable)throwable);
            throw new RuntimeException(throwable);
        }
    }

    public long hash(byte[] fixedChunk, int fixedOffset, byte[] variableChunk) {
        try {
            long result = 0L;
            for (MethodHandle hashFlat : this.hashFlatMethods) {
                result = CombineHashFunction.getHash(result, hashFlat.invokeExact(fixedChunk, fixedOffset, variableChunk));
            }
            return result;
        }
        catch (Throwable throwable) {
            Throwables.throwIfUnchecked((Throwable)throwable);
            throw new RuntimeException(throwable);
        }
    }

    private static MethodHandle toAbsoluteFlatArgument(Type type, MethodHandle methodHandle, int argument, int fixedPosition) throws ReflectiveOperationException {
        methodHandle = MethodHandles.collectArguments(methodHandle, argument + 1, MethodHandles.insertArguments(INTEGER_ADD, 1, fixedPosition));
        if (!type.isFlatVariableWidth()) {
            methodHandle = MethodHandles.insertArguments(methodHandle, argument + 2, new Object[]{VariableWidthData.EMPTY_CHUNK});
            methodHandle = MethodHandles.dropArguments(methodHandle, argument + 2, new Class[]{byte[].class});
        }
        return methodHandle;
    }

    private static boolean readFlatFieldIsNull(int fieldNullOffset, byte[] fixedChunk, int fixedOffset) {
        return fixedChunk[fixedOffset + fieldNullOffset] != 0;
    }

    private static void writeFieldNull(int fieldNullOffset, byte[] fixedChunk, int fixedOffset) {
        fixedChunk[fixedOffset + fieldNullOffset] = 1;
    }

    private static boolean flatIsNull(int fieldNullOffset, byte[] fixedChunk, int fixedOffset) {
        return fixedChunk[fixedOffset + fieldNullOffset] != 0;
    }

    private static boolean booleanNotEquals(boolean left, boolean right) {
        return left != right;
    }

    private static int integerAdd(int left, int right) {
        return left + right;
    }

    static {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            READ_FLAT_FIELD_IS_NULL = lookup.findStatic(FlatHashStrategy.class, "readFlatFieldIsNull", MethodType.methodType(Boolean.TYPE, Integer.TYPE, byte[].class, Integer.TYPE));
            READ_FLAT_NULL_FIELD = lookup.findVirtual(BlockBuilder.class, "appendNull", MethodType.methodType(BlockBuilder.class)).asType(MethodType.methodType(Void.TYPE, BlockBuilder.class));
            WRITE_FLAT_NULL_FIELD = MethodHandles.dropArguments(MethodHandles.dropArguments(lookup.findStatic(FlatHashStrategy.class, "writeFieldNull", MethodType.methodType(Void.TYPE, Integer.TYPE, byte[].class, Integer.TYPE)), 3, new Class[]{byte[].class, Integer.TYPE}), 1, new Class[]{Block.class, Integer.TYPE});
            FLAT_IS_NULL = lookup.findStatic(FlatHashStrategy.class, "flatIsNull", MethodType.methodType(Boolean.TYPE, Integer.TYPE, byte[].class, Integer.TYPE));
            BLOCK_IS_NULL = lookup.findVirtual(Block.class, "isNull", MethodType.methodType(Boolean.TYPE, Integer.TYPE));
            LOGICAL_OR = lookup.findStatic(Boolean.class, "logicalOr", MethodType.methodType(Boolean.TYPE, Boolean.TYPE, Boolean.TYPE));
            BOOLEAN_NOT_EQUALS = lookup.findStatic(FlatHashStrategy.class, "booleanNotEquals", MethodType.methodType(Boolean.TYPE, Boolean.TYPE, Boolean.TYPE));
            INTEGER_ADD = lookup.findStatic(FlatHashStrategy.class, "integerAdd", MethodType.methodType(Integer.TYPE, Integer.TYPE, Integer.TYPE));
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }
}

