/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.annotations.VisibleForTesting;
import io.trino.Session;
import io.trino.SystemSessionProperties;
import io.trino.annotation.NotThreadSafe;
import io.trino.operator.BigintGroupByHash;
import io.trino.operator.FlatGroupByHash;
import io.trino.operator.MultiChannelGroupByHash;
import io.trino.operator.UpdateMemory;
import io.trino.operator.Work;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.sql.gen.JoinCompiler;
import java.util.List;

@NotThreadSafe
public interface GroupByHash {
    public static GroupByHash createGroupByHash(Session session, List<Type> types, boolean hasPrecomputedHash, int expectedSize, JoinCompiler joinCompiler, TypeOperators typeOperators, UpdateMemory updateMemory) {
        boolean flatGroupByHash = SystemSessionProperties.isFlatGroupByHash(session);
        boolean dictionaryAggregationEnabled = SystemSessionProperties.isDictionaryAggregationEnabled(session);
        return GroupByHash.createGroupByHash(flatGroupByHash, types, hasPrecomputedHash, expectedSize, dictionaryAggregationEnabled, joinCompiler, typeOperators, updateMemory);
    }

    public static GroupByHash createGroupByHash(boolean flatGroupByHash, List<Type> types, boolean hasPrecomputedHash, int expectedSize, boolean dictionaryAggregationEnabled, JoinCompiler joinCompiler, TypeOperators typeOperators, UpdateMemory updateMemory) {
        if (types.size() == 1 && types.get(0).equals(BigintType.BIGINT)) {
            return new BigintGroupByHash(hasPrecomputedHash, expectedSize, updateMemory);
        }
        if (flatGroupByHash) {
            return new FlatGroupByHash(types, hasPrecomputedHash, expectedSize, dictionaryAggregationEnabled, joinCompiler, updateMemory);
        }
        return new MultiChannelGroupByHash(types, hasPrecomputedHash, expectedSize, dictionaryAggregationEnabled, joinCompiler, typeOperators, updateMemory);
    }

    public long getEstimatedSize();

    public int getGroupCount();

    public void appendValuesTo(int var1, PageBuilder var2);

    public Work<?> addPage(Page var1);

    public Work<int[]> getGroupIds(Page var1);

    public long getRawHash(int var1);

    @VisibleForTesting
    public int getCapacity();
}

