/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.MoreFutures;
import io.trino.metadata.Split;
import io.trino.operator.DriverContext;
import io.trino.operator.OperatorContext;
import io.trino.operator.SourceOperator;
import io.trino.operator.SourceOperatorFactory;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.CatalogHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.function.table.ConnectorTableFunctionHandle;
import io.trino.spi.function.table.TableFunctionProcessorProvider;
import io.trino.spi.function.table.TableFunctionProcessorState;
import io.trino.spi.function.table.TableFunctionSplitProcessor;
import io.trino.split.EmptySplit;
import io.trino.sql.planner.plan.PlanNodeId;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public class LeafTableFunctionOperator
implements SourceOperator {
    private final OperatorContext operatorContext;
    private final PlanNodeId sourceId;
    private final TableFunctionProcessorProvider tableFunctionProvider;
    private final ConnectorTableFunctionHandle functionHandle;
    private final ConnectorSession session;
    private final Deque<ConnectorSplit> pendingSplits = new ArrayDeque<ConnectorSplit>();
    private boolean noMoreSplits;
    private TableFunctionSplitProcessor processor;
    private boolean processorFinishedSplit = true;
    private ListenableFuture<Void> processorBlocked = NOT_BLOCKED;

    public LeafTableFunctionOperator(OperatorContext operatorContext, PlanNodeId sourceId, CatalogHandle functionCatalog, TableFunctionProcessorProvider tableFunctionProvider, ConnectorTableFunctionHandle functionHandle) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.sourceId = Objects.requireNonNull(sourceId, "sourceId is null");
        this.tableFunctionProvider = Objects.requireNonNull(tableFunctionProvider, "tableFunctionProvider is null");
        this.functionHandle = Objects.requireNonNull(functionHandle, "functionHandle is null");
        this.session = operatorContext.getSession().toConnectorSession(functionCatalog);
    }

    private void resetProcessor(ConnectorSplit nextSplit) {
        this.processor = this.tableFunctionProvider.getSplitProcessor(this.session, this.functionHandle, nextSplit);
        this.processorFinishedSplit = false;
        this.processorBlocked = NOT_BLOCKED;
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public PlanNodeId getSourceId() {
        return this.sourceId;
    }

    @Override
    public boolean needsInput() {
        return false;
    }

    @Override
    public void addInput(Page page) {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not take input");
    }

    @Override
    public void addSplit(Split split) {
        Preconditions.checkState((!this.noMoreSplits ? 1 : 0) != 0, (Object)"no more splits expected");
        this.pendingSplits.add(split.getConnectorSplit());
    }

    @Override
    public void noMoreSplits() {
        this.noMoreSplits = true;
    }

    @Override
    public Page getOutput() {
        TableFunctionProcessorState state;
        if (this.processorFinishedSplit) {
            while (this.pendingSplits.peekFirst() instanceof EmptySplit) {
                this.pendingSplits.remove();
            }
            if (this.pendingSplits.isEmpty()) {
                return null;
            }
            ConnectorSplit nextSplit = this.pendingSplits.remove();
            this.resetProcessor(nextSplit);
        }
        if ((state = this.processor.process()) == TableFunctionProcessorState.Finished.FINISHED) {
            this.processorFinishedSplit = true;
        }
        if (state instanceof TableFunctionProcessorState.Blocked) {
            TableFunctionProcessorState.Blocked blocked = (TableFunctionProcessorState.Blocked)state;
            this.processorBlocked = MoreFutures.toListenableFuture((CompletableFuture)blocked.getFuture());
        }
        if (state instanceof TableFunctionProcessorState.Processed) {
            TableFunctionProcessorState.Processed processed = (TableFunctionProcessorState.Processed)state;
            if (processed.isUsedInput()) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, "Invalid state, as no input has been provided: " + state);
            }
            return processed.getResult();
        }
        return null;
    }

    @Override
    public ListenableFuture<Void> isBlocked() {
        return this.processorBlocked;
    }

    @Override
    public void finish() {
    }

    @Override
    public boolean isFinished() {
        return this.processorFinishedSplit && this.pendingSplits.isEmpty() && this.noMoreSplits;
    }

    @Override
    public void close() throws Exception {
    }

    public static class LeafTableFunctionOperatorFactory
    implements SourceOperatorFactory {
        private final int operatorId;
        private final PlanNodeId sourceId;
        private final CatalogHandle functionCatalog;
        private final TableFunctionProcessorProvider tableFunctionProvider;
        private final ConnectorTableFunctionHandle functionHandle;
        private boolean closed;

        public LeafTableFunctionOperatorFactory(int operatorId, PlanNodeId sourceId, CatalogHandle functionCatalog, TableFunctionProcessorProvider tableFunctionProvider, ConnectorTableFunctionHandle functionHandle) {
            this.operatorId = operatorId;
            this.sourceId = Objects.requireNonNull(sourceId, "sourceId is null");
            this.functionCatalog = Objects.requireNonNull(functionCatalog, "functionCatalog is null");
            this.tableFunctionProvider = Objects.requireNonNull(tableFunctionProvider, "tableFunctionProvider is null");
            this.functionHandle = Objects.requireNonNull(functionHandle, "functionHandle is null");
        }

        @Override
        public PlanNodeId getSourceId() {
            return this.sourceId;
        }

        @Override
        public SourceOperator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext operatorContext = driverContext.addOperatorContext(this.operatorId, this.sourceId, LeafTableFunctionOperator.class.getSimpleName());
            return new LeafTableFunctionOperator(operatorContext, this.sourceId, this.functionCatalog, this.tableFunctionProvider, this.functionHandle);
        }

        @Override
        public void noMoreOperators() {
            this.closed = true;
        }
    }
}

