/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import io.trino.operator.aggregation.KeyValuePairs;
import io.trino.operator.aggregation.state.KeyValuePairsState;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AggregationFunction;
import io.trino.spi.function.AggregationState;
import io.trino.spi.function.BlockIndex;
import io.trino.spi.function.BlockPosition;
import io.trino.spi.function.CombineFunction;
import io.trino.spi.function.Convention;
import io.trino.spi.function.Description;
import io.trino.spi.function.InputFunction;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorDependency;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.OutputFunction;
import io.trino.spi.function.SqlNullable;
import io.trino.spi.function.SqlType;
import io.trino.spi.function.TypeParameter;
import io.trino.spi.function.TypeParameters;
import io.trino.spi.type.Type;
import io.trino.type.BlockTypeOperators;

@AggregationFunction(value="map_agg", isOrderSensitive=true)
@Description(value="Aggregates all the rows (key/value pairs) into a single map")
public final class MapAggregationFunction {
    private MapAggregationFunction() {
    }

    @InputFunction
    @TypeParameters(value={@TypeParameter(value="K"), @TypeParameter(value="V")})
    public static void input(@TypeParameter(value="K") Type keyType, @OperatorDependency(operator=OperatorType.EQUAL, argumentTypes={"K", "K"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION}, result=InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN)) BlockTypeOperators.BlockPositionEqual keyEqual, @OperatorDependency(operator=OperatorType.HASH_CODE, argumentTypes={"K"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) BlockTypeOperators.BlockPositionHashCode keyHashCode, @TypeParameter(value="V") Type valueType, @AggregationState(value={"K", "V"}) KeyValuePairsState state, @BlockPosition @SqlType(value="K") Block key, @SqlNullable @BlockPosition @SqlType(value="V") Block value, @BlockIndex int position) {
        KeyValuePairs pairs = state.get();
        if (pairs == null) {
            pairs = new KeyValuePairs(keyType, keyEqual, keyHashCode, valueType);
            state.set(pairs);
        }
        long startSize = pairs.estimatedInMemorySize();
        pairs.add(key, value, position, position);
        state.addMemoryUsage(pairs.estimatedInMemorySize() - startSize);
    }

    @CombineFunction
    public static void combine(@AggregationState(value={"K", "V"}) KeyValuePairsState state, @AggregationState(value={"K", "V"}) KeyValuePairsState otherState) {
        if (state.get() != null && otherState.get() != null) {
            Block keys = otherState.get().getKeys();
            Block values = otherState.get().getValues();
            KeyValuePairs pairs = state.get();
            long startSize = pairs.estimatedInMemorySize();
            for (int i = 0; i < keys.getPositionCount(); ++i) {
                pairs.add(keys, values, i, i);
            }
            state.addMemoryUsage(pairs.estimatedInMemorySize() - startSize);
        } else if (state.get() == null) {
            state.set(otherState.get());
        }
    }

    @OutputFunction(value="map(K, V)")
    public static void output(@AggregationState(value={"K", "V"}) KeyValuePairsState state, BlockBuilder out) {
        KeyValuePairs pairs = state.get();
        if (pairs == null) {
            out.appendNull();
        } else {
            pairs.serialize(out);
        }
    }
}

