/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation;

import io.trino.operator.aggregation.state.LongState;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AggregationFunction;
import io.trino.spi.function.AggregationState;
import io.trino.spi.function.BlockIndex;
import io.trino.spi.function.BlockPosition;
import io.trino.spi.function.CombineFunction;
import io.trino.spi.function.InputFunction;
import io.trino.spi.function.OutputFunction;
import io.trino.spi.function.SqlNullable;
import io.trino.spi.function.SqlType;
import io.trino.spi.function.TypeParameter;
import io.trino.spi.type.BigintType;

@AggregationFunction(value="$internal$max_data_size_for_stats", hidden=true)
public final class MaxDataSizeForStats {
    public static final String NAME = "$internal$max_data_size_for_stats";

    private MaxDataSizeForStats() {
    }

    @InputFunction
    @TypeParameter(value="T")
    public static void input(@AggregationState LongState state, @SqlNullable @BlockPosition @SqlType(value="T") Block block, @BlockIndex int index) {
        MaxDataSizeForStats.update(state, block.getEstimatedDataSizeForStats(index));
    }

    @CombineFunction
    public static void combine(@AggregationState LongState state, @AggregationState LongState otherState) {
        MaxDataSizeForStats.update(state, otherState.getValue());
    }

    private static void update(LongState state, long size) {
        state.setValue(Math.max(state.getValue(), size));
    }

    @OutputFunction(value="bigint")
    public static void output(@AggregationState LongState state, BlockBuilder out) {
        BigintType.BIGINT.writeLong(out, state.getValue());
    }
}

