/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.minmaxbyn;

import io.trino.operator.aggregation.minmaxbyn.MaxByNState;
import io.trino.operator.aggregation.minmaxbyn.MinMaxByNStateFactory;
import io.trino.operator.aggregation.minmaxbyn.TypedKeyValueHeap;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.function.AccumulatorState;
import io.trino.spi.function.AccumulatorStateFactory;
import io.trino.spi.function.Convention;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorDependency;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.TypeParameter;
import io.trino.spi.type.Type;
import io.trino.util.Failures;
import java.lang.invoke.MethodHandle;
import java.util.function.LongFunction;

public class MaxByNStateFactory
implements AccumulatorStateFactory<MaxByNState> {
    private static final long MAX_NUMBER_OF_VALUES = 10000L;
    private final LongFunction<TypedKeyValueHeap> heapFactory = n -> {
        Failures.checkCondition(n > 0L, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "third argument of max_by must be a positive integer", new Object[0]);
        Failures.checkCondition(n <= 10000L, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "third argument of max_by must be less than or equal to %s; found %s", 10000L, n);
        return new TypedKeyValueHeap(false, keyReadFlat, keyWriteFlat, valueReadFlat, valueWriteFlat, compareFlatFlat, compareFlatBlock, keyType, valueType, Math.toIntExact(n));
    };

    public MaxByNStateFactory(@OperatorDependency(operator=OperatorType.READ_VALUE, argumentTypes={"K"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.FLAT}, result=InvocationConvention.InvocationReturnConvention.BLOCK_BUILDER)) MethodHandle keyReadFlat, @OperatorDependency(operator=OperatorType.READ_VALUE, argumentTypes={"K"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL}, result=InvocationConvention.InvocationReturnConvention.FLAT_RETURN)) MethodHandle keyWriteFlat, @OperatorDependency(operator=OperatorType.READ_VALUE, argumentTypes={"V"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.FLAT}, result=InvocationConvention.InvocationReturnConvention.BLOCK_BUILDER)) MethodHandle valueReadFlat, @OperatorDependency(operator=OperatorType.READ_VALUE, argumentTypes={"V"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL}, result=InvocationConvention.InvocationReturnConvention.FLAT_RETURN)) MethodHandle valueWriteFlat, @OperatorDependency(operator=OperatorType.COMPARISON_UNORDERED_FIRST, argumentTypes={"K", "K"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.FLAT, InvocationConvention.InvocationArgumentConvention.FLAT}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) MethodHandle compareFlatFlat, @OperatorDependency(operator=OperatorType.COMPARISON_UNORDERED_FIRST, argumentTypes={"K", "K"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.FLAT, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) MethodHandle compareFlatBlock, @TypeParameter(value="K") Type keyType, @TypeParameter(value="V") Type valueType) {
    }

    public MaxByNState createSingleState() {
        return new SingleMaxByNState(this.heapFactory);
    }

    public MaxByNState createGroupedState() {
        return new GroupedMaxByNState(this.heapFactory);
    }

    private static class SingleMaxByNState
    extends MinMaxByNStateFactory.SingleMinMaxByNState
    implements MaxByNState {
        public SingleMaxByNState(LongFunction<TypedKeyValueHeap> heapFactory) {
            super(heapFactory);
        }

        public SingleMaxByNState(SingleMaxByNState state) {
            super(state);
        }

        @Override
        public AccumulatorState copy() {
            return new SingleMaxByNState(this);
        }
    }

    private static class GroupedMaxByNState
    extends MinMaxByNStateFactory.GroupedMinMaxByNState
    implements MaxByNState {
        public GroupedMaxByNState(LongFunction<TypedKeyValueHeap> heapFactory) {
            super(heapFactory);
        }
    }
}

