/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.minmaxn;

import io.trino.operator.aggregation.minmaxn.MaxNState;
import io.trino.operator.aggregation.minmaxn.MinMaxNStateFactory;
import io.trino.operator.aggregation.minmaxn.TypedHeap;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.function.AccumulatorState;
import io.trino.spi.function.AccumulatorStateFactory;
import io.trino.spi.function.Convention;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorDependency;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.TypeParameter;
import io.trino.spi.type.Type;
import io.trino.util.Failures;
import java.lang.invoke.MethodHandle;
import java.util.function.LongFunction;

public class MaxNStateFactory
implements AccumulatorStateFactory<MaxNState> {
    private static final long MAX_NUMBER_OF_VALUES = 10000L;
    private final LongFunction<TypedHeap> heapFactory = n -> {
        Failures.checkCondition(n > 0L, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "second argument of max_n must be positive", new Object[0]);
        Failures.checkCondition(n <= 10000L, (ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "second argument of max_n must be less than or equal to %s; found %s", 10000L, n);
        return new TypedHeap(false, readFlat, writeFlat, compareFlatFlat, compareFlatBlock, elementType, Math.toIntExact(n));
    };

    public MaxNStateFactory(@OperatorDependency(operator=OperatorType.READ_VALUE, argumentTypes={"T"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.FLAT}, result=InvocationConvention.InvocationReturnConvention.BLOCK_BUILDER)) MethodHandle readFlat, @OperatorDependency(operator=OperatorType.READ_VALUE, argumentTypes={"T"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL}, result=InvocationConvention.InvocationReturnConvention.FLAT_RETURN)) MethodHandle writeFlat, @OperatorDependency(operator=OperatorType.COMPARISON_UNORDERED_FIRST, argumentTypes={"T", "T"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.FLAT, InvocationConvention.InvocationArgumentConvention.FLAT}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) MethodHandle compareFlatFlat, @OperatorDependency(operator=OperatorType.COMPARISON_UNORDERED_FIRST, argumentTypes={"T", "T"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.FLAT, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) MethodHandle compareFlatBlock, @TypeParameter(value="T") Type elementType) {
    }

    public MaxNState createSingleState() {
        return new SingleMaxNState(this.heapFactory);
    }

    public MaxNState createGroupedState() {
        return new GroupedMaxNState(this.heapFactory);
    }

    private static class SingleMaxNState
    extends MinMaxNStateFactory.SingleMinMaxNState
    implements MaxNState {
        public SingleMaxNState(LongFunction<TypedHeap> heapFactory) {
            super(heapFactory);
        }

        public SingleMaxNState(SingleMaxNState state) {
            super(state);
        }

        @Override
        public AccumulatorState copy() {
            return new SingleMaxNState(this);
        }
    }

    private static class GroupedMaxNState
    extends MinMaxNStateFactory.GroupedMinMaxNState
    implements MaxNState {
        public GroupedMaxNState(LongFunction<TypedHeap> heapFactory) {
            super(heapFactory);
        }
    }
}

