/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.multimapagg;

import io.trino.array.ObjectBigArray;
import io.trino.operator.aggregation.multimapagg.MultimapAggregationState;
import io.trino.operator.scalar.BlockSet;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.MapBlockBuilder;
import io.trino.spi.function.AggregationFunction;
import io.trino.spi.function.AggregationState;
import io.trino.spi.function.BlockIndex;
import io.trino.spi.function.BlockPosition;
import io.trino.spi.function.CombineFunction;
import io.trino.spi.function.Convention;
import io.trino.spi.function.Description;
import io.trino.spi.function.InputFunction;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorDependency;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.OutputFunction;
import io.trino.spi.function.SqlNullable;
import io.trino.spi.function.SqlType;
import io.trino.spi.function.TypeParameter;
import io.trino.spi.function.TypeParameters;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.Type;
import io.trino.type.BlockTypeOperators;
import io.trino.type.TypeUtils;

@AggregationFunction(value="multimap_agg", isOrderSensitive=true)
@Description(value="Aggregates all the rows (key/value pairs) into a single multimap")
public final class MultimapAggregationFunction {
    private static final int EXPECTED_ENTRY_SIZE = 100;

    private MultimapAggregationFunction() {
    }

    @InputFunction
    @TypeParameters(value={@TypeParameter(value="K"), @TypeParameter(value="V")})
    public static void input(@AggregationState(value={"K", "V"}) MultimapAggregationState state, @BlockPosition @SqlType(value="K") Block key, @SqlNullable @BlockPosition @SqlType(value="V") Block value, @BlockIndex int position) {
        state.add(key, value, position);
    }

    @CombineFunction
    public static void combine(@AggregationState(value={"K", "V"}) MultimapAggregationState state, @AggregationState(value={"K", "V"}) MultimapAggregationState otherState) {
        state.merge(otherState);
    }

    @OutputFunction(value="map(K, array(V))")
    public static void output(@TypeParameter(value="K") Type keyType, @OperatorDependency(operator=OperatorType.IS_DISTINCT_FROM, argumentTypes={"K", "K"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION}, result=InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN)) BlockTypeOperators.BlockPositionIsDistinctFrom keyDistinctFrom, @OperatorDependency(operator=OperatorType.HASH_CODE, argumentTypes={"K"}, convention=@Convention(arguments={InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION}, result=InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL)) BlockTypeOperators.BlockPositionHashCode keyHashCode, @TypeParameter(value="V") Type valueType, @AggregationState(value={"K", "V"}) MultimapAggregationState state, BlockBuilder out) {
        if (state.isEmpty()) {
            out.appendNull();
        } else {
            ObjectBigArray valueArrayBlockBuilders = new ObjectBigArray();
            valueArrayBlockBuilders.ensureCapacity((long)state.getEntryCount());
            BlockBuilder distinctKeyBlockBuilder = keyType.createBlockBuilder(null, state.getEntryCount(), TypeUtils.expectedValueSize(keyType, 100));
            BlockSet keySet = new BlockSet(keyType, keyDistinctFrom, keyHashCode, state.getEntryCount());
            state.forEach((key, value, keyValueIndex) -> {
                if (keySet.add(key, keyValueIndex)) {
                    keyType.appendTo(key, keyValueIndex, distinctKeyBlockBuilder);
                    BlockBuilder valueArrayBuilder = valueType.createBlockBuilder(null, 10, TypeUtils.expectedValueSize(valueType, 100));
                    valueArrayBlockBuilders.set((long)keySet.positionOf(key, keyValueIndex), (Object)valueArrayBuilder);
                }
                valueType.appendTo(value, keyValueIndex, (BlockBuilder)valueArrayBlockBuilders.get((long)keySet.positionOf(key, keyValueIndex)));
            });
            ArrayType valueArrayType = new ArrayType(valueType);
            ((MapBlockBuilder)out).buildEntry((arg_0, arg_1) -> MultimapAggregationFunction.lambda$output$1(distinctKeyBlockBuilder, keyType, (Type)valueArrayType, valueArrayBlockBuilders, arg_0, arg_1));
        }
    }

    private static /* synthetic */ void lambda$output$1(BlockBuilder distinctKeyBlockBuilder, Type keyType, Type valueArrayType, ObjectBigArray valueArrayBlockBuilders, BlockBuilder keyBuilder, BlockBuilder valueBuilder) throws RuntimeException {
        for (int i = 0; i < distinctKeyBlockBuilder.getPositionCount(); ++i) {
            keyType.appendTo((Block)distinctKeyBlockBuilder, i, keyBuilder);
            valueArrayType.writeObject(valueBuilder, (Object)((BlockBuilder)valueArrayBlockBuilders.get((long)i)).build());
        }
    }
}

